--[[---------------------------------------------------------------------------
    Name: phRaid
    Author: pherl <pherl@live.com>
-----------------------------------------------------------------------------]]

-- IsSpellInRange will be available in 2.0.
-- Now We could only use CheckInteractDistance in 1.12(CWOW)

local L = AceLibrary("AceLocale-2.2"):new("phRaid")
local phRRange = phRaid:NewModule("phRaidRange",
    "AceEvent-2.0",
    "AceConsole-2.0",
    "AceDebug-2.0"
)

function phRRange:OnInitialize()
    phRaid.db.defaults.profile["Range"] = {
        FirstAlpha = 0.6,
        Time = 2.0,
    }
    phRaid.options.args.rangecheck = {
        name = L["RangeCheck"],
        desc = L["RangeCheck"],
        type = "group",
        order = 500,
        args = {
            enable = {
                name = L["Enable"],
                type = "toggle",
                desc = L["RangeCheck"],
                get = function() return phRaid:IsModuleActive("phRaidRange") end,
                set = function() phRaid:ToggleModuleActive("phRaidRange") end,
                order = 1
            },
            time = {
                name = L["RefreshRate"],
                type = "range",
                min = 0.2,
                max = 5,
                step = 0.2,
                desc = L["RefreshRate"],
                get = function() return phRaid.db.profile.Range.Time end,
                set = function(value)
                    phRaid.db.profile.Range.Time = value
                    local self = phRaid:GetModule("phRaidRange")
                    self:CancelScheduledEvent("phRaidRangeCheck")
                    self:ScheduleRepeatingEvent("phRaidRangeCheck", self.RangeCheck, value, self)
                end,
                disabled = function() return not phRaid:IsModuleActive("phRaidRange") end,
            },
            alpha = {
                name = L["FirstAlpha"],
                type = "range",
                min = 0.05,
                max = 1,
                step = 0.05,
                desc = L["FirstAlpha"],
                get = function() return phRaid.db.profile.Range.FirstAlpha end,
                set = function(value) phRaid.db.profile.Range.FirstAlpha = value end,
                disabled = function() return not phRaid:IsModuleActive("phRaidRange") end,
            },
        }
    }
    _, self.playerClass = UnitClass("player")
end

function phRRange:OnEnable()
    self.enabled = true
    self:ScheduleRepeatingEvent("phRaidRangeCheck", self.RangeCheck, phRaid.db.profile.Range.Time, self)
end

function phRRange:OnDisable()
    self.enabled = false
    self:RangeCheck()
end

function phRRange:RangeCheck()
    for unit in pairs(phRaid.visible) do
        if not self.enabled or CheckInteractDistance(unit, 4) then
            phRaid.frames[unit]:SetAlpha(1)
        else
            phRaid.frames[unit]:SetAlpha(phRaid.db.profile.Range.FirstAlpha)
        end
    end
    if not self.enabled then
        self:CancelScheduledEvent("phRaidRangeCheck")
    end
end


--~ function phRRange:CreateOptions(opt)
--~     self.options = opt
--~     local options = opt:AddOptionsTab("fphROptionsRange", L["RangeCheck"])

--~     local encheck = opt:CreateCheck("EnableRangeCheck", L["Enable"]..L["RangeCheck"], options, function ()
--~         local b = phRaid:ToggleModuleActive("phRaidRange")
--~     end)
--~     encheck:SetChecked(self.enabled)
--~     encheck:SetPoint("TOPLEFT", options, "TOPLEFT", 10, -10)
--~     encheck:Show()

--~     local rate = opt:CreateSlider("RangeRate", L["RefreshRate"], 0.2, 5, 0.2, options, function()
--~         this.Current:SetText(string.format("%.2f", arg1))
--~         phRaid.db.profile.Range.Time = arg1
--~         self:CancelScheduledEvent("phRaidRangeCheck")
--~         if self.enabled then
--~             self:ScheduleRepeatingEvent("phRaidRangeCheck", self.RangeCheck, arg1, self)
--~         end
--~     end)
--~     rate:SetValue(phRaid.db.profile.Range.time)
--~     rate:SetPoint("TOPLEFT", encheck, "BOTTOMLEFT", 0, -20)

--~     local firstAlpha = opt:CreateSlider("RangeFirstAlpha", L["FirstAlpha"], 0.05, 1, 0.05, options, function()
--~         this.Current:SetText(string.format("%.2f",arg1))
--~         phRaid.db.profile.Range.firstAlpha = arg1
--~     end)
--~     firstAlpha:SetValue(phRaid.db.profile.Range.firstAlpha)
--~     firstAlpha:SetPoint("TOPLEFT", rate, "BOTTOMLEFT", 0, -20)
--~ end
