﻿--[[---------------------------------------------------------------------------
    Name: phRaid
    Author: pherl <pherl@live.com>
-----------------------------------------------------------------------------]]

local L = AceLibrary("AceLocale-2.2"):new("phRaid")
local function RestoreFrameStyle()
    phRaid:CopyTable(phRaid.db.defaults.profile.FrameStyle, phRaid.db.profile.FrameStyle)
    phRaid:UpdateUnitFrames()
    phRaid:UpdateAllUnitFrameLayout()
end
local function RestoreLayout()
    phRaid.db.profile.Sort = phRaid.db.defaults.profile.Sort
    phRaid:CopyTable(phRaid.db.defaults.profile.Regions, phRaid.db.profile.Regions)
    for i = 1, phRaid.MAXREGION do
        phRaid.regionFrames[i]:SetScale(phRaid.db.profile.Regions[i].Scale)
    end
    phRaid:RestorePosition()
    phRaid:UpdateSortFunctions()
    phRaid:UpdateVisibility()
    phRaid:UpdateLayout()
end

phRaid.options = {
    type = "group",
    args = {
        config = {
            name = L["Config"],
            type = "execute",
            desc = L["Config"],
            func = function () phRaid.dewdrop:Open(phRaid.main, "cursorX", true, "cursorY", true) end,
            order = 1,
        },
        framestyle = {
            name = L["Frame Style"],
            type = "group",
            desc = L["Frame Style"],
            args = {
                layout = {
                    name = L["Layout"],
                    type = "text",
                    desc = L["Layout"],
                    get = function() return phRaid.db.profile.FrameStyle.Layout end,
                    set = function(value)
                        phRaid.db.profile.FrameStyle.Layout = value
                        phRaid:UpdateUnitFrames()
                        phRaid:UpdateAllUnitFrameLayout()
                    end,
                    validate = {L["Single Line Mode"], L["Double Lines Mode"]},
                    order = 1,
                },
                nameonbar = {
                    name = L["Show Unit Name on HP Bar"],
                    type = "toggle",
                    desc = L["Only For Single Line Mode"],
                    get = function() return phRaid.db.profile.FrameStyle.NameOnBar end,
                    set = function(value)
                        phRaid.db.profile.FrameStyle.NameOnBar = value
                        phRaid:UpdateUnitFrames()
                        phRaid:UpdateAllUnitFrameLayout()
                    end,
                    disabled = function() return phRaid.db.profile.FrameStyle.Layout == L["Double Lines Mode"] end,
                    order = 2
                },
--~                 righttoleft = {
--~                     name = L["Right To Left Layout"],
--~                     type = "toggle",
--~                     desc = L["Only For Single Line Mode"],
--~                     get = function() return phRaid.db.profile.FrameStyle.RightToLeft end,
--~                     set = function(value)
--~                         phRaid.db.profile.FrameStyle.RightToLeft = value
--~                         phRaid:UpdateAllUnitFrameLayout()
--~                     end,
--~                     order = 3,
--~                 },
                texture = {
                    name = L["Bar Texture"],
                    type = "text",
                    desc = L["Bar Texture"],
                    get = function() return phRaid.db.profile.FrameStyle.BarTexture end,
                    set = function(value)
                        phRaid.db.profile.FrameStyle.BarTexture = value
                        for k, v in phRaid.frames do
                            v.HPBar:SetStatusBarTexture(phRaid.BARTEXTURE[value])
                            v.MPBar:SetStatusBarTexture(phRaid.BARTEXTURE[value])
                        end
                    end,
                    validate = {"default", "banto", "halcyone", "otravi", "perl", "smooth", "striped", "charcoal"},
                    order = 5,
                },
                barwidth = {
                    name = L["Bar Width"],
                    type = "range",
                    desc = L["Bar Width"],
                    min = 40,
                    max = 200,
                    step = 5,
                    get = function() return phRaid.db.profile.FrameStyle.BarWidth end,
                    set = function(value)
                        phRaid.db.profile.FrameStyle.BarWidth = value
                        phRaid:UpdateAllUnitFrameLayout()
                    end,
                    order = 10,
                },
                namelength = {
                    name = L["Name Width"],
                    type = "range",
                    desc = L["Only For Single Line Mode"],
                    min = 20,
                    max = 200,
                    step = 2,
                    get = function() return phRaid.db.profile.FrameStyle.NameWidth end,
                    set = function(value)
                        phRaid.db.profile.FrameStyle.NameWidth = value
                        phRaid:UpdateAllUnitFrameLayout()
                    end,
                    disabled = function() return phRaid.db.profile.FrameStyle.Layout == L["Double Lines Mode"] end,
                    order = 11,
                },
                statuslength = {
                    name = L["Status Text Width"],
                    type = "range",
                    desc = L["Status Text Width"],
                    min = 20,
                    max = 200,
                    step = 2,
                    get = function() return phRaid.db.profile.FrameStyle.StatusWidth end,
                    set = function(value)
                        phRaid.db.profile.FrameStyle.StatusWidth = value
                        phRaid:UpdateAllUnitFrameLayout()
                    end,
                    order = 12,
                },
                hpheight = {
                    name = L["HP Bar Height"],
                    type = "range",
                    desc = L["HP Bar Height"],
                    min = 2,
                    max = 30,
                    step = 1,
                    get = function() return phRaid.db.profile.FrameStyle.HPBarHeight end,
                    set = function(value)
                        phRaid.db.profile.FrameStyle.HPBarHeight = value
                        phRaid:UpdateAllUnitFrameLayout()
                    end,
                    order = 20,
                },
                hptexttype = {
                    name = L["HP Text Type"],
                    type = "text",
                    desc = L["HP Text Type"],
                    get = function() return phRaid.db.profile.FrameStyle.HPTextType end,
                    set = function(value)
                        phRaid.db.profile.FrameStyle.HPTextType = value
                        phRaid:UNIT_HEALTH(phRaid.visible)
                    end,
                    validate = {L["Show Deficit"], L["Show Percent"], L["Do Not Show"]},
                    order = 21,
                },
                showmana = {
                    name = L["Show Mana Bar"],
                    type = "toggle",
                    desc = L["Show Mana Bar"],
                    get = function() return phRaid.db.profile.FrameStyle.ShowMana end,
                    set = function(value)
                        phRaid.db.profile.FrameStyle.ShowMana = value
--~                         phRaid:UpdateUnitFrames()
                        phRaid:UpdateAllUnitFrameLayout()
                    end,
                    order = 30,
                },
                mpheight = {
                    name = L["MP Bar Height"],
                    type = "range",
                    desc = L["MP Bar Height"],
                    min = 2,
                    max = 30,
                    step = 1,
                    get = function() return phRaid.db.profile.FrameStyle.MPBarHeight end,
                    set = function(value)
                        phRaid.db.profile.FrameStyle.MPBarHeight = value
                        phRaid:UpdateAllUnitFrameLayout()
                    end,
                    disabled = function() return not phRaid.db.profile.FrameStyle.ShowMana end,
                    order = 31,
                },
                enableAllTypeMP = {
                    name = L["EnableAllTypeMP"],
                    type = "toggle",
                    desc = L["EnableAllTypeMP"],
                    get = function() return phRaid.db.profile.FrameStyle.EnableAllTypeMP end,
                    set = function(value)
                        phRaid.db.profile.FrameStyle.EnableAllTypeMP = value
                        if value then
                            phRaid:RegisterBucketEvent("UNIT_RAGE", 0.2, "UNIT_MANA")
                            phRaid:RegisterBucketEvent("UNIT_ENERGY", 0.2, "UNIT_MANA")
                            phRaid:RegisterBucketEvent("UNIT_MAXRAGE", 0.2, "UNIT_MAXMANA")
                            phRaid:RegisterBucketEvent("UNIT_MAXENERGY", 0.2, "UNIT_MAXMANA")
                        else
                            phRaid:UnregisterBucketEvent("UNIT_RAGE")
                            phRaid:UnregisterBucketEvent("UNIT_ENERGY")
                            phRaid:UnregisterBucketEvent("UNIT_MAXRAGE")
                            phRaid:UnregisterBucketEvent("UNIT_MAXENERGY")
                        end
                        phRaid:UpdateAllUnitFrameLayout()
                    end,
                    disabled = function() return not phRaid.db.profile.FrameStyle.ShowMana end,
                    order = 32,
                },
                showgroup = {
                    name = L["Show Group Number"],
                    type = "toggle",
                    desc = L["Show Group Number"],
                    get = function() return phRaid.db.profile.FrameStyle.ShowGroup end,
                    set = function(value)
                        phRaid.db.profile.FrameStyle.ShowGroup = value
                        phRaid:UpdateUnitFrames()
                        phRaid:UpdateAllUnitFrameLayout()
                    end,
                    order = 40
                },
                groupgap = {
                    name = L["Group Gap"],
                    type = "range",
                    desc = L["Group Gap"],
                    min = 1,
                    max = 100,
                    step = 1,
                    get = function() return phRaid.db.profile.FrameStyle.GroupGap end,
                    set = function(value)
                        phRaid.db.profile.FrameStyle.GroupGap = value
                        phRaid:UpdateLayout()
                    end,
                    order = 45,
                },
                buffsize = {
                    name = L["Buff Icon Size"],
                    type = "range",
                    desc = L["Buff Icon Size"],
                    min = 5,
                    max = 25,
                    step = 1,
                    get = function() return phRaid.db.profile.FrameStyle.BuffSize end,
                    set = function(value)
                        phRaid.db.profile.FrameStyle.BuffSize = value
                        phRaid:UpdateAllUnitFrameLayout()
                        phRaid:GetModule("phRaidBuff"):UNIT_AURA(phRaid.visible)
                    end,
                    disabled = function() return not phRaid:IsModuleActive("phRaidBuff") end,
                    order = 50,
                },
                restoredefault = {
                    name = L["Restore Defaults"],
                    type = "execute",
                    desc = L["Restore Defaults"],
                    func = RestoreFrameStyle,
                },
            },
            order = 35,
        },
        show = {
            name = L["Show"],
            type = "toggle",
            desc = L["Show"],
            get = function() return phRaid.main:IsVisible() end,
            set = function(value) if value then phRaid.main:Show() else phRaid.main:Hide() end end,
            order = 10,
        },
        lock = {
            name = L["Lock"],
            type = "toggle",
            desc = L["Lock"],
            get = function() return phRaid.db.profile.Lock end,
            set = function(value) phRaid.db.profile.Lock = value end,
            order = 20,
        },
        layout = {
            name = L["Layout"],
            type = "group",
            desc = L["Layout"],
            args = {
                sort = {
                    name = L["Sort"],
                    type = "text",
                    desc = L["CustomSortHint"],
                    validate = {L["SortByClass"], L["SortByGroup"], L["SortByCustom"]},
                    order = 1,
                    get = function()
                        local sort = phRaid.db.profile.Sort
                        if sort == "CLASS" then return L["SortByClass"] end
                        if sort == "GROUP" then return L["SortByGroup"] end
                        if sort == "CUSTOM" then return L["SortByCustom"] end
                    end,
                    set = function(value)
                        if value == L["SortByClass"] then value = "CLASS"
                        elseif value == L["SortByGroup"] then value = "GROUP"
                        else value = "CUSTOM" end
                        phRaid.db.profile.Sort = value
                        phRaid:UpdateSortFunctions()
                        phRaid:UpdateVisibility()
                        phRaid:UpdateLayout()
                    end,
                    order = 10,
                },
                regions = {
                    name = L["Regions"],
                    type = "group",
                    desc = L["Regions"],
                    args = {
                    },
                    order = 20,
                },
                restoredefault = {
                    name = L["Restore Defaults"],
                    type = "execute",
                    desc = L["Restore Defaults"],
                    func = RestoreLayout,
                    order = 1000,
                },
            },
            order = 30,
        },
        misc = {
            name = L["Misc"],
            type = "group",
            desc = L["Misc"],
            args = {
                altdrag = {
                    name = L["AltDragAlways"],
                    desc = L["AltDragAlways"],
                    type = "toggle",
                    get = function() return phRaid.db.profile.AltDragAlways end,
                    set = function(value) phRaid.db.profile.AltDragAlways = value end,
                    order = 10,
                },
                tooltip = {
                    name = L["ShowTooltip"],
                    desc = L["ShowTooltip"],
                    type = "toggle",
                    get = function() return phRaid.db.profile.ShowTooltip end,
                    set = function(value) phRaid.db.profile.ShowTooltip = value end,
                    order = 20,
                },
                hidewhencombat = {
                    name = L["Hide Tooltip When Affecting Combat"],
                    desc = L["Hide Tooltip When Affecting Combat"],
                    type = "toggle",
                    get = function() return phRaid.db.profile.HideWhenCombat end,
                    set = function(value) phRaid.db.profile.HideWhenCombat = value end,
                    disabled = function() return not phRaid.db.profile.ShowTooltip end,
                    order = 21,
                },
                clickheal = {
                    name = L["Enable Click Heal"],
                    desc = L["Enable Click Heal"],
                    type = "toggle",
                    get = function() return phRaid.db.profile.ClickHeal end,
                    set = function(value) phRaid.db.profile.ClickHeal = value end,
                    order = 30,
                }
            },
            order = 1000,
        },
    }
}

function phRaid:OnProfileEnable()
    self:Debug("ProfileEnabled")
end

do
    local function GetRegionLayoutGetFunction(i, field)
        return function()
            return phRaid.db.profile.Regions[i][field]
        end
    end
    local function GetRegionLayoutSetFunction(i, field)
        return function(value)
            phRaid.db.profile.Regions[i][field] = value
            phRaid:UpdateLayout()
        end
    end
    local function GetRegionScaleSetFunction(i)
        return function(value)
            phRaid.db.profile.Regions[i].Scale = value
            phRaid.regionFrames[i]:SetScale(value)
            phRaid:SavePosition()
        end
    end
    local function SetRegionSortSetFunction(i)
        return function(value)
            local func = phRaid:ParseStringToFunctions(value)
            if func then
                phRaid.db.profile.Regions[i].Sort = value
                phRaid.regions[i].sortFunctions = func
                phRaid:UpdateVisibility()
                phRaid:UpdateLayout()
                return true
            else
                phRaid:Print(L["Region"] .. i .. ":" .. L["Incorrect"])
            end
        end
    end
    local function GetRegionShowGetFunction(i)
        return function()
            return phRaid.regionFrames[i]:IsVisible()
        end
    end
    local function GetRegionShowSetFunction(i)
        return function(value)
            if value then phRaid.regionFrames[i]:Show()
            else phRaid.regionFrames[i]:Hide()
            end
        end
    end
    local regions = phRaid.options.args.layout.args.regions.args
    local disableCustom = function() return phRaid.db.profile.Sort ~= "CUSTOM" end
    for i = 1, phRaid.MAXREGION do
        local regionIndex ="region" .. i 
        regions[regionIndex] = {}
        regions[regionIndex].name = L["Region"] .. i
        regions[regionIndex].type = "group"
        regions[regionIndex].args = {}
        regions[regionIndex].order = i
        if i == 1 then
            regions[regionIndex].desc = L["RegionOneDefault"]
        else
            regions[regionIndex].desc = L["OtherRegionsForCustom"]
            regions[regionIndex].disabled = disableCustom
        end
        local arg = regions[regionIndex].args

        local order = 1
        arg.show = {}
        arg.show.name = L["Show"]
        arg.show.desc = L["Show"]
        arg.show.type = "toggle"
        arg.show.get = GetRegionShowGetFunction(i)
        arg.show.set = GetRegionShowSetFunction(i)
        arg.show.order = order 
        order = order + 1
        
        arg.sortText = {}
        arg.sortText.name = L["SortText"]
        arg.sortText.desc = L["ConditionHelp"]
        arg.sortText.type = "text"
        arg.sortText.get = GetRegionLayoutGetFunction(i, "Sort")
        arg.sortText.set = SetRegionSortSetFunction(i)
        arg.sortText.usage = L["SortText"]
        arg.sortText.disabled = disableCustom
        arg.sortText.order = order
        order = order + 1

        arg.columns = {}
        arg.columns.name = L["ColumnCount"]
        arg.columns.desc = arg.columns.name
        arg.columns.type = "range"
        arg.columns.min = 1
        arg.columns.max = 9
        arg.columns.step = 1
        arg.columns.get = GetRegionLayoutGetFunction(i, "Columns")
        arg.columns.set = GetRegionLayoutSetFunction(i, "Columns")
        arg.columns.order = order
        order = order + 1

        arg.columnGap = {}
        arg.columnGap.name = L["ColumnGap"]
        arg.columnGap.desc = arg.columnGap.name
        arg.columnGap.type = "range"
        arg.columnGap.min = 0
        arg.columnGap.max = 150
        arg.columnGap.step = 5
        arg.columnGap.get = GetRegionLayoutGetFunction(i, "ColumnGap")
        arg.columnGap.set = GetRegionLayoutSetFunction(i, "ColumnGap")
        arg.columnGap.order = order
        order = order + 1
        
        arg.scale = {}
        arg.scale.name = L["Scale"]
        arg.scale.desc = arg.scale.name
        arg.scale.type = "range"
        arg.scale.min = 0.05
        arg.scale.max = 3
        arg.scale.step = 0.05
        arg.scale.get = GetRegionLayoutGetFunction(i, "Scale")
        arg.scale.set = GetRegionScaleSetFunction(i)
        arg.columnGap.order = order
        order = order + 1
        
        arg.nobreak = {}
        arg.nobreak.name = L["NoBreak"]
        arg.nobreak.desc = arg.nobreak.name
        arg.nobreak.type = "toggle"
        arg.nobreak.get = GetRegionLayoutGetFunction(i, "NoBreak")
        arg.nobreak.set = GetRegionLayoutSetFunction(i, "NoBreak")
        arg.nobreak.order = order
        order = order + 1
    end
end
