-- **************************
-- Coded By ReCover
-- ***
-- Changelog:
-- 0.3:
-- - Slash commands (/mapcoords or /mc)
-- - Saving settings variable (MapCoords)
-- - Coords below your portraite and your party members portraite (Not able to get it if member is in another zone, workaround anyone?)
-- - Able to toggle all labels (using slash commands)
-- - Added function round to round the numbers instead of stripping them from their decimals
-- - Updated toc to patch 1.3.1
-- 0.2:
-- - Kickass fix made by Astus so cursor coords is accurate out-of-the-box =)
-- 0.1:
-- - Made the AddOn
-- **************************

local OFFSET_X = 0.0022;
local OFFSET_Y = -0.0262;

MapCoords_Loaded="|cff00ff00MapCoords汉化版1.0已载入|r";
MapCoords_Modifier="|cff00ff00由DieBoy汉化|r";

-- Master echo colors
local R_ON = 0;
local G_ON = 1;
local B_ON = 0;
local R_OFF = 1;
local G_OFF = 0;
local B_OFF = 0;
local R_ABOUT = 1;
local G_ABOUT = 1;
local B_ABOUT = 0;

function round(float)
  return floor(float+0.5);
end

function MapCoords_OnLoad()
	SlashCmdList["MAPCOORDS"] = MapCoords_SlashCommand;
	SLASH_MAPCOORDS1 = "/mapcoords";
	SLASH_MAPCOORDS2 = "/mc";

	if (not MapCoords) then  --First start settings and first start notification
		MapCoords = {};
		MapCoords["worldmap cursor"]=true;
		MapCoords["worldmap player"]=true;
		MapCoords["player"]=true;
		MapCoords["party1"]=true;
		MapCoords["party2"]=true;
		MapCoords["party3"]=true;
		MapCoords["party4"]=true;
	end
	
	if( DEFAULT_CHAT_FRAME ) then
		DEFAULT_CHAT_FRAME:AddMessage(format(MapCoords_Loaded));
		DEFAULT_CHAT_FRAME:AddMessage(format(MapCoords_Modifier));
	end
	
end

function MapCoords_Echo(msg,r,g,b)
	if (not r) then r = 1; end
	if (not g) then g = 1; end
	if (not b) then b = 1; end
	
	DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b);
end

function MapCoords_SlashCommand(msg)
	msg = string.lower(msg);
	-- WorldMap
	if (msg == "worldmap" or msg =="w") then
		if (MapCoords["worldmap cursor"] == true and MapCoords["worldmap player"] == true) then
			MapCoords["worldmap cursor"]=false;
			MapCoords["worldmap player"]=false;
			MapCoords_Echo("MapCoords > 隐藏所有世界地图坐标");
		else
			MapCoords["worldmap cursor"]=true;
			MapCoords["worldmap player"]=true;
			MapCoords_Echo("MapCoords > 显示所有世界地图坐标");
		end
	elseif (msg == "worldmap cursor" or msg == "w c" or msg == "wc") then
		if (MapCoords["worldmap cursor"] == true) then
			MapCoords["worldmap cursor"]=false;
			MapCoords_Echo("MapCoords > 隐藏世界地图鼠标坐标");
		else
			MapCoords["worldmap cursor"]=true;
			MapCoords_Echo("MapCoords > 显示世界地图鼠标坐标");
		end
	elseif (msg == "worldmap player" or msg == "w p" or msg == "wp") then
		if (MapCoords["worldmap player"] == true) then
			MapCoords["worldmap player"]=false;
			MapCoords_Echo("MapCoords > 隐藏世界地图玩家坐标");
		else
			MapCoords["worldmap player"]=true;
			MapCoords_Echo("MapCoords > 显示世界地图玩家坐标");
		end
	-- Portrait
	elseif (msg == "portrait" or msg == "p") then
		if (MapCoords["portrait player"] == true and MapCoords["portrait party1"] == true and MapCoords["portrait party2"] == true and MapCoords["portrait party3"] == true and MapCoords["portrait party4"] == true) then
			MapCoords["portrait player"]=false;
			MapCoords["portrait party1"]=false;
			MapCoords["portrait party2"]=false;
			MapCoords["portrait party3"]=false;
			MapCoords["portrait party4"]=false;
			MapCoords_Echo("MapCoords > 隐藏所有头像坐标");
		else
			MapCoords["portrait player"]=true;
			MapCoords["portrait party1"]=true;
			MapCoords["portrait party2"]=true;
			MapCoords["portrait party3"]=true;
			MapCoords["portrait party4"]=true;
			MapCoords_Echo("MapCoords > 显示所有头像坐标");
		end
	elseif (msg == "player") then
		if (MapCoords["portrait player"] == true) then
			MapCoords["portrait player"]=false;
			MapCoords_Echo("MapCoords > 隐藏玩家头像坐标");
		else
			MapCoords["portrait player"]=true;
			MapCoords_Echo("MapCoords > 显示玩家头像坐标");
		end
	elseif (msg == "party") then
		if (MapCoords["portrait party1"] == true and MapCoords["portrait party2"] == true and MapCoords["portrait party3"] == true and MapCoords["portrait party4"] == true) then
			MapCoords["portrait party1"]=false;
			MapCoords["portrait party2"]=false;
			MapCoords["portrait party3"]=false;
			MapCoords["portrait party4"]=false;
			MapCoords_Echo("MapCoords > 隐藏队友头像坐标");
		else
			MapCoords["portrait party1"]=true;
			MapCoords["portrait party2"]=true;
			MapCoords["portrait party3"]=true;
			MapCoords["portrait party4"]=true;
			MapCoords_Echo("MapCoords > 显示队友头像坐标");
		end
	elseif (msg == "party 1" or msg == "party1" or msg == "p 1" or msg == "p1") then
		if (MapCoords["portrait party1"] == true) then
			MapCoords["portrait party1"]=false;
			MapCoords_Echo("MapCoords > 隐藏1号队友头像坐标");
		else
			MapCoords["portrait party1"]=true;
			MapCoords_Echo("MapCoords > 显示1号队友头像坐标");
		end
	elseif (msg == "party 2" or msg == "party2" or msg == "p 2" or msg == "p2") then
		if (MapCoords["portrait party2"] == true) then
			MapCoords["portrait party2"]=false;
			MapCoords_Echo("MapCoords > 隐藏2号队友头像坐标");
		else
			MapCoords["portrait party2"]=true;
			MapCoords["portrait"]=true;
			MapCoords_Echo("MapCoords > 显示2号队友头像坐标");
		end
	elseif (msg == "party 3" or msg == "party3" or msg == "p 3" or msg == "p3") then
		if (MapCoords["portrait party3"] == true) then
			MapCoords["portrait party3"]=false;
			MapCoords_Echo("MapCoords > 隐藏3号队友头像坐标");
		else
			MapCoords["portrait party3"]=true;
			MapCoords["portrait"]=true;
			MapCoords_Echo("MapCoords > 显示3号队友头像坐标");
		end
	elseif (msg == "party 4" or msg == "party4" or msg == "p 4" or msg == "p4") then
		if (MapCoords["portrait party4"] == true) then
			MapCoords["portrait party4"]=false;
			MapCoords_Echo("MapCoords > 隐藏4号队友头像坐标");
		else
			MapCoords["portrait party4"]=true;
			MapCoords["portrait"]=true;
			MapCoords_Echo("MapCoords > 显示4号队友头像坐标");
		end
	elseif (msg == "about" or msg == "a") then
		MapCoords_Echo("MapCoords汉化版",R_ABOUT,G_ABOUT,B_ABOUT);
		MapCoords_Echo("由DieBoy汉化",R_ABOUT,G_ABOUT,B_ABOUT);
		MapCoords_Echo("游戏ID 暗蚂蚁",R_ABOUT,G_ABOUT,B_ABOUT);
	else
	    MapCoords_Echo("MapCoords汉化版");
	    MapCoords_Echo("激活指令:");
	    MapCoords_Echo("/mapcoords or /mc");
	    MapCoords_Echo("-- 世界地图坐标 --");
	    if (MapCoords["worldmap cursor"] == true and MapCoords["worldmap player"] == true) then MapCoords_Echo("/mc [worldmap|w] 所有世界地图坐标:开启",R_ON,G_ON,B_ON);
	    else MapCoords_Echo("/mc [worldmap|w] 所有世界地图坐标:关闭",R_OFF,G_OFF,B_OFF); end
	    if (MapCoords["worldmap cursor"] == true) then MapCoords_Echo("/mc [worldmap cursor|wc|w c] 世界地图鼠标坐标:开启",R_ON,G_ON,B_ON);
	    else MapCoords_Echo("/mc [worldmap cursor|wc|w c] 世界地图鼠标坐标:关闭",R_OFF,G_OFF,B_OFF); end
	    if (MapCoords["worldmap player"] == true) then MapCoords_Echo("/mc [worldmap player|wp|w p] 世界地图玩家坐标:开启",R_ON,G_ON,B_ON);
	    else MapCoords_Echo("/mc [worldmap player|wp|w p] 世界地图玩家坐标:关闭",R_OFF,G_OFF,B_OFF); end
	    MapCoords_Echo("-- 头像坐标 --");
	    if (MapCoords["portrait player"] == true and MapCoords["portrait party1"] == true and MapCoords["portrait party2"] == true and MapCoords["portrait party3"] == true and MapCoords["portrait party4"] == true) then MapCoords_Echo("/mc [portrait|p] 所有头像坐标:开启",R_ON,G_ON,B_ON);
	    else MapCoords_Echo("/mc [portrait|p] 所有头像坐标:关闭",R_OFF,G_OFF,B_OFF); end
	    if (MapCoords["portrait player"] == true) then MapCoords_Echo("/mc [player] 玩家头像坐标:开启",R_ON,G_ON,B_ON);
	    else MapCoords_Echo("/mc [player] 玩家头像坐标:关闭",R_OFF,G_OFF,B_OFF); end
	    if (MapCoords["portrait party1"] == true and MapCoords["portrait party2"] == true and MapCoords["portrait party3"] == true and MapCoords["portrait party4"] == true) then MapCoords_Echo("/mc [party] 队伍头像坐标:开启",R_ON,G_ON,B_ON);
	    else MapCoords_Echo("/mc [party] 队伍头像坐标:关闭",R_OFF,G_OFF,B_OFF); end
	    if (MapCoords["portrait party1"] == true) then MapCoords_Echo("/mc [party1|party 1|p 1|p1] 1号队友头像坐标:开启",R_ON,G_ON,B_ON);
	    else MapCoords_Echo("/mc [party1|party 1|p 1|p1] 1号队友头像坐标:关闭",R_OFF,G_OFF,B_OFF); end
	    if (MapCoords["portrait party2"] == true) then MapCoords_Echo("/mc [party2|party 2|p 2|p2] 2号队友头像坐标:开启",R_ON,G_ON,B_ON);
	    else MapCoords_Echo("/mc [party2|party 2|p 2|p2] 2号队友头像坐标:关闭",R_OFF,G_OFF,B_OFF); end
	    if (MapCoords["portrait party3"] == true) then MapCoords_Echo("/mc [party3|party 3|p 3|p3] 3号队友头像坐标:开启",R_ON,G_ON,B_ON);
	    else MapCoords_Echo("/mc [party3|party 3|p 3|p3] 3号队友头像坐标:关闭",R_OFF,G_OFF,B_OFF); end
	    if (MapCoords["portrait party4"] == true) then MapCoords_Echo("/mc [party4|party 4|p 4|p4] 4号队友头像坐标:开启",R_ON,G_ON,B_ON);
	    else MapCoords_Echo("/mc [party4|party 4|p 4|p4] 4号队友头像坐标:关闭",R_OFF,G_OFF,B_OFF); end
	    MapCoords_Echo("/mc [about|a] -- 显示更多信息",R_ABOUT,G_ABOUT,B_ABOUT);
	end
end

function MapCoordsPlayer_OnUpdate()
	if (MapCoords["portrait player"] == true) then
		local posX, posY = GetPlayerMapPosition("player");
		if ( posX == 0 and posY == 0 ) then
			MapCoordsPlayerPortraitCoords:SetText("n/a");
		else
			MapCoordsPlayerPortraitCoords:SetText(round(posX * 100)..","..round(posY * 100));
		end
	else
		MapCoordsPlayerPortraitCoords:SetText("");
	end
	if (MapCoords["portrait party1"] == true and GetNumPartyMembers() >= 1) then
		local posX, posY = GetPlayerMapPosition("party1");
		if ( posX == 0 and posY == 0 ) then
			MapCoordsParty1PortraitCoords:SetText("n/a");
		else
			MapCoordsParty1PortraitCoords:SetText(round(posX * 100)..","..round(posY * 100));
		end
	else
		MapCoordsParty1PortraitCoords:SetText("");
	end
	if (MapCoords["portrait party2"] == true and GetNumPartyMembers() >= 2) then
		local posX, posY = GetPlayerMapPosition("party2");
		if ( posX == 0 and posY == 0 ) then
			MapCoordsParty2PortraitCoords:SetText("n/a");
		else
			MapCoordsParty2PortraitCoords:SetText(round(posX * 100)..","..round(posY * 100));
		end
	else
		MapCoordsParty2PortraitCoords:SetText("");
	end
	if (MapCoords["portrait party3"] == true and GetNumPartyMembers() >= 3) then
		local posX, posY = GetPlayerMapPosition("party3");
		if ( posX == 0 and posY == 0 ) then
			MapCoordsParty3PortraitCoords:SetText("n/a");
		else
			MapCoordsParty3PortraitCoords:SetText(round(posX * 100)..","..round(posY * 100));
		end
	else
		MapCoordsParty3PortraitCoords:SetText("");
	end
	if (MapCoords["portrait party4"] == true and GetNumPartyMembers() >= 4) then
		local posX, posY = GetPlayerMapPosition("party4");
		if ( posX == 0 and posY == 0 ) then
			MapCoordsParty4PortraitCoords:SetText("n/a");
		else
			MapCoordsParty4PortraitCoords:SetText(round(posX * 100)..","..round(posY * 100));
		end
	else
		MapCoordsParty4PortraitCoords:SetText("");
	end
end

function MapCoordsWorldMap_OnUpdate()
	local output = "";
	if (MapCoords["worldmap cursor"] == true) then
		local x, y = GetCursorPosition();
		-- Tweak coords so they are accurate
		local scale = WorldMapFrame:GetScale();
		x = x / scale;
		y = y / scale;
		local width = WorldMapButton:GetWidth();
		local height = WorldMapButton:GetHeight();
		local centerX, centerY = WorldMapFrame:GetCenter();
		local adjustedX = (x - (centerX - (width/2))) / width;
		local adjustedY = (centerY + (height/2) - y) / height;
		x = (adjustedX + OFFSET_X) * 100;
		y = (adjustedY + OFFSET_Y) * 100;
		-- Write output
		output = "鼠标坐标: "..format("%d,%d",x,y);
	end
	if (MapCoords["worldmap cursor"] == true and MapCoords["worldmap player"]) then output = output.." -- "; end
	if (MapCoords["worldmap player"] == true) then
		local px, py = GetPlayerMapPosition("player");
		output = output.."玩家坐标: "..round(px * 100)..","..round(py * 100);
	end
	MapCoordsWorldMap:SetText(output);
end

