tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Jeklik_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Venoxis_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Marli_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_BloodlordMandokir_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Jindo_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Arlokk_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Hakkar_OnLoad");



-- Jeklik
function CT_RABoss_Jeklik_OnLoad()
	CT_RABoss_AddMod("耶克里克", CT_RABOSS_JEKLIK_INFO, 1, CT_RABOSS_LOCATIONS_ZULGURUB);
	
	CT_RABoss_AddEvent("耶克里克", "CHAT_MSG_MONSTER_YELL", CT_RABoss_Jeklik_EventHandler);
	CT_RABoss_AddEvent("耶克里克", "CHAT_MSG_MONSTER_EMOTE", CT_RABoss_Jeklik_EventHandler);
	
	CT_RABoss_AddDropDownButton("耶克里克", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
end

function CT_RABoss_Jeklik_EventHandler(event)
	if ( not CT_RABoss_Mods["耶克里克"] or not CT_RABoss_Mods["耶克里克"]["status"] or not CT_RABoss_Mods["耶克里克"].enabled ) then
		return;
	end
	if ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_JEKLIK_BAT_TRIG) ) then
		CT_RABoss_Announce(CT_RABOSS_JEKLIK_BAT_WARN, CT_RABoss_Mods["耶克里克"]["announce"]);
		CT_RABoss_PlaySound(2);
	elseif ( event == "CHAT_MSG_MONSTER_EMOTE" and string.find(arg1, CT_RABOSS_JEKLIK_HEAL_TRIG) ) then
		CT_RABoss_Announce(CT_RABOSS_JEKLIK_HEAL_WARN, CT_RABoss_Mods["耶克里克"]["announce"]);
		CT_RABoss_PlaySound(3);
	end
end


-- Venoxis
function CT_RABoss_Venoxis_OnLoad()
	CT_RABoss_AddMod("温诺希斯", CT_RABOSS_VENOXIS_INFO, 1, CT_RABOSS_LOCATIONS_ZULGURUB);
	
	CT_RABoss_AddEvent("温诺希斯", "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", CT_RABoss_Venoxis_EventHandler);
	
	CT_RABoss_AddDropDownButton("温诺希斯", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
end

function CT_RABoss_Venoxis_EventHandler(event)
	if ( not CT_RABoss_Mods["温诺希斯"] or not CT_RABoss_Mods["温诺希斯"]["status"] or not CT_RABoss_Mods["温诺希斯"].enabled ) then
		return;
	end
	if ( event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS" and string.find(arg1, CT_RABOSS_VENOXIS_TRIG) ) then
		CT_RABoss_Announce(CT_RABOSS_VENOXIS_WARN, CT_RABoss_Mods["温诺希斯"]["announce"]);
		CT_RABoss_PlaySound(2);
	end
end


-- Mar'li
function CT_RABoss_Marli_OnLoad()
	CT_RABoss_AddMod("玛尔里", CT_RABOSS_MARLI_INFO, 1, CT_RABOSS_LOCATIONS_ZULGURUB);

	CT_RABoss_AddEvent("玛尔里", "CHAT_MSG_MONSTER_YELL", CT_RABoss_Marli_EventHandler);

	CT_RABoss_AddDropDownButton("玛尔里", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
end

function CT_RABoss_Marli_EventHandler(event)
	if ( not CT_RABoss_Mods["玛尔里"] or not CT_RABoss_Mods["玛尔里"]["status"] or not CT_RABoss_Mods["玛尔里"].enabled ) then
		return;
	end

	if ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_MARLI_CHILDS_TRIG) ) then
		CT_RABoss_Announce( CT_RABOSS_MARLI_CHILDS_WARN, CT_RABoss_Mods["玛尔里"]["announce"]);
		CT_RABoss_PlaySound(3);

	elseif ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_MARLI_SPIDER_TRIG) and not CT_RABoss_Mods["玛尔里"]["TransTroll"] ) then
		CT_RABoss_Mods["玛尔里"]["TransTroll"] = true;
		CT_RABoss_Announce( CT_RABOSS_MARLI_SPIDER_WARN, CT_RABoss_Mods["玛尔里"]["announce"]);
		CT_RABoss_PlaySound(2);
		CT_RABoss_Schedule("CT_RABoss_Marli_EventHandler", 58, "PreTransTrollWarning");
		CT_RABoss_VisualTimer.addTimer("MarliTrans", 63, CT_RABOSS_MARLI_SPIDER_TIMER);

	elseif ( event == "PreTransTrollWarning" ) then
		CT_RABoss_Mods["玛尔里"]["TransTroll"] = false;
		CT_RABoss_Announce(CT_RABOSS_MARLI_5SECWARN, CT_RABoss_Mods["玛尔里"]["announce"]);
		CT_RABoss_PlaySound(3);
	end
end


-- Bloodlord Mandokir
function CT_RABoss_BloodlordMandokir_OnLoad()
	CT_RABoss_AddMod("血领主曼多基尔", CT_RABOSS_MANDOKIR_INFO, 1, CT_RABOSS_LOCATIONS_ZULGURUB);
	CT_RABoss_AddEvent("血领主曼多基尔", "CHAT_MSG_MONSTER_YELL", CT_RABoss_BloodlordMandokir_EventHandler);
	
	CT_RABoss_AddDropDownButton("血领主曼多基尔", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("血领主曼多基尔", { CT_RABOSS_MANDOKIR_TELL_TARGET, CT_RABOSS_MANDOKOIR_TELL_TARGET_INFO }, "CT_RABoss_ModInfo", "sendTell", "CT_RABoss_SetInfo");
	
	CT_RABoss_SetVar("血领主曼多基尔", "alertNearby", 1);
end

function CT_RABoss_BloodlordMandokir_EventHandler(event)
	if ( not CT_RABoss_Mods["血领主曼多基尔"] or not CT_RABoss_Mods["血领主曼多基尔"]["status"] or not CT_RABoss_Mods["血领主曼多基尔"].enabled ) then
		return;
	end
	if ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_MANDOKIR_REGEXP) ) then
		local iStart, iEnd, sPlayer = string.find(arg1, CT_RABOSS_MANDOKIR_REGEXP);
		if ( sPlayer ) then
			if ( sPlayer == UnitName("player") ) then
				CT_RABoss_Announce(CT_RABOSS_MANDOKIR_WATCHWARNYOU);
				CT_RABoss_Announce(CT_RABOSS_MANDOKIR_WATCHWARNYOU);
				CT_RABoss_PlaySound(2);
				if ( CT_RA_Level >= 1 and CT_RABoss_Mods["血领主曼多基尔"]["announce"] ) then
					CT_RA_AddMessage("MS *** " .. UnitName("player") .. CT_RABOSS_MANDOKIR_WATCHWARNRAID .. " ***");
				end
				
			else
				if ( CT_RABoss_Mods["血领主曼多基尔"]["sendTell"] and CT_RA_Level >= 1 ) then
					SendChatMessage(CT_RABOSS_MANDOKIR_WATCHWARNTELL, "WHISPER", nil, sPlayer);
				end
				CT_RABoss_Announce("*** " .. sPlayer .. CT_RABOSS_MANDOKIR_WATCHWARNRAID .. " ***", CT_RABoss_Mods["血领主曼多基尔"]["announce"]);
				CT_RABoss_PlaySound(3);
			end
		end
	end
end


-- Jin'do
function CT_RABoss_Jindo_OnLoad()
	CT_RABoss_AddMod("金度", CT_RABOSS_JINDO_INFO, 1, CT_RABOSS_LOCATIONS_ZULGURUB);

	CT_RABoss_AddEvent("金度", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_Jindo_EventHandler);
	CT_RABoss_AddEvent("金度", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_Jindo_EventHandler);
	CT_RABoss_AddEvent("金度", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_Jindo_EventHandler);
	
	CT_RABoss_AddEvent("金度", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF", CT_RABoss_ProphetSkeram_EventHandler);
	CT_RABoss_AddEvent("金度", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE", CT_RABoss_ProphetSkeram_EventHandler);

	CT_RABoss_AddDropDownButton("金度", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("金度", { CT_RABOSS_JINDO_ALERT_NEARBY, CT_RABOSS_JINDO_ALERT_NEARBY_INFO }, "CT_RABoss_ModInfo", "alertNearby", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("金度", { CT_RABOSS_JINDO_TELL_TARGET, CT_RABOSS_JINDO_TELL_TARGET_INFO }, "CT_RABoss_ModInfo", "sendTell", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("金度", { CT_RABOSS_JINDO_MC, CT_RABOSS_JINDO_MC_INFO }, "CT_RABoss_ModInfo", "healing", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("金度", { CT_RABOSS_JINDO_SPLIT, CT_RABOSS_JINDO_SPLIT_INFO }, "CT_RABoss_ModInfo", "washtotem", "CT_RABoss_SetInfo");
end

function CT_RABoss_Jindo_EventHandler(event)
	if ( not CT_RABoss_Mods["金度"] or not CT_RABoss_Mods["金度"]["status"] or not CT_RABoss_Mods["金度"].enabled ) then
		return;
	end
	if ( event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE" ) then
		local iStart, iEnd, sPlayer, sType = string.find(arg1, CT_RABOSS_JINDO_AFFLICT_CURSE);
		if ( sPlayer and sType ) then
			if ( sPlayer == CT_RABOSS_SELF1 and sType == CT_RABOSS_SELF2 ) then
				if ( CT_RA_Level >= 1 and CT_RABoss_Mods["金度"]["announce"] ) then
					CT_RA_AddMessage("MS *** " .. UnitName("player") .. CT_RABOSS_JINDO_CURSEWARNRAID);
				end
				CT_RABoss_Announce(CT_RABOSS_JINDO_CURSEWARNYOU);
				CT_RABoss_Announce(CT_RABOSS_JINDO_CURSEWARNYOU);
			        CT_RABoss_PlaySound(2);

				
			else
				if ( CT_RABoss_Mods["金度"]["sendTell"] and CT_RA_Level >= 1 ) then
					SendChatMessage(CT_RABOSS_JINDO_CURSEWARNTELL, "WHISPER", nil, sPlayer);
				end
				if ( CT_RABoss_Mods["金度"]["alertNearby"] ) then
					CT_RABoss_Announce("*** " .. sPlayer .. CT_RABOSS_JINDO_CURSEWARNRAID, CT_RABoss_Mods["金度"]["announce"]);
					CT_RABoss_PlaySound(3);
				end
			end
		end
	end
		-- Arcane Explosion alert
	if ( event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE" and arg1 == CT_RABOSS_JINDO_ARCANE_DETECT and CT_RABoss_Mods["金度"]["healing"] ) then
		CT_RABoss_Announce(CT_RABOSS_JINDO_ARCANE_ALERT, CT_RABoss_Mods["金度"]["announce"]);
		CT_RABoss_PlaySound(3);
	end

	-- Split alert
	if ( event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF" and arg1 == CT_RABOSS_JINDO_SPLIT_DETECT and CT_RABoss_Mods["金度"]["washtotem"] ) then
		CT_RABoss_Announce(CT_RABOSS_JINDO_SPLIT_ALERT, CT_RABoss_Mods["金度"]["announce"]);
		CT_RABoss_PlaySound(3);
	end
end


-- Hakkar
function CT_RABoss_Hakkar_OnLoad()
	CT_RABoss_AddMod("哈卡", CT_RABOSS_HAKKAR_INFO, 1, CT_RABOSS_LOCATIONS_ZULGURUB);

	CT_RABoss_AddEvent("哈卡", "CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE", CT_RABoss_Hakkar_EventHandler);
	CT_RABoss_AddEvent("哈卡", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_Hakkar_EventHandler);
	CT_RABoss_AddEvent("哈卡", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_Hakkar_EventHandler);
	CT_RABoss_AddEvent("哈卡", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_Hakkar_EventHandler);
	CT_RABoss_AddEvent("哈卡", "CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_DAMAGE", CT_RABoss_Hakkar_EventHandler);
	CT_RABoss_AddEvent("哈卡", "CHAT_MSG_SPELL_PERIODIC_CREATURE_DAMAGE", CT_RABoss_Hakkar_EventHandler);
	CT_RABoss_AddEvent("哈卡", "CHAT_MSG_MONSTER_YELL", CT_RABoss_Hakkar_EventHandler);

	CT_RABoss_AddDropDownButton("哈卡", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("哈卡", { CT_RABOSS_HAKKAR_LD, CT_RABOSS_HAKKAR_LD_INFO }, "CT_RABoss_ModInfo", "lifeDrain", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("哈卡", { CT_RABOSS_HAKKAR_FRENESIE, CT_RABOSS_HAKKAR_FRENESIE_INFO }, "CT_RABoss_ModInfo", "frenzy", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("哈卡", { CT_RABOSS_HAKKAR_MC, CT_RABOSS_HAKKAR_MC_INFO }, "CT_RABoss_ModInfo", "crazy", "CT_RABoss_SetInfo");

	CT_RA_RegisterSlashCmd("/hakkarstop", CT_RABOSS_CMD_HAKKARSTOP, 30, "HAKKARSTOP", function()
		CT_RABoss_UnSchedule("CT_RABoss_Hakkar_EventHandler");
		CT_RABoss_UnSchedule("CT_RABoss_Hakkar_EventHandler");
		CT_RABoss_VisualTimer.removeTimer("HakkarEnrage");
		CT_RABoss_VisualTimer.removeTimer("HakkarPoison");
		CT_RABoss_VisualTimer.removeTimer("HakkarCrazy");
	end, "/hakkarstop");
end

function CT_RABoss_Hakkar_EventHandler(event)
	if ( not CT_RABoss_Mods["哈卡"] or not CT_RABoss_Mods["哈卡"]["status"] or not CT_RABoss_Mods["哈卡"].enabled ) then
		return;
	end
	
	if ( event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_DAMAGE" and CT_RABoss_Mods["哈卡"]["crazy"] ) then
		local iStart, iEnd, sPlayer, sType = string.find(arg1, CT_RABOSS_HAKKAR_AFFLICT_MC);
		if ( sPlayer and sType ) then
			if ( sPlayer == CT_RABOSS_SELF1 and sType == CT_RABOSS_SELF2 ) then
				CT_RABoss_Announce("*** " .. UnitName("player") .. CT_RABOSS_HAKKAR_MC_WARN, CT_RABoss_Mods["哈卡"]["announce"]);
			else
				CT_RABoss_Announce("*** " .. sPlayer .. CT_RABOSS_HAKKAR_MC_WARN, CT_RABoss_Mods["哈卡"]["announce"]);
			end
			CT_RABoss_PlaySound(2);
			CT_RABoss_Schedule("CT_RABoss_Hakkar_EventHandler", 16, "preCrazyWarn");
			CT_RABoss_VisualTimer.addTimer("HakkarCrazy", 20, CT_RABOSS_HAKKAR_MC_TIMER);
		end

	elseif ( event == "preCrazyWarn" and CT_RABoss_Mods["哈卡"]["crazy"] ) then
		CT_RABoss_Announce(CT_RABOSS_HAKKAR_MC_PREWARN, CT_RABoss_Mods["哈卡"]["announce"]);
		CT_RABoss_PlaySound(3);
	end

	if  ( (event == "CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE") and string.find(arg1, CT_RABOSS_HAKKAR_MC_RESIST) and CT_RABoss_Mods["哈卡"]["crazy"] ) then
		CT_RABoss_Announce(CT_RABOSS_HAKKAR_MC_RESIST_WARN, CT_RABoss_Mods["哈卡"]["announce"]) 
		CT_RABoss_PlaySound(2);
		CT_RABoss_Schedule("CT_RABoss_Hakkar_EventHandler", 16, "preCrazyWarn");
		CT_RABoss_VisualTimer.addTimer("HakkarCrazy", 20, CT_RABOSS_HAKKAR_MC_TIMER);
	end

	if ( event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_DAMAGE" and not CT_RABoss_Mods["哈卡"]["priorWarning"] and CT_RABoss_Mods["哈卡"]["lifeDrain"] ) then
		local iStart, iEnd, sPlayer, sType = string.find(arg1, CT_RABOSS_HAKKAR_AFFLICT_POISON);
		if ( sPlayer and sType ) then
			CT_RABoss_Mods["哈卡"]["priorWarning"] = true;
			CT_RABoss_Announce(CT_RABOSS_HAKKAR_LIFE_DRAIN, CT_RABoss_Mods["哈卡"]["announce"]);
			CT_RABoss_PlaySound(3);
			CT_RABoss_Schedule("CT_RABoss_Hakkar_EventHandler", 30, "priorWarning");
			CT_RABoss_VisualTimer.addTimer("HakkarPoison", 90, CT_RABOSS_HAKKAR_LD_TIMER);
		end
		
	elseif ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_HAKKAR_YELL) and ( CT_RABoss_Mods["哈卡"]["lifeDrain"] or CT_RABoss_Mods["哈卡"]["frenzy"] ) ) then
		CT_RABoss_UnSchedule("CT_RABoss_Hakkar_EventHandler");
		CT_RABoss_UnSchedule("CT_RABoss_Hakkar_EventHandler");

		if ( CT_RABoss_Mods["哈卡"]["lifeDrain"] ) then
	   		CT_RABoss_Mods["哈卡"]["priorWarning"] = true;
	        	CT_RABoss_Announce(CT_RABOSS_HAKKAR_90SECWARN, CT_RABoss_Mods["哈卡"]["announce"]);
		    	CT_RABoss_PlaySound(3);
		    	CT_RABoss_Schedule("CT_RABoss_Hakkar_EventHandler", 30, "priorWarning");
			CT_RABoss_VisualTimer.addTimer("HakkarPoison", 90, CT_RABOSS_HAKKAR_LD_TIMER);
		end
		
		if ( CT_RABoss_Mods["哈卡"]["frenzy"] ) then
			CT_RABoss_Schedule("CT_RABoss_Hakkar_EventHandler", 120, "totalWarning");
			CT_RABoss_VisualTimer.addTimer("HakkarEnrage", 600, CT_RABOSS_HAKKAR_FRENESIE_TIMER);
		end

	elseif ( event == "priorWarning" and CT_RABoss_Mods["哈卡"]["lifeDrain"] ) then
		CT_RABoss_Announce(CT_RABOSS_HAKKAR_60SECWARN, CT_RABoss_Mods["哈卡"]["announce"]);
		CT_RABoss_PlaySound(3);
		CT_RABoss_Schedule("CT_RABoss_Hakkar_EventHandler", 20, "priorWarning2");

	elseif ( event == "priorWarning2" and CT_RABoss_Mods["哈卡"]["lifeDrain"] ) then
		CT_RABoss_Announce(CT_RABOSS_HAKKAR_40SECWARN, CT_RABoss_Mods["哈卡"]["announce"]);
		CT_RABoss_PlaySound(3);
		CT_RABoss_Schedule("CT_RABoss_Hakkar_EventHandler", 30, "priorWarning3");

	elseif ( event == "priorWarning3" and CT_RABoss_Mods["哈卡"]["lifeDrain"] ) then
		CT_RABoss_Announce(CT_RABOSS_HAKKAR_10SECWARN, CT_RABoss_Mods["哈卡"]["announce"]);
		CT_RABoss_PlaySound(3);
		CT_RABoss_Mods["哈卡"]["priorWarning"] = false;

	elseif ( event == "totalWarning" and CT_RABoss_Mods["哈卡"]["frenzy"] ) then
		CT_RABoss_Announce(CT_RABOSS_HAKKAR_8MINWARN, CT_RABoss_Mods["哈卡"]["announce"]);
		CT_RABoss_PlaySound(3);
	    	CT_RABoss_Schedule("CT_RABoss_Hakkar_EventHandler", 180, "totalWarning2");

	elseif ( event == "totalWarning2" and CT_RABoss_Mods["哈卡"]["frenzy"] ) then
		CT_RABoss_Announce(CT_RABOSS_HAKKAR_5MINWARN, CT_RABoss_Mods["哈卡"]["announce"]);
		CT_RABoss_PlaySound(3);
	    	CT_RABoss_Schedule("CT_RABoss_Hakkar_EventHandler", 120, "totalWarning3");

	elseif ( event == "totalWarning3" and CT_RABoss_Mods["哈卡"]["frenzy"] ) then
		CT_RABoss_Announce(CT_RABOSS_HAKKAR_3MINWARN, CT_RABoss_Mods["哈卡"]["announce"]);
		CT_RABoss_PlaySound(3);
	    	CT_RABoss_Schedule("CT_RABoss_Hakkar_EventHandler", 60, "totalWarning4");

	elseif ( event == "totalWarning4" and CT_RABoss_Mods["哈卡"]["frenzy"] ) then
		CT_RABoss_Announce(CT_RABOSS_HAKKAR_2MINWARN, CT_RABoss_Mods["哈卡"]["announce"]);
		CT_RABoss_PlaySound(3);
	    	CT_RABoss_Schedule("CT_RABoss_Hakkar_EventHandler", 60, "totalWarning5");

	elseif ( event == "totalWarning5" and CT_RABoss_Mods["哈卡"]["frenzy"] ) then
		CT_RABoss_Announce(CT_RABOSS_HAKKAR_1MINWARN, CT_RABoss_Mods["哈卡"]["announce"]);
		CT_RABoss_PlaySound(3);
    end
end


-- Arlokk
function CT_RABoss_Arlokk_OnLoad()
	CT_RABoss_AddMod("娅尔罗", CT_RABOSS_ARLOKK_INFO, 1, CT_RABOSS_LOCATIONS_ZULGURUB);
	CT_RABoss_AddEvent("娅尔罗", "CHAT_MSG_MONSTER_YELL", CT_RABoss_Arlokk_EventHandler);

	CT_RABoss_AddDropDownButton("娅尔罗", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("娅尔罗", { CT_RABOSS_ARLOKK_TELL_TARGET, CT_RABOSS_ARLOKK_TELL_TARGET_INFO }, "CT_RABoss_ModInfo", "sendTell", "CT_RABoss_SetInfo");
	
	CT_RABoss_SetVar("娅尔罗", "alertNearby", 1);
end

function CT_RABoss_Arlokk_EventHandler(event)
	if ( not CT_RABoss_Mods["娅尔罗"] or not CT_RABoss_Mods["娅尔罗"]["status"] or not CT_RABoss_Mods["娅尔罗"].enabled ) then
		return;
	end
	
	if ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_ARLOKK_REGEXP) ) then
		local iStart, iEnd, sPlayer = string.find(arg1, CT_RABOSS_ARLOKK_REGEXP);
		if ( sPlayer ) then
			if ( sPlayer == UnitName("player") ) then
				CT_RABoss_Announce(CT_RABOSS_ARLOKK_WATCHWARNYOU);
				CT_RABoss_Announce(CT_RABOSS_ARLOKK_WATCHWARNYOU);
				CT_RABoss_PlaySound(2);
				if ( CT_RA_Level >= 1 and CT_RABoss_Mods["娅尔罗"]["announce"] ) then
					CT_RA_AddMessage("MS *** " .. UnitName("player") .. CT_RABOSS_ARLOKK_WATCHWARNRAID .. " ***");
				end
				
			else
				if ( CT_RABoss_Mods["娅尔罗"]["sendTell"] and CT_RA_Level >= 1 ) then
					SendChatMessage(CT_RABOSS_ARLOKK_WATCHWARNTELL, "WHISPER", nil, sPlayer);
				end
				CT_RABoss_Announce("*** " .. sPlayer .. CT_RABOSS_ARLOKK_WATCHWARNRAID .. " ***", CT_RABoss_Mods["娅尔罗"]["announce"]);
				CT_RABoss_PlaySound(3);
			end
		end

	end
end