tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Azuregos_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Drakes_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Emeriss_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Lethon_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Ysondre_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Taerar_OnLoad");


-- Azuregos
function CT_RABoss_Azuregos_OnLoad()
	CT_RABoss_AddMod("艾索雷葛斯", CT_RABOSS_AZUREGOS_INFO, 1, CT_RABOSS_LOCATIONS_OUTDOOR);
	
	CT_RABoss_AddEvent("艾索雷葛斯", "CHAT_MSG_MONSTER_YELL", CT_RABoss_Azuregos_EventHandler);
	CT_RABoss_AddEvent("艾索雷葛斯", "CHAT_MSG_SPELL_AURA_GONE_OTHER", CT_RABoss_Azuregos_EventHandler);
	CT_RABoss_AddEvent("艾索雷葛斯", "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", CT_RABoss_Azuregos_EventHandler);
	
	CT_RABoss_AddDropDownButton("艾索雷葛斯", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
end

function CT_RABoss_Azuregos_EventHandler(event)
	if ( not CT_RABoss_Mods["艾索雷葛斯"] or not CT_RABoss_Mods["艾索雷葛斯"]["status"] or not CT_RABoss_Mods["艾索雷葛斯"].enabled ) then
		return;
	end
	if ( event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS" and string.find(arg1, CT_RABOSS_AZUREGOS_REFLECTION) ) then
		CT_RABoss_Announce(CT_RABOSS_AZUREGOS_SHIELDWARN, CT_RABoss_Mods["艾索雷葛斯"]["announce"]);
		CT_RABoss_PlaySound(3);
		
	elseif ( event == "CHAT_MSG_SPELL_AURA_GONE_OTHER" and string.find(arg1, CT_RABOSS_AZUREGOS_REFLECTION_END) ) then
		CT_RABoss_Announce(CT_RABOSS_AZUREGOS_SHIELDDOWN, CT_RABoss_Mods["艾索雷葛斯"]["announce"]);
		CT_RABoss_PlaySound(2);
		
	elseif ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_AZUREGOS_TELEPORT) ) then
		CT_RABoss_Announce(CT_RABOSS_AZUREGOS_PORTWARN, CT_RABoss_Mods["艾索雷葛斯"]["announce"]);
		CT_RABoss_PlaySound(1);
	end
end


-- Emerald drakes
function CT_RABoss_Drakes_OnLoad()
	CT_RABoss_AddMod("翡翠绿龙", CT_RABOSS_DRAKES_INFO, 1, CT_RABOSS_LOCATIONS_OUTDOOR);
	
	CT_RABoss_AddEvent("翡翠绿龙", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_Drakes_EventHandler);
	CT_RABoss_AddEvent("翡翠绿龙", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_Drakes_EventHandler);
	CT_RABoss_AddEvent("翡翠绿龙", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_Drakes_EventHandler);
	
	CT_RABoss_AddDropDownButton("翡翠绿龙", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("翡翠绿龙", { CT_RABOSS_DRAKES_BREATH, CT_RABOSS_DRAKES_BREATH_INFO }, "CT_RABoss_ModInfo", "enableBreath", "CT_RABoss_SetInfo");
end

function CT_RABoss_Drakes_EventHandler(event)
	if ( not CT_RABoss_Mods["翡翠绿龙"] or not CT_RABoss_Mods["翡翠绿龙"]["status"] or not CT_RABoss_Mods["翡翠绿龙"].enabled ) then
		return;
	end

	-- Breath alert
	if ( event == "breathWarning" and CT_RABoss_Mods["翡翠绿龙"]["enableBreath"] ) then
		CT_RABoss_Mods["翡翠绿龙"]["BreathTrip"] = false;
		CT_RABoss_Announce(CT_RABOSS_DRAKES_BREATH_PREALERT, CT_RABoss_Mods["翡翠绿龙"]["announce"]);
		CT_RABoss_PlaySound(3);
	
	-- Breath prealert
	elseif ( ( string.find(arg1, CT_RABOSS_DRAKES_BREATH_DETECT) ) and not CT_RABoss_Mods["翡翠绿龙"]["BreathTrip"] and CT_RABoss_Mods["翡翠绿龙"]["enableBreath"] ) then
		CT_RABoss_Mods["翡翠绿龙"]["BreathTrip"] = true;
		CT_RABoss_Announce(CT_RABOSS_DRAKES_BREATH_ALERT, CT_RABoss_Mods["翡翠绿龙"]["announce"]);
		CT_RABoss_PlaySound(1);
		CT_RABoss_Schedule("CT_RABoss_Drakes_EventHandler", 25, "breathWarning");
		CT_RABoss_VisualTimer.addTimer("DrakesBreath", 30, CT_RABOSS_DRAKES_BREATH_TIMER);
	end
end


-- Emeriss
function CT_RABoss_Emeriss_OnLoad()
	CT_RABoss_AddMod("艾莫莉丝", CT_RABOSS_EMERISS_INFO, 1, CT_RABOSS_LOCATIONS_OUTDOOR);

	CT_RABoss_AddEvent("艾莫莉丝", "UNIT_HEALTH", CT_RABoss_Lethon_EventHandler);
	CT_RABoss_AddEvent("艾莫莉丝", "CHAT_MSG_MONSTER_YELL", CT_RABoss_Emeriss_EventHandler);
	CT_RABoss_AddEvent("艾莫莉丝", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_Emeriss_EventHandler);
	CT_RABoss_AddEvent("艾莫莉丝", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_Emeriss_EventHandler);
	CT_RABoss_AddEvent("艾莫莉丝", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_Emeriss_EventHandler);

	CT_RABoss_AddDropDownButton("艾莫莉丝", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("艾莫莉丝", { CT_RABOSS_EMERISS_ALERT_NEARBY, CT_RABOSS_EMERISS_ALERT_NEARBY_INFO }, "CT_RABoss_ModInfo", "alertNearby", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("艾莫莉丝", { CT_RABOSS_EMERISS_TELL_TARGET, CT_RABOSS_EMERISS_TELL_TARGET_INFO }, "CT_RABoss_ModInfo", "sendTell", "CT_RABoss_SetInfo");
	
	CT_RABoss_SetVar("艾莫莉丝", "alertNearby", 1);
	CT_RABoss_Mods["艾莫莉丝"]["healthLow"] = 80;
	CT_RABoss_Mods["艾莫莉丝"]["preAlert"] = true;
end

function CT_RABoss_Emeriss_EventHandler(event)
	if ( not CT_RABoss_Mods["艾莫莉丝"] or not CT_RABoss_Mods["艾莫莉丝"]["status"] or not CT_RABoss_Mods["艾莫莉丝"].enabled ) then
		return;
	end
	
	-- Disease alert
	if ( (event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" ) and CT_RABoss_Mods["艾莫莉丝"]["alertNearby"] ) then
		local iStart, iEnd, sPlayer, sType = string.find(arg1, CT_RABOSS_EMERISS_AFFLICT_BOMB);
		if ( sPlayer and sType ) then
			if ( sPlayer == CT_RABOSS_SELF1 and sType == CT_RABOSS_SELF2 ) then
				CT_RABoss_Announce(CT_RABOSS_EMERISS_DISEASE_ALERT_YOU);
				CT_RABoss_Announce(CT_RABOSS_EMERISS_DISEASE_ALERT_YOU);
				CT_RABoss_PlaySound(2);
				if ( CT_RA_Level >= 1 and CT_RABoss_Mods["艾莫莉丝"]["announce"] and CT_RABoss_Mods["艾莫莉丝"]["alertNearby"] ) then
					CT_RA_AddMessage("MS *** " .. UnitName("player") .. CT_RABOSS_EMERISS_DISEASE_ALERT);
				end
				
			else
				if ( CT_RABoss_Mods["艾莫莉丝"]["sendTell"] and CT_RA_Level >= 1 ) then
					SendChatMessage(CT_RABOSS_EMERISS_DISEASE_TELL, "WHISPER", nil, sPlayer);
				end
					CT_RABoss_Announce("*** " .. sPlayer .. CT_RABOSS_EMERISS_DISEASE_ALERT, CT_RABoss_Mods["艾莫莉丝"]["announce"]);
					CT_RABoss_PlaySound(2);
			end
		end
	end

	-- Begin  initialization
	if ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_EMERISS_BEGIN) and arg2 == CT_RABOSS_NAMES["艾莫莉丝"] ) then
		CT_RABoss_Mods["艾莫莉丝"]["healthLow"] = 80;
		CT_RABoss_Mods["艾莫莉丝"]["preAlert"] = true;
	end

	-- Event alert
	if ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_EMERISS_EVENT) and arg2 == CT_RABOSS_NAMES["艾莫莉丝"] ) then
		CT_RABoss_Announce(CT_RABOSS_EMERISS_EVENT_ALERT, CT_RABoss_Mods["艾莫莉丝"]["announce"]);
		CT_RABoss_Mods["艾莫莉丝"]["healthLow"] = CT_RABoss_Mods["艾莫莉丝"]["healthLow"] - 25;
		CT_RABoss_Mods["艾莫莉丝"]["preAlert"] = true;
	end

	-- Event pre-alert
	if ( UnitName("target") == CT_RABOSS_NAMES["艾莫莉丝"] and CT_RABoss_Mods["艾莫莉丝"]["preAlert"] ) then
		local targetHealth = UnitHealth("target");
		
		-- Alert near event
		if ( targetHealth <= CT_RABoss_Mods["艾莫莉丝"]["healthLow"] and targetHealth > CT_RABoss_Mods["艾莫莉丝"]["healthLow"]-3 and targetHealth > 15 ) then
			CT_RABoss_Mods["艾莫莉丝"]["preAlert"] = false;
			CT_RABoss_Announce(CT_RABOSS_EMERISS_EVENT_PREALERT, CT_RABoss_Mods["艾莫莉丝"]["announce"]);
		end
	end
end


-- Lethon
function CT_RABoss_Lethon_OnLoad()
	CT_RABoss_AddMod("莱索恩", CT_RABOSS_LETHON_INFO, 1, CT_RABOSS_LOCATIONS_OUTDOOR);

	CT_RABoss_AddEvent("莱索恩", "CHAT_MSG_MONSTER_YELL", CT_RABoss_Lethon_EventHandler);
	CT_RABoss_AddEvent("莱索恩", "UNIT_HEALTH", CT_RABoss_Lethon_EventHandler);

	CT_RABoss_AddDropDownButton("莱索恩", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");

	CT_RABoss_Mods["莱索恩"]["healthLow"] = 80;
	CT_RABoss_Mods["莱索恩"]["preAlert"] = true;
end

function CT_RABoss_Lethon_EventHandler(event)
	if ( not CT_RABoss_Mods["莱索恩"] or not CT_RABoss_Mods["莱索恩"]["status"] or not CT_RABoss_Mods["莱索恩"].enabled ) then
		return;
	end

	-- Begin  initialization
	if ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_LETHON_BEGIN) and arg2 == CT_RABOSS_NAMES["莱索恩"] ) then
		CT_RABoss_Mods["莱索恩"]["healthLow"] = 80;
		CT_RABoss_Mods["莱索恩"]["preAlert"] = true;
	end

	-- Event alert
	if ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_LETHON_EVENT) and arg2 == CT_RABOSS_NAMES["莱索恩"] ) then
		CT_RABoss_Announce(CT_RABOSS_LETHON_EVENT_ALERT, CT_RABoss_Mods["莱索恩"]["announce"]);
		CT_RABoss_Mods["莱索恩"]["healthLow"] = CT_RABoss_Mods["莱索恩"]["healthLow"] - 25;
		CT_RABoss_Mods["莱索恩"]["preAlert"] = true;
	end

	-- Event pre-alert
	if ( UnitName("target") == CT_RABOSS_NAMES["莱索恩"] and CT_RABoss_Mods["莱索恩"]["preAlert"] ) then
		local targetHealth = UnitHealth("target");
		
		-- Alert near event
		if ( targetHealth <= CT_RABoss_Mods["莱索恩"]["healthLow"] and targetHealth > CT_RABoss_Mods["莱索恩"]["healthLow"]-3 and targetHealth > 15 ) then
			CT_RABoss_Mods["莱索恩"]["preAlert"] = false;
			CT_RABoss_Announce(CT_RABOSS_LETHON_EVENT_PREALERT, CT_RABoss_Mods["莱索恩"]["announce"]);
		end
	end
end


-- Ysondre
function CT_RABoss_Ysondre_OnLoad()
	CT_RABoss_AddMod("伊森德雷", CT_RABOSS_YSONDRE_INFO, 1, CT_RABOSS_LOCATIONS_OUTDOOR);

	CT_RABoss_AddEvent("伊森德雷", "CHAT_MSG_MONSTER_YELL", CT_RABoss_Ysondre_EventHandler);
	CT_RABoss_AddEvent("伊森德雷", "UNIT_HEALTH", CT_RABoss_Ysondre_EventHandler);

	CT_RABoss_AddDropDownButton("伊森德雷", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");

	CT_RABoss_Mods["伊森德雷"]["healthLow"] = 80;
	CT_RABoss_Mods["伊森德雷"]["preAlert"] = true;
end

function CT_RABoss_Ysondre_EventHandler(event)
	if ( not CT_RABoss_Mods["伊森德雷"] or not CT_RABoss_Mods["伊森德雷"]["status"] or not CT_RABoss_Mods["伊森德雷"].enabled ) then
		return;
	end

	-- Begin  initialization
	if ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_YSONDRE_BEGIN) and arg2 == CT_RABOSS_NAMES["伊森德雷"] ) then
		CT_RABoss_Mods["伊森德雷"]["healthLow"] = 80;
		CT_RABoss_Mods["伊森德雷"]["preAlert"] = true;
	end

	-- Event alert
	if ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_YSONDRE_EVENT) and arg2 == CT_RABOSS_NAMES["伊森德雷"] ) then
		CT_RABoss_Announce(CT_RABOSS_YSONDRE_EVENT_ALERT, CT_RABoss_Mods["伊森德雷"]["announce"]);
		CT_RABoss_Mods["伊森德雷"]["healthLow"] = CT_RABoss_Mods["伊森德雷"]["healthLow"] - 25;
		CT_RABoss_Mods["伊森德雷"]["preAlert"] = true;
	end

	-- Event pre-alert
	if ( UnitName("target") == CT_RABOSS_NAMES["伊森德雷"] and CT_RABoss_Mods["伊森德雷"]["preAlert"] ) then
		local targetHealth = UnitHealth("target");
		
		-- Alert near event
		if ( targetHealth <= CT_RABoss_Mods["伊森德雷"]["healthLow"] and targetHealth > CT_RABoss_Mods["伊森德雷"]["healthLow"]-3 and targetHealth > 15 ) then
			CT_RABoss_Mods["伊森德雷"]["preAlert"] = false;
			CT_RABoss_Announce(CT_RABOSS_YSONDRE_EVENT_PREALERT, CT_RABoss_Mods["伊森德雷"]["announce"]);
		end
	end
end


-- Taerar
function CT_RABoss_Taerar_OnLoad()
	CT_RABoss_AddMod("泰拉尔", CT_RABOSS_TAERAR_INFO, 1, CT_RABOSS_LOCATIONS_OUTDOOR);

	CT_RABoss_AddEvent("泰拉尔", "CHAT_MSG_MONSTER_YELL", CT_RABoss_Taerar_EventHandler);
	CT_RABoss_AddEvent("泰拉尔", "UNIT_HEALTH", CT_RABoss_Taerar_EventHandler);

	CT_RABoss_AddDropDownButton("泰拉尔", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");

	CT_RABoss_Mods["泰拉尔"]["healthLow"] = 80;
	CT_RABoss_Mods["泰拉尔"]["preAlert"] = true;
end

function CT_RABoss_Taerar_EventHandler(event)
	if ( not CT_RABoss_Mods["泰拉尔"] or not CT_RABoss_Mods["泰拉尔"]["status"] or not CT_RABoss_Mods["泰拉尔"].enabled ) then
		return;
	end

	-- Begin  initialization
	if ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_TAERAR_BEGIN) and arg2 == CT_RABOSS_NAMES["泰拉尔"] ) then
		CT_RABoss_Mods["泰拉尔"]["healthLow"] = 80;
		CT_RABoss_Mods["泰拉尔"]["preAlert"] = true;
	end

	-- Event alert
	if ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_TAERAR_EVENT) and arg2 == CT_RABOSS_NAMES["泰拉尔"] ) then
		CT_RABoss_Announce(CT_RABOSS_TAERAR_EVENT_ALERT, CT_RABoss_Mods["泰拉尔"]["announce"]);
		CT_RABoss_Mods["泰拉尔"]["healthLow"] = CT_RABoss_Mods["泰拉尔"]["healthLow"] - 25;
		CT_RABoss_Mods["泰拉尔"]["preAlert"] = true;
	end

	-- Event pre-alert
	if ( UnitName("target") == CT_RABOSS_NAMES["泰拉尔"] and CT_RABoss_Mods["泰拉尔"]["preAlert"] ) then
		local targetHealth = UnitHealth("target");
		
		-- Alert near event
		if ( targetHealth <= CT_RABoss_Mods["泰拉尔"]["healthLow"] and targetHealth > CT_RABoss_Mods["泰拉尔"]["healthLow"]-3 and targetHealth > 15 ) then
			CT_RABoss_Mods["泰拉尔"]["preAlert"] = false;
			CT_RABoss_Announce(CT_RABOSS_TAERAR_EVENT_PREALERT, CT_RABoss_Mods["泰拉尔"]["announce"]);
		end
	end
end