tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Razorgore_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Vaelastrasz_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Firemaw_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Ebonroc_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Flamegor_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Chromaggus_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Nefarian_OnLoad");
tinsert(CT_RABoss_ModsToLoad,"CT_RABoss_Broodlord_OnLoad");




-- Razorgore
function CT_RABoss_Razorgore_OnLoad()
	CT_RABoss_AddMod("狂野的拉佐格尔", CT_RABOSS_RAZOR_INFO, 1, CT_RABOSS_LOCATIONS_BLACKWINGSLAIR);

	CT_RABoss_AddEvent("狂野的拉佐格尔", "CHAT_MSG_MONSTER_YELL", CT_RABoss_Razorgore_EventHandler);
	CT_RABoss_AddEvent("狂野的拉佐格尔", "CHAT_MSG_SPELL_FRIENDLYPLAYER_BUFF", CT_RABoss_Razorgore_EventHandler);
	CT_RABoss_AddEvent("狂野的拉佐格尔", "CHAT_MSG_ADDON", CT_RABoss_Razorgore_EventHandler);
	
	CT_RABoss_AddDropDownButton("狂野的拉佐格尔", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("狂野的拉佐格尔", { CT_RABOSS_RAZOR_MC, CT_RABOSS_RAZOR_MC_INFO }, "CT_RABoss_ModInfo", "mindControl", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("狂野的拉佐格尔", { CT_RABOSS_RAZOR_EGGS, CT_RABOSS_RAZOR_EGGS_INFO }, "CT_RABoss_ModInfo", "eggsCount", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("狂野的拉佐格尔", { CT_RABOSS_RAZOR_EGGSSYNC, CT_RABOSS_RAZOR_EGGSSYNC_INFO }, "CT_RABoss_ModInfo", "eggsSync", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("狂野的拉佐格尔", { CT_RABOSS_RAZOR_EGGSEST, CT_RABOSS_RAZOR_EGGSEST_INFO }, "CT_RABoss_ModInfo", "eggsTime", "CT_RABoss_SetInfo");
end

function CT_RABoss_Razorgore_EventHandler(event)
	if ( not CT_RABoss_Mods["狂野的拉佐格尔"] or not CT_RABoss_Mods["狂野的拉佐格尔"]["status"] or not CT_RABoss_Mods["狂野的拉佐格尔"].enabled ) then
		return;
	end
	-- Mind Control alert
	if ( event == "CHAT_MSG_MONSTER_YELL" and CT_RABoss_Mods["狂野的拉佐格尔"]["mindControl"] ) then
		local iStart, iEnd, sPlayer = string.find(arg1, CT_RABOSS_RAZOR_MC_DETECT);
		if ( sPlayer ) then
			CT_RABoss_Announce(string.format(CT_RABOSS_RAZOR_MC_WARN, sPlayer), CT_RABoss_Mods["狂野的拉佐格尔"]["announce"]);
			CT_RABoss_PlaySound(3);
		end
	end
	-- Init eggs count
	if ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_RAZOR_BEGIN_DETECT) and CT_RABoss_Mods["狂野的拉佐格尔"]["eggsCount"] ) then
		CT_RABoss_Counter.initialize("狂野的拉佐格尔", "EggCount", CT_RABoss_Mods["狂野的拉佐格尔"]["eggsSync"], CT_RABoss_Mods["狂野的拉佐格尔"]["announce"], 30, CT_RABOSS_RAZOR_MOBNAME, CT_RABOSS_RAZOR_EGG_WARN, CT_RABOSS_RAZOR_EGG_COUNTHEADER);
		CT_RABoss_Counter.setOptions("狂野的拉佐格尔", "EggCount", {["displayEstEnd"] = CT_RABoss_Mods["狂野的拉佐格尔"]["eggsTime"], ["discardTime"] = 1000});

		CT_RABoss_Announce(CT_RABOSS_RAZOR_BEGIN_WARN, CT_RABoss_Mods["狂野的拉佐格尔"]["announce"]);
		CT_RABoss_PlaySound(2);
	end
	-- Eggs count alerts
	if ( event == "CHAT_MSG_SPELL_FRIENDLYPLAYER_BUFF" and CT_RABoss_Mods["狂野的拉佐格尔"]["eggsCount"] ) then
		local _, _, mobName = string.find(arg1, CT_RABOSS_RAZOR_EGG_DETECT);
		
		if ( mobName ) then
			CT_RABoss_Counter.sendSync(mobName, "狂野的拉佐格尔", "EggCount");
		end
	elseif ( event == "CHAT_MSG_ADDON" and CT_RABoss_Mods["狂野的拉佐格尔"]["eggsCount"] ) then
		CT_RABoss_Counter.receiveSync(arg1, arg2, arg4, "狂野的拉佐格尔", "EggCount");
	end

end


-- Vaelastrasz
function CT_RABoss_Vaelastrasz_OnLoad()
	CT_RABoss_AddMod("瓦拉斯塔兹", CT_RABOSS_VAEL_INFO, 1, CT_RABOSS_LOCATIONS_BLACKWINGSLAIR);

	CT_RABoss_AddEvent("瓦拉斯塔兹", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_Vaelastrasz_EventHandler);
	CT_RABoss_AddEvent("瓦拉斯塔兹", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_Vaelastrasz_EventHandler);
	CT_RABoss_AddEvent("瓦拉斯塔兹", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_Vaelastrasz_EventHandler);
	
	CT_RABoss_AddDropDownButton("瓦拉斯塔兹", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("瓦拉斯塔兹", { CT_RABOSS_VAEL_ALERT_NEARBY, CT_RABOSS_VAEL_ALERT_NEARBY_INFO }, "CT_RABoss_ModInfo", "alertNearby", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("瓦拉斯塔兹", { CT_RABOSS_VAEL_TELL_TARGET, CT_RABOSS_VAEL_TELL_TARGET_INFO }, "CT_RABoss_ModInfo", "sendTell", "CT_RABoss_SetInfo");
	
	CT_RABoss_SetVar("瓦拉斯塔兹", "alertNearby", 1);
end

function CT_RABoss_Vaelastrasz_EventHandler(event)
	if ( not CT_RABoss_Mods["瓦拉斯塔兹"] or not CT_RABoss_Mods["瓦拉斯塔兹"]["status"] or not CT_RABoss_Mods["瓦拉斯塔兹"].enabled ) then
		return;
	end
	if ( event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE" or ( ( event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" ) and CT_RABoss_Mods["瓦拉斯塔兹"]["alertNearby"] ) ) then
		local iStart, iEnd, sPlayer, sType = string.find(arg1, CT_RABOSS_VAEL_AFFLICT_BURNING);
		if ( sPlayer and sType ) then
			if ( sPlayer == CT_RABOSS_SELF1 and sType == CT_RABOSS_SELF2 ) then
				sPlayer = UnitName("player");
				CT_RABoss_Announce(CT_RABOSS_VAEL_BOMBWARNYOU);
				CT_RABoss_Announce(CT_RABOSS_VAEL_BOMBWARNYOU);
				CT_RABoss_PlaySound(2);
			end
			if ( CT_RABoss_Mods["瓦拉斯塔兹"]["sendTell"] and CT_RA_Level > 1 and sPlayer ~= UnitName("player") ) then
				SendChatMessage(CT_RABOSS_VAEL_BURNINGWARNTELL, "WHISPER", nil, sPlayer);
			end

			CT_RABoss_Announce(format(CT_RABOSS_VAEL_BURNINGWARNRAID, sPlayer), CT_RABoss_Mods["瓦拉斯塔兹"]["announce"]);
			CT_RABoss_PlaySound(3);
		end
	end
end


-- Broodlord
function CT_RABoss_Broodlord_OnLoad()
	CT_RABoss_AddMod("勒什雷尔", CT_RABOSS_BROODLORD_INFO, 1, CT_RABOSS_LOCATIONS_BLACKWINGSLAIR);
	
	CT_RABoss_AddEvent("勒什雷尔", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_Broodlord_EventHandler);
	CT_RABoss_AddEvent("勒什雷尔", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_Broodlord_EventHandler);
	CT_RABoss_AddEvent("勒什雷尔", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_Broodlord_EventHandler);
	
	CT_RABoss_AddDropDownButton("勒什雷尔", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
end

function CT_RABoss_Broodlord_EventHandler(event)
	if ( not CT_RABoss_Mods["勒什雷尔"] or not CT_RABoss_Mods["勒什雷尔"]["status"] or not CT_RABoss_Mods["勒什雷尔"].enabled ) then
		return;
	end
	
	if ( event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" ) then
		local _, _, playerName = string.find(arg1, CT_RABOSS_BROODLORD_SACRIFICE_DETECT);
		
		if ( playerName ) then
			if ( playerName == CT_RABOSS_SELF1 ) then
				sPlayer = UnitName("player");
				
			end
			
			CT_RABoss_PlaySound(1);
			CT_RABoss_Announce(format(CT_RABOSS_BROODLORD_SACRIFICE_ALERT, playerName), CT_RABoss_Mods["勒什雷尔"]["announce"]);
		end
	end
end


-- Firemaw Wing Buffet and Shadowflame (Thanks to Puddy and Sting of Blood Legion - Illidan Horde)
function CT_RABoss_Firemaw_OnLoad()
	CT_RABoss_AddMod("费尔默", CT_RABOSS_FIREMAW_INFO, 1, CT_RABOSS_LOCATIONS_BLACKWINGSLAIR);

	CT_RABoss_AddEvent("费尔默", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE", CT_RABoss_Firemaw_EventHandler);
	CT_RABoss_AddEvent("费尔默", "PLAYER_REGEN_DISABLED", CT_RABoss_Firemaw_EventHandler);

	CT_RABoss_AddDropDownButton("费尔默", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");	
	CT_RABoss_AddDropDownButton("费尔默", { CT_RABOSS_SHADOWFLAME, CT_RABOSS_SHADOWFLAME_INFO }, "CT_RABoss_ModInfo", "shadowflame", "CT_RABoss_SetInfo");

	CT_RABoss_SetVar("费尔默", "shadowflame", 1);
end

function CT_RABoss_Firemaw_EventHandler(event)
	if ( not CT_RABoss_Mods["费尔默"] or not CT_RABoss_Mods["费尔默"]["status"] or not CT_RABoss_Mods["费尔默"].enabled ) then
		return;
	end
	if ( event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE" and string.find(arg1, CT_RABOSS_FIREMAW_BUFFET) and not CT_RABoss_Mods["费尔默"]["BuffetTrip"] ) then
		CT_RABoss_Announce(CT_RABOSS_FIREMAW_BUFFET_WARN, CT_RABoss_Mods["费尔默"]["announce"]);
		CT_RABoss_Mods["费尔默"]["BuffetTrip"] = true;
		CT_RABoss_PlaySound(2);
		CT_RABoss_Schedule("CT_RABoss_Firemaw_EventHandler", 29, "preBuffetWarning");
		CT_RABoss_VisualTimer.addTimer("FiremawBuffet", 32, CT_RABOSS_FIREMAW_BUFFET_TIMER);

	elseif ( event == "preBuffetWarning" ) then
		CT_RABoss_Mods["费尔默"]["BuffetTrip"] = false;
		CT_RABoss_Announce(CT_RABOSS_FIREMAW_3SECWARN, CT_RABoss_Mods["费尔默"]["announce"]);
		CT_RABoss_PlaySound(3);

	elseif ( event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE" and string.find(arg1, CT_RABOSS_FIREMAW_SHADOWFLAME_DETECT) and CT_RABoss_Mods["费尔默"]["shadowflame"] ) then
		CT_RABoss_Announce(CT_RABOSS_FIREMAW_SHADOWFLAME_WARN, CT_RABoss_Mods["费尔默"]["announce"]);
		CT_RABoss_PlaySound(3);

	elseif ( event == "PLAYER_REGEN_DISABLED" ) then
		CT_RABoss_Schedule("CT_RABoss_Firemaw_EventHandler", 10, "checkStart");


	elseif ( event == "checkStart" ) then
		if ( UnitName("target") and UnitName("target") == CT_RABOSS_NAMES["费尔默"] and UnitAffectingCombat("target") ) then
			CT_RABoss_Announce(CT_RABOSS_FIREMAW_BUFFET_WARN_FIRST, CT_RABoss_Mods["费尔默"]["announce"]);
			CT_RABoss_Mods["费尔默"]["BuffetTrip"] = true;
			CT_RABoss_PlaySound(2);
			CT_RABoss_Schedule("CT_RABoss_Firemaw_EventHandler", 19, "preBuffetWarning");
			CT_RABoss_VisualTimer.addTimer("FiremawBuffet", 22, CT_RABOSS_FIREMAW_BUFFET_TIMER);
		end

	end
end


-- Ebonroc Wing Buffet and Shadowflame (Thanks to Sting of Blood Legion - Illidan Horde)
function CT_RABoss_Ebonroc_OnLoad()
	CT_RABoss_AddMod("埃博诺克", CT_RABOSS_EBONROC_INFO, 1, CT_RABOSS_LOCATIONS_BLACKWINGSLAIR);

	CT_RABoss_AddEvent("埃博诺克", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE", CT_RABoss_Ebonroc_EventHandler);
	CT_RABoss_AddEvent("埃博诺克", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_Ebonroc_EventHandler);
	CT_RABoss_AddEvent("埃博诺克", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_Ebonroc_EventHandler);
	CT_RABoss_AddEvent("埃博诺克", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_Ebonroc_EventHandler);
	CT_RABoss_AddEvent("埃博诺克", "PLAYER_REGEN_DISABLED", CT_RABoss_Ebonroc_EventHandler);

	CT_RABoss_AddDropDownButton("埃博诺克", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");	
	CT_RABoss_AddDropDownButton("埃博诺克", { CT_RABOSS_SHADOWFLAME, CT_RABOSS_SHADOWFLAME_INFO }, "CT_RABoss_ModInfo", "shadowflame", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("埃博诺克", { CT_RABOSS_EBONROC_SHADOW, CT_RABOSS_EBONROC_SHADOW_INFO }, "CT_RABoss_ModInfo", "shadowEbonroc", "CT_RABoss_SetInfo");

	CT_RABoss_SetVar("埃博诺克", "shadowflame", 1);
	CT_RABoss_SetVar("埃博诺克", "shadowEbonroc", 1);
end

function CT_RABoss_Ebonroc_EventHandler(event)
	if ( not CT_RABoss_Mods["埃博诺克"] or not CT_RABoss_Mods["埃博诺克"]["status"] or not CT_RABoss_Mods["埃博诺克"].enabled ) then
		return;
	end
	if ( event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE" and string.find(arg1, CT_RABOSS_EBONROC_BUFFET) and not CT_RABoss_Mods["埃博诺克"]["BuffetTrip"] ) then
		CT_RABoss_Announce(CT_RABOSS_EBONROC_BUFFET_WARN, CT_RABoss_Mods["埃博诺克"]["announce"]);
		CT_RABoss_Mods["埃博诺克"]["BuffetTrip"] = true;
		CT_RABoss_PlaySound(2);
		CT_RABoss_Schedule("CT_RABoss_Ebonroc_EventHandler", 29, "preBuffetWarning");
		CT_RABoss_VisualTimer.addTimer("EbonrocBuffet", 32, CT_RABOSS_EBONROC_BUFFET_TIMER);

	elseif ( event == "preBuffetWarning" ) then
		CT_RABoss_Mods["埃博诺克"]["BuffetTrip"] = false;
		CT_RABoss_Announce(CT_RABOSS_EBONROC_3SECWARN, CT_RABoss_Mods["埃博诺克"]["announce"]);
		CT_RABoss_PlaySound(3);

	elseif ( event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE" and string.find(arg1, CT_RABOSS_EBONROC_SHADOWFLAME_DETECT) and CT_RABoss_Mods["埃博诺克"]["shadowflame"] ) then
		CT_RABoss_Announce(CT_RABOSS_EBONROC_SHADOWFLAME_WARN, CT_RABoss_Mods["埃博诺克"]["announce"]);
		CT_RABoss_PlaySound(3);

	elseif ( (event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE") and CT_RABoss_Mods["埃博诺克"]["shadowEbonroc"] ) then
		local iStart, iEnd, sPlayer, sType = string.find(arg1, CT_RABOSS_EBONROC_AFFLICT_BOMB);
		if ( sPlayer and sType ) then
			if ( sPlayer == CT_RABOSS_SELF1 and sType == CT_RABOSS_SELF2 ) then
				CT_RABoss_Announce(CT_RABOSS_EBONROC_SOEYOU);
				CT_RABoss_Announce(CT_RABOSS_EBONROC_SOEYOU);
				if ( CT_RA_Level >= 1 and CT_RABoss_Mods["埃博诺克"]["announce"] ) then
					CT_RA_AddMessage("MS " .. format(CT_RABOSS_EBONROC_SOEOTHER, UnitName("player")));
				end
				CT_RABoss_PlaySound(1);
			elseif ( CT_RABoss_Mods["埃博诺克"]["shadowEbonroc"] ) then
				if ( CT_RABoss_Mods["埃博诺克"]["shadowEbonroc"] ) then
					CT_RABoss_Announce(format(CT_RABOSS_EBONROC_SOEOTHER, sPlayer), CT_RABoss_Mods["埃博诺克"]["announce"]);
					CT_RABoss_PlaySound(1);
				end
			end
		end

	elseif ( event == "PLAYER_REGEN_DISABLED" ) then
		CT_RABoss_Schedule("CT_RABoss_Ebonroc_EventHandler", 10, "checkStart");

	elseif ( event == "checkStart" ) then
		if ( UnitName("target") == CT_RABOSS_NAMES["埃博诺克"] and UnitAffectingCombat("target") ) then
			CT_RABoss_Announce(CT_RABOSS_EBONROC_BUFFET_WARN_FIRST, CT_RABoss_Mods["埃博诺克"]["announce"]);
			CT_RABoss_Mods["埃博诺克"]["BuffetTrip"] = true;
			CT_RABoss_PlaySound(2);
			CT_RABoss_Schedule("CT_RABoss_Ebonroc_EventHandler", 19, "preBuffetWarning");
			CT_RABoss_VisualTimer.addTimer("EbonrocBuffet", 22, CT_RABOSS_EBONROC_BUFFET_TIMER);
		end
	end
end


-- Flamegor Wing Buffet, Shadowflame, and Frenzy (Thanks to Sting of Blood Legion - Illidan Horde)
function CT_RABoss_Flamegor_OnLoad()
	CT_RABoss_AddMod("弗莱格尔", CT_RABOSS_FLAMEGOR_INFO, 1, CT_RABOSS_LOCATIONS_BLACKWINGSLAIR);

	CT_RABoss_AddEvent("弗莱格尔", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE", CT_RABoss_Flamegor_EventHandler);
	CT_RABoss_AddEvent("弗莱格尔", "CHAT_MSG_MONSTER_EMOTE", CT_RABoss_Flamegor_EventHandler);				-- Frenzy
	CT_RABoss_AddEvent("弗莱格尔", "PLAYER_REGEN_DISABLED", CT_RABoss_Flamegor_EventHandler);

	CT_RABoss_AddDropDownButton("弗莱格尔", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");	
	CT_RABoss_AddDropDownButton("弗莱格尔", { CT_RABOSS_FLAMEGOR_FRENZY, CT_RABOSS_FLAMEGOR_FRENZY_INFO }, "CT_RABoss_ModInfo", "frenzyAlert", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("弗莱格尔", { CT_RABOSS_SHADOWFLAME, CT_RABOSS_SHADOWFLAME_INFO }, "CT_RABoss_ModInfo", "shadowflame", "CT_RABoss_SetInfo");

	CT_RABoss_SetVar("弗莱格尔", "shadowflame", 1);
	CT_RABoss_SetVar("弗莱格尔", "frenzyAlert", 1);
end

function CT_RABoss_Flamegor_EventHandler(event)
	if ( not CT_RABoss_Mods["弗莱格尔"] or not CT_RABoss_Mods["弗莱格尔"]["status"] or not CT_RABoss_Mods["弗莱格尔"].enabled ) then
		return;
	end
	if ( event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE" and string.find(arg1, CT_RABOSS_FLAMEGOR_BUFFET) and not CT_RABoss_Mods["弗莱格尔"]["BuffetTrip"] ) then
		CT_RABoss_Announce(CT_RABOSS_FLAMEGOR_BUFFET_WARN, CT_RABoss_Mods["弗莱格尔"]["announce"]);
		CT_RABoss_Mods["弗莱格尔"]["BuffetTrip"] = true;
		CT_RABoss_PlaySound(2);
		CT_RABoss_Schedule("CT_RABoss_Flamegor_EventHandler", 29, "preBuffetWarning");
		CT_RABoss_VisualTimer.addTimer("FlamegorBuffet", 32, CT_RABOSS_FLAMEGOR_BUFFET_TIMER);

	elseif ( event == "preBuffetWarning" ) then
		CT_RABoss_Mods["弗莱格尔"]["BuffetTrip"] = false;
		CT_RABoss_Announce(CT_RABOSS_FLAMEGOR_3SECWARN, CT_RABoss_Mods["弗莱格尔"]["announce"]);
		CT_RABoss_PlaySound(3);

	elseif ( event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE" and string.find(arg1, CT_RABOSS_FLAMEGOR_SHADOWFLAME_DETECT) and CT_RABoss_Mods["弗莱格尔"]["shadowflame"] ) then
		CT_RABoss_Announce(CT_RABOSS_FLAMEGOR_SHADOWFLAME_WARN, CT_RABoss_Mods["弗莱格尔"]["announce"]);
		CT_RABoss_PlaySound(3);

	elseif ( event == "CHAT_MSG_MONSTER_EMOTE" and string.find(arg1, CT_RABOSS_FLAMEGOR_FRENZY_DETECT) and CT_RABoss_Mods["弗莱格尔"]["frenzyAlert"] ) then
		CT_RABoss_Announce(CT_RABOSS_FLAMEGOR_TRANQSHOT, CT_RABoss_Mods["弗莱格尔"]["announce"]);
		CT_RABoss_PlaySound(1);

	elseif ( event == "PLAYER_REGEN_DISABLED" ) then
		CT_RABoss_Schedule("CT_RABoss_Flamegor_EventHandler", 10, "checkStart");

	elseif ( event == "checkStart" ) then
		if ( UnitName("target") == CT_RABOSS_NAMES["弗莱格尔"] and UnitAffectingCombat("target") ) then
			CT_RABoss_Announce(CT_RABOSS_FLAMEGOR_BUFFET_WARN_FIRST, CT_RABoss_Mods["弗莱格尔"]["announce"]);
			CT_RABoss_Mods["弗莱格尔"]["BuffetTrip"] = true;
			CT_RABoss_PlaySound(2);
			CT_RABoss_Schedule("CT_RABoss_Flamegor_EventHandler", 19, "preBuffetWarning");
			CT_RABoss_VisualTimer.addTimer("FlamegorBuffet", 22, CT_RABOSS_FLAMEGOR_BUFFET_TIMER);
		end
	end
end


-- Chromaggus
CT_RABoss_Chromaggus_PlayerDamageEvents =
{
	["CHAT_MSG_SPELL_SELF_DAMAGE"] = true,
	["CHAT_MSG_SPELL_PET_DAMAGE"] = true,
	["CHAT_MSG_SPELL_PARTY_DAMAGE"] = true,
	["CHAT_MSG_SPELL_FRIENDLYPLAYER_DAMAGE"] = true
};

function CT_RABoss_Chromaggus_OnLoad() -- Many many thanks to Silmalia of Ebon Order for the majority of code for this mod
	CT_RABoss_AddMod("克洛玛古斯", CT_RABOSS_CHROMAGGUS_INFO, 1, CT_RABOSS_LOCATIONS_BLACKWINGSLAIR);

	CT_RABoss_AddDropDownButton("克洛玛古斯", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("克洛玛古斯", { CT_RABOSS_CHROMAGGUS_BREATHWARNING, CT_RABOSS_CHROMAGGUS_BREATHWARNING_INFO }, "CT_RABoss_ModInfo", "breathWarning", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("克洛玛古斯", { CT_RABOSS_CHROMAGGUS_CASTWARNING, CT_RABOSS_CHROMAGGUS_CASTWARNING_INFO }, "CT_RABoss_ModInfo", "castWarning", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("克洛玛古斯", { CT_RABOSS_CHROMAGGUS_SHIELDWARNING, CT_RABOSS_CHROMAGGUS_SHIELDWARNING_INFO }, "CT_RABoss_ModInfo", "shieldWarning", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("克洛玛古斯", { CT_RABOSS_CHROMAGGUS_FRENZYWARNING, CT_RABOSS_CHROMAGGUS_FRENZYWARNING_INFO }, "CT_RABoss_ModInfo", "frenzyWarning", "CT_RABoss_SetInfo");

	CT_RABoss_UnSchedule("CT_RABoss_Chromaggus_OnEvent");

	CT_RABoss_Mods["克洛玛古斯"][CT_RABOSS_CHROMAGGUS_BREATH1] = CT_RABOSS_CHROMAGGUS_BREATH1;
	CT_RABoss_Mods["克洛玛古斯"][CT_RABOSS_CHROMAGGUS_BREATH2] = CT_RABOSS_CHROMAGGUS_BREATH2;
	CT_RABoss_Mods["克洛玛古斯"]["LastBreath"] = nil;
	CT_RABoss_Mods["克洛玛古斯"]["Vulnerability"] = nil;
	CT_RABoss_Mods["克洛玛古斯"]["checkStart"] = nil;

	CT_RABoss_SetVar("克洛玛古斯", "breathWarning", true);
	CT_RABoss_SetVar("克洛玛古斯", "castWarning", false);
	CT_RABoss_SetVar("克洛玛古斯", "frenzyWarning", false);
	CT_RABoss_SetVar("克洛玛古斯", "shieldWarning", false);

	CT_RABoss_AddEvent("克洛玛古斯", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE", CT_RABoss_Chromaggus_OnEvent); -- Breaths
	CT_RABoss_AddEvent("克洛玛古斯", "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", CT_RABoss_Chromaggus_OnEvent); -- Frenzy
	CT_RABoss_AddEvent("克洛玛古斯", "CHAT_MSG_MONSTER_EMOTE", CT_RABoss_Chromaggus_OnEvent); -- Elemental Shield
	CT_RABoss_AddEvent("克洛玛古斯", "PLAYER_REGEN_DISABLED", CT_RABoss_Chromaggus_OnEvent); -- Start of encounter

	for k, v in CT_RABoss_Chromaggus_PlayerDamageEvents do
		CT_RABoss_AddEvent("克洛玛古斯", k, CT_RABoss_Chromaggus_OnEvent); -- Detect Elemental Shield vulnerable school
	end
end

function CT_RABoss_Chromaggus_ResetMod()
	CT_RABoss_Mods["克洛玛古斯"][CT_RABOSS_CHROMAGGUS_BREATH1] = CT_RABOSS_CHROMAGGUS_BREATH1;
	CT_RABoss_Mods["克洛玛古斯"][CT_RABOSS_CHROMAGGUS_BREATH2] = CT_RABOSS_CHROMAGGUS_BREATH2;
	CT_RABoss_Mods["克洛玛古斯"]["LastBreath"] = nil;
	CT_RABoss_Mods["克洛玛古斯"]["checkStart"] = nil;
	CT_RABoss_Mods["克洛玛古斯"]["Vulnerability"] = nil;

	CT_RABoss_UnSchedule("CT_RABoss_Chromaggus_OnEvent");
end

function CT_RABoss_Chromaggus_OnEvent(event)
	-- Return if the mod is not enabled
	if ( not CT_RABoss_Mods["克洛玛古斯"] or not CT_RABoss_Mods["克洛玛古斯"]["enabled"] or not CT_RABoss_Mods["克洛玛古斯"]["status"] ) then
		return;
	end
	
	-- Set to current time
	local currTime = GetTime();

	if ( CT_RABoss_Mods["克洛玛古斯"][CT_RABOSS_CHROMAGGUS_BREATH1] and ( not CT_RABoss_Mods["克洛玛古斯"]["LastAction"] or ( currTime - CT_RABoss_Mods["克洛玛古斯"]["LastAction"] ) > CT_RABOSS_CHROMAGGUS_COMBATLIMIT ) and not CT_RABoss_Mods["克洛玛古斯"]["checkStart"] ) then
		CT_RABoss_Debug(1, "Resetting mod", GetTime() - ( CT_RABoss_Mods["克洛玛古斯"]["LastAction"] or GetTime()+1 ));
		CT_RABoss_Chromaggus_ResetMod();
	end
	
	if ( CT_RABoss_Mods["克洛玛古斯"]["breathWarning"] and ( event == CT_RABOSS_CHROMAGGUS_BREATH1 or event == CT_RABOSS_CHROMAGGUS_BREATH2 ) ) then
		-- Breath warnings
--		local name = event;
--		if ( CT_RABoss_Mods["克洛玛古斯"][event] ) then
		local name = CT_RABoss_Mods["克洛玛古斯"][event];
--		end
		CT_RABoss_Debug(2, "Warning for scheduled breath", event, name);
		CT_RABoss_Announce(format(CT_RABOSS_CHROMAGGUS_BREATH10SECWARNING, name), CT_RABoss_Mods["克洛玛古斯"]["announce"]);
		CT_RABoss_PlaySound(1);
		
	elseif ( event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE" ) then
		-- Breath attack
		local iStart, iEnd, spellName = string.find(arg1, CT_RABOSS_CHROMAGGUS_BREATHCASTSTRING);
		
		if ( spellName ) then
			-- Set the names if they are not set yet
			if ( CT_RABoss_Mods["克洛玛古斯"][CT_RABOSS_CHROMAGGUS_BREATH1] == CT_RABOSS_CHROMAGGUS_BREATH1 ) then
				CT_RABoss_Mods["克洛玛古斯"][CT_RABOSS_CHROMAGGUS_BREATH1] = spellName;
				CT_RABoss_Debug(3, "Setting breath 1", spellName);
			elseif ( CT_RABoss_Mods["克洛玛古斯"][CT_RABOSS_CHROMAGGUS_BREATH2] == CT_RABOSS_CHROMAGGUS_BREATH2 ) then
				CT_RABoss_Mods["克洛玛古斯"][CT_RABOSS_CHROMAGGUS_BREATH2] = spellName;
				CT_RABoss_Debug(3, "Setting breath 2", spellName);
			end
			
			-- Used to make sure we're still fighting
			CT_RABoss_Mods["克洛玛古斯"]["LastAction"] = currTime;
			
			if ( CT_RABoss_Mods["克洛玛古斯"]["castWarning"] ) then
				CT_RABoss_Announce(format(CT_RABOSS_CHROMAGGUS_BREATHCASTINGWARNING, spellName), CT_RABoss_Mods["克洛玛古斯"]["announce"]);
			end
			
			if ( CT_RABoss_Mods["克洛玛古斯"][CT_RABOSS_CHROMAGGUS_BREATH1] == spellName ) then
				CT_RABoss_Schedule("CT_RABoss_Chromaggus_OnEvent", CT_RABOSS_CHROMAGGUS_BREATHWARNINGTIME, CT_RABOSS_CHROMAGGUS_BREATH1);
				CT_RABoss_VisualTimer.addTimer("ChromaggusBreath", 30, CT_RABoss_Mods["克洛玛古斯"][CT_RABOSS_CHROMAGGUS_BREATH2]);
				CT_RABoss_Debug(2, "Scheduling breath", CT_RABOSS_CHROMAGGUS_BREATH1);
			elseif ( CT_RABoss_Mods["克洛玛古斯"][CT_RABOSS_CHROMAGGUS_BREATH2] == spellName ) then
				CT_RABoss_Schedule("CT_RABoss_Chromaggus_OnEvent", CT_RABOSS_CHROMAGGUS_BREATHWARNINGTIME, CT_RABOSS_CHROMAGGUS_BREATH2);
				CT_RABoss_VisualTimer.addTimer("ChromaggusBreath", 30, CT_RABoss_Mods["克洛玛古斯"][CT_RABOSS_CHROMAGGUS_BREATH1]);
				CT_RABoss_Debug(2, "Scheduling breath", CT_RABOSS_CHROMAGGUS_BREATH2);
			end
		end
	elseif ( event == "CHAT_MSG_MONSTER_EMOTE" ) then
		-- Frenzy
		if ( string.find(arg1, CT_RABOSS_CHROMAGGUS_FRENZYEMOTE) and arg2 == CT_RABOSS_NAMES["克洛玛古斯"] ) then
			if ( CT_RABoss_Mods["克洛玛古斯"]["frenzyWarning"] ) then
				CT_RABoss_Announce(CT_RABOSS_CHROMAGGUS_FRENZYCASTWARNING, CT_RABoss_Mods["克洛玛古斯"]["announce"]);
				CT_RABoss_PlaySound(2);
			end
			-- Used to make sure we're still fighting
			CT_RABoss_Mods["克洛玛古斯"]["LastAction"] = currTime;
			
		-- Elemental Shield
		elseif ( string.find(arg1, CT_RABOSS_CHROMAGGUS_SHIELDEMOTE) and arg2 == CT_RABOSS_NAMES["克洛玛古斯"] ) then
			if ( CT_RABoss_Mods["克洛玛古斯"]["shieldWarning"] ) then
--				CT_RABoss_Announce(CT_RABOSS_CHROMAGGUS_NEWVULNERABILITYWARNING, CT_RABoss_Mods["克洛玛古斯"]["announce"]);
				CT_RABoss_Announce(CT_RABOSS_CHROMAGGUS_NEWVULNERABILITYWARNING);
				CT_RABoss_PlaySound(1);
			end
			-- Used to make sure we're still fighting
			CT_RABoss_Mods["克洛玛古斯"]["LastAction"] = currTime;
			
			-- Since spells that are in the air when Chromaggus changes resists will still hit him with vulnerability bonus, we wait 2.5 seconds before we clear resists.
			CT_RABoss_Schedule( function() CT_RABoss_Mods["克洛玛古斯"]["Vulnerability"] = nil CT_RABoss_Debug(4, "Resetting vulnerability"); end, CT_RABOSS_CHROMAGGUS_WAITSHIELDCLEAR);
		end
		
	elseif ( CT_RABoss_Chromaggus_PlayerDamageEvents[event] ) then
		-- Check for new vulnerabilities
		if ( not CT_RABoss_Mods["克洛玛古斯"]["Vulnerability"] ) then
			local iStart, iEnd, hittype, damage, school = string.find(arg1, CT_RABOSS_CHROMAGGUS_SPELLDAMAGESTRING);
			if ( tonumber(damage or "") ) then
				CT_RABoss_Debug(1, "Registered hit", hittype, tonumber(damage), school);
				-- Used to make sure we're still fighting
				CT_RABoss_Mods["克洛玛古斯"]["LastAction"] = currTime;
				
				if ( 
					( tonumber(damage) >= CT_RABOSS_CHROMAGGUS_ELEMENTALSHIELDLIMIT_HIT and string.find(hittype, CT_RABOSS_CHROMAGGUS_HIT) ) or
					( tonumber(damage) >= CT_RABOSS_CHROMAGGUS_ELEMENTALSHIELDLIMIT_CRIT and string.find(hittype, CT_RABOSS_CHROMAGGUS_CRIT) )
				) then
					CT_RABoss_Debug(4, "Setting vulnerability", school, (tonumber(damage) or -1));
					CT_RABoss_Mods["克洛玛古斯"]["Vulnerability"] = school;
					
					if ( CT_RABoss_Mods["克洛玛古斯"]["shieldWarning"] ) then
--						CT_RABoss_Announce(format(CT_RABOSS_CHROMAGGUS_NEWVULNERABILITYFOUNDWARNING, school), CT_RABoss_Mods["克洛玛古斯"]["announce"]);
						CT_RABoss_Announce(format(CT_RABOSS_CHROMAGGUS_NEWVULNERABILITYFOUNDWARNING, school));
						CT_RABoss_PlaySound(2);
					end
				end
			end
		end
			
	elseif ( event == "PLAYER_REGEN_DISABLED" ) then
		CT_RABoss_Mods["克洛玛古斯"]["checkStart"] = true;
		CT_RABoss_Schedule("CT_RABoss_Chromaggus_OnEvent", 5, "checkStart");
	
	elseif ( event == "checkStart" ) then
		local shallRestoreTarget = false;
		
		if ( CT_RABoss_Mods["克洛玛古斯"]["checkStart"] ) then
			if ( not UnitExists("target") or ( UnitName("target") ~= CT_RABOSS_CHROMAGGUS_BOSSNAME and UnitClass("player") ~= CT_RA_ROGUE ) ) then
				TargetByName(CT_RABOSS_CHROMAGGUS_BOSSNAME);
				shallRestoreTarget = true;
			end
			
			if ( UnitExists("target") and UnitName("target") == CT_RABOSS_CHROMAGGUS_BOSSNAME and UnitAffectingCombat("target") ) then
				CT_RABoss_Chromaggus_ResetMod();
				-- Used to make sure we're still fighting
				CT_RABoss_Mods["克洛玛古斯"]["LastAction"] = currTime;
				
				CT_RABoss_Schedule("CT_RABoss_Chromaggus_OnEvent", CT_RABOSS_CHROMAGGUS_BREATHWARNINGTIME - CT_RABOSS_CHROMAGGUS_BREATHINTERVAL - 5, CT_RABOSS_CHROMAGGUS_BREATH1);
				CT_RABoss_Schedule("CT_RABoss_Chromaggus_OnEvent", CT_RABOSS_CHROMAGGUS_BREATHWARNINGTIME - 5, CT_RABOSS_CHROMAGGUS_BREATH2);
				CT_RABoss_VisualTimer.addTimer("ChromaggusBreath", 25, CT_RABoss_Mods["克洛玛古斯"][CT_RABOSS_CHROMAGGUS_BREATH1]);
			else
				CT_RABoss_Mods["克洛玛古斯"]["LastAction"] = nil;
			end
			
			if ( shallRestoreTarget ) then
				TargetLastTarget();
			end
		end
		CT_RABoss_Mods["克洛玛古斯"]["checkStart"] = nil;
	end
end


-- Nefarian (Thanks to Sting of Blood Legion - Illidan Horde)
function CT_RABoss_Nefarian_OnLoad()
	CT_RABoss_AddMod("奈法利安", CT_RABOSS_NEFARIAN_INFO, 1, CT_RABOSS_LOCATIONS_BLACKWINGSLAIR);
	
	CT_RABoss_AddEvent("奈法利安", "CHAT_MSG_MONSTER_YELL", CT_RABoss_Nefarian_EventHandler);
	CT_RABoss_AddEvent("奈法利安", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE", CT_RABoss_Nefarian_EventHandler);
	CT_RABoss_AddEvent("奈法利安", "CHAT_MSG_COMBAT_HOSTILE_DEATH", CT_RABoss_Nefarian_EventHandler);
	CT_RABoss_AddEvent("奈法利安", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_Nefarian_EventHandler);
	CT_RABoss_AddEvent("奈法利安", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_Nefarian_EventHandler);
	CT_RABoss_AddEvent("奈法利安", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_Nefarian_EventHandler);
	CT_RABoss_AddEvent("奈法利安", "CHAT_MSG_ADDON", CT_RABoss_Nefarian_EventHandler);
	
	CT_RABoss_AddDropDownButton("奈法利安", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("奈法利安", { CT_RABOSS_NEFARIAN_SHADOWFLAME, CT_RABOSS_NEFARIAN_SHADOWFLAME_INFO }, "CT_RABoss_ModInfo", "shadowflame", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("奈法利安", { CT_RABOSS_NEFARIAN_FEAR, CT_RABOSS_NEFARIAN_FEAR_INFO }, "CT_RABoss_ModInfo", "fearAlert", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("奈法利安", { CT_RABOSS_NEFARIAN_VEIL, CT_RABOSS_NEFARIAN_VEIL_INFO }, "CT_RABoss_ModInfo", "veilOfShadow", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("奈法利安", { CT_RABOSS_NEFARIAN_KC, CT_RABOSS_NEFARIAN_KC_INFO }, "CT_RABoss_ModInfo", "KillCount", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("奈法利安", { CT_RABOSS_NEFARIAN_KCS, CT_RABOSS_NEFARIAN_KCS_INFO }, "CT_RABoss_ModInfo", "KillSync", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("奈法利安", { CT_RABOSS_NEFARIAN_KCEST, CT_RABOSS_NEFARIAN_KCEST_INFO }, "CT_RABoss_ModInfo", "KillTime", "CT_RABoss_SetInfo");
	--precast warnings
	CT_RABoss_AddDropDownButton("奈法利安", { CT_RABOSS_NEFARIAN_PREFEAR, CT_RABOSS_NEFARIAN_PREFEAR_INFO }, "CT_RABoss_ModInfo", "PrefearAlert", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("奈法利安", { CT_RABOSS_NEFARIAN_PRESHAD, CT_RABOSS_NEFARIAN_PRESHAD_INFO }, "CT_RABoss_ModInfo", "PreShadAlert", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("奈法利安", { CT_RABOSS_NEFARIAN_PRECLASS, CT_RABOSS_NEFARIAN_PRECLASS_INFO }, "CT_RABoss_ModInfo", "PreClassAlert", "CT_RABoss_SetInfo");
end

function CT_RABoss_Nefarian_EventHandler(event)
	if ( not CT_RABoss_Mods["奈法利安"] or not CT_RABoss_Mods["奈法利安"]["status"] or not CT_RABoss_Mods["奈法利安"].enabled ) then
		return;
	end
	
	if ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_NEFARIAN_START) and CT_RABoss_Mods["奈法利安"]["KillCount"] ) then
		CT_RABoss_Counter.initialize("奈法利安", "DrakonidCount", CT_RABoss_Mods["奈法利安"]["KillSync"], CT_RABoss_Mods["奈法利安"]["announce"], 42, CT_RABOSS_NEFARIAN_MOBNAME, CT_RABOSS_NEFARIAN_KCOUNT, CT_RABOSS_NEFARIAN_KCOUNT_HEADER);
		CT_RABoss_Counter.setOptions("奈法利安", "DrakonidCount", {["displayEstEnd"] = CT_RABoss_Mods["奈法利安"]["KillTime"]});

		CT_RABoss_Announce(CT_RABOSS_NEFARIAN_BEGIN, CT_RABoss_Mods["奈法利安"]["announce"]);
		CT_RABoss_PlaySound(2);
	
	elseif ( event == "CHAT_MSG_COMBAT_HOSTILE_DEATH" and CT_RABoss_Mods["奈法利安"]["KillCount"] ) then
		local _, _, mobName = string.find(arg1, CT_RABOSS_NEFARIAN_DRAGONDEATH);
		
		if ( mobName ) then
			CT_RABoss_Counter.sendSync(mobName, "奈法利安", "DrakonidCount");
		end
	elseif ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_NEFARIAN_SHAMAN_CALL) and (CT_RABoss_Mods["奈法利安"]["PreClassAlert"]) ) then
		CT_RABoss_Announce(CT_RABOSS_NEFARIAN_SHAMAN_ALERT, CT_RABoss_Mods["奈法利安"]["announce"]);
		CT_RABoss_PlaySound(1);
		--adevent next class in 27
		CT_RABoss_Schedule("CT_RABoss_Nefarian_EventHandler", 27, "CLASS27SEC");
		CT_RABoss_VisualTimer.addTimer("NefarianClassCall", 32, CT_RABOSS_NEFARIAN_CLASS_TIMER);

	elseif ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_NEFARIAN_DRUID_CALL) and (CT_RABoss_Mods["奈法利安"]["PreClassAlert"]) ) then
		CT_RABoss_Announce(CT_RABOSS_NEFARIAN_DRUID_ALERT, CT_RABoss_Mods["奈法利安"]["announce"]);
		CT_RABoss_PlaySound(1);
		--adevent next class in 27
		CT_RABoss_Schedule("CT_RABoss_Nefarian_EventHandler", 27, "CLASS27SEC");
		CT_RABoss_VisualTimer.addTimer("NefarianClassCall", 32, CT_RABOSS_NEFARIAN_CLASS_TIMER);

	elseif ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_NEFARIAN_WARLOCK_CALL) and (CT_RABoss_Mods["奈法利安"]["PreClassAlert"]) ) then
		CT_RABoss_Announce(CT_RABOSS_NEFARIAN_WARLOCK_ALERT, CT_RABoss_Mods["奈法利安"]["announce"]);
		CT_RABoss_PlaySound(1);
		--adevent next class in 27
		CT_RABoss_Schedule("CT_RABoss_Nefarian_EventHandler", 27, "CLASS27SEC");
		CT_RABoss_VisualTimer.addTimer("NefarianClassCall", 32, CT_RABOSS_NEFARIAN_CLASS_TIMER);

	elseif ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_NEFARIAN_PRIEST_CALL) and (CT_RABoss_Mods["奈法利安"]["PreClassAlert"]) ) then
		CT_RABoss_Announce(CT_RABOSS_NEFARIAN_PRIEST_ALERT, CT_RABoss_Mods["奈法利安"]["announce"]);
		CT_RABoss_PlaySound(1);
		--adevent next class in 27
		CT_RABoss_Schedule("CT_RABoss_Nefarian_EventHandler", 27, "CLASS27SEC");
		CT_RABoss_VisualTimer.addTimer("NefarianClassCall", 32, CT_RABOSS_NEFARIAN_CLASS_TIMER);

	elseif ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_NEFARIAN_HUNTER_CALL) and (CT_RABoss_Mods["奈法利安"]["PreClassAlert"]) ) then
		CT_RABoss_Announce(CT_RABOSS_NEFARIAN_HUNTER_ALERT, CT_RABoss_Mods["奈法利安"]["announce"]);
		CT_RABoss_PlaySound(1);
		--adevent next class in 27
		CT_RABoss_Schedule("CT_RABoss_Nefarian_EventHandler", 27, "CLASS27SEC");
		CT_RABoss_VisualTimer.addTimer("NefarianClassCall", 32, CT_RABOSS_NEFARIAN_CLASS_TIMER);

	elseif ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_NEFARIAN_WARRIOR_CALL) and (CT_RABoss_Mods["奈法利安"]["PreClassAlert"]) ) then
		CT_RABoss_Announce(CT_RABOSS_NEFARIAN_WARRIOR_ALERT, CT_RABoss_Mods["奈法利安"]["announce"]);
		CT_RABoss_PlaySound(1);
		--adevent next class in 27
		CT_RABoss_Schedule("CT_RABoss_Nefarian_EventHandler", 27, "CLASS27SEC");
		CT_RABoss_VisualTimer.addTimer("NefarianClassCall", 32, CT_RABOSS_NEFARIAN_CLASS_TIMER);

	elseif ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_NEFARIAN_ROGUE_CALL) and (CT_RABoss_Mods["奈法利安"]["PreClassAlert"]) ) then
		CT_RABoss_Announce(CT_RABOSS_NEFARIAN_ROGUE_ALERT, CT_RABoss_Mods["奈法利安"]["announce"]);
		CT_RABoss_PlaySound(1);
		--adevent next class in 27
		CT_RABoss_Schedule("CT_RABoss_Nefarian_EventHandler", 27, "CLASS27SEC");
		CT_RABoss_VisualTimer.addTimer("NefarianClassCall", 32, CT_RABOSS_NEFARIAN_CLASS_TIMER);

	elseif ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_NEFARIAN_PALADIN_CALL) and (CT_RABoss_Mods["奈法利安"]["PreClassAlert"]) ) then
		CT_RABoss_Announce(CT_RABOSS_NEFARIAN_PALADIN_ALERT, CT_RABoss_Mods["奈法利安"]["announce"]);
		CT_RABoss_PlaySound(1);
		--adevent next class in 27
		CT_RABoss_Schedule("CT_RABoss_Nefarian_EventHandler", 27, "CLASS27SEC");
		CT_RABoss_VisualTimer.addTimer("NefarianClassCall", 32, CT_RABOSS_NEFARIAN_CLASS_TIMER);

	elseif ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_NEFARIAN_MAGE_CALL) and (CT_RABoss_Mods["奈法利安"]["PreClassAlert"]) ) then
		CT_RABoss_Announce(CT_RABOSS_NEFARIAN_MAGE_ALERT, CT_RABoss_Mods["奈法利安"]["announce"]);
		CT_RABoss_PlaySound(1);
		--adevent next class in 27
		CT_RABoss_Schedule("CT_RABoss_Nefarian_EventHandler", 27, "CLASS27SEC");
		CT_RABoss_VisualTimer.addTimer("NefarianClassCall", 32, CT_RABOSS_NEFARIAN_CLASS_TIMER);

	elseif ( (event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE") and (arg1 == CT_RABOSS_NEFARIAN_SHADOWFLAME_DETECT) and (CT_RABoss_Mods["奈法利安"]["shadowflame"]) ) then
		CT_RABoss_Announce(CT_RABOSS_NEFARIAN_SHADOWFLAME_WARN, CT_RABoss_Mods["奈法利安"]["announce"]);
		CT_RABoss_PlaySound(3);
		--adevent next shad in 8
		CT_RABoss_Schedule("CT_RABoss_Nefarian_EventHandler", 8, "SHAD8SEC");
		CT_RABoss_VisualTimer.addTimer("NefarianShadowflame", 13, CT_RABOSS_NEFARIAN_SHADOWFLAME_TIMER);

	elseif ( (event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE") and (arg1 == CT_RABOSS_NEFARIAN_FEAR_DETECT) and (CT_RABoss_Mods["奈法利安"]["fearAlert"]) ) then
		CT_RABoss_Announce(CT_RABOSS_NEFARIAN_FEAR_WARN, CT_RABoss_Mods["奈法利安"]["announce"]);
		CT_RABoss_PlaySound(3);
		--adevent next fear in 23
		CT_RABoss_Schedule("CT_RABoss_Nefarian_EventHandler", 23, "FEAR23SEC");
		CT_RABoss_VisualTimer.addTimer("奈法利安", 28, CT_RABOSS_NEFARIAN_FEAR_TIMER);

	elseif ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_NEFARIAN_LAND_10SEC_DETECT) ) then
		CT_RABoss_Announce(CT_RABOSS_NEFARIAN_LAND_10SEC, CT_RABoss_Mods["奈法利安"]["announce"]);
		CT_RABoss_PlaySound(1);

	elseif ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_NEFARIAN_LANDING_DETECT) ) then
		CT_RABoss_Announce(CT_RABOSS_NEFARIAN_LANDING, CT_RABoss_Mods["奈法利安"]["announce"]);
		CT_RABoss_PlaySound(1);

	elseif ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_NEFARIAN_ZERG_DETECT) ) then
		CT_RABoss_Announce(CT_RABOSS_NEFARIAN_ZERG, CT_RABoss_Mods["奈法利安"]["announce"]);
		CT_RABoss_PlaySound(1);
		
	elseif ( (event == "CLASS27SEC") and (CT_RABoss_Mods["奈法利安"]["PreClassAlert"]) ) then
	 	CT_RABoss_Announce(CT_RABOSS_NEFARIAN_PRECLASS_WARN, CT_RABoss_Mods["奈法利安"]["announce"]);
		CT_RABoss_PlaySound(3);
		
	elseif ( (event == "FEAR23SEC") and (CT_RABoss_Mods["奈法利安"]["PrefearAlert"]) ) then
		CT_RABoss_Announce(CT_RABOSS_NEFARIAN_PREFEAR_WARN, CT_RABoss_Mods["奈法利安"]["announce"]);
		CT_RABoss_PlaySound(3);
		
	elseif ( (event == "SHAD8SEC") and (CT_RABoss_Mods["奈法利安"]["PreShadAlert"]) ) then
		CT_RABoss_Announce(CT_RABOSS_NEFARIAN_PRESHAD_WARN, CT_RABoss_Mods["奈法利安"]["announce"]);
		CT_RABoss_PlaySound(3);
		
	elseif ( CT_RABoss_Mods["奈法利安"]["veilOfShadow"] ) and ( event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE" ) then
		local iStart, iEnd, sPlayer, sType = string.find(arg1, CT_RABOSS_NEFARIAN_AFFLICT_VEIL);
		if ( sPlayer and sType ) then
			if ( sPlayer == CT_RABOSS_SELF1 and sType == CT_RABOSS_SELF2 ) then
				CT_RABoss_Announce("*** " .. UnitName("player") .. CT_RABOSS_NEFARIAN_CURSEWARNRAID, CT_RABoss_Mods["奈法利安"]["announce"]);
				CT_RABoss_PlaySound(2);
			else 
				CT_RABoss_Announce("*** " .. sPlayer .. CT_RABOSS_NEFARIAN_CURSEWARNRAID, CT_RABoss_Mods["奈法利安"]["announce"]);
				CT_RABoss_PlaySound(3);
			end
		end
	elseif ( event == "CHAT_MSG_ADDON" and CT_RABoss_Mods["奈法利安"]["KillCount"] ) then
		CT_RABoss_Counter.receiveSync(arg1, arg2, arg4, "奈法利安", "DrakonidCount");
	end
end