tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_ProphetSkeram_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_PrincessYauj_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Sartura_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Fankriss_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Huhuran_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Emperors_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Viscidus_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Ouro_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Defender_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_Mindslayer_OnLoad");
tinsert(CT_RABoss_ModsToLoad, "CT_RABoss_CThun_OnLoad");



-- The Prophet Skeram
function CT_RABoss_ProphetSkeram_OnLoad()
	CT_RABoss_AddMod("预言者斯克拉姆", CT_RABOSS_SKERAM_INFO, 1, CT_RABOSS_LOCATIONS_AHNQIRAJ);

	-- MC events
	CT_RABoss_AddEvent("预言者斯克拉姆", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_ProphetSkeram_EventHandler);
	CT_RABoss_AddEvent("预言者斯克拉姆", "CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_DAMAGE", CT_RABoss_ProphetSkeram_EventHandler);
	CT_RABoss_AddEvent("预言者斯克拉姆", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_ProphetSkeram_EventHandler);

	CT_RABoss_AddEvent("预言者斯克拉姆", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF", CT_RABoss_ProphetSkeram_EventHandler);
	CT_RABoss_AddEvent("预言者斯克拉姆", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE", CT_RABoss_ProphetSkeram_EventHandler);

	CT_RABoss_AddDropDownButton("预言者斯克拉姆", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("预言者斯克拉姆", { CT_RABOSS_SKERAM_ARCANE, CT_RABOSS_SKERAM_ARCANE_INFO }, "CT_RABoss_ModInfo", "arcaneExplosion", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("预言者斯克拉姆", { CT_RABOSS_SKERAM_MC, CT_RABOSS_SKERAM_MC_INFO }, "CT_RABoss_ModInfo", "mindControl", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("预言者斯克拉姆", { CT_RABOSS_SKERAM_SPLIT, CT_RABOSS_SKERAM_SPLIT_INFO }, "CT_RABoss_ModInfo", "split", "CT_RABoss_SetInfo");
end

function CT_RABoss_ProphetSkeram_EventHandler(event)
	if ( not CT_RABoss_Mods["预言者斯克拉姆"] or not CT_RABoss_Mods["预言者斯克拉姆"]["status"] or not CT_RABoss_Mods["预言者斯克拉姆"].enabled ) then
		return;
	end

	if ( ( event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_HOSTILEPLAYER_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE" ) and CT_RABoss_Mods["预言者斯克拉姆"]["mindControl"] ) then
		local iStart, iEnd, sPlayer, sType = string.find(arg1, CT_RABOSS_SKERAM_MC_DETECT);
		if ( sPlayer and sType ) then
			if ( sPlayer == CT_RABOSS_SELF1 and sType == CT_RABOSS_SELF2 ) then
				CT_RABoss_Announce(format(CT_RABOSS_SKERAM_MC_ALERT, UnitName("player")), CT_RABoss_Mods["预言者斯克拉姆"]["announce"]);
				CT_RABoss_PlaySound(2);
			else
				CT_RABoss_Announce(format(CT_RABOSS_SKERAM_MC_ALERT, sPlayer), CT_RABoss_Mods["预言者斯克拉姆"]["announce"]);
				CT_RABoss_PlaySound(3);
			end
		end
	end

	-- Arcane Explosion alert
	if ( event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE" and arg1 == CT_RABOSS_SKERAM_ARCANE_DETECT and CT_RABoss_Mods["预言者斯克拉姆"]["arcaneExplosion"] ) then
		CT_RABoss_Announce(CT_RABOSS_SKERAM_ARCANE_ALERT, CT_RABoss_Mods["预言者斯克拉姆"]["announce"]);
		CT_RABoss_PlaySound(3);
	end

	-- Split alert
	if ( event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF" and arg1 == CT_RABOSS_SKERAM_SPLIT_DETECT and CT_RABoss_Mods["预言者斯克拉姆"]["split"] ) then
		CT_RABoss_Announce(CT_RABOSS_SKERAM_SPLIT_ALERT, CT_RABoss_Mods["预言者斯克拉姆"]["announce"]);
		CT_RABoss_PlaySound(3);
	end
end


-- Princess Yauj
function CT_RABoss_PrincessYauj_OnLoad()
	CT_RABoss_AddMod("亚尔基公主", CT_RABOSS_YAUJ_INFO, 1, CT_RABOSS_LOCATIONS_AHNQIRAJ);

	CT_RABoss_AddEvent("亚尔基公主", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF", CT_RABoss_PrincessYauj_EventHandler);
	CT_RABoss_AddEvent("亚尔基公主", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_PrincessYauj_EventHandler);		-- Fear
	CT_RABoss_AddEvent("亚尔基公主", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_PrincessYauj_EventHandler);			-- Fear
	CT_RABoss_AddEvent("亚尔基公主", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_PrincessYauj_EventHandler);	-- Fear

	CT_RABoss_AddDropDownButton("亚尔基公主", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("亚尔基公主", { CT_RABOSS_YAUJ_HEAL, CT_RABOSS_YAUJ_HEAL_INFO }, "CT_RABoss_ModInfo", "heal", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("亚尔基公主", { CT_RABOSS_YAUJ_FEAR, CT_RABOSS_YAUJ_FEAR_INFO }, "CT_RABoss_ModInfo", "fear", "CT_RABoss_SetInfo");
end

function CT_RABoss_PrincessYauj_EventHandler(event)
	if ( not CT_RABoss_Mods["亚尔基公主"] or not CT_RABoss_Mods["亚尔基公主"]["status"] or not CT_RABoss_Mods["亚尔基公主"].enabled ) then
		return;
	end

	-- Heal alert
	if ( event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF" and arg1 == CT_RABOSS_YAUJ_HEAL_DETECT and CT_RABoss_Mods["亚尔基公主"]["heal"] ) then
		CT_RABoss_Announce(CT_RABOSS_YAUJ_HEAL_ALERT, CT_RABoss_Mods["亚尔基公主"]["announce"]);
		CT_RABoss_PlaySound(2);
	end

	-- Fear alert
	if ( event == "preFearWarn" ) then
		CT_RABoss_Mods["亚尔基公主"]["fearTrip"] = false;
		CT_RABoss_Announce(CT_RABOSS_YAUJ_FEAR_PREALERT, CT_RABoss_Mods["亚尔基公主"]["announce"]);
		CT_RABoss_PlaySound(3);

	elseif ( CT_RABoss_Mods["亚尔基公主"]["fear"] and  not CT_RABoss_Mods["亚尔基公主"]["fearTrip"] and (event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE") and string.find(arg1, CT_RABOSS_YAUJ_FEAR_DETECT) ) then
		CT_RABoss_Mods["亚尔基公主"]["fearTrip"] = true;
		CT_RABoss_Announce(CT_RABOSS_YAUJ_FEAR_ALERT, CT_RABoss_Mods["亚尔基公主"]["announce"]);
		CT_RABoss_PlaySound(2);
		CT_RABoss_Schedule("CT_RABoss_PrincessYauj_EventHandler", 15, "preFearWarn");
		CT_RABoss_VisualTimer.addTimer("YaujFear", 20, CT_RABOSS_YAUJ_FEAR_TIMER);
	end
end


-- Battleguard Sartura
function CT_RABoss_Sartura_Stop()
	CT_RABoss_UnSchedule("CT_RABoss_Sartura_EventHandler");
	CT_RABoss_UnSchedule("CT_RABoss_Sartura_EventHandler");
	CT_RABoss_VisualTimer.removeTimer("SarturaWhirlwind");
	CT_RABoss_VisualTimer.removeTimer("SarturaEnrage");

	CT_RABoss_Mods["沙尔图拉"]["lastAction"] = nil;
end

function CT_RABoss_Sartura_OnLoad()
	CT_RABoss_AddMod("沙尔图拉", CT_RABOSS_SARTURA_INFO, 1, CT_RABOSS_LOCATIONS_AHNQIRAJ);

	CT_RABoss_AddEvent("沙尔图拉", "CHAT_MSG_MONSTER_EMOTE", CT_RABoss_Sartura_EventHandler);
	CT_RABoss_AddEvent("沙尔图拉", "CHAT_MSG_MONSTER_YELL", CT_RABoss_Sartura_EventHandler);
	CT_RABoss_AddEvent("沙尔图拉", "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", CT_RABoss_Sartura_EventHandler);
	CT_RABoss_AddEvent("沙尔图拉", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF", CT_RABoss_Sartura_EventHandler);
	CT_RABoss_AddEvent("沙尔图拉", "CHAT_MSG_SPELL_AURA_GONE_OTHER", CT_RABoss_Sartura_EventHandler);

	CT_RABoss_AddDropDownButton("沙尔图拉", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("沙尔图拉", { CT_RABOSS_SARTURA_WHIRLWIND, CT_RABOSS_SARTURA_WHIRLWIND_INFO }, "CT_RABoss_ModInfo", "whirlwind", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("沙尔图拉", { CT_RABOSS_SARTURA_ENRAGE, CT_RABOSS_SARTURA_ENRAGE_INFO }, "CT_RABoss_ModInfo", "enrage", "CT_RABoss_SetInfo");

	CT_RA_RegisterSlashCmd("/sarturastop", CT_RABOSS_CMD_SARTURASTOP, 30, "SARTURASTOP", function()
		CT_RABoss_Sartura_Stop();
	end, "/sarturastop");

	CT_RABoss_Mods["沙尔图拉"]["lastAction"] = nil;
end

function CT_RABoss_Sartura_EventHandler(event)
	if ( not CT_RABoss_Mods["沙尔图拉"] or not CT_RABoss_Mods["沙尔图拉"]["status"] or not CT_RABoss_Mods["沙尔图拉"].enabled ) then
		return;
	end

	-- Whirlwind alert
	if ( event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS" and string.find(arg1, CT_RABOSS_SARTURA_WHIRLWIND_DETECT) and CT_RABoss_Mods["沙尔图拉"]["whirlwind"] ) then
		CT_RABoss_Announce(CT_RABOSS_SARTURA_WHIRLWIND_ALERT, CT_RABoss_Mods["沙尔图拉"]["announce"]);
		CT_RABoss_PlaySound(2);

		CT_RABoss_Schedule("CT_RABoss_Sartura_EventHandler", 21, "preWhirlwind");
		CT_RABoss_Schedule("CT_RABoss_Sartura_EventHandler", 12, "preStun");
		CT_RABoss_VisualTimer.addTimer("SarturaWhirlwind", 15, CT_RABOSS_SARTURA_WHIRLWIND_TIMER);

		CT_RABoss_Mods["沙尔图拉"]["lastAction"] = GetTime();
	end

	-- Pre-Whirlwind alert
	if ( event == "preWhirlwind" and CT_RABoss_Mods["沙尔图拉"]["whirlwind"] ) then
		CT_RABoss_Announce(CT_RABOSS_SARTURA_WHIRLWIND_PREALERT, CT_RABoss_Mods["沙尔图拉"]["announce"]);
		CT_RABoss_PlaySound(3);
	end
	
	-- Pre-stun alert
	if ( event == "preStun" and CT_RABoss_Mods["沙尔图拉"]["whirlwind"] ) then
		CT_RABoss_Announce(CT_RABOSS_SARTURA_STUN_PREALERT, CT_RABoss_Mods["沙尔图拉"]["announce"]);
		CT_RABoss_PlaySound(3);
	end
	
	-- Whirlwind fade alert
	if ( event == "CHAT_MSG_SPELL_AURA_GONE_OTHER" and string.find(arg1, CT_RABOSS_SARTURA_WHIRLWIND_FADE_DETECT) and CT_RABoss_Mods["沙尔图拉"]["whirlwind"] ) then
		CT_RABoss_Announce(CT_RABOSS_SARTURA_WHIRLWIND_FADE_ALERT, CT_RABoss_Mods["沙尔图拉"]["announce"]);
		CT_RABoss_PlaySound(3);

		CT_RABoss_Mods["沙尔图拉"]["lastAction"] = GetTime();
	end

	-- Pre-Crazy alerts
	if ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_SARTURA_BEGIN) and arg2 == CT_RABOSS_NAMES["沙尔图拉"] and CT_RABoss_Mods["沙尔图拉"]["enrage"] ) then
		CT_RABoss_Schedule("CT_RABoss_Sartura_EventHandler", 120, "totalWarning");
		CT_RABoss_VisualTimer.addTimer("SarturaEnrage", 600, CT_RABOSS_SARTURA_ENRAGE_TIMER, "red");

		CT_RABoss_Mods["沙尔图拉"]["lastAction"] = GetTime();

	elseif ( event == "totalWarning" and CT_RABoss_Mods["沙尔图拉"]["enrage"] ) then
		CT_RABoss_Announce(format(CT_RABOSS_SARTURA_CRAZY_PREALERT, "8"), CT_RABoss_Mods["沙尔图拉"]["announce"]);
		CT_RABoss_PlaySound(3);
		CT_RABoss_Schedule("CT_RABoss_Sartura_EventHandler", 180, "totalWarning2");

	elseif ( event == "totalWarning2" and CT_RABoss_Mods["沙尔图拉"]["enrage"] ) then
		CT_RABoss_Announce(format(CT_RABOSS_SARTURA_CRAZY_PREALERT, "5"), CT_RABoss_Mods["沙尔图拉"]["announce"]);
		CT_RABoss_PlaySound(3);
		CT_RABoss_Schedule("CT_RABoss_Sartura_EventHandler", 120, "totalWarning3");

	elseif ( event == "totalWarning3" and CT_RABoss_Mods["沙尔图拉"]["enrage"] ) then
		CT_RABoss_Announce(format(CT_RABOSS_SARTURA_CRAZY_PREALERT, "3"), CT_RABoss_Mods["沙尔图拉"]["announce"]);
		CT_RABoss_PlaySound(3);
		CT_RABoss_Schedule("CT_RABoss_Sartura_EventHandler", 60, "totalWarning4");

	elseif ( event == "totalWarning4" and CT_RABoss_Mods["沙尔图拉"]["enrage"] ) then
		CT_RABoss_Announce(format(CT_RABOSS_SARTURA_CRAZY_PREALERT, "2"), CT_RABoss_Mods["沙尔图拉"]["announce"]);
		CT_RABoss_PlaySound(3);
		CT_RABoss_Schedule("CT_RABoss_Sartura_EventHandler", 60, "totalWarning5");

	elseif ( event == "totalWarning5" and CT_RABoss_Mods["沙尔图拉"]["enrage"] ) then
		CT_RABoss_Announce(format(CT_RABOSS_SARTURA_CRAZY_PREALERT, "1"), CT_RABoss_Mods["沙尔图拉"]["announce"]);
		CT_RABoss_PlaySound(3);
		
	elseif ( event == "CHAT_MSG_MONSTER_EMOTE" and string.find(arg1, "CT_RABOSS_SARTURA_CRAZY_DETECT") and arg2 == CT_RABOSS_NAMES["沙尔图拉"] and CT_RABoss_Mods["沙尔图拉"]["enrage"] ) then
		CT_RABoss_Announce(CT_RABOSS_SARTURA_CRAZY_ALERT, CT_RABoss_Mods["沙尔图拉"]["announce"]);
		CT_RABoss_PlaySound(3);
		
		CT_RABoss_Sartura_Stop();
	end

	-- Enrage alert
	if ( event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF" and string.find(arg1, CT_RABOSS_SARTURA_ENRAGE_DETECT) ) then
		CT_RABoss_Announce(CT_RABOSS_SARTURA_ENRAGE_ALERT, CT_RABoss_Mods["沙尔图拉"]["announce"]);
		CT_RABoss_PlaySound(3);

		CT_RABoss_Mods["沙尔图拉"]["lastAction"] = GetTime();
	end

	-- Sartura Death
	if ( event == "CHAT_MSG_MONSTER_YELL" and string.find(arg1, CT_RABOSS_SARTURA_END) and arg2 == CT_RABOSS_NAMES["沙尔图拉"] ) then
		CT_RABoss_Sartura_Stop();
	end

	-- Stop the script
	if ( CT_RABoss_Mods["沙尔图拉"]["lastAction"] and (GetTime() - CT_RABoss_Mods["沙尔图拉"]["lastAction"]) > 40 ) then
		CT_RABoss_Sartura_Stop();
	end
end


-- Fankriss the Unyielding
function CT_RABoss_Fankriss_OnLoad()
	CT_RABoss_AddMod("顽强的范克瑞斯", CT_RABOSS_FANKRISS_INFO, 1, CT_RABOSS_LOCATIONS_AHNQIRAJ);

	CT_RABoss_AddEvent("顽强的范克瑞斯", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF", CT_RABoss_Fankriss_EventHandler);
	CT_RABoss_AddEvent("顽强的范克瑞斯", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_Fankriss_EventHandler);
	CT_RABoss_AddEvent("顽强的范克瑞斯", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_Fankriss_EventHandler);
	CT_RABoss_AddEvent("顽强的范克瑞斯", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_Fankriss_EventHandler);

	CT_RABoss_AddDropDownButton("顽强的范克瑞斯", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("顽强的范克瑞斯", { CT_RABOSS_FANKRISS_INVOC, CT_RABOSS_FANKRISS_INVOC_INFO }, "CT_RABoss_ModInfo", "invoc", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("顽强的范克瑞斯", { CT_RABOSS_FANKRISS_ENTANGLE, CT_RABOSS_FANKRISS_ENTANGLE_INFO }, "CT_RABoss_ModInfo", "entangle", "CT_RABoss_SetInfo");
end

function CT_RABoss_Fankriss_EventHandler(event)
	if ( not CT_RABoss_Mods["顽强的范克瑞斯"] or not CT_RABoss_Mods["顽强的范克瑞斯"]["status"] or not CT_RABoss_Mods["顽强的范克瑞斯"].enabled ) then
		return;
	end

	-- Snake alert
	if ( event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF" and string.find(arg1, CT_RABOSS_FANKRISS_INVOC_DETECT) and CT_RABoss_Mods["顽强的范克瑞斯"]["invoc"] ) then
		CT_RABoss_Announce(CT_RABOSS_FANKRISS_INVOC_ALERT, CT_RABoss_Mods["顽强的范克瑞斯"]["announce"]);
		CT_RABoss_PlaySound(2);
	end
	
	-- Entangle alert
	if ( (event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE") and CT_RABoss_Mods["顽强的范克瑞斯"]["entangle"] ) then
		local iStart, iEnd, sPlayer, sType = string.find(arg1, CT_RABOSS_FANKRISS_ENTANGLE_DETECT);
		
		if ( sPlayer and sType ) then
			if ( sPlayer == CT_RABOSS_SELF1 and sType == CT_RABOSS_SELF2 ) then
				sPlayer = UnitName("player");
			end
			
			CT_RABoss_Announce(format(CT_RABOSS_FANKRISS_ENTANGLE_ALERT, sPlayer), CT_RABoss_Mods["顽强的范克瑞斯"]["announce"]);
			CT_RABoss_PlaySound(3);
		end
	end
end


-- Princesse Huhuran
function CT_RABoss_Huhuran_OnLoad()
	CT_RABoss_AddMod("哈霍兰公主", CT_RABOSS_HUHURAN_INFO, 1, CT_RABOSS_LOCATIONS_AHNQIRAJ);

	CT_RABoss_AddEvent("哈霍兰公主", "CHAT_MSG_MONSTER_EMOTE", CT_RABoss_Huhuran_EventHandler);
	CT_RABoss_AddEvent("哈霍兰公主", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_Huhuran_EventHandler);
	CT_RABoss_AddEvent("哈霍兰公主", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_Huhuran_EventHandler);
	CT_RABoss_AddEvent("哈霍兰公主", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_Huhuran_EventHandler);
	CT_RABoss_AddEvent("哈霍兰公主", "UNIT_HEALTH", CT_RABoss_Huhuran_EventHandler);
	CT_RABoss_AddEvent("哈霍兰公主", "PLAYER_REGEN_DISABLED", CT_RABoss_Huhuran_EventHandler);

	CT_RABoss_AddDropDownButton("哈霍兰公主", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("哈霍兰公主", { CT_RABOSS_HUHURAN_FRENZY, CT_RABOSS_HUHURAN_FRENZY_INFO }, "CT_RABoss_ModInfo", "frenzy", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("哈霍兰公主", { CT_RABOSS_HUHURAN_BERSERK, CT_RABOSS_HUHURAN_BERSERK_INFO }, "CT_RABoss_ModInfo", "berserk", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("哈霍兰公主", { CT_RABOSS_HUHURAN_WYVERN, CT_RABOSS_HUHURAN_WYVERN_INFO }, "CT_RABoss_ModInfo", "wyvern", "CT_RABoss_SetInfo");
	
	CT_RABoss_Mods["哈霍兰公主"]["healthLow"] = 33;
end

function CT_RABoss_Huhuran_EventHandler(event)
	if ( not CT_RABoss_Mods["哈霍兰公主"] or not CT_RABoss_Mods["哈霍兰公主"]["status"] or not CT_RABoss_Mods["哈霍兰公主"].enabled ) then
		return;
	end

	if ( event == "CHAT_MSG_MONSTER_EMOTE" and arg2 == CT_RABOSS_NAMES["哈霍兰公主"] ) then
		-- Frenzy alert
		if ( string.find(arg1, CT_RABOSS_HUHURAN_FRENZY_DETECT) and CT_RABoss_Mods["哈霍兰公主"]["frenzy"] ) then
			CT_RABoss_Announce(CT_RABOSS_HUHURAN_FRENZY_ALERT, CT_RABoss_Mods["哈霍兰公主"]["announce"]);
			CT_RABoss_PlaySound(2);
			
		-- Berserk alert
		elseif ( string.find(arg1, CT_RABOSS_HUHURAN_BERSERK_DETECT) and CT_RABoss_Mods["哈霍兰公主"]["berserk"] ) then
			CT_RABoss_Announce(CT_RABOSS_HUHURAN_BERSERK_ALERT, CT_RABoss_Mods["哈霍兰公主"]["announce"]);
			CT_RABoss_PlaySound(2);
		end
	elseif ( event == "PLAYER_REGEN_DISABLED" and not CT_RABoss_Mods["哈霍兰公主"]["wyvernLoop"] and UnitName("target") and string.find(UnitName("target"), CT_RABOSS_NAMES["哈霍兰公主"]) ) then
		CT_RABoss_Mods["哈霍兰公主"]["wyvernLoop"] = 1;
		CT_RABoss_Schedule("CT_RABoss_Huhuran_EventHandler", 27, "wyvernPreWarn");
		CT_RABoss_VisualTimer.addTimer("HuhuranWyvern", 30, CT_RABOSS_HUHURAN_WYVERN_TIMER);
	end

	-- Wyvern Sting alert
	if ( event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" or evvent == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" ) then
		if ( string.find(arg1, CT_RABOSS_HUHURAN_WYVERN_DETECT) and not CT_RABoss_Mods["哈霍兰公主"]["wyvernLoop"] and CT_RABoss_Mods["哈霍兰公主"]["wyvern"] ) then
			CT_RABoss_Mods["哈霍兰公主"]["wyvernLoop"] = 1;

			CT_RABoss_Announce(CT_RABOSS_HUHURAN_WYVERN_ALERT, CT_RABoss_Mods["哈霍兰公主"]["announce"]);
			CT_RABoss_PlaySound(2);

			CT_RABoss_Schedule("CT_RABoss_Huhuran_EventHandler", 27, "wyvernPreWarn");
			CT_RABoss_VisualTimer.addTimer("HuhuranWyvern", 30, CT_RABOSS_HUHURAN_WYVERN_TIMER);
		end

	-- Wyvern Sting pre-alert
	elseif ( event == "wyvernPreWarn" and CT_RABoss_Mods["哈霍兰公主"]["wyvern"] ) then
		CT_RABoss_Mods["哈霍兰公主"]["wyvernLoop"] = nil;
		CT_RABoss_Announce(CT_RABOSS_HUHURAN_WYVERN_PREALERT, CT_RABoss_Mods["哈霍兰公主"]["announce"]);
	end
	
	-- Berserk pre-alert
	if ( CT_RABoss_Mods["哈霍兰公主"]["berserk"] and UnitName("target") and UnitName("target") == CT_RABOSS_NAMES["哈霍兰公主"] ) then
		local targetHealth = UnitHealth("target");
		
		if ( targetHealth ) then
			-- Alert near Berserk event
			if ( targetHealth <= CT_RABoss_Mods["哈霍兰公主"]["healthLow"] and targetHealth > 30 and not CT_RABoss_Mods["哈霍兰公主"]["priorWarning"] ) then
				CT_RABoss_Announce(CT_RABOSS_HUHURAN_BERSERK_PREALERT, CT_RABoss_Mods["哈霍兰公主"]["announce"]);
				CT_RABoss_Mods["哈霍兰公主"]["priorWarning"] = true;
		
			-- Berserk pre-alert deactivation
			elseif ( targetHealth <= 30 ) then
				CT_RABoss_Mods["哈霍兰公主"]["priorWarning"] = false;
			end
		end
	end
end


-- The Twin Emperors
function CT_RABoss_Emperors_Stop()
	CT_RABoss_Mods["双子皇帝"]["fight"] = nil;
	CT_RABoss_Mods["双子皇帝"]["tp"] = nil;
	CT_RABoss_Mods["双子皇帝"]["lastAction"] = nil;

	CT_RABoss_UnSchedule("CT_RABoss_Emperors_EventHandler");
	CT_RABoss_UnSchedule("CT_RABoss_Emperors_EventHandler");
	CT_RABoss_VisualTimer.removeTimer("EmperorsEnrage");
	CT_RABoss_VisualTimer.removeTimer("EmperorsTeleport");
end

function CT_RABoss_Emperors_OnLoad()
	CT_RABoss_AddMod("双子皇帝", CT_RABOSS_EMPERORS_INFO, 1, CT_RABOSS_LOCATIONS_AHNQIRAJ);
	
	CT_RABoss_AddEvent("双子皇帝", "PLAYER_REGEN_DISABLED", CT_RABoss_Emperors_EventHandler);
	CT_RABoss_AddEvent("双子皇帝", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF", CT_RABoss_Emperors_EventHandler);
	CT_RABoss_AddEvent("双子皇帝", "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", CT_RABoss_Emperors_EventHandler);
	CT_RABoss_AddEvent("双子皇帝", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE", CT_RABoss_Emperors_EventHandler);
	
	CT_RABoss_AddDropDownButton("双子皇帝", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("双子皇帝", { CT_RABOSS_EMPERORS_TIMER, CT_RABOSS_EMPERORS_TIMER_INFO }, "CT_RABoss_ModInfo", "timerEnrage", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("双子皇帝", { CT_RABOSS_EMPERORS_TP, CT_RABOSS_EMPERORS_TP_INFO }, "CT_RABoss_ModInfo", "teleport", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("双子皇帝", { CT_RABOSS_EMPERORS_EXPLODE, CT_RABOSS_EMPERORS_EXPLODE_INFO }, "CT_RABoss_ModInfo", "alertNearby", "CT_RABoss_SetInfo");

	CT_RA_RegisterSlashCmd("/twinstop", CT_RABOSS_CMD_EMPERORSSTOP, 30, "TWINSTOP", function()
		CT_RABoss_Emperors_Stop();
	end, "/twinstop");

	CT_RABoss_Mods["双子皇帝"]["fight"] = nil;
	CT_RABoss_Mods["双子皇帝"]["tp"] = nil;
	CT_RABoss_Mods["双子皇帝"]["lastAction"] = nil;
end


function CT_RABoss_Emperors_Start()
	CT_RABoss_Mods["双子皇帝"]["fight"] = 1;
	CT_RABoss_Mods["双子皇帝"]["tp"] = nil;
	CT_RABoss_Mods["双子皇帝"]["lastAction"] = GetTime();

	CT_RABoss_Announce(CT_RABOSS_EMPERORS_FIRSTTP_ALERT, CT_RABoss_Mods["双子皇帝"]["announce"]);
	CT_RABoss_PlaySound(1);

	CT_RABoss_Schedule("CT_RABoss_Emperors_EventHandler", 180, "enragePreWarn1");
	CT_RABoss_Schedule("CT_RABoss_Emperors_EventHandler", 18, "tpPreWarn");
	CT_RABoss_VisualTimer.addTimer("EmperorsEnrage", 900, CT_RABOSS_EMPERORS_ENRAGE_TIMER, "red");
	CT_RABoss_VisualTimer.addTimer("EmperorsTeleport", 25, CT_RABOSS_EMPERORS_TP_TIMER);
end

function CT_RABoss_Emperors_TP()
	CT_RABoss_Mods["双子皇帝"]["tp"] = 1;
	CT_RABoss_Mods["双子皇帝"]["lastAction"] = GetTime();

	CT_RABoss_PlaySound(1);
	CT_RABoss_Announce(CT_RABOSS_EMPERORS_TP_ALERT, CT_RABoss_Mods["双子皇帝"]["announce"]);

	CT_RABoss_Schedule("CT_RABoss_Emperors_EventHandler", 25, "tpPreWarn");
	CT_RABoss_VisualTimer.addTimer("EmperorsTeleport", 30, CT_RABOSS_EMPERORS_TP_TIMER);
end

function CT_RABoss_Emperors_EventHandler(event)
	if ( not CT_RABoss_Mods["双子皇帝"] or not CT_RABoss_Mods["双子皇帝"]["status"] or not CT_RABoss_Mods["双子皇帝"].enabled ) then
		return;
	end
	
	-- Encounter begin
	if ( event == "PLAYER_REGEN_DISABLED" and not CT_RABoss_Mods["双子皇帝"]["fight"] ) then
		CT_RABoss_Schedule("CT_RABoss_Emperors_EventHandler", 5, "checkStart");

	elseif ( event == "checkStart" ) then
		if ( UnitName("target") and ( string.find(UnitName("target"), CT_RABOSS_EMPERORS_VEKNILASH) or string.find(UnitName("target"), CT_RABOSS_EMPERORS_VEKLOR) ) and UnitAffectingCombat("target") ) then
			CT_RABoss_Emperors_Start();
		end

	-- 12 min
	elseif ( event == "enragePreWarn1" and CT_RABoss_Mods["双子皇帝"]["timerEnrage"] ) then
		CT_RABoss_Announce(format(CT_RABOSS_EMPERORS_ENRAGE_PREALERT, "12"), CT_RABoss_Mods["双子皇帝"]["announce"]);
		CT_RABoss_Schedule("CT_RABoss_Emperors_EventHandler", 240, "enragePreWarn2");

	-- 8 min
	elseif ( event == "enragePreWarn2" and CT_RABoss_Mods["双子皇帝"]["timerEnrage"] ) then
		CT_RABoss_Announce(format(CT_RABOSS_EMPERORS_ENRAGE_PREALERT, "8"), CT_RABoss_Mods["双子皇帝"]["announce"]);
		CT_RABoss_Schedule("CT_RABoss_Emperors_EventHandler", 180, "enragePreWarn3");

	-- 5 min
	elseif ( event == "enragePreWarn3" and CT_RABoss_Mods["双子皇帝"]["timerEnrage"] ) then
		CT_RABoss_Announce(format(CT_RABOSS_EMPERORS_ENRAGE_PREALERT, "5"), CT_RABoss_Mods["双子皇帝"]["announce"]);
		CT_RABoss_Schedule("CT_RABoss_Emperors_EventHandler", 120, "enragePreWarn4");

	-- 3 min
	elseif ( event == "enragePreWarn4" and CT_RABoss_Mods["双子皇帝"]["timerEnrage"] ) then
		CT_RABoss_Announce(format(CT_RABOSS_EMPERORS_ENRAGE_PREALERT, "3"), CT_RABoss_Mods["双子皇帝"]["announce"]);
		CT_RABoss_Schedule("CT_RABoss_Emperors_EventHandler", 60, "enragePreWarn5");

	-- 2 min
	elseif ( event == "enragePreWarn5" and CT_RABoss_Mods["双子皇帝"]["timerEnrage"] ) then
		CT_RABoss_Announce(format(CT_RABOSS_EMPERORS_ENRAGE_PREALERT, "2"), CT_RABoss_Mods["双子皇帝"]["announce"]);
		CT_RABoss_Schedule("CT_RABoss_Emperors_EventHandler", 60, "enragePreWarn6");

	-- 1 min
	elseif ( event == "enragePreWarn6" and CT_RABoss_Mods["双子皇帝"]["timerEnrage"] ) then
		CT_RABoss_Announce(format(CT_RABOSS_EMPERORS_ENRAGE_PREALERT, "1"), CT_RABoss_Mods["双子皇帝"]["announce"]);

	end

	-- Emperor Teleport alert
	if ( CT_RABoss_Mods["双子皇帝"]["teleport"] and event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE" ) then
		if ( string.find(arg1, CT_RABOSS_EMPERORS_TP_CASTER) or string.find(arg1, CT_RABOSS_EMPERORS_TP_MELEE) and not CT_RABoss_Mods["双子皇帝"]["tp"] ) then
			CT_RABoss_Emperors_TP();
		end
	
	-- Emperor Teleport pre-alert
	elseif ( CT_RABoss_Mods["双子皇帝"]["teleport"] and event == "tpPreWarn" ) then
		CT_RABoss_Mods["双子皇帝"]["tp"] = nil;

		CT_RABoss_Announce(CT_RABOSS_EMPERORS_TP_PREALERT, CT_RABoss_Mods["双子皇帝"]["announce"]);
		CT_RABoss_PlaySound(1);
		
	-- Detect Exploding Bug, must be in proximity of the exploding bug.
	elseif ( CT_RABoss_Mods["双子皇帝"]["alertNearby"] and (event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF" or event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS") ) then
		local _, _, bugType = string.find(arg1, CT_RABOSS_EMPERORS_EXPLODE_DETECT);
		
		if ( bugType ) then
			CT_RABoss_Announce(string.format(CT_RABOSS_EMPERORS_EXPLODE_ALERT, bugType), CT_RABoss_Mods["双子皇帝"]["announce"]);
			CT_RABoss_PlaySound(3);
		end
		
	-- Detect Mutated Bug, must be in proximity of the mutated bug.
	elseif ( CT_RABoss_Mods["双子皇帝"]["alertNearby"] and (event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF" or event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS") ) then
		local _, _, bugType = string.find(arg1, CT_RABOSS_EMPERORS_MUTATE_DETECT);
		
		if ( bugType ) then
			CT_RABoss_Announce(string.format(CT_RABOSS_EMPERORS_MUTATE_ALERT, bugType), CT_RABoss_Mods["双子皇帝"]["announce"]);
			CT_RABoss_PlaySound(3);
		end
	end

	-- Stop script
	if ( CT_RABoss_Mods["双子皇帝"]["lastAction"] and (GetTime() - CT_RABoss_Mods["双子皇帝"]["lastAction"]) > 40 ) then
		CT_RABoss_Emperors_Stop();
	end
end


-- Viscidus
function CT_RABoss_Viscidus_OnLoad()
	CT_RABoss_AddMod("维希度斯", CT_RABOSS_VISCIDUS_INFO, 1, CT_RABOSS_LOCATIONS_AHNQIRAJ);

	CT_RABoss_AddEvent("维希度斯", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_Viscidus_EventHandler);
	CT_RABoss_AddEvent("维希度斯", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_Viscidus_EventHandler);
	CT_RABoss_AddEvent("维希度斯", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_Viscidus_EventHandler);
	CT_RABoss_AddEvent("维希度斯", "CHAT_MSG_MONSTER_EMOTE", CT_RABoss_Viscidus_EventHandler);

	CT_RABoss_AddDropDownButton("维希度斯", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("维希度斯", { CT_RABOSS_VISCIDUS_CLOUD, CT_RABOSS_VISCIDUS_CLOUD_INFO }, "CT_RABoss_ModInfo", "sendTell", "CT_RABoss_SetInfo");
end

function CT_RABoss_Viscidus_EventHandler(event)
	if ( not CT_RABoss_Mods["维希度斯"] or not CT_RABoss_Mods["维希度斯"]["status"] or not CT_RABoss_Mods["维希度斯"].enabled ) then
		return;

	end

	if ( event == "CHAT_MSG_MONSTER_EMOTE" and string.find(arg1, CT_RABOSS_VISCIDUS_FREEZE_DETECT) ) then
			CT_RABoss_Announce(CT_RABOSS_VISCIDUS_FREEZE_ALERT, CT_RABoss_Mods["维希度斯"]["announce"]);

	else
		local _, _, playerName = string.find(arg1, CT_RABOSS_VISCIDUS_TOXIN_DETECT);
		if ( playerName ) then
			if ( playerName == CT_RABOSS_SELF1 ) then
				playerName = UnitName("player");
				CT_RABoss_Announce(CT_RABOSS_VISCIDUS_TOXIN_ALERT);
				CT_RABoss_Announce(CT_RABOSS_VISCIDUS_TOXIN_ALERT);
				CT_RABoss_Announce(CT_RABOSS_VISCIDUS_TOXIN_ALERT);
				CT_RABoss_PlaySound(2);

			elseif ( CT_RABoss_Mods["维希度斯"]["sendTell"] and CT_RA_Level > 1 ) then
				SendChatMessage(CT_RABOSS_VISCIDUS_TOXIN_ALERT, "WHISPER", nil, playerName);
			end
		end
	end
end


-- Ouro
function CT_RABoss_Ouro_OnLoad()
	CT_RABoss_AddMod("奥罗", CT_RABOSS_OURO_INFO, 1, CT_RABOSS_LOCATIONS_AHNQIRAJ);

	CT_RABoss_AddEvent("奥罗", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE", CT_RABoss_Ouro_EventHandler);
	CT_RABoss_AddEvent("奥罗", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF", CT_RABoss_Ouro_EventHandler);
	CT_RABoss_AddEvent("奥罗", "CHAT_MSG_MONSTER_EMOTE", CT_RABoss_Ouro_EventHandler);
	CT_RABoss_AddEvent("奥罗", "PLAYER_REGEN_DISABLED", CT_RABoss_Ouro_EventHandler);
	
	CT_RABoss_AddDropDownButton("奥罗", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
end

local MoundRepeat = 0
function CT_RABoss_Ouro_EventHandler(event)
	if ( not CT_RABoss_Mods["奥罗"] or not CT_RABoss_Mods["奥罗"]["status"] or not CT_RABoss_Mods["奥罗"].enabled ) then
		return;
	end
	
	if ( event == "PLAYER_REGEN_DISABLED" ) then
		CT_RABoss_Schedule("CT_RABoss_Ouro_EventHandler", 5, "checkStart");
	elseif ( event == "checkStart" ) then
--		if ( UnitName("target") == CT_RABOSS_NAMES["奥罗"] and UnitAffectingCombat("target") ) then
		if ( UnitExists("target") and UnitName("target") == CT_RABOSS_NAMES["奥罗"] ) then
			CT_RABoss_Schedule("CT_RABoss_Ouro_EventHandler", 10, "sweepWarning");
			CT_RABoss_Schedule("CT_RABoss_Ouro_EventHandler", 12, "sandblastWarning");
		end
	elseif ( event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE" ) then
		if ( arg1 == CT_RABOSS_OURO_SWEEP_DETECT ) then
			CT_RABoss_Announce(CT_RABOSS_OURO_SWEEP_ALERT, CT_RABoss_Mods["奥罗"]["announce"]);
			CT_RABoss_Schedule("CT_RABoss_Ouro_EventHandler", 15, "sweepWarning");
			CT_RABoss_PlaySound(1);

		elseif ( arg1 == CT_RABOSS_OURO_SANDBLAST_DETECT ) then
			CT_RABoss_Announce(CT_RABOSS_OURO_SANDBLAST_ALERT, CT_RABoss_Mods["奥罗"]["announce"]);
			CT_RABoss_Schedule("CT_RABoss_Ouro_EventHandler", 17, "sandblastWarning");
			CT_RABoss_PlaySound(1);							
		end
		
	elseif ( event == "sweepWarning" ) then
			CT_RABoss_Announce(format(CT_RABOSS_OURO_SWEEP_PREALERT, "5"), CT_RABoss_Mods["奥罗"]["announce"]);
	
	elseif ( event == "sandblastWarning" ) then
			CT_RABoss_Announce(format(CT_RABOSS_OURO_SANDBLAST_PREALERT, "5"), CT_RABoss_Mods["奥罗"]["announce"]);

	elseif ( event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF" ) then
		if ( arg1 == CT_RABOSS_OURO_MOUNDS_DETECT ) then
			CT_RABoss_Announce(CT_RABOSS_OURO_SUBMERGE_ALERT, CT_RABoss_Mods["奥罗"]["announce"]);
			CT_RABoss_UnSchedule("CT_RABoss_Ouro_EventHandler", "sweepWarning");
			CT_RABoss_UnSchedule("CT_RABoss_Ouro_EventHandler", "sandblastWarning");
			CT_RABoss_Schedule("CT_RABoss_Ouro_EventHandler", 20, "emergeWarning");
			CT_RABoss_PlaySound(2);

		elseif ( arg1 == CT_RABOSS_OURO_SCARABS_DETECT ) then
			if ( MoundRepeat < GetTime()- 2 ) then
				if ( OuroBerserk ) then
					CT_RABoss_Announce(CT_RABOSS_OURO_BUGSSPAWN_ALERT, CT_RABoss_Mods["奥罗"]["announce"]);
					MoundRepeat = GetTime();

				else
					CT_RABoss_Announce(CT_RABOSS_OURO_EMERGE_ALERT, CT_RABoss_Mods["奥罗"]["announce"]);
					CT_RABoss_Schedule("CT_RABoss_Ouro_EventHandler", 15, "sweepWarning");
					CT_RABoss_Schedule("CT_RABoss_Ouro_EventHandler", 17, "sandblastWarning");
					CT_RABoss_Schedule("CT_RABoss_Ouro_EventHandler", 45, "scarabs15");

					MoundRepeat = GetTime();
				end
			end
		end
	
	elseif ( event == "emergeWarning" ) then
		CT_RABoss_Announce(format(CT_RABOSS_OURO_EMERGE_PREALERT, "10"), CT_RABoss_Mods["奥罗"]["announce"]);
	
	elseif ( event == "scarabs15" ) then
		CT_RABoss_Announce(format(CT_RABOSS_OURO_BUGSDESPAWN_PREALERT, "15"), CT_RABoss_Mods["奥罗"]["announce"]);
				
	elseif ( event == "CHAT_MSG_MONSTER_EMOTE" and arg1 == CT_RABOSS_OURO_BERSERK_DETECT and arg2 == CT_RABOSS_NAMES["奥罗"] ) then
		CT_RABoss_Announce(CT_RABOSS_OURO_BERSERK_ALERT, CT_RABoss_Mods["奥罗"]["announce"]);
		OuroBerserk = true
		CT_RABoss_Schedule("CT_RABoss_Ouro_EventHandler", 240, "BerserkReset");

	-- Wipe
	elseif ( event == "BerserkReset" ) then
		OuroBerserk = false
		
	end
end


-- Anubisath Defender
function CT_RABoss_Defender_OnLoad()
	CT_RABoss_AddMod("阿努比萨斯防御者", CT_RABOSS_DEFENDER_INFO, 1, CT_RABOSS_LOCATIONS_AHNQIRAJ);
	
	CT_RABoss_AddEvent("阿努比萨斯防御者", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE", CT_RABoss_Defender_EventHandler);
	CT_RABoss_AddEvent("阿努比萨斯防御者", "CHAT_MSG_SPELL_CREATURE_VS_PARTY_DAMAGE", CT_RABoss_Defender_EventHandler);
	CT_RABoss_AddEvent("阿努比萨斯防御者", "CHAT_MSG_SPELL_CREATURE_VS_SELF_DAMAGE", CT_RABoss_Defender_EventHandler);
	CT_RABoss_AddEvent("阿努比萨斯防御者", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF", CT_RABoss_Defender_EventHandler);
	CT_RABoss_AddEvent("阿努比萨斯防御者", "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS", CT_RABoss_Defender_EventHandler);
	CT_RABoss_AddEvent("阿努比萨斯防御者", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_Defender_EventHandler);
	CT_RABoss_AddEvent("阿努比萨斯防御者", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_Defender_EventHandler);
	CT_RABoss_AddEvent("阿努比萨斯防御者", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_Defender_EventHandler);
	
	CT_RABoss_AddDropDownButton("阿努比萨斯防御者", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("阿努比萨斯防御者", { CT_RABOSS_DEFENDER_ABILITIES, CT_RABOSS_DEFENDER_ABILITIES }, "CT_RABoss_ModInfo", "abilities", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("阿努比萨斯防御者", { CT_RABOSS_DEFENDER_SUMMON, CT_RABOSS_DEFENDER_SUMMON_INFO }, "CT_RABoss_ModInfo", "notifySummon", "CT_RABoss_SetInfo");
	CT_RABoss_AddDropDownButton("阿努比萨斯防御者", { CT_RABOSS_DEFENDER_PLAGUETELL, CT_RABOSS_DEFENDER_PLAGUETELL_INFOM }, "CT_RABoss_ModInfo", "sendPlagueTells", "CT_RABoss_SetInfo");
	
	CT_RABoss_SetVar("阿努比萨斯防御者", "sendPlagueTells", 0);
end


function CT_RABoss_Defender_EventHandler(event)
	if ( not CT_RABoss_Mods["阿努比萨斯防御者"] or not CT_RABoss_Mods["阿努比萨斯防御者"]["status"] or not CT_RABoss_Mods["阿努比萨斯防御者"].enabled ) then
		return;
	end
	
	-- Ability alerts
	if ( event == "CHAT_MSG_SPELL_PERIODIC_CREATURE_BUFFS" and CT_RABoss_Mods["阿努比萨斯防御者"]["abilities"] ) then
		-- Explode
		if ( arg1 == CT_RABOSS_DEFENDER_EXPLODE_DETECT ) then
			CT_RABoss_Announce(CT_RABOSS_DEFENDER_EXPLODE_ALERT, CT_RABoss_Mods["阿努比萨斯防御者"]["announce"]);
			
		-- Enrage
		elseif ( arg1 == CT_RABOSS_DEFENDER_ENRAGE_DETECT ) then
			CT_RABoss_Announce(CT_RABOSS_DEFENDER_ENRAGE_ALERT, CT_RABoss_Mods["阿努比萨斯防御者"]["announce"]);
		end
	
	-- Summonning alerts
	elseif ( event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_BUFF" and CT_RABoss_Mods["阿努比萨斯防御者"]["notifySummon"]) then
		-- Summonning Anubisath Swarmguard alert
		if ( arg1 == CT_RABOSS_DEFENDER_GUARD_DETECT ) then
			CT_RABoss_Announce(CT_RABOSS_DEFENDER_GUARD_ALERT, CT_RABoss_Mods["阿努比萨斯防御者"]["announce"]);
			
		-- Summon Anubisath Warrior alert
		elseif ( arg1 == CT_RABOSS_DEFENDER_WARRIOR_DETECT ) then
			CT_RABoss_Announce(CT_RABOSS_DEFENDER_WARRIOR_ALERT, CT_RABoss_Mods["阿努比萨斯防御者"]["announce"]);
		end

	-- Plague alerts
	elseif ( (event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE") and CT_RABoss_Mods["阿努比萨斯防御者"]["sendPlagueTells"] ) then
		local _, _, playerName = string.find(arg1, CT_RABOSS_DEFENDER_PLAGUE_DETECT);
		
		if ( playerName ) then
			if ( playerName == CT_RABOSS_SELF1 ) then
				playerName = UnitName("player");
				CT_RABoss_Announce(string.format(CT_RABOSS_DEFENDER_PLAGUE_ALERT, CT_RABOSS_DEFENDER_YOUHAVE));
				CT_RABoss_Announce(string.format(CT_RABOSS_DEFENDER_PLAGUE_ALERT, CT_RABOSS_DEFENDER_YOUHAVE));
				CT_RABoss_PlaySound(2);
				
			else
					SendChatMessage(CT_RABOSS_DEFENDER_PLAGUE_TELL, "WHISPER", nil, playerName);
				CT_RABoss_PlaySound(1);
			end
			
			if ( CT_RA_Level >= 1 and CT_RABoss_Mods["阿努比萨斯防御者"]["announce"] ) then
				CT_RA_AddMessage("MS " .. string.format(CT_RABOSS_DEFENDER_PLAGUE_ALERT, playerName .. CT_RABOSS_DEFENDER_HAS));
			end
		end
	end
end


-- Qiraji Mindslayer
function CT_RABoss_Mindslayer_OnLoad()
	CT_RABoss_AddMod("其拉洗脑者", CT_RABOSS_MINDSLAYER_INFO, 1, CT_RABOSS_LOCATIONS_AHNQIRAJ);
	
	CT_RABoss_AddEvent("其拉洗脑者", "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE", CT_RABoss_Mindslayer_EventHandler);
	CT_RABoss_AddEvent("其拉洗脑者", "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE", CT_RABoss_Mindslayer_EventHandler);
	CT_RABoss_AddEvent("其拉洗脑者", "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE", CT_RABoss_Mindslayer_EventHandler);
	
	CT_RABoss_AddDropDownButton("其拉洗脑者", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");
end


function CT_RABoss_Mindslayer_EventHandler(event)
	if ( not CT_RABoss_Mods["其拉洗脑者"] or not CT_RABoss_Mods["其拉洗脑者"]["status"] or not CT_RABoss_Mods["其拉洗脑者"].enabled ) then
		return;
	end

	if ( event == "CHAT_MSG_SPELL_PERIODIC_SELF_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_FRIENDLYPLAYER_DAMAGE" or event == "CHAT_MSG_SPELL_PERIODIC_PARTY_DAMAGE" ) then
		local _, _, playerName, playerType = string.find(arg1, CT_RABOSS_MINDSLAYER_MINDFLAY_DETECT);

		if ( playerName and playerType) then
			if ( playerType == CT_RABOSS_SELF2 and playerName == CT_RABOSS_SELF1 ) then
				playerName = UnitName("player");
			end

			CT_RABoss_PlaySound(2);
			CT_RABoss_Announce(string.format(CT_RABOSS_MINDSLAYER_MINDFLAY_ALERT, playerName), CT_RABoss_Mods["其拉洗脑者"]["announce"]);
		end
	end
end


-- C'Thun
function CT_RABoss_CThun_Reset()
	CT_RABoss_SetVar("克苏恩", "fight", nil);
	CT_RABoss_SetVar("克苏恩", "phase", 1);
	CT_RABoss_SetVar("克苏恩", "type", nil);

	CT_RABoss_UnSchedule("CT_RABoss_CThun_EventHandler");
	CT_RABoss_VisualTimer.removeTimer("CThunTentakle");
	CT_RABoss_VisualTimer.removeTimer("CThunDarkGlare");
	CT_RABoss_VisualTimer.removeTimer("CThunGiantTentacle");
end

function CT_RABoss_CThun_OnLoad()
	CT_RABoss_AddMod("克苏恩", CT_RABOSS_CTHUN_INFO, 1, CT_RABOSS_LOCATIONS_AHNQIRAJ);

	CT_RABoss_AddEvent("克苏恩", "CHAT_MSG_CHANNEL", CT_RABoss_CThun_EventHandler);
	CT_RABoss_AddEvent("克苏恩", "PLAYER_ENTERING_WORLD", CT_RABoss_CThun_EventHandler);
	CT_RABoss_AddEvent("克苏恩", "PLAYER_REGEN_DISABLED", CT_RABoss_CThun_EventHandler);
	CT_RABoss_AddEvent("克苏恩", "CHAT_MSG_MONSTER_EMOTE", CT_RABoss_CThun_EventHandler);
	CT_RABoss_AddEvent("克苏恩", "CHAT_MSG_COMBAT_HOSTILE_DEATH", CT_RABoss_CThun_EventHandler);
	CT_RABoss_AddEvent("克苏恩", "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE", CT_RABoss_CThun_EventHandler);

	CT_RABoss_AddDropDownButton("克苏恩", { CT_RABOSS_ANNOUNCE, CT_RABOSS_ANNOUNCE_INFO .. CT_RABOSS_REQ_LEADER_OR_PROM }, "CT_RABoss_ModInfo", "announce", "CT_RABoss_SetInfo");

	CT_RA_RegisterSlashCmd("/cthunstop", CT_RABOSS_CMD_CTHUNSTOP, 30, "CTHUNSTOP", function()
		CT_RABoss_CThun_Reset();
		if ( CT_RA_Level >= 1 ) then
			CT_RA_SendMessage("CTHUNDIESYNCHRO", 1);
		end
	end, "/cthunstop");

	CT_RA_RegisterSlashCmd("/cthunstart", CT_RABOSS_CMD_CTHUNSTART, 30, "CTHUNSTART", function()
		CT_RABoss_CThun_Start();
	end, "/cthunstart");
	CT_RABoss_SetVar("克苏恩", "fight", nil);
	CT_RABoss_SetVar("克苏恩", "phase", 1);
end

function CT_RABoss_CThun_Start()
	CT_RABoss_SetVar("克苏恩", "fight", 1);
	CT_RABoss_SetVar("克苏恩", "phase", 1);

	CT_RABoss_Announce(CT_RABOSS_CTHUN_START_ALERT, CT_RABoss_Mods["克苏恩"]["announce"]);
	CT_RABoss_Schedule("CT_RABoss_CThun_EventHandler", 40, "tentacle5");
	CT_RABoss_Schedule("CT_RABoss_CThun_EventHandler", 43, "darkglare5");
	CT_RABoss_VisualTimer.addTimer("CThunTentakle", 45, CT_RABOSS_CTHUN_TENTAKLE_TIMER);
	CT_RABoss_VisualTimer.addTimer("CThunDarkGlare", 48, CT_RABOSS_CTHUN_DARKGLARE_TIMER);
end

function CT_RABoss_CThun_Phase2()
	CT_RABoss_SetVar("克苏恩", "phase", 2);
	CT_RABoss_SetVar("克苏恩", "type", 1);

	CT_RABoss_Announce(CT_RABOSS_CTHUN_PHASE2_ALERT, CT_RABoss_Mods["克苏恩"]["announce"]);
	CT_RABoss_UnSchedule("CT_RABoss_CThun_EventHandler");
	CT_RABoss_Schedule("CT_RABoss_CThun_EventHandler", 35, "tentacle5");
	CT_RABoss_Schedule("CT_RABoss_CThun_EventHandler", 5, "gianttentacle5");
	CT_RABoss_VisualTimer.removeTimer("CThunTentakle");
	CT_RABoss_VisualTimer.removeTimer("CThunDarkGlare");
	CT_RABoss_VisualTimer.addTimer("CThunTentakle", 40, CT_RABOSS_CTHUN_TENTAKLE_TIMER);
	CT_RABoss_VisualTimer.addTimer("CThunGiantTentacle", 10, CT_RABOSS_CTHUN_GIANTTENTACLE[CT_RABoss_Mods["克苏恩"]["type"]], "orange");
end

function CT_RABoss_CThun_EventHandler(event)
	if ( not CT_RABoss_Mods["克苏恩"] or not CT_RABoss_Mods["克苏恩"]["status"] or not CT_RABoss_Mods["克苏恩"].enabled ) then
		return;
	end
	-- Encounter begin
	if ( event == "PLAYER_REGEN_DISABLED" and not CT_RABoss_Mods["克苏恩"]["fight"] ) then
		if ( UnitExists("target") and UnitName("target") == CT_RABOSS_CTHUN_BOSSNAME_PHASE1 ) then
			CT_RABoss_CThun_Start();

			if ( CT_RA_Level >= 1 ) then
				CT_RA_SendMessage("CTHUNSTARTSYNCHRO", 1);
			end
		end
	end

	-- Eye tentacle pop alert
	if ( event == "tentacle" ) then
		if ( CT_RABoss_Mods["克苏恩"]["phase"] == 2 ) then
		CT_RABoss_Announce(CT_RABOSS_CTHUN_TENTACLE_ALERT, CT_RABoss_Mods["克苏恩"]["announce"]);
		end

		-- Phase 1 => 45 sec
		if ( CT_RABoss_Mods["克苏恩"]["phase"] == 1 ) then
			CT_RABoss_Schedule("CT_RABoss_CThun_EventHandler", 40, "tentacle5");
			CT_RABoss_VisualTimer.addTimer("CThunTentakle", 45, CT_RABOSS_CTHUN_TENTAKLE_TIMER);

		-- Phase 2 => 30 sec
		elseif ( CT_RABoss_Mods["克苏恩"]["phase"] == 2 ) then
			CT_RABoss_Schedule("CT_RABoss_CThun_EventHandler", 25, "tentacle5");
			CT_RABoss_VisualTimer.addTimer("CThunTentakle", 30, CT_RABOSS_CTHUN_TENTAKLE_TIMER);
		end

	-- Eye tentacle 5sec prealert
	elseif ( event == "tentacle5" ) then
		if ( CT_RABoss_Mods["克苏恩"]["phase"] == 2 ) then
		CT_RABoss_Announce(format(CT_RABOSS_CTHUN_TENTACLE_PREALERT, "5"), CT_RABoss_Mods["克苏恩"]["announce"]);
		end
		CT_RABoss_Schedule("CT_RABoss_CThun_EventHandler", 5, "tentacle");
	end

	-- Darkglare pop alert
	if ( event == "darkglare" and CT_RABoss_Mods["克苏恩"]["phase"] == 1 ) then
		CT_RABoss_Announce(CT_RABOSS_CTHUN_DARKGLARE_ALERT, CT_RABoss_Mods["克苏恩"]["announce"]);
		CT_RABoss_Schedule("CT_RABoss_CThun_EventHandler", 28, "darkglareEnd10");
		CT_RABoss_Schedule("CT_RABoss_CThun_EventHandler", 38, "darkglareEnd");
		CT_RABoss_Schedule("CT_RABoss_CThun_EventHandler", 81, "darkglare5");
		CT_RABoss_VisualTimer.addTimer("CThunDarkGlare", 38, CT_RABOSS_CTHUN_DARKGLARE_TIMER, "orange");

	-- Darkglare 5sec prealert
	elseif ( event == "darkglare5" and CT_RABoss_Mods["克苏恩"]["phase"] == 1 ) then
		CT_RABoss_Announce(format(CT_RABOSS_CTHUN_DARKGLARE_PREALERT, "5"), CT_RABoss_Mods["克苏恩"]["announce"]);
		CT_RABoss_Schedule("CT_RABoss_CThun_EventHandler", 5, "darkglare");

		local CThunTarget = nil;
		
		-- Get name and raid group of CThun's target before Dark Glare cast
		for i = 1, GetNumRaidMembers(), 1 do
			name, _, subgroup, _, _, _, _, _ = GetRaidRosterInfo(i);
			if ( UnitExists("raid"..i.."target") and UnitName("raid"..i.."target") == CT_RABOSS_CTHUN_BOSSNAME_PHASE1 ) then
				CThunTarget = UnitName("raid"..i.."targettarget")
				break;
			end
		end
		
		if ( CThunTarget and subgroup ) then
			CT_RABoss_Announce(format(CT_RABOSS_CTHUN_DARKGLARE_ONGROUP, subgroup.."("..CThunTarget..")"), CT_RABoss_Mods["克苏恩"]["announce"]);
		end

	-- Darkglare 5sec until end
	elseif ( event == "darkglareEnd10" and CT_RABoss_Mods["克苏恩"]["phase"] == 1 ) then
		CT_RABoss_Announce(CT_RABOSS_CTHUN_DARKGLARE_END_PREALERT, CT_RABoss_Mods["克苏恩"]["announce"]);

	-- Darkglare end
	elseif ( event == "darkglareEnd" and CT_RABoss_Mods["克苏恩"]["phase"] == 1 )then
		CT_RABoss_Announce(CT_RABOSS_CTHUN_DARKGLARE_END_ALERT, CT_RABoss_Mods["克苏恩"]["announce"]);
		CT_RABoss_VisualTimer.addTimer("CThunDarkGlare", 48, CT_RABOSS_CTHUN_DARKGLARE_TIMER);
	end
	
	if ( event == "gianttentacle") then
		CT_RABoss_Announce(format(CT_RABOSS_CTHUN_GIANTTENTACLE_ALERT, CT_RABOSS_CTHUN_GIANTTENTACLE[CT_RABoss_Mods["克苏恩"]["type"]]), CT_RABoss_Mods["克苏恩"]["announce"]);
		CT_RABoss_Schedule("CT_RABoss_CThun_EventHandler", 25, "gianttentacle5");
		if ( CT_RABoss_Mods["克苏恩"]["type"] == 1) then
			CT_RABoss_SetVar("克苏恩", "type", 2);
		else
			CT_RABoss_SetVar("克苏恩", "type", 1);
		end
		CT_RABoss_VisualTimer.addTimer("CThunGiantTentacle", 30, CT_RABOSS_CTHUN_GIANTTENTACLE[CT_RABoss_Mods["克苏恩"]["type"]], "orange");
	elseif ( event == "gianttentacle5" ) then
		CT_RABoss_Announce(format(CT_RABOSS_CTHUN_GIANTTENTACLE_PREALERT, "5", CT_RABOSS_CTHUN_GIANTTENTACLE[CT_RABoss_Mods["克苏恩"]["type"]]), CT_RABoss_Mods["克苏恩"]["announce"]);
		CT_RABoss_Schedule("CT_RABoss_CThun_EventHandler", 5, "gianttentacle");
	end

	-- Phase 2 begin
	if ( event == "CHAT_MSG_COMBAT_HOSTILE_DEATH") then
		if ( arg1 == CT_RABOSS_CTHUN_PHASE1_DIE_DETECT ) then
		CT_RABoss_CThun_Phase2();
			if ( CT_RA_Level >= 1 ) then
				CT_RA_SendMessage("CTHUNPHASE2SYNCHRO", 1);
			end
		elseif ( arg1 == CT_RABOSS_CTHUN_PHASE2_DIE_DETECT ) then
			CT_RABoss_CThun_Reset();
		if ( CT_RA_Level >= 1 ) then
				CT_RA_SendMessage("CTHUNDIESYNCHRO", 1);
			end
		end
	end

	-- Phase 1&2 begin by synchronisation
	if ( event == "CHAT_MSG_CHANNEL" and CT_RA_Channel and arg9 and strlower(arg9) == strlower(CT_RA_Channel) ) then
		if ( arg1 == "CTHUNSTARTSYNCHRO" and not CT_RABoss_Mods["克苏恩"]["fight"] ) then
			CT_RABoss_CThun_Start();
		elseif ( arg1 == "CTHUNPHASE2SYNCHRO" and CT_RABoss_Mods["克苏恩"]["phase"] == 1 ) then
			CT_RABoss_CThun_Phase2();
		elseif ( arg1 == "CTHUNDIESYNCHRO" ) then
			CT_RABoss_CThun_Reset();
		end
	end

	-- C'Thun weakened
	if ( event == "CHAT_MSG_MONSTER_EMOTE" and string.find(arg1, CT_RABOSS_CTHUN_WEAKENED_DETECT) ) then
		CT_RABoss_UnSchedule("CT_RABoss_CThun_EventHandler");
		CT_RABoss_VisualTimer.removeTimer("CThunTentakle");
		CT_RABoss_VisualTimer.removeTimer("CThunGiantTentacle");
		CT_RABoss_Announce(CT_RABOSS_CTHUN_WEAK_ALERT, CT_RABoss_Mods["克苏恩"]["announce"]);
		CT_RABoss_Schedule("CT_RABoss_CThun_EventHandler", 35, "invul10");
		CT_RABoss_VisualTimer.addTimer("CThunWeakened", 45, CT_RABOSS_CTHUN_WEAKENED_TIMER);
		CT_RABoss_SetVar("克苏恩", "type", 1);

	-- C'Thun weakened end 10 sec
	elseif ( event == "invul10" ) then
		CT_RABoss_Announce(CT_RABOSS_CTHUN_INVUL_PREALERT, CT_RABoss_Mods["克苏恩"]["announce"]);
		CT_RABoss_Schedule("CT_RABoss_CThun_EventHandler", 10, "invul");

	-- C'Thun weakened end
	elseif ( event == "invul" ) then
		CT_RABoss_Announce(CT_RABOSS_CTHUN_INVUL_ALERT, CT_RABoss_Mods["克苏恩"]["announce"]);
		CT_RABoss_Schedule("CT_RABoss_CThun_EventHandler", 32, "tentacle5");
		CT_RABoss_Schedule("CT_RABoss_CThun_EventHandler", 2, "gianttentacle5");
		CT_RABoss_VisualTimer.addTimer("CThunTentakle", 37, CT_RABOSS_CTHUN_TENTAKLE_TIMER);
		CT_RABoss_VisualTimer.addTimer("CThunGiantTentacle", 7, CT_RABOSS_CTHUN_GIANTTENTACLE[CT_RABoss_Mods["克苏恩"]["type"]], "orange");
	end

	if ( event == "CHAT_MSG_SPELL_CREATURE_VS_CREATURE_DAMAGE" and arg1 == CT_RABOSS_CTHUN_EYE_BEAM_DETECT ) then
		CT_RABoss_Announce(CT_RABOSS_CTHUN_EYE_BEAM_ALERT, CT_RABoss_Mods["克苏恩"]["announce"]);
	end
	-- Reseting mod when zoning
	if ( event == "PLAYER_ENTERING_WORLD" ) then
		CT_RABoss_CThun_Reset();
	end
end