local function SetItemSellPriceText(id, amount)
  local idStr = "item" .. id;
  if Aqua.Database_Item[idStr] == nil then return nil end;
  local price = tonumber(Aqua.Database_Item[idStr]["price"]);
  local returnStr = "";
  if price == nil then return nil end
  local g = (price - mod(price, 10000)) / 10000;
  local s = (price - g * 10000) / 100;
  local c = mod(price, 100);
  local prices = price * amount;
  local gs = (prices - mod(prices, 10000)) / 10000;
  local ss = (prices - g * 10000) / 100;
  local cs = mod(prices, 100);
  if amount > 1 then
    return string.format("Sell Price: |cffffff00%02d|r.|cffffffff%02d|r.|cffff8c00%02d|r (|cffffff00%02d|r.|cffffffff%02d|r.|cffff8c00%02d|r per)", gs, ss, cs, g, s, c)
  else
    return string.format("Sell Price: |cffffff00%02d|r.|cffffffff%02d|r.|cffff8c00%02d|r", g, s, c);
  end
end

local function EnName(id)
  local idStr = "item" .. id;
  if Aqua.Database_Item[idStr] == nil then return nil end;
  local name = Aqua.Database_Item[idStr]["enName"];
  if name == nil then return nil end;
  return '|cffaaaaaaItem Name |r|cffffffff' .. name .. '|r';
end

local function CnName(id)
  local idStr = "item" .. id;
  if Aqua.Database_Item[idStr] == nil then return nil end;
  local name = Aqua.Database_Item[idStr]["cnName"];
  if name == nil then return nil end;
  return '|cffaaaaaa物品名 |r|cffffffff' .. name .. '|r';
end

local function LinkToID(link)
	if link then
		local _, _, id = string.find(link, "(%d+):");
		return tonumber(id);
	end
end

--[[  Function Hooks ]]--

local Blizz_ContainerFrameItemButton_OnEnter = ContainerFrameItemButton_OnEnter;
ContainerFrameItemButton_OnEnter = function()
	Blizz_ContainerFrameItemButton_OnEnter();

	local bag = this:GetParent():GetID();
	local slot = this:GetID();
	

  local itemId = LinkToID(GetContainerItemLink(bag, slot));
  local texture, count = GetContainerItemInfo(bag, slot);  
  -- Aqua:Debug(tostring(bag) .. "," .. tostring(slot) .. " x " .. tostring(count));
  if itemId ~= nil then
    if GetLocale() ~= "enUS" then
      enN = EnName(itemId);
      if enN ~= nil then
        GameTooltip:AddLine(enN);
      end
    end
    if GetLocale() ~= "zhCN" then
      cnN = CnName(itemId);
      if cnN ~= nil then
        GameTooltip:AddLine(cnN);
      end
    end
    local itemPrice = SetItemSellPriceText(itemId, count)
    if itemPrice ~= nil then
      GameTooltip:AddLine(itemPrice);
    end
  end
	GameTooltip:Show();
end

local Bliz_GameTooltip_SetLootItem = GameTooltip.SetLootItem;
GameTooltip.SetLootItem = function(self, slot)
	Bliz_GameTooltip_SetLootItem(self, slot);
  
  local itemId = LinkToID(GetLootSlotLink(slot));
	-- AddOwners(GameTooltip, itemId);
  if itemId ~= nil then
    if GetLocale() ~= "enUS" then
      enN = EnName(itemId);
      if enN ~= nil then
        GameTooltip:AddLine(enN);
      end
    end
    if GetLocale() ~= "zhCN" then
      cnN = CnName(itemId);
      if cnN ~= nil then
        GameTooltip:AddLine(cnN);
      end
    end
    local itemPrice = SetItemSellPriceText(itemId, 1)
    if itemPrice ~= nil then
      GameTooltip:AddLine(itemPrice);
    end
  end
  
	self:Show();
end

local Bliz_SetHyperlink = GameTooltip.SetHyperlink;
GameTooltip.SetHyperlink = function(self, link, count)
	if link then
		Bliz_SetHyperlink(self, link, count);
		
		if not count then
			count = 1; 
		end
		
		local id = LinkToID(link);
		if id then
			itemId = id
		else
			itemId = LinkToID(id)
		end
    if itemId ~= nil then
      if GetLocale() ~= "enUS" then
        enN = EnName(itemId);
        if enN ~= nil then
          GameTooltip:AddLine(enN);
        end
      end
      if GetLocale() ~= "zhCN" then
        cnN = CnName(itemId);
        if cnN ~= nil then
          GameTooltip:AddLine(cnN);
        end
      end
      local itemPrice = SetItemSellPriceText(itemId, 1)
      if itemPrice ~= nil then
        GameTooltip:AddLine(itemPrice);
      end
    end
		self:Show();
	end
end

local Bliz_GameTooltip_SetLootRollItem = GameTooltip.SetLootRollItem;
GameTooltip.SetLootRollItem = function(self, rollID) 
	Bliz_GameTooltip_SetLootRollItem(self, rollID);
	
	-- AddOwners(self, LinkToID(GetLootRollItemLink(rollID)));
  itemId = GetLootRollItemLink(rollID);
  if itemId ~= nil then
    if GetLocale() ~= "enUS" then
      enN = EnName(itemId);
      if enN ~= nil then
        GameTooltip:AddLine(enN);
      end
    end
    if GetLocale() ~= "zhCN" then
      cnN = CnName(itemId);
      if cnN ~= nil then
        GameTooltip:AddLine(cnN);
      end
    end
    local itemPrice = SetItemSellPriceText(itemId, 1)
    if itemPrice ~= nil then
      GameTooltip:AddLine(itemPrice);
    end
  end
	self:Show();
end

local Bliz_SetItemRef = SetItemRef;
SetItemRef = function(link, text, button)
	Bliz_SetItemRef(link, text, button);
	
	-- AddOwners(ItemRefTooltip, LinkToID(link));
  itemId = LinkToID(link);
  if itemId ~= nil then
    if GetLocale() ~= "enUS" then
      enN = EnName(itemId);
      if enN ~= nil then
        GameTooltip:AddLine(enN);
      end
    end
    if GetLocale() ~= "zhCN" then
      cnN = CnName(itemId);
      if cnN ~= nil then
        GameTooltip:AddLine(cnN);
      end
    end
    local itemPrice = SetItemSellPriceText(itemId, 1)
    if itemPrice ~= nil then
      GameTooltip:AddLine(itemPrice);
    end
  end
	ItemRefTooltip:Show();
end

local Bliz_GameTooltip_SetAuctionItem = GameTooltip.SetAuctionItem;
GameTooltip.SetAuctionItem = function(self, type, index)
	Bliz_GameTooltip_SetAuctionItem(self, type, index);
	
	-- AddOwners(self, LinkToID(GetAuctionItemLink(type, index)));
  itemId = LinkToID(GetAuctionItemLink(type, index));
  -- Aqua:Debug(itemId);
  if itemId ~= nil then
    if GetLocale() ~= "enUS" then
      enN = EnName(itemId);
      if enN ~= nil then
        GameTooltip:AddLine(enN);
      end
    end
    if GetLocale() ~= "zhCN" then
      cnN = CnName(itemId);
      if cnN ~= nil then
        GameTooltip:AddLine(cnN);
      end
    end
    local itemPrice = SetItemSellPriceText(itemId, 1)
    if itemPrice ~= nil then
      GameTooltip:AddLine(itemPrice);
    end
  end
  
	self:Show();
end