Aqua = {};
Aqua.Version = "0.1";

-- 信息显示级别
Aqua.isDebug = true;
Aqua.isWarning = true;
Aqua.isInfo = true;

-- 信息显示功能
-- 此功能可以提供不同级别的信息显示，包括DEBUG, WARNING和INFO
Aqua.InfoFrame = DEFAULT_CHAT_FRAME;
local function InternalShowText(msg, ui, subElement, msgType)
	fullMsg = "[Aqua][" .. msgType .. "]";
	if ui ~= nil then 
		fullMsg = fullMsg .. "[" .. ui .. "]" 
		if subElement ~= nil then
			fullMsg = fullMsg .. "[" .. subElement .. "]"
		end
	end
	fullMsg = fullMsg .. " " .. msg;
	Aqua.InfoFrame:AddMessage(fullMsg);
end

function Aqua:Debug(msg, ui, subElement)
	if Aqua.isDebug then 
		InternalShowText(msg, ui, subElement, "DEBUG");
	end
end

function Aqua:Warning(msg, ui, subElement)
	if Aqua.isWarning then
		InternalShowText(msg, ui, subElement, "WARNING");
	end
end

function Aqua:Info(msg, ui, subElement)
	if Aqua.isInfo then
		InternalShowText(msg, ui, subElement, "INFO");
	end
end


Aqua:Info("Aqua core library loaded!");