#version 300 es
// 浮点数的精度
precision highp float;

/**
通用
*/
uniform float fAlpha;

uniform sampler2D uTextureColor;

//合成后的风速纹理
uniform sampler2D textureComposite;
//云图类型
uniform int iRadarType2;

//图片的坐标点 固定为
// 0.0f, 0.0f,
// 0.0f, 1.0f,
// 1.0f, 0.0f,
// 1.0f, 1.0f
in vec2 vTexCoord;
out vec4 fragColor;
vec4 getColorByType(float, int, sampler2D, float);
vec4 getColorWind(float, sampler2D, float);
vec4 getColorTemp(float, sampler2D, float);
vec4 getColorPressure(float, sampler2D, float);
vec4 getColorRainDay(float, sampler2D, float);

vec4 getFinalColor(int, vec2, sampler2D, sampler2D, float);

//从RGBA颜色中解码出两个浮点值
vec2 decodeFromColor(vec4 color) {
    vec2 ressult= (color.ga + color.rb / 255.5) * 200.0 - 100.0;
    return ressult;
}

//计算颜色
vec4 getFinalColor(int type, vec2 texCoord, sampler2D textureCompsite, sampler2D textureColor, float alpha){
    vec4 color = texture(textureCompsite, texCoord);
    vec2 values = decodeFromColor(color);//灰度值，如果是风力云图，则存在x，y。否则只存在x
    float realValue;//实际值
    //风力类型，算两个U/V两个方向的值
    if (type==0) {
        realValue = sqrt(pow(values.x, 2.0) + pow(values.y, 2.0));
    } else {
        realValue = values.x;
    }
    return getColorByType(realValue, type, textureColor, alpha);
}

/**
 将灰度值转换为颜色
*/
vec4 getColorByType(float r, int type, sampler2D textureColor, float alpha){
    if (type==0){
        return getColorWind(r, textureColor, alpha);
    } else if (type ==1){
        return getColorTemp(r, textureColor, alpha);
    } else if (type == 2){
        return getColorPressure(r, textureColor, alpha);
    } else {
        return getColorRainDay(r, textureColor, alpha);
    }
}
const float minWindSpeed = 0.0;
const float maxWindSpeed = 104.0;
vec4 getColorWind(float r, sampler2D textureColor, float alpha){

    float c = (r - minWindSpeed) / (maxWindSpeed - minWindSpeed);
    //texture2D获取到指定纹理图片中指定位置的一个像素
    vec4 color = texture(textureColor, vec2(c, 0.5));
    if (r <= 5.0 && alpha > 0.35) {
        alpha = 0.35;
    }
    color.a = color.a*alpha;
    return color;
}
vec4 getColorTemp(float r, sampler2D textureColor, float alpha){
    float c = r<-70.0?0.0:r>50.0?1.0:((r+70.0)/120.0);
    vec4 color = texture(textureColor, vec2(c, 0.5));//从色阶图片纹理中取出颜色
    //    vec4 color = texture(uTextureColor, vec2(c,0.5));
    color.a = color.a*alpha;
    return color;
}
vec4 getColorPressure(float r, sampler2D textureColor, float alpha){
    float c;
    if (r<870.0){
        c = 0.0;
    } else if (r<920.0){
        c =(r-870.0)*0.00117647;
    } else if (r<948.0){
        c =(r-920.0)*0.00210084+0.05882352;
    } else if (r<964.0){ //2
        c =(r-948.0)*0.00735294+0.11764706;
    } else if (r<973.0){
        c =(r-964.0)*0.00653595+0.23529408;
    } else if (r<1021.0){ //6
        c =(r-973.0)*0.00735294+0.2941176;
    } else if (r<1030.0){
        c =(r-1021.0)*0.00653595+0.64705872;
    } else if (r<1080.0){ //5
        c =(r-1030.0)*0.00588235+0.70588224;
    } else {
        c = 1.0;
    }
    vec4 color = texture(textureColor, vec2(c, 0.5));
    //    vec4 color = texture(uTextureColor, vec2(c,0.5));
    color.a = color.a*alpha;
    return color;
}
vec4 getColorRainDay(float r, sampler2D textureColor, float alpha){
    float c;
    if (r<0.1){
        c = 0.0;
    } else if (r<0.2){
        //0.1-0.2 ,占1/13份额
        c =(r-0.1)*0.7692308;
    } else if (r<0.6){
        //0.2-0.6 ,占1/13份额
        c =(r-0.2)*0.1923077+0.07692308;
    } else if (r<1.2){
        c =(r-0.6)*0.12820513+0.15384615;
    } else if (r<4.0){
        c =(r-1.2)*0.02747253+0.23076924;
    } else if (r<8.0){
        c =(r-4.0)*0.01923077+0.30769232;
    } else if (r<10.0){
        c =(r-8.0)*0.03846154+0.3846154;
    } else if (r<45.0){
        //1050-1080 ,占8/14份额  /40*8/14+6/14
        c =(r-10.0)*0.01538462+0.46153844;
    } else {
        c = 1.0;
    }
    vec4 color = texture(textureColor, vec2(c, 0.5));
    if (c!=0.0){
        if (r<0.2){
            alpha = alpha*0.5;
        } else if (r<0.6){
            alpha = alpha*0.6;
        } else if (r<4.0){
            alpha = alpha*0.8;
        }
        color.a = color.a*alpha;
    } else {
        color.a = 0.0;
    }
    return color;
}

void main() {
    vec4 color = getFinalColor(iRadarType2, vTexCoord, textureComposite, uTextureColor, fAlpha);
    fragColor = color;
}