#version 300 es
//1. 输入UV两个方向风速的灰度图，和用于保存结果的纹理
//2. 根据灰度图计算出UV两个方向的风速
//3. 将UV两个方向的风速编码成颜色，保存到指定纹理中

precision highp float;

//云图类型
uniform int iRadarType;

//灰度图纹理 如果是风力云图则textureImageU和textureImageV都有效
//如果是温度和气压，则仅textureImageU生效
uniform sampler2D textureImageU;
uniform sampler2D textureImageV;

//灰度图代表的风力的最大最小值
uniform float fMinU;
uniform float fMaxU;
uniform float fMaxV;
uniform float fMinV;

//图片纹理映射坐标点 固定为
// 0.0f, 0.0f,
// 0.0f, 1.0f,
// 1.0f, 0.0f,
// 1.0f, 1.0f
in vec2 vTexCoord;//纹理映射坐标
out vec4 fragColor;
const float stand = 1.0 / 256.0;

float getRealValue(vec2 uv, sampler2D imgTexture, float max, float min) {
    vec4 color=texture(imgTexture, uv);
    float r=color.r;//因为灰度图的rgb三个颜色分量相等，所以可以任意取出一个颜色通道的值作为灰度值，取值范围0~1
    float  result =r*(max-min)+min;
    return result;
}

//将颜色转换为对应的风速值 为了保持画面平滑，做一次四点插值计算
float convertColorToValue(vec2 uv, sampler2D imgTexture, float max, float min) {
    vec2 px = vec2(stand, stand);//(1/256, 1/256)
    vec2 uvt = uv * vec2(256.0, 256.0);//纹理坐标(0~1,0~1)*(256.0,256.0)
    vec2 vc = (floor(uvt)) * px;//floor(x)向下取整 纹理坐标*(256.0,256.0)*(1/256,1/256)
    vec2 f = fract(uvt);//fract(x) 返回x的小数部分  纹理坐标*(256.0,256.0)的小数部分

    //取四个点的值(当前点、右侧点、下侧点、右下侧点)，然后做插值(插值(插值(当前点，右侧点),插值(下侧点，右下侧点)))
    float tl = getRealValue(vc, imgTexture, max, min);
    float tr = getRealValue(vc + vec2(px.x, 0), imgTexture, max, min);
    float bl = getRealValue(vc + vec2(0, px.y), imgTexture, max, min);
    float br = getRealValue(vc + px, imgTexture, max, min);
    //mix线性插值 dest=x*(1-level)+y*level 假设x=1,y=2,level=0.5，dest=1*0.5+2*0.5=1.5，level越大其结果越趋向于y
    return mix(mix(tl, tr, f.x), mix(bl, br, f.x), f.y);
}

//将两个浮点数编码成RGBA颜色值
vec4 encode2Color(float value1, float value2) {
    //风速范围是-100~100。对每个风速分量先加100，再除200。所以在取出风速时要做一次反计算，也就是先乘200，再减100
    value1= (value1 + 100.0)/200.0;
    value2= (value2 + 100.0)/200.0;
    //将UV两个方向的风速编码成颜色存储到纹理中
    float r =fract(value1 * 255.0 + 0.25 / 255.0);
    float g = value1 - r / 255.0;//u = g + r/255

    float b =fract(value2 * 255.0 + 0.25 / 255.0);
    float a = value2 - b / 255.0;//v = a + b/255
    return vec4(r, g, b, a);
}

void main() {
    float speedU = convertColorToValue(vTexCoord, textureImageU, fMaxU, fMinU);
    float speedV = 0.0;
    if (iRadarType == 0) {
        speedV = convertColorToValue(vTexCoord, textureImageV, fMaxV, fMinV);
    }
    fragColor = encode2Color(speedU, speedV);
}