#version 300 es
// 浮点数精度
precision highp float;
/**
通用
*/
// 顶点坐标
uniform mat4 uMVPMatrix;
uniform int fType;
out vec2 vfType;
in vec2 aTexCoord;


/**
点数据类型相关变量方法
*/
uniform vec4 uColor;
uniform float uZ;
const float K_EARTH_CIRCLE_2 =20037508.0;//赤道周长的一半，单位米。也就是将地球以墨卡托投影坐标系展开后的宽度的一半
const float EARTH_RADIUS_IN_METERS =6378137.0;//地球半径，单位米
out vec4 vColor;
float degToRad(float paramDouble);
vec2 latLongAddToPixels(float lat, float lon);


/**
图片类型相关变量
*/
// 顶点对应的图片上的坐标
in vec4 aPosition;
out vec2 vTexCoord;



void main(){
    //下雨类型
    if (fType==3){
        vec2 pixels = latLongAddToPixels(aTexCoord.x, aTexCoord.y);
        vec4 position = uMVPMatrix * vec4(pixels.x, pixels.y, uZ, 1.0);
        gl_Position = vec4(position.x, position.y, -1.0 * uZ, position.w);
        vColor = uColor;
    } else {
        vTexCoord = aTexCoord;
        gl_Position =  uMVPMatrix * aPosition;
    }
    vfType = vec2(fType, 0);
}



float degToRad(float paramDouble){
    return paramDouble * 0.017453292519943295;
}

vec2 latLongAddToPixels(float lat, float lon){

    float var6 = EARTH_RADIUS_IN_METERS * degToRad(lon);
    float var8 = sin(degToRad(lat));
    float var10 = log((1.0 + var8) / (1.0 - var8));
    float var12 = EARTH_RADIUS_IN_METERS * var10 / 2.0;
    float var14 = (K_EARTH_CIRCLE_2 + var6) / 0.14929106831550598;
    float var16 = (K_EARTH_CIRCLE_2 - var12) / 0.14929106831550598;

    return vec2(var14, var16);
}
