#version 300 es
// 浮点数的精度
precision highp float;

/**
通用
*/
uniform float fAlpha;
uniform int fPlayLast;
uniform int fTypeS;
uniform int fLastType;


/**
点数据类型相关变量
*/
in vec4 vColor;


/**
图片类型相关变量方法
*/
//2D采样器，可以理解为图片的唯一标识
uniform sampler2D uTextureUnitU;
uniform sampler2D uTextureUnitV;
uniform sampler2D uTextureColor;
uniform float fMinU;
uniform float fMaxU;
uniform float fMaxV;
uniform float fMinV;

uniform sampler2D uLastTextureUnitU;
uniform sampler2D uLastTextureUnitV;
uniform sampler2D uLastTextureColor;
uniform float fLastMinU;
uniform float fLastMaxU;
uniform float fLastMaxV;
uniform float fLastMinV;
const float stand = 1.0/256.0;
const float maxC = 1.0-stand/2.0;
//图片的坐标点 固定为
// 0.0f, 0.0f,
// 0.0f, 1.0f,
// 1.0f, 0.0f,
// 1.0f, 1.0f
in vec2 vTexCoord;

//图片标值，色值转换相关方法
vec4 convertR(vec2, sampler2D, float, float);
vec4 getRealValue(vec2, sampler2D, float, float);
vec4 getColorByType(vec4, int, sampler2D, float);
vec4 getColorWind(vec4, sampler2D, float);
vec4 getColorTemp(vec4, sampler2D, float);
vec4 getColorPressure(vec4, sampler2D, float);
vec4 getColorRainDay(vec4, sampler2D, float);
vec4 getColorRain48H(vec4, sampler2D, float);
vec4 getColorRainSnow(vec4, sampler2D, float);
vec4 getColorRainSnowForSnow(vec4, sampler2D, float);
vec4 getColorRainSnowForSleet(vec4, sampler2D, float);
vec4 getColorAqi(vec4, sampler2D, float);

vec4 getFinalColor(vec2, sampler2D, sampler2D, sampler2D, int, float, float, float, float, float);

out vec4 fragColor;
void main(){
    vec4 color = getFinalColor(vTexCoord, uTextureUnitU, uTextureUnitV, uTextureColor, fTypeS, fMaxU, fMinU, fMaxV, fMinV, fAlpha);
    if (fPlayLast==1){
        vec4 lastColor = getFinalColor(vTexCoord, uLastTextureUnitU, uLastTextureUnitV, uLastTextureColor, fLastType, fLastMaxU, fLastMinU, fLastMaxV, fLastMinV, (1.0-fAlpha));
        fragColor = color.a*color+(1.0-color.a)*lastColor;
    } else {
        fragColor = color;
    }
}

//计算颜色
vec4 getFinalColor(vec2 texCoord, sampler2D textureUnitU, sampler2D textureUnitV, sampler2D textureColor, int type, float maxU, float minU, float maxV, float minV, float alpha){
    if (type==3){
        //下雨类型
        return vColor;
    } else {
        //其他类型
        vec4 rU = convertR(texCoord, textureUnitU, maxU, minU);
        float r;
        //风力类型，算两个U/V两个方向的值
        if (type==0){
            vec4 rV = convertR(texCoord, textureUnitV, maxV, minV);
            r= sqrt(pow(rU.r, 2.0)+pow(rV.r, 2.0));
        } else {
            r = rU.r;
        }
        return getColorByType(vec4(r, rU.g, rU.b, rU.a), type, textureColor, alpha);
    }
}

/**
图片类方法开始
*/

vec4 getColorByType(vec4 r, int type, sampler2D textureColor, float alpha){
    if (type==0){
        return getColorWind(r, textureColor, alpha);
    } else if (type ==1){
        return getColorTemp(r, textureColor, alpha);
    } else if (type == 2){
        return getColorPressure(r, textureColor, alpha);
    } else if (type == 5){
        return getColorAqi(r, textureColor, alpha);
    } else if (type == 8){
        return getColorRain48H(r, textureColor, alpha);
    } else if (type == 10){
        return getColorRainSnow(r, textureColor, alpha);
    }
    else {
        return getColorRainDay(r, textureColor, alpha);
    }
}

const float minAQIValue = 0.0;
const float maxAQIValue = 500.0;
vec4 getColorAqi(vec4 value, sampler2D textureColor, float alpha){
    float r = value.r;
    if (r < 1.0) {
        return vec4(0.0, 0.0, 0.0, 0.0);
    } else {
        float c = (r - minAQIValue) / (maxAQIValue - minAQIValue);
        //texture2D获取到指定纹理图片中指定位置的一个像素
        vec4 color = texture(textureColor, vec2(c, 0.5));
        color.a = color.a*alpha;
        return color;
    }
}

vec4 getColorWind(vec4 value, sampler2D textureColor, float alpha){
    float r = value.r;
    float c;
    if (r<0.0){
        c = 0.0;
    } else if (r<1.0){
        c =r*0.07142857;
    } else if (r<3.0){
        c =(r-1.0)*0.03571428+0.07142857;
    } else if (r<5.0){
        c =(r-3.0)*0.03571428+0.14285714;
    } else if (r<75.0){
        c =(r-5.0)*0.01020408+0.21428571;
    } else if (r<105.0){
        c =(r-75.0)*0.00238095+0.92857143;
    } else {
        c = 1.0;
    }
    //texture2D获取到指定纹理图片中指定位置的一个像素
    vec4 color = texture(textureColor, vec2(c, 0.5));
    color.a = color.a*alpha;
    return color;
}
vec4 getColorTemp(vec4 value, sampler2D textureColor, float alpha){
    float r = value.r;
    float c = r<-70.0?0.0:r>50.0?1.0:((r+70.0)/120.0);
    vec4 color = texture(textureColor, vec2(c, 0.5));
    //    vec4 color = texture(uTextureColor, vec2(c,0.5));
    color.a = color.a*alpha;
    return color;
}
vec4 getColorPressure(vec4 value, sampler2D textureColor, float alpha){
    float r = value.r;
    float c;
    if (r<870.0){
        c = 0.0;
    } else if (r<920.0){
        c =(r-870.0)*0.00117647;
    } else if (r<948.0){
        c =(r-920.0)*0.00210084+0.05882352;
    } else if (r<964.0){ //2
        c =(r-948.0)*0.00735294+0.11764706;
    } else if (r<973.0){
        c =(r-964.0)*0.00653595+0.23529408;
    } else if (r<1021.0){ //6
        c =(r-973.0)*0.00735294+0.2941176;
    } else if (r<1030.0){
        c =(r-1021.0)*0.00653595+0.64705872;
    } else if (r<1080.0){ //5
        c =(r-1030.0)*0.00588235+0.70588224;
    } else {
        c = 1.0;
    }
    vec4 color = texture(textureColor, vec2(c, 0.5));
    color.a = color.a*alpha;
    return color;
}

//48小时降水配色
vec4 getColorRain48H(vec4 value, sampler2D textureColor, float alpha){
    float r = value.r;
    if (r < 5.0) {
        return vec4(0.0, 0.0, 0.0, 0.0);
    } else if (r < 9.0) {
        return vec4(0.84705883, 1.0, 0.972549, 0.6);
    } else if (r < 19.0) {
        return vec4(0.7019608, 0.9843137, 0.9098039, 0.6);
    } else if (r < 37.0) {
        return vec4(0.5921569, 0.9607843, 0.28627452, 0.6);
    } else if (r < 55.0) {
        return vec4(0.40392157, 0.8901961, 0.22745098, 0.69803923);
    } else if (r < 73.0) {
        return vec4(0.33333334, 0.8039216, 0.15686275, 0.8);
    } else if (r < 91.0) {
        return vec4(0.28235295, 0.7411765, 0.047058824, 0.85);
    } else if (r < 109.0) {
        return vec4(0.9647059, 0.92941177, 0.34117648, 0.9490196);
    } else if (r < 127.0) {
        return vec4(0.9607843, 0.85882354, 0.16078432, 0.949019);
    } else if (r < 145.0) {
        return vec4(0.9647059, 0.7254902, 0.14901961, 0.9490196);
    } else if (r < 163.0) {
        return vec4(0.9607843, 0.47058824, 0.20392157, 0.9490196);
    } else if (r < 181.0) {
        return vec4(0.92156863, 0.29411766, 0.16862746, 0.9490196);
    } else if (r < 199.0) {
        return vec4(0.8352941, 0.1254902, 0.1254902, 0.9490196);
    } else if (r < 217.0) {
        return vec4(0.7411765, 0.0, 0.0, 0.9490196);
    } else if (r < 235.0) {
        return vec4(0.67058825, 0.0, 0.11372549, 0.9490196);
    } else {
        return vec4(0.5647059,0.0,0.1254902, 0.9490196);
    }
}


//48小时雨雪云图配色
vec4 getColorRainSnow(vec4 value, sampler2D textureColor, float alpha){
    float r = value.r;
    float g = value.g;
    bool isRain =  g < 0.39;
    bool isSleet = g >= 0.39 && g < 0.58;
    bool isSnow =  g >= 0.58;
    if (isSnow) {
        return getColorRainSnowForSnow(value, textureColor, alpha);
    }
    if (isSleet) {
        return getColorRainSnowForSleet(value, textureColor, alpha);
    }

    //降雨配色
    if (r < 5.0) {
        return vec4(0.0, 0.0, 0.0, 0.0);
    } else if (r < 9.0) {
        return vec4(0.7019608, 0.9843137, 0.9098039, 0.6);
    } else if (r < 19.0) {
        return vec4(0.61960787, 0.9607843, 0.6784314, 0.6);
    } else if (r < 37.0) {
        return vec4(0.52156866, 0.92941177, 0.4117647, 0.6);
    } else if (r < 55.0) {
        return vec4(0.40392157, 0.8901961, 0.22745098, 0.69803923);
    } else if (r < 73.0) {
        return vec4(0.36862746, 0.84313726, 0.19215687, 0.8);
    } else if (r < 91.0) {
        return vec4(0.33333334, 0.8039216, 0.15686275, 0.85);
    } else if (r < 109.0) {
        return vec4(0.30588236, 0.76862746, 0.09411765, 0.9490196);
    } else if (r < 127.0) {
        return vec4(0.28235295, 0.7411765, 0.047058824, 0.949019);
    } else if (r < 145.0) {
        return vec4(0.2509804, 0.7019608, 0.019607844, 0.9490196);
    } else if (r < 163.0) {
        return vec4(0.23529412, 0.67058825, 0.015686275, 0.9490196);
    } else if (r < 181.0) {
        return vec4(0.21960784, 0.6313726, 0.011764706, 0.9490196);
    } else if (r < 199.0) {
        return vec4(0.20392157, 0.5921569, 0.007843138, 0.9490196);
    } else if (r < 217.0) {
        return vec4(0.19215687, 0.5647059, 0.003921569, 0.9490196);
    } else if (r < 235.0) {
        return vec4(0.09803922, 0.5372549, 0.015686275, 0.9490196);
    } else {
        return vec4(0.06666667,0.41960785,0.0, 0.9490196);
    }
}

//雨雪云图降雪配色
vec4 getColorRainSnowForSnow(vec4 value, sampler2D textureColor, float alpha){
    float r = value.r;
    if (r < 5.0) {
        return vec4(0.0, 0.0, 0.0, 0.0);
    } else if (r < 9.0) {
        return vec4(0.8745098, 0.7490196, 1.0, 0.6);
    } else if (r < 19.0) {
        return vec4(0.8156863, 0.64705884, 0.9882353, 0.6);
    } else if (r < 37.0) {
        return vec4(0.7607843, 0.5568628, 0.972549, 0.6);
    } else if (r < 55.0) {
        return vec4(0.70980394, 0.4627451, 0.9607843, 0.69803923);
    } else if (r < 73.0) {
        return vec4(0.6745098, 0.40784314, 0.94509804, 0.8);
    } else if (r < 91.0) {
        return vec4(0.64705884, 0.35686275, 0.9372549, 0.85);
    } else if (r < 109.0) {
        return vec4(0.6117647, 0.3019608, 0.92156863, 0.9490196);
    } else if (r < 127.0) {
        return vec4(0.56078434, 0.25882354, 0.85882354, 0.949019);
    } else if (r < 145.0) {
        return vec4(0.5176471, 0.22745098, 0.80784315, 0.9490196);
    } else if (r < 163.0) {
        return vec4(0.47058824, 0.1882353, 0.7490196, 0.9490196);
    } else if (r < 181.0) {
        return vec4(0.41960785, 0.12941177, 0.7137255, 0.9490196);
    } else if (r < 199.0) {
        return vec4(0.3764706, 0.078431375, 0.68235296, 0.9490196);
    } else if (r < 217.0) {
        return vec4(0.32941177, 0.023529412, 0.64705884, 0.9490196);
    } else if (r < 235.0) {
        return vec4(0.29803923, 0.011764706, 0.5882353, 0.9490196);
    } else {
        return vec4(0.24705882,0.0,0.49803922, 0.9490196);
    }
}

//雨雪云图雨夹雪配色
vec4 getColorRainSnowForSleet(vec4 value, sampler2D textureColor, float alpha){
    float r = value.r;
    if (r < 5.0) {
        return vec4(0.0, 0.0, 0.0, 0.0);
    } else if (r < 9.0) {
        return vec4(0.81960785, 0.8666667, 0.8901961, 0.6);
    } else if (r < 19.0) {
        return vec4(0.7529412, 0.80784315, 0.85882354, 0.6);
    } else if (r < 37.0) {
        return vec4(0.7058824, 0.76862746, 0.8352941, 0.6);
    } else if (r < 55.0) {
        return vec4(0.6392157, 0.70980394, 0.8039216, 0.69803923);
    } else if (r < 73.0) {
        return vec4(0.5686275, 0.64705884, 0.7607843, 0.8);
    } else if (r < 91.0) {
        return vec4(0.5058824, 0.58431375, 0.7176471, 0.85);
    } else if (r < 109.0) {
        return vec4(0.4392157, 0.5254902, 0.6745098, 0.9490196);
    } else if (r < 127.0) {
        return vec4(0.38431373, 0.47058824, 0.627451, 0.949019);
    } else if (r < 145.0) {
        return vec4(0.3372549, 0.42352942, 0.5882353, 0.9490196);
    } else if (r < 163.0) {
        return vec4(0.2784314, 0.3647059, 0.5411765, 0.9490196);
    } else if (r < 181.0) {
        return vec4(0.23921569, 0.3254902, 0.50980395, 0.9490196);
    } else if (r < 199.0) {
        return vec4(0.20784314, 0.2901961, 0.48235294, 0.9490196);
    } else if (r < 217.0) {
        return vec4(0.16862746, 0.24705882, 0.44705883, 0.9490196);
    } else if (r < 235.0) {
        return vec4(0.15294118, 0.23137255, 0.43137255, 0.9490196);
    } else {
        return vec4(0.11764706,0.19607843,0.4, 0.9490196);
    }
}

vec4 getColorRainDay(vec4 value, sampler2D textureColor, float alpha){
    float r = value.r;
    float c;
    if (r<0.1){
        c = 0.0;
    } else if (r<0.2){
        //0.1-0.2 ,占1/13份额
        c =(r-0.1)*0.7692308;
    } else if (r<0.6){
        //0.2-0.6 ,占1/13份额
        c =(r-0.2)*0.1923077+0.07692308;
    } else if (r<1.2){
        c =(r-0.6)*0.12820513+0.15384615;
    } else if (r<4.0){
        c =(r-1.2)*0.02747253+0.23076924;
    } else if (r<8.0){
        c =(r-4.0)*0.01923077+0.30769232;
    } else if (r<10.0){
        c =(r-8.0)*0.03846154+0.3846154;
    } else if (r<45.0){
        //1050-1080 ,占8/14份额  /40*8/14+6/14
        c =(r-10.0)*0.01538462+0.46153844;
    } else {
        c = 1.0;
    }
    vec4 color = texture(textureColor, vec2(c, 0.5));
    if (c!=0.0){
        if (r<0.2){
            alpha = alpha*0.5;
        } else if (r<0.6){
            alpha = alpha*0.6;
        } else if (r<4.0){
            alpha = alpha*0.8;
        }
        color.a = color.a*alpha;
    } else {
        color.a = 0.0;
    }
    return color;
}

vec4 convertR(vec2 uv, sampler2D texture, float max, float min) {
    vec2 px = vec2(stand, stand);//(1/256, 1/256)
    vec2 uvt = uv * vec2(256.0, 256.0);//纹理坐标(0~1,0~1)*(256.0,256.0)
    vec2 vc = (floor(uvt)) * px;//floor(x)向下取整 纹理坐标*(256.0,256.0)*(1/256,1/256)
    vec2 f = fract(uvt);//fract(x) 返回x的小数部分  纹理坐标*(256.0,256.0)的小数部分

    //取四个点的值(当前点、右侧点、下侧点、右下侧点)，然后做插值(插值(插值(当前点，右侧点),插值(下侧点，右下侧点)))
    vec4 tl = getRealValue(vc, texture, max, min);
    vec4 tr = getRealValue(vc + vec2(px.x, 0), texture, max, min);
    vec4 bl = getRealValue(vc + vec2(0, px.y), texture, max, min);
    vec4 br = getRealValue(vc + px, texture, max, min);
    //mix线性插值 dest=x*(1-level)+y*level 假设x=1,y=2,level=0.5，dest=1*0.5+2*0.5=1.5，level越大其结果越趋向于y
    return mix(mix(tl, tr, f.x), mix(bl, br, f.x), f.y);
}

//获取指定坐标的颜色。其中red通道会根据max和min换算成实际气象值(如降水量、风力等)。
//其余分量则原样返回。
vec4 getRealValue(vec2 uv, sampler2D u_screen, float max, float min) {
    vec4 color=texture(u_screen, uv);
    float r=color.r;
    float result =r*(max-min)+min;
    return vec4(result, color.g, color.b, color.a);
}

/**
图片类方法结束
*/