#version 300 es
// 浮点数的精度
precision highp float;

/**
通用
*/
uniform float fAlpha;
uniform int fPlayLast;
uniform int fTypeS;
uniform int fLastType;
uniform int fColor;


/**
点数据类型相关变量
*/
in vec4 vColor;


/**
图片类型相关变量方法
*/
//2D采样器，可以理解为图片的唯一标识
uniform sampler2D uTextureUnitU;
uniform sampler2D uTextureUnitV;
uniform sampler2D uTextureColor;
uniform float fMinU;
uniform float fMaxU;
uniform float fMaxV;
uniform float fMinV;

uniform sampler2D uLastTextureUnitU;
uniform sampler2D uLastTextureUnitV;
uniform sampler2D uLastTextureColor;
uniform float fLastMinU;
uniform float fLastMaxU;
uniform float fLastMaxV;
uniform float fLastMinV;
const float stand = 1.0 / 256.0;
const float maxC = 1.0 - stand / 2.0;
//图片的坐标点 固定为
// 0.0f, 0.0f,
// 0.0f, 1.0f,
// 1.0f, 0.0f,
// 1.0f, 1.0f
in vec2 vTexCoord;

//图片标值，色值转换相关方法
float convertR(vec2, sampler2D, float, float);
float convertRForAllergy(vec2, sampler2D, float, float);
float getRealValue(vec2, sampler2D, float, float);
vec4 getColorByType(float, int, sampler2D, float);
vec4 getColorTemp(float, sampler2D, float);
vec4 getColorAllergy(float);
vec4 getFinalColor(vec2, sampler2D, sampler2D, sampler2D, int, float, float, float, float, float);
float getConfig (float, float, float, float, float);
float bilinearWind2(const vec2, sampler2D, vec2);

out vec4 fragColor;
void main() {
    if(fTypeS == 12){
        fragColor = getFinalColor(vTexCoord, uTextureUnitU, uTextureUnitV, uTextureColor, fTypeS, fMaxU, fMinU, fMaxV, fMinV, fAlpha);
    }else{
        float rV = convertR(vTexCoord, uTextureUnitV, fMaxV, fMinV);
        if (rV >= 0.1) {
            vec4 color = getFinalColor(vTexCoord, uTextureUnitU, uTextureUnitV, uTextureColor, fTypeS, fMaxU, fMinU, fMaxV, fMinV, fAlpha);
            color.a = 0.9;
            if (fPlayLast == 1) {
                vec4 lastColor = getFinalColor(vTexCoord, uLastTextureUnitU, uLastTextureUnitV, uLastTextureColor, fLastType, fLastMaxU, fLastMinU, fLastMaxV, fLastMinV, (1.0 - fAlpha));
                fragColor = color.a * color + (1.0 - color.a) * lastColor;
            } else {
                fragColor = color;
            }
        } else {
            discard;
        }
    }
}

float getConfig (float A, float e, float i, float R, float n) {
    return e == A ? i == A ? R == A ? n == A ? 15.0 : 13.0 : n == A ? 14.0 : 12.0 : R == A ? n == A ? 11.0 : 9.0 : n == A ? 10.0 : 8.0 : i == A ? R == A ? n == A ? 7.0 : 5.0 : n == A ? 6.0 : 4.0 : R == A ? n == A ? 3.0 : 1.0 : n == A ? 2.0 : 0.0;
}


float bilinearWind2(const vec2 uv, sampler2D _screen, float max, float min) {
    vec2 px = vec2(stand, stand);//(1/256, 1/256)
    vec2 uvt = uv * vec2(256.0, 256.0);//纹理坐标(0~1,0~1)*(256.0,256.0)
    vec2 vc = (floor(uvt)) * px;//floor(x)向下取整 纹理坐标*(256.0,256.0)*(1/256,1/256)
    vec2 f = fract(uvt);//fract(x) 返回x的小数部分  纹理坐标*(256.0,256.0)的小数部分


    float tl;
    if(fTypeS == 12){
        tl = convertRForAllergy(vc, _screen, max, min);
    }else{
        tl = convertR(vc, _screen, max, min);
    }
    tl=floor(tl+0.5);

    float tr;
    if(fTypeS == 12){
        tr = convertRForAllergy(vc + vec2(px.x, 0.0), _screen, max, min);
    }else{
        tr = convertR(vc + vec2(px.x, 0.0), _screen, max, min);
    }
    tr=floor(tr+0.5);

    float bl;
    if(fTypeS == 12){
        bl = convertRForAllergy(vc + vec2(0.0, px.y), _screen, max, min);
    }else{
        bl = convertR(vc + vec2(0.0, px.y), _screen, max, min);
    }
    bl=floor(bl+0.5);

    float br;
    if(fTypeS == 12){
        br = convertRForAllergy(vc + px, _screen, max, min);
    }else{
        br = convertR(vc + px, _screen, max, min);
    }
    br=floor(br+0.5);


    for (float i=0.0;i<=10.0;i++){
        //      float code= getConfig(i,tl,tr,bl,br);
        float code= getConfig(i, bl, br, tl, tr);
        if (code==0.0){ }
        if (code==1.0) {
            if (f.x<0.5&&f.y<0.5-f.x){
                return i;
            }
        }
        if (code==2.0) {
            if (f.x>0.5&&f.y<f.x-0.5){
                return i;
            }
        }
        if (code==3.0) {
            if (f.y<0.5){
                return i;
            }
        }
        if (code==4.0) {
            if (f.x>0.5&&f.y>1.5-f.x){
                return i;
            }
        }
        if (code==5.0) {
            if (!(f.x>0.5&&f.y<f.x-0.5)&&!(f.x<0.5&&f.y>0.5+f.x)){
                return i;
            }
        }
        if (code==6.0) {
            if (f.x>0.5){
                return i;
            }
        }
        if (code==7.0) {
            if (!(f.x<0.5&&f.y>0.5+f.x)){
                return i;
            }
        }
        if (code==8.0) {
            if (f.x<0.5&&f.y>0.5+f.x){
                return i;
            }
        }
        if (code==9.0) {
            if (f.x<0.5){
                return i;
            }
        }
        if (code==10.0) {
            if (!(f.x>0.5&&f.y>1.5-f.x)&&!(f.x<0.5&&f.y<0.5-f.x)){
                return i;
            }
        }
        //
        if (code==11.0) {
            if (!(f.x>0.5&&f.y>1.5-f.x)){
                return i;
            }
        }
        if (code==12.0) {
            if (f.y>0.5){
                return i;
            }
        }
        if (code==13.0) {
            if (!(f.x>0.5&&f.y<f.x-0.5)){
                return i;
            }
        }
        if (code==14.0) {
            if (!(f.x<0.5&&f.y<0.5-f.x)){
                return i;
            }
        }
        if (code==15.0) {
            return i;
        }

    }
    return 0.0;
}

//计算颜色
vec4 getFinalColor(vec2 texCoord, sampler2D textureUnitU, sampler2D textureUnitV, sampler2D textureColor, int type, float maxU, float minU, float maxV, float minV, float alpha) {
    if (type == 3) {
        //下雨类型
        return vColor;
    }else if (type==12){
        //float level = bilinearWind2(texCoord, textureUnitU, maxU, minU);
        float level = getRealValue(texCoord,textureUnitU,maxU,minU);
        //float level = convertRForAllergy(texCoord,textureUnitU,maxU,minU);
        float level1 = floor(level);
        return getColorAllergy(level1);
     }  else {
        //其他类型
        float rU = bilinearWind2(texCoord, textureUnitU, maxU, minU);
        float r;
        //风力类型，算两个U/V两个方向的值
        if (type == 0) {
            float rV = convertR(texCoord, textureUnitV, maxV, minV);
            r = sqrt(pow(rU, 2.0) + pow(rV, 2.0));
        } else {
            r = rU;
        }
        return getColorByType(r, type, textureColor, alpha);
    }
}

/**
图片类方法开始
*/

vec4 getColorByType(float r, int type, sampler2D textureColor, float alpha) {
    return getColorTemp(r, textureColor, alpha);
}

vec4 getColorAllergy(float r){
    vec4 color;
    if(fColor == 0){
        if(r <= 1.0){
             color = vec4(85.0/255.0,205.0/255.0,40.0/255.0,0.65);//绿
        } else if(r <= 2.0) {
            color = vec4(245.0/255.0,219.0/255.0,43.0/255.0,0.75);//黄
        } else if(r <= 3.0) {
            color = vec4(248.0/255.0,143.0/255.0,13.0/255.0,0.8);//橙
        } else if(r <= 4.0) {
            color = vec4(230.0/255.0,75.0/255.0,75.0/255.0,0.85);//红
        } else {
            color = vec4(230.0/255.0,75.0/255.0,75.0/255.0,0.85);//红
        }
    }else{
        if(r <= 1.0){
            color = vec4(85.0/255.0,205.0/255.0,40.0/255.0,0.0);//透明
        } else if(r <= 2.0) {
            color = vec4(255.0/255.0,189.0/255.0,16.0/255.0,0.75);//黄
        } else if(r <= 3.0) {
            color = vec4(255.0/255.0,131.0/255.0,0.0/255.0,0.8);//橙
        } else if(r <= 4.0) {
            color = vec4(230.0/255.0,75.0/255.0,75.0/255.0,0.85);//红
        } else {
            color = vec4(230.0/255.0,75.0/255.0,75.0/255.0,0.85);//红
        }
    }
    return color;
}

vec4 getColorTemp(float r, sampler2D textureColor, float alpha) {
    vec4 color;
    if (r <= 0.0) {
        color = vec4(138.0 / 255.0, 234.0 / 255.0, 129.0 / 255.0, 0.0);//透明
    }
    else if (r <= 2.0) {
        color = vec4(138.0 / 255.0, 234.0 / 255.0, 129.0 / 255.0, 0.7);//绿色 雨
    }
    else if (r <= 3.0) {
        color = vec4(49.0 / 255.0, 196.0 / 255.0, 245.0 / 255.0, 1.0);//浅蓝色 冻雨
    }
    else if (r <= 4.0) {
        color = vec4(214.0 / 255.0, 86.0 / 255.0, 240.0 / 255.0, 1.0);//粉色 混合冰
    }
    else if (r <= 5.0) {
        color = vec4(226.0 / 255.0, 225.0 / 255.0, 241.0 / 255.0, 1.0);//浅灰色 雪
    }
    else if (r <= 6.0) {
        color = vec4(161.0 / 255.0, 181.0 / 255.0, 230.0 / 255.0, 1.0);//深灰色 湿雪
    }
    else if (r <= 7.0) {
        color = vec4(135.0 / 255.0, 127.0 / 255.0, 245.0 / 255.0, 1.0);//深蓝色+蒙白色  雨夹雪
    }
    else if (r <= 8.0) {
        color = vec4(149.0 / 255.0, 39.0 / 255.0, 240.0 / 255.0, 1.0);//蓝粉 冰粒
    }
    else {
        color = vec4(138.0 / 255.0, 234.0 / 255.0, 129.0 / 255.0, 0.0);//深红色
    }
    return color;
}

float convertR(vec2 uv, sampler2D texture, float max, float min) {
    vec2 px = vec2(stand, stand);//(1/256, 1/256)
    vec2 uvt = uv * vec2(256.0, 256.0);//纹理坐标(0~1,0~1)*(256.0,256.0)
    vec2 vc = (floor(uvt)) * px;//floor(x)向下取整 纹理坐标*(256.0,256.0)*(1/256,1/256)
    vec2 f = fract(uvt);//fract(x) 返回x的小数部分  纹理坐标*(256.0,256.0)的小数部分

    //取四个点的值(当前点、右侧点、下侧点、右下侧点)，然后做插值(插值(插值(当前点，右侧点),插值(下侧点，右下侧点)))
    float tl = getRealValue(vc, texture, max, min);
    float tr = getRealValue(vc + vec2(px.x, 0), texture, max, min);
    float bl = getRealValue(vc + vec2(0, px.y), texture, max, min);
    //    vec2 vc = (uv * vec2(255.0, 255.0))/ vec2(257.0, 257.0);
    float br = getRealValue(vc + px, texture, max, min);
    //mix线性插值 dest=x*(1-level)+y*level 假设x=1,y=2,level=0.5，dest=1*0.5+2*0.5=1.5，level越大其结果越趋向于y
    return mix(mix(tl, tr, f.x), mix(bl, br, f.x), f.y);
}

float convertRForAllergy(vec2 uv, sampler2D texture, float max, float min) {
    vec2 px = vec2(stand, stand);//(1/256, 1/256)
    vec2 uvt = uv * vec2(256.0, 256.0);//纹理坐标(0~1,0~1)*(256.0,256.0)
    vec2 vc = (floor(uvt)) * px;//floor(x)向下取整 纹理坐标*(256.0,256.0)*(1/256,1/256)
    vec2 f = fract(uvt);//fract(x) 返回x的小数部分  纹理坐标*(256.0,256.0)的小数部分

    return getRealValue(vc,texture,max,min);
}

float getRealValue(vec2 uv, sampler2D u_screen, float max, float min) {
    vec4 color = texture(u_screen, uv);
    float r = color.r;//因为灰度图的rgb三个颜色分量相等，所以可以任意取出一个颜色通道的值作为灰度值，取值范围0~1
    float result = r * (max - min) + min;
    return result;
}