#version 300 es
/*利用变换反馈更新粒子位置*/

precision highp float;

uniform float uVisiblePixel[4];//可视屏幕范围对应的高德地图OpenGL绘制范围左下角、右上角坐标
uniform sampler2D sWind;// 合并后的风速纹理
uniform float uWindPixelRange[4];//风速纹理对应的高德地图OpenGL绘制坐标范围，也取左下角和右上角
uniform vec2 uScreenResXY;//屏幕分辨率
uniform float uRandomSeed;//随机数
uniform float uRandomSeed2;//随机数
uniform float uParticleLifeCount;//粒子最大生命值，渲染该次数后消失重绘

in vec2 aPosition;//输入粒子点位置
in float aParticleLife;//当前粒子的生命值

out vec2 vPosition;//输出粒子点位置
out float vParticleLife;

//从RGBA颜色中解码出两个风速浮点值
vec2 decodeFromColor(vec4 color) {
    vec2 ressult= (color.ga + color.rb / 255.5) * 200.0 - 100.0;
    return ressult;
}

vec2 oneValueFromWindTexture(vec2 pos) {
    vec4 windColor = texture(sWind, pos);
    vec2 wind = decodeFromColor(windColor);//U西风为正，V南风为正，即右上为正方向
    return wind;
}

void main() {
    vec2 lastPos = aPosition;
    //上次粒子位置对应的高德地图坐标
    vec2 aMapPixel = vec2(uVisiblePixel[0] + (uVisiblePixel[2] - uVisiblePixel[0]) * lastPos.x,
    uVisiblePixel[3] + (uVisiblePixel[1] - uVisiblePixel[3]) * (1.0 - lastPos.y));//纹理坐标和地图坐标Y轴相反

    //根据粒子所在的地图位置占整个纹理的比例，计算出在纹理(0~1)范围内的位置。左上角为原点
    vec2 windTexturePos = vec2((aMapPixel.x - uWindPixelRange[0]) / (uWindPixelRange[2] - uWindPixelRange[0]),
    (aMapPixel.y - uWindPixelRange[3]) / (uWindPixelRange[1] - uWindPixelRange[3]));

    //从风速合并纹理中取出实际风速，计算出变更距离
    vec2 wind = oneValueFromWindTexture(windTexturePos);

    float realSpeed = length(wind);//实际风速值

    float n = 0.05 / uScreenResXY.x;
    float o = 0.05 / uScreenResXY.y;
    vec4 pars1 = vec4(2.0 * n, 2.0 * o, -n, -o);
    vec2 dpos = wind.xy * pars1.xy + pars1.zw;//风速转换为移动距离

    if (aParticleLife >= uParticleLifeCount) {
        vPosition = vec2(fract(uRandomSeed * realSpeed * 100.0), fract(uRandomSeed2 * realSpeed * 100.0));
        vParticleLife = 0.0;
    } else {
        vPosition = aPosition + dpos;
        vParticleLife = aParticleLife + 1.0;
    }
    gl_Position = vec4(vPosition, 0.0, 1.0);
}
