/*global require:true*/
(function( exports ){
	"use strict";

	var fs = require( 'fs' );
	var Pfile = require( '..' + fs.separator + '..' + fs.separator + 'lib' + fs.separator + 'processing-file' );

	var bearSVG = '<svg xmlns="http://www.w3.org/2000/svg" width="100" height="62.905px">\n' +
'<path d="M11.068,34.558c-1.585-2.365-2.595-5.098-2.939-8.106c-0.344,0.092-0.666,0.161-1.033,0.161\n' +
'\tc-2.342,0-4.248-1.906-4.248-4.248c0-1.47,0.758-2.756,1.883-3.514l12.147-8.45c2.549-1.562,5.534-2.526,8.749-2.641l30.149,0.092\n' +
'\tL77.819,4.34c0-0.115,0-0.229,0-0.345C77.819,1.791,79.586,0,81.791,0c2.205,0,3.996,1.791,3.996,3.995\n' +
'\tc0,0.345-0.046,0.712-0.138,1.034l2.043,0.275c2.365,0.459,4.156,2.549,4.156,5.052c0,0.161,0,0.298-0.022,0.436l6.544,3.536\n' +
'\tc0.941,0.368,1.63,1.309,1.63,2.388c0,0.367-0.068,0.689-0.206,1.01l-1.631,3.697c-0.804,1.309-2.181,2.228-3.788,2.411\n' +
'\tl-15.041,1.791L65.787,41.527l7.738,13.363l5.098,2.365c0.803,0.552,1.354,1.493,1.354,2.549c0,1.699-1.378,3.078-3.101,3.078\n' +
'\tl-9.805,0.022c-2.525,0-4.707-1.424-5.809-3.49l-8.382-15.155l-18.92,0.023l6.682,10.287l4.937,2.25\n' +
'\tc0.919,0.551,1.516,1.538,1.516,2.664c0,1.699-1.378,3.076-3.077,3.076l-9.828,0.023c-2.388,0-4.5-1.286-5.649-3.215l-9.208-14.627\n' +
'\tl-6.429,6.246l-0.528,4.087l2.158,1.423c0.368,0.184,0.689,0.438,0.965,0.758c1.056,1.332,0.872,3.284-0.459,4.34\n' +
'\tc-0.574,0.482-1.286,0.713-1.975,0.689l-4.317,0.023c-1.194-0.139-2.273-0.758-2.962-1.677l-5.029-8.68C0.275,51.033,0,50,0,48.898\n' +
'\tc0-1.676,0.62-3.215,1.676-4.387L11.068,34.558z"/>\n' +
'</svg>\n';

	exports.constructor = {
		setup: function(){
			this.pfile = new Pfile( fs.workingDirectory + fs.separator + "test" + fs.separator + "files" + fs.separator + "bear.svg" );
		},
		teardown: function( done ){
			done();
		},
		'constructor': function( test ){
			test.equal( this.pfile.filename, "bear.svg", "The file should be named bear.svg" );
			test.equal( this.pfile.pathdir, fs.workingDirectory + fs.separator + "test" + fs.separator + "files", "The pathdir isn't correct" );
			test.equal( this.pfile.filenamenoext, "bear", "The filenamenoext should be bear" );
		},
		'setImageData': function( test ){
			this.pfile.setImageData();
			test.equal( this.pfile.imagedata, bearSVG );
		}

	};

}(typeof exports === 'object' && exports || this));
