'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = parseAttrs;

var _objectAssign = require('object-assign');

var _objectAssign2 = _interopRequireDefault(_objectAssign);

var _parseRules = require('./parseRules');

var _parseRules2 = _interopRequireDefault(_parseRules);

var _attr = require('./attr');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function parseAttrs() {
    var posthtmlAttrs = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];
    var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

    var parseRules = (0, _objectAssign2.default)({}, _parseRules2.default, options.rules || {});
    var attrs = {};
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
        for (var _iterator = Object.keys(posthtmlAttrs)[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            var attrName = _step.value;

            attrs[attrName] = (0, _attr.parseAttr)(posthtmlAttrs[attrName], parseRules[attrName]);
        }
    } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
    } finally {
        try {
            if (!_iteratorNormalCompletion && _iterator.return) {
                _iterator.return();
            }
        } finally {
            if (_didIteratorError) {
                throw _iteratorError;
            }
        }
    }

    attrs.compose = function () {
        return composeAttrs(this, parseRules);
    };

    return attrs;
}

function composeAttrs(attrs, parseRules) {
    delete attrs.compose;

    var posthtmlAttrs = {};
    var _iteratorNormalCompletion2 = true;
    var _didIteratorError2 = false;
    var _iteratorError2 = undefined;

    try {
        for (var _iterator2 = Object.keys(attrs)[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
            var attrName = _step2.value;

            posthtmlAttrs[attrName] = (0, _attr.stringifyAttr)(attrs[attrName], parseRules[attrName]);
        }
    } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
    } finally {
        try {
            if (!_iteratorNormalCompletion2 && _iterator2.return) {
                _iterator2.return();
            }
        } finally {
            if (_didIteratorError2) {
                throw _iteratorError2;
            }
        }
    }

    return posthtmlAttrs;
}