# object.reduce [![NPM version](https://badge.fury.io/js/object.reduce.svg)](http://badge.fury.io/js/object.reduce)

> Reduces an object to a value that is the accumulated result of running each property in the object through a callback.

Executes the callback function once for each own enumerable property in the object, receiving four arguments: the initial value (or value from the previous callback call), the `value` of the current property, the `key` of the current property, and the `object` over which the function is iterating. Node.js/JavaScript utility.

## Install with [npm](npmjs.org)

```bash
npm i object.reduce --save
```
## Install with [bower](https://github.com/bower/bower)

```bash
bower install object.reduce --save
```

## Usage

A callback function is executed once for each own enumerable property in the object, receiving four arguments:

  - `acc`: the initial value (or value from the previous callback call),
  - `value`: the of the current property,
  - `key`: the of the current property, and
  - the original `object` over which the function is iterating.

**Example**

```js
var reduce = require('object.reduce');
var a = {a: 'foo', b: 'bar', c: 'baz'};

reduce(a, function (acc, value, key, obj) {
  acc[key] = value.toUpperCase();
  return acc;
}, {});

//=> {a: 'FOO', b: 'BAR', c: 'BAZ'};
```

## Related projects

* [object.defaults](https://github.com/jonschlinkert/object.defaults): Like `extend` but only copies missing properties/values to the target… [more](https://github.com/jonschlinkert/object.defaults)
* [object.filter](https://github.com/jonschlinkert/object.filter): Create a new object filtered to have only properties for… [more](https://github.com/jonschlinkert/object.filter)
* [object.omit](https://github.com/jonschlinkert/object.omit): Return a copy of an object without the given key,… [more](https://github.com/jonschlinkert/object.omit)
* [object.pick](https://github.com/jonschlinkert/object.pick): Returns a filtered copy of an object with only the… [more](https://github.com/jonschlinkert/object.pick)

## Running tests

Install dev dependencies:

```bash
npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/object.reduce/issues)

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright (c) 2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on April 25, 2015._

<!-- reflinks generated by verb-reflinks plugin -->

[verb]: https://github.com/assemble/verb
[template]: https://github.com/jonschlinkert/template
[assemble]: http://assemble.io