# collection-map [![NPM version](https://badge.fury.io/js/collection-map.svg)](http://badge.fury.io/js/collection-map)

> Returns an array of mapped values from an array or object.

## Install

Install with [npm](https://www.npmjs.com/)

```sh
$ npm i collection-map --save
```

## Usage

```js
var map = require('collection-map');
```

### objects

**map object values**

```js
var obj = {a: 'foo', b: 'bar', c: 'baz'};
var res = map(obj, function(item, i, arr) {
  return item;
});

// res => ['foo', 'bar', 'baz']
```

**index is exposed as the second param**

```js
var res = map(obj, function(item, i, arr) {
  return i;
});

// res => [0, 1, 2]
```

### arrays

**map array values**

```js
var arr = ['foo', 'bar', 'baz'];
var res = map(arr, function(item, i, arr) {
  return item;
});

// res => ['foo', 'bar', 'baz']
```

**index is exposed as the second param**

```js
var arr = ['foo', 'bar', 'baz'];
var res = map(arr, function(item, i, arr) {
  return i;
});

// res => [0, 1, 2]
```

### strings

**works with strings**

```js
var obj = {
  a: {aaa: 'one', bbb: 'four', ccc: 'seven'},
  b: {aaa: 'two', bbb: 'five', ccc: 'eight'},
  c: {aaa: 'three', bbb: 'six', ccc: 'nine'}
};

var arr = [obj.a, obj.b, obj.c];

var res = map(obj, 'aaa');
// res => ['one', 'two', 'three']

var res = map(arr, 'bbb');
// res => ['four', 'five', 'six']
```

### this

**exposes the third argument as `this`**

```js
var arr = ['a', 'b', 'c'];
var ctx = {a: 'aaa', b: 'bbb', c: 'ccc'};

var res = map(arr, function(item, i, arr) {
  return this[item];
}, ctx);

// res => ['aaa', 'bbb', 'ccc']
```

## Related projects

* [arr-map](https://github.com/jonschlinkert/arr-map): Faster, node.js focused alternative to JavaScript's native array map.
* [get-values](https://github.com/jonschlinkert/get-values): Return an array of all values from the given object.
* [is-plain-object](https://github.com/jonschlinkert/is-plain-object): Returns true if an object was created by the `Object` constructor.
* [make-iterator](https://github.com/jonschlinkert/make-iterator): Convert an argument into a valid iterator. Based on the `.makeIterator()` implementation in mout https://github.com/mout/mout.

## Running tests

Install dev dependencies:

```sh
$ npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/collection-map/issues/new)

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on June 07, 2015._
