package com.nibiru.lib.controller;

import com.nibiru.lib.controller.IBluexListener;
import com.nibiru.lib.BTDevice;
import com.nibiru.lib.controller.ControllerServiceState;
import com.nibiru.lib.controller.StickEvent;
import com.nibiru.lib.controller.GyroEvent;
import com.nibiru.lib.controller.AccEvent;
import com.nibiru.lib.controller.NibiruInputEvent;

interface IBluexService{
void registerListener(IBluexListener listener);
void unregisterListener(IBluexListener listener);

boolean connectController(in BTDevice device);
boolean disconnectController(in BTDevice device);

BTDevice[] getDeviceList();
BTDevice getDeviceByPlayerOrder(int player);

void requestErrorReport(int type);

void setPlayerOrder(int oldone, int newone);

void resetCurrentApp();

void configure(int config);

int[] getDeviceKeyMap(in int deviceId);

void updateDeviceInfo(in BTDevice device);

void deleteDevice(in String addr);

ControllerServiceState getServiceState();

void setNibiruPlayer(in boolean isEnabled);

void controllMotor(int playerOrder, int pos, int operate);

void setSystemCursorMode(boolean isCursor);

int[] getKeyStateMap(int player);

int getKeyState(int player, int keycode);

float getStickState(int player, int axis);

StickEvent getStickState2(int player);

int getServiceVersion();

boolean sendInputEvent(in NibiruInputEvent event);

boolean enableGlobalControll(boolean enable, String packageName);

void switchMod(int player, int targetOrder);

boolean startInputView(String inputStr, String currentText, int type, int maxLen);

void hideInputView();

int getKeyState2(int player);

GyroEvent getGyroEvent(int player);

AccEvent getAccEvent(int player);

void setMouseSpeed(int speed);

int getMouseSpeed();

boolean isSupportInput();

int getClassVersion();

boolean sendVirtualData(in byte[] data);

void startVirtualService(int type);

void stopVietualService(int type);

void connectVirutalService(String addr, int type);

void disconnectVirtualService(int type);

boolean isInputViewShow();

String getServiceToken();

int openDeviceManagerUI(in Bundle bundle);

boolean handleExternalInput(in NibiruInputEvent event, String token, int cursorMode, int currentState);

void setCursorState(String token, boolean isShow, int state);

boolean controllMotor2(int playerOrder, int pos, int operate, long duration);

void setNibiruIMEShow(boolean isShow);

void notifyNibiruInput(String content,int resCode);

byte[] getDeviceDescriptor(int player);

boolean isSDKClient(String packageName);

void sendCtrlCmd(in Bundle cmd);

void updateSdkState(in Bundle state);

Bundle[] getServiceState2(int cmd, in Bundle para);

int isSupportExternalEvent();

boolean handleExternalInput2(in Bundle event, in Bundle sdkState);

int hasDeviceConnected();

int isSupportSdk(int sdkversion);


}