
--------------------------------
-- @module RichElementText
-- @extend RichElement
-- @parent_module ccui

--------------------------------
-- brief Initialize a RichElementText with various arguments.<br>
-- param tag A integer tag value.<br>
-- param color A color in Color3B.<br>
-- param opacity A opacity in GLubyte.<br>
-- param text Content string.<br>
-- param fontName Content font name.<br>
-- param fontSize Content font size.<br>
-- param flags italics, bold, underline, strikethrough, url, outline, shadow or glow<br>
-- param url uniform resource locator<br>
-- param outlineColor the color of the outline<br>
-- param outlineSize the outline effect size value<br>
-- param shadowColor the shadow effect color value<br>
-- param shadowOffset shadow effect offset value<br>
-- param shadowBlurRadius the shadow effect blur radius<br>
-- param glowColor glow color<br>
-- return True if initialize success, false otherwise.
-- @function [parent=#RichElementText] init 
-- @param self
-- @param #int tag
-- @param #color3b_table color
-- @param #unsigned char opacity
-- @param #string text
-- @param #string fontName
-- @param #float fontSize
-- @param #unsigned int flags
-- @param #string url
-- @param #color3b_table outlineColor
-- @param #int outlineSize
-- @param #color3b_table shadowColor
-- @param #size_table shadowOffset
-- @param #int shadowBlurRadius
-- @param #color3b_table glowColor
-- @return bool#bool ret (return value: bool)
        
--------------------------------
-- brief Create a RichElementText with various arguments.<br>
-- param tag A integer tag value.<br>
-- param color A color in Color3B.<br>
-- param opacity A opacity in GLubyte.<br>
-- param text Content string.<br>
-- param fontName Content font name.<br>
-- param fontSize Content font size.<br>
-- param flags italics, bold, underline, strikethrough, url, outline, shadow or glow<br>
-- param url uniform resource locator<br>
-- param outlineColor the color of the outline<br>
-- param outlineSize the outline effect size value<br>
-- param shadowColor the shadow effect color value<br>
-- param shadowOffset shadow effect offset value<br>
-- param shadowBlurRadius the shadow effect blur radius<br>
-- param glowColor glow color<br>
-- return RichElementText instance.
-- @function [parent=#RichElementText] create 
-- @param self
-- @param #int tag
-- @param #color3b_table color
-- @param #unsigned char opacity
-- @param #string text
-- @param #string fontName
-- @param #float fontSize
-- @param #unsigned int flags
-- @param #string url
-- @param #color3b_table outlineColor
-- @param #int outlineSize
-- @param #color3b_table shadowColor
-- @param #size_table shadowOffset
-- @param #int shadowBlurRadius
-- @param #color3b_table glowColor
-- @return RichElementText#RichElementText ret (return value: ccui.RichElementText)
        
--------------------------------
-- brief Default constructor.<br>
-- js ctor<br>
-- lua new
-- @function [parent=#RichElementText] RichElementText 
-- @param self
-- @return RichElementText#RichElementText self (return value: ccui.RichElementText)
        
return nil
