
--------------------------------
-- @module Properties
-- @parent_module cc

--------------------------------
-- Returns the value of a variable that is set in this Properties object.<br>
-- Variables take on the format ${name} and are inherited from parent Property objects.<br>
-- param name Name of the variable to get.<br>
-- param defaultValue Value to return if the variable is not found.<br>
-- return The value of the specified variable, or defaultValue if not found.
-- @function [parent=#Properties] getVariable 
-- @param self
-- @param #char name
-- @param #char defaultValue
-- @return char#char ret (return value: char)
        
--------------------------------
-- Get the value of the given property as a string. This can always be retrieved,<br>
-- whatever the intended type of the property.<br>
-- param name The name of the property to interpret, or NULL to return the current property's value.<br>
-- param defaultValue The default value to return if the specified property does not exist.<br>
-- return The value of the given property as a string, or the empty string if no property with that name exists.
-- @function [parent=#Properties] getString 
-- @param self
-- @return char#char ret (return value: char)
        
--------------------------------
-- Interpret the value of the given property as a long integer.<br>
-- If the property does not exist, zero will be returned.<br>
-- If the property exists but could not be scanned, an error will be logged and zero will be returned.<br>
-- param name The name of the property to interpret, or NULL to return the current property's value.<br>
-- return The value of the given property interpreted as a long.<br>
-- Zero if the property does not exist or could not be scanned.
-- @function [parent=#Properties] getLong 
-- @param self
-- @return long#long ret (return value: long)
        
--------------------------------
-- @overload self         
-- @overload self, char, bool, bool         
-- @function [parent=#Properties] getNamespace
-- @param self
-- @param #char id
-- @param #bool searchNames
-- @param #bool recurse
-- @return Properties#Properties ret (return value: cc.Properties)

--------------------------------
-- Gets the file path for the given property if the file exists.<br>
-- This method will first search for the file relative to the working directory.<br>
-- If the file is not found then it will search relative to the directory the bundle file is in.<br>
-- param name The name of the property.<br>
-- param path The string to copy the path to if the file exists.<br>
-- return True if the property exists and the file exists, false otherwise.<br>
-- script{ignore}
-- @function [parent=#Properties] getPath 
-- @param self
-- @param #char name
-- @param #string path
-- @return bool#bool ret (return value: bool)
        
--------------------------------
-- Interpret the value of the given property as a Matrix.<br>
-- If the property does not exist, out will be set to the identity matrix.<br>
-- If the property exists but could not be scanned, an error will be logged and out will be set<br>
-- to the identity matrix.<br>
-- param name The name of the property to interpret, or NULL to return the current property's value.<br>
-- param out The matrix to set to this property's interpreted value.<br>
-- return True on success, false if the property does not exist or could not be scanned.
-- @function [parent=#Properties] getMat4 
-- @param self
-- @param #char name
-- @param #mat4_table out
-- @return bool#bool ret (return value: bool)
        
--------------------------------
-- Check if a property with the given name is specified in this Properties object.<br>
-- param name The name of the property to query.<br>
-- return True if the property exists, false otherwise.
-- @function [parent=#Properties] exists 
-- @param self
-- @param #char name
-- @return bool#bool ret (return value: bool)
        
--------------------------------
-- Sets the value of the property with the specified name.<br>
-- If there is no property in this namespace with the current name,<br>
-- one is added. Otherwise, the value of the first property with the<br>
-- specified name is updated.<br>
-- If name is NULL, the value current property (see getNextProperty) is<br>
-- set, unless there is no current property, in which case false<br>
-- is returned.<br>
-- param name The name of the property to set.<br>
-- param value The property value.<br>
-- return True if the property was set, false otherwise.
-- @function [parent=#Properties] setString 
-- @param self
-- @param #char name
-- @param #char value
-- @return bool#bool ret (return value: bool)
        
--------------------------------
-- Get the ID of this Property's namespace. The ID should be a unique identifier,<br>
-- but its uniqueness is not enforced.<br>
-- return The ID of this Property's namespace.
-- @function [parent=#Properties] getId 
-- @param self
-- @return char#char ret (return value: char)
        
--------------------------------
-- Rewind the getNextProperty() and getNextNamespace() iterators<br>
-- to the beginning of the file.
-- @function [parent=#Properties] rewind 
-- @param self
-- @return Properties#Properties self (return value: cc.Properties)
        
--------------------------------
-- Sets the value of the specified variable.<br>
-- param name Name of the variable to set.<br>
-- param value The value to set.
-- @function [parent=#Properties] setVariable 
-- @param self
-- @param #char name
-- @param #char value
-- @return Properties#Properties self (return value: cc.Properties)
        
--------------------------------
-- Interpret the value of the given property as a boolean.<br>
-- param name The name of the property to interpret, or NULL to return the current property's value.<br>
-- param defaultValue the default value to return if the specified property does not exist within the properties file.<br>
-- return true if the property exists and its value is "true", otherwise false.
-- @function [parent=#Properties] getBool 
-- @param self
-- @return bool#bool ret (return value: bool)
        
--------------------------------
-- @overload self, char, vec4_table         
-- @overload self, char, vec3_table         
-- @function [parent=#Properties] getColor
-- @param self
-- @param #char name
-- @param #vec3_table out
-- @return bool#bool ret (return value: bool)

--------------------------------
-- Returns the type of a property.<br>
-- param name The name of the property to interpret, or NULL to return the current property's type.<br>
-- return The type of the property.
-- @function [parent=#Properties] getType 
-- @param self
-- @return int#int ret (return value: int)
        
--------------------------------
-- Get the next namespace.
-- @function [parent=#Properties] getNextNamespace 
-- @param self
-- @return Properties#Properties ret (return value: cc.Properties)
        
--------------------------------
-- Interpret the value of the given property as an integer.<br>
-- If the property does not exist, zero will be returned.<br>
-- If the property exists but could not be scanned, an error will be logged and zero will be returned.<br>
-- param name The name of the property to interpret, or NULL to return the current property's value.<br>
-- return The value of the given property interpreted as an integer.<br>
-- Zero if the property does not exist or could not be scanned.
-- @function [parent=#Properties] getInt 
-- @param self
-- @return int#int ret (return value: int)
        
--------------------------------
-- Interpret the value of the given property as a Vector3.<br>
-- If the property does not exist, out will be set to Vector3(0.0f, 0.0f, 0.0f).<br>
-- If the property exists but could not be scanned, an error will be logged and out will be set<br>
-- to Vector3(0.0f, 0.0f, 0.0f).<br>
-- param name The name of the property to interpret, or NULL to return the current property's value.<br>
-- param out The vector to set to this property's interpreted value.<br>
-- return True on success, false if the property does not exist or could not be scanned.
-- @function [parent=#Properties] getVec3 
-- @param self
-- @param #char name
-- @param #vec3_table out
-- @return bool#bool ret (return value: bool)
        
--------------------------------
-- Interpret the value of the given property as a Vector2.<br>
-- If the property does not exist, out will be set to Vector2(0.0f, 0.0f).<br>
-- If the property exists but could not be scanned, an error will be logged and out will be set<br>
-- to Vector2(0.0f, 0.0f).<br>
-- param name The name of the property to interpret, or NULL to return the current property's value.<br>
-- param out The vector to set to this property's interpreted value.<br>
-- return True on success, false if the property does not exist or could not be scanned.
-- @function [parent=#Properties] getVec2 
-- @param self
-- @param #char name
-- @param #vec2_table out
-- @return bool#bool ret (return value: bool)
        
--------------------------------
-- Interpret the value of the given property as a Vector4.<br>
-- If the property does not exist, out will be set to Vector4(0.0f, 0.0f, 0.0f, 0.0f).<br>
-- If the property exists but could not be scanned, an error will be logged and out will be set<br>
-- to Vector4(0.0f, 0.0f, 0.0f, 0.0f).<br>
-- param name The name of the property to interpret, or NULL to return the current property's value.<br>
-- param out The vector to set to this property's interpreted value.<br>
-- return True on success, false if the property does not exist or could not be scanned.
-- @function [parent=#Properties] getVec4 
-- @param self
-- @param #char name
-- @param #vec4_table out
-- @return bool#bool ret (return value: bool)
        
--------------------------------
-- Get the name of the next property.<br>
-- If a valid next property is returned, the value of the property can be<br>
-- retrieved using any of the get methods in this class, passing NULL for the property name.<br>
-- return The name of the next property, or NULL if there are no properties remaining.
-- @function [parent=#Properties] getNextProperty 
-- @param self
-- @return char#char ret (return value: char)
        
--------------------------------
-- Interpret the value of the given property as a floating-point number.<br>
-- If the property does not exist, zero will be returned.<br>
-- If the property exists but could not be scanned, an error will be logged and zero will be returned.<br>
-- param name The name of the property to interpret, or NULL to return the current property's value.<br>
-- return The value of the given property interpreted as a float.<br>
-- Zero if the property does not exist or could not be scanned.
-- @function [parent=#Properties] getFloat 
-- @param self
-- @return float#float ret (return value: float)
        
--------------------------------
-- Interpret the value of the given property as a Quaternion specified as an axis angle.<br>
-- If the property does not exist, out will be set to Quaternion().<br>
-- If the property exists but could not be scanned, an error will be logged and out will be set<br>
-- to Quaternion().<br>
-- param name The name of the property to interpret, or NULL to return the current property's value.<br>
-- param out The quaternion to set to this property's interpreted value.<br>
-- return True on success, false if the property does not exist or could not be scanned.
-- @function [parent=#Properties] getQuaternionFromAxisAngle 
-- @param self
-- @param #char name
-- @param #cc.Quaternion out
-- @return bool#bool ret (return value: bool)
        
--------------------------------
-- @overload self, char, vec4_table         
-- @overload self, char, vec3_table         
-- @function [parent=#Properties] parseColor
-- @param self
-- @param #char str
-- @param #vec3_table out
-- @return bool#bool ret (return value: bool)

--------------------------------
-- Attempts to parse the specified string as a Vector3 value.<br>
-- On error, false is returned and the output is set to all zero values.<br>
-- param str The string to parse.<br>
-- param out The value to populate if successful.<br>
-- return True if a valid Vector3 was parsed, false otherwise.
-- @function [parent=#Properties] parseVec3 
-- @param self
-- @param #char str
-- @param #vec3_table out
-- @return bool#bool ret (return value: bool)
        
--------------------------------
-- Attempts to parse the specified string as an axis-angle value.<br>
-- The specified string is expected to contain four comma-separated<br>
-- values, where the first three values represents the axis and the<br>
-- fourth value represents the angle, in degrees.<br>
-- On error, false is returned and the output is set to all zero values.<br>
-- param str The string to parse.<br>
-- param out A Quaternion populated with the orientation of the axis-angle, if successful.<br>
-- return True if a valid axis-angle was parsed, false otherwise.
-- @function [parent=#Properties] parseAxisAngle 
-- @param self
-- @param #char str
-- @param #cc.Quaternion out
-- @return bool#bool ret (return value: bool)
        
--------------------------------
-- Attempts to parse the specified string as a Vector2 value.<br>
-- On error, false is returned and the output is set to all zero values.<br>
-- param str The string to parse.<br>
-- param out The value to populate if successful.<br>
-- return True if a valid Vector2 was parsed, false otherwise.
-- @function [parent=#Properties] parseVec2 
-- @param self
-- @param #char str
-- @param #vec2_table out
-- @return bool#bool ret (return value: bool)
        
--------------------------------
-- Attempts to parse the specified string as a Vector4 value.<br>
-- On error, false is returned and the output is set to all zero values.<br>
-- param str The string to parse.<br>
-- param out The value to populate if successful.<br>
-- return True if a valid Vector4 was parsed, false otherwise.
-- @function [parent=#Properties] parseVec4 
-- @param self
-- @param #char str
-- @param #vec4_table out
-- @return bool#bool ret (return value: bool)
        
return nil
