/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.org.apache.avro.reflect;

import com.flurry.org.apache.avro.Schema;
import com.flurry.org.apache.avro.io.Encoder;
import com.flurry.org.apache.avro.reflect.ReflectData;
import com.flurry.org.apache.avro.specific.SpecificDatumWriter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public class ReflectDatumWriter<T>
extends SpecificDatumWriter<T> {
    public ReflectDatumWriter() {
        this(ReflectData.get());
    }

    public ReflectDatumWriter(Class<T> c2) {
        this(c2, ReflectData.get());
    }

    public ReflectDatumWriter(Class<T> c2, ReflectData data) {
        this(data.getSchema(c2), data);
    }

    public ReflectDatumWriter(Schema root) {
        this(root, ReflectData.get());
    }

    protected ReflectDatumWriter(Schema root, ReflectData reflectData) {
        super(root, reflectData);
    }

    protected ReflectDatumWriter(ReflectData reflectData) {
        super(reflectData);
    }

    @Override
    protected long getArraySize(Object array) {
        if (array instanceof Collection) {
            return ((Collection)array).size();
        }
        return Array.getLength(array);
    }

    @Override
    protected Iterator<Object> getArrayElements(final Object array) {
        if (array instanceof Collection) {
            return ((Collection)array).iterator();
        }
        return new Iterator<Object>(){
            private int i = 0;
            private final int length = Array.getLength(array);

            @Override
            public boolean hasNext() {
                return this.i < this.length;
            }

            @Override
            public Object next() {
                return Array.get(array, this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    protected void writeString(Schema schema, Object datum, Encoder out) throws IOException {
        if (schema.getProp("java-class") != null) {
            datum = datum.toString();
        }
        this.writeString(datum, out);
    }

    @Override
    protected void writeBytes(Object datum, Encoder out) throws IOException {
        if (datum instanceof byte[]) {
            out.writeBytes((byte[])datum);
        } else {
            super.writeBytes(datum, out);
        }
    }

    @Override
    protected void write(Schema schema, Object datum, Encoder out) throws IOException {
        if (datum instanceof Byte) {
            datum = ((Byte)datum).intValue();
        } else if (datum instanceof Short) {
            datum = ((Short)datum).intValue();
        }
        try {
            super.write(schema, datum, out);
        }
        catch (NullPointerException e2) {
            NullPointerException result = new NullPointerException("in " + schema.getFullName() + " " + e2.getMessage());
            result.initCause(e2.getCause() == null ? e2 : e2.getCause());
            throw result;
        }
    }
}

