/*
 * Decompiled with CFR 0.152.
 */
package com.flurry.android;

import android.content.Context;
import android.os.Looper;
import android.text.TextUtils;
import com.flurry.android.an;
import com.flurry.android.cy;
import com.flurry.android.fl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.UUID;

public class FlurryDataSenderBlockInfo {
    private String gh = null;
    private long gi = -1L;
    private int gj = -1;
    private File au = null;

    public FlurryDataSenderBlockInfo(Context context) {
        this.gh = UUID.randomUUID().toString();
        this.au = context.getFileStreamPath(".flurrydatasenderblock." + this.gh);
    }

    public FlurryDataSenderBlockInfo(Context context, String string) {
        this.gh = string;
        this.au = context.getFileStreamPath(".flurrydatasenderblock." + this.gh);
    }

    public String getIdentifier() {
        return this.gh;
    }

    public long getCreationDate() {
        return this.gi;
    }

    public int getDataSize() {
        return this.gj;
    }

    public boolean setData(byte[] byArray) {
        boolean bl2;
        block8: {
            DataOutputStream dataOutputStream;
            block7: {
                if (Looper.myLooper() == Looper.getMainLooper()) {
                    cy.d("FlurryDataSenderBlockInfo", "setData(byte[]) running on the MAIN thread!");
                }
                bl2 = false;
                cy.e("FlurryDataSenderBlockInfo", "Writing FlurryDataSenderBlockInfo: " + this.au.getAbsolutePath());
                Object var3_4 = null;
                dataOutputStream = null;
                boolean bl3 = false;
                if (an.a(this.au)) break block7;
                fl.a(null);
                return false;
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.au);
                dataOutputStream = new DataOutputStream(fileOutputStream);
                int n2 = byArray.length;
                dataOutputStream.writeShort(n2);
                dataOutputStream.write(byArray);
                dataOutputStream.writeShort(0);
                bl2 = true;
                this.gj = n2;
                this.gi = System.currentTimeMillis();
            }
            catch (Throwable throwable) {
                try {
                    cy.b("FlurryDataSenderBlockInfo", "", throwable);
                    break block8;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    fl.a(dataOutputStream);
                }
            }
            fl.a(dataOutputStream);
        }
        return bl2;
    }

    public byte[] getData() {
        byte[] byArray;
        block8: {
            block9: {
                int n2;
                DataInputStream dataInputStream;
                block7: {
                    if (Looper.myLooper() == Looper.getMainLooper()) {
                        cy.d("FlurryDataSenderBlockInfo", "getData() running on the MAIN thread!");
                    }
                    byArray = null;
                    if (!this.au.exists()) break block9;
                    cy.e("FlurryDataSenderBlockInfo", "Reading FlurryDataSenderBlockInfo: " + this.au.getAbsolutePath());
                    FileInputStream fileInputStream = null;
                    dataInputStream = null;
                    fileInputStream = new FileInputStream(this.au);
                    dataInputStream = new DataInputStream(fileInputStream);
                    n2 = dataInputStream.readUnsignedShort();
                    if (n2 != 0) break block7;
                    fl.a(dataInputStream);
                    return null;
                }
                try {
                    byArray = new byte[n2];
                    dataInputStream.readFully(byArray);
                    dataInputStream.readUnsignedShort();
                }
                catch (Throwable throwable) {
                    try {
                        cy.b("FlurryDataSenderBlockInfo", "Error when loading persistent file", throwable);
                        break block8;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        fl.a(dataInputStream);
                    }
                }
                fl.a(dataInputStream);
                break block8;
            }
            cy.e("FlurryDataSenderBlockInfo", "Agent cache file doesn't exist.");
        }
        return byArray;
    }

    public boolean exists() {
        if (TextUtils.isEmpty((CharSequence)this.gh)) {
            return false;
        }
        return this.au != null && this.au.exists();
    }

    public boolean deletePersistentData() {
        if (this.au.exists()) {
            if (this.au.delete()) {
                cy.c("FlurryDataSenderBlockInfo", "Deleted persistence file");
                this.gi = -1L;
                this.gj = -1;
                return true;
            }
            cy.d("FlurryDataSenderBlockInfo", "Cannot delete persistence file");
        }
        return false;
    }
}

