/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.location.Location;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ListView;
import com.facebook.AppEventsLogger;
import com.facebook.FacebookException;
import com.facebook.LoggingBehavior;
import com.facebook.Request;
import com.facebook.Session;
import com.facebook.android.R;
import com.facebook.internal.Logger;
import com.facebook.internal.Utility;
import com.facebook.model.GraphPlace;
import com.facebook.widget.GraphObjectAdapter;
import com.facebook.widget.GraphObjectPagingLoader;
import com.facebook.widget.PickerFragment;
import com.facebook.widget.SimpleGraphObjectCursor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class PlacePickerFragment
extends PickerFragment<GraphPlace> {
    public static final String RADIUS_IN_METERS_BUNDLE_KEY = "com.facebook.widget.PlacePickerFragment.RadiusInMeters";
    public static final String RESULTS_LIMIT_BUNDLE_KEY = "com.facebook.widget.PlacePickerFragment.ResultsLimit";
    public static final String SEARCH_TEXT_BUNDLE_KEY = "com.facebook.widget.PlacePickerFragment.SearchText";
    public static final String LOCATION_BUNDLE_KEY = "com.facebook.widget.PlacePickerFragment.Location";
    public static final String SHOW_SEARCH_BOX_BUNDLE_KEY = "com.facebook.widget.PlacePickerFragment.ShowSearchBox";
    public static final int DEFAULT_RADIUS_IN_METERS = 1000;
    public static final int DEFAULT_RESULTS_LIMIT = 100;
    private static final int searchTextTimerDelayInMilliseconds = 2000;
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String LOCATION = "location";
    private static final String CATEGORY = "category";
    private static final String WERE_HERE_COUNT = "were_here_count";
    private static final String TAG = "PlacePickerFragment";
    private Location location;
    private int radiusInMeters = 1000;
    private int resultsLimit = 100;
    private String searchText;
    private Timer searchTextTimer;
    private boolean hasSearchTextChangedSinceLastQuery;
    private boolean showSearchBox = true;
    private EditText searchBox;

    public PlacePickerFragment() {
        this(null);
    }

    public PlacePickerFragment(Bundle args) {
        super(GraphPlace.class, R.layout.com_facebook_placepickerfragment, args);
        this.setPlacePickerSettingsFromBundle(args);
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public int getRadiusInMeters() {
        return this.radiusInMeters;
    }

    public void setRadiusInMeters(int radiusInMeters) {
        this.radiusInMeters = radiusInMeters;
    }

    public int getResultsLimit() {
        return this.resultsLimit;
    }

    public void setResultsLimit(int resultsLimit) {
        this.resultsLimit = resultsLimit;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        if (TextUtils.isEmpty((CharSequence)searchText)) {
            searchText = null;
        }
        this.searchText = searchText;
        if (this.searchBox != null) {
            this.searchBox.setText((CharSequence)searchText);
        }
    }

    public void onSearchBoxTextChanged(String searchText, boolean forceReloadEventIfSameText) {
        if (!forceReloadEventIfSameText && Utility.stringsEqualOrEmpty(this.searchText, searchText)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)searchText)) {
            searchText = null;
        }
        this.searchText = searchText;
        this.hasSearchTextChangedSinceLastQuery = true;
        if (this.searchTextTimer == null) {
            this.searchTextTimer = this.createSearchTextTimer();
        }
    }

    public GraphPlace getSelection() {
        List selection = this.getSelectedGraphObjects();
        return selection != null && !selection.isEmpty() ? (GraphPlace)selection.iterator().next() : null;
    }

    @Override
    public void setSettingsFromBundle(Bundle inState) {
        super.setSettingsFromBundle(inState);
        this.setPlacePickerSettingsFromBundle(inState);
    }

    @Override
    public void onInflate(Activity activity, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(activity, attrs, savedInstanceState);
        TypedArray a = activity.obtainStyledAttributes(attrs, R.styleable.com_facebook_place_picker_fragment);
        this.setRadiusInMeters(a.getInt(0, this.radiusInMeters));
        this.setResultsLimit(a.getInt(1, this.resultsLimit));
        if (a.hasValue(1)) {
            this.setSearchText(a.getString(2));
        }
        this.showSearchBox = a.getBoolean(3, this.showSearchBox);
        a.recycle();
    }

    @Override
    void setupViews(ViewGroup view) {
        if (this.showSearchBox) {
            ListView listView = (ListView)view.findViewById(R.id.com_facebook_picker_list_view);
            View searchHeaderView = this.getActivity().getLayoutInflater().inflate(R.layout.com_facebook_picker_search_box, (ViewGroup)listView, false);
            listView.addHeaderView(searchHeaderView, null, false);
            this.searchBox = (EditText)view.findViewById(R.id.com_facebook_picker_search_text);
            this.searchBox.addTextChangedListener((TextWatcher)new SearchTextWatcher());
            if (!TextUtils.isEmpty((CharSequence)this.searchText)) {
                this.searchBox.setText((CharSequence)this.searchText);
            }
        }
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (this.searchBox != null) {
            InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
            imm.showSoftInput((View)this.searchBox, 1);
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();
        if (this.searchBox != null) {
            InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
            imm.hideSoftInputFromWindow(this.searchBox.getWindowToken(), 0);
        }
    }

    @Override
    void saveSettingsToBundle(Bundle outState) {
        super.saveSettingsToBundle(outState);
        outState.putInt(RADIUS_IN_METERS_BUNDLE_KEY, this.radiusInMeters);
        outState.putInt(RESULTS_LIMIT_BUNDLE_KEY, this.resultsLimit);
        outState.putString(SEARCH_TEXT_BUNDLE_KEY, this.searchText);
        outState.putParcelable(LOCATION_BUNDLE_KEY, (Parcelable)this.location);
        outState.putBoolean(SHOW_SEARCH_BOX_BUNDLE_KEY, this.showSearchBox);
    }

    @Override
    void onLoadingData() {
        this.hasSearchTextChangedSinceLastQuery = false;
    }

    @Override
    Request getRequestForLoadData(Session session) {
        return this.createRequest(this.location, this.radiusInMeters, this.resultsLimit, this.searchText, this.extraFields, session);
    }

    @Override
    String getDefaultTitleText() {
        return this.getString(R.string.com_facebook_nearby);
    }

    @Override
    void logAppEvents(boolean doneButtonClicked) {
        AppEventsLogger logger = AppEventsLogger.newLogger((Context)this.getActivity(), this.getSession());
        Bundle parameters = new Bundle();
        String outcome = doneButtonClicked ? "Completed" : "Unknown";
        parameters.putString("fb_dialog_outcome", outcome);
        parameters.putInt("num_places_picked", this.getSelection() != null ? 1 : 0);
        logger.logSdkEvent("fb_place_picker_usage", null, parameters);
    }

    @Override
    PickerFragment.PickerFragmentAdapter<GraphPlace> createAdapter() {
        PickerFragment.PickerFragmentAdapter<GraphPlace> adapter = new PickerFragment.PickerFragmentAdapter<GraphPlace>((PickerFragment)this, (Context)this.getActivity()){

            @Override
            protected CharSequence getSubTitleOfGraphObject(GraphPlace graphObject) {
                String category = graphObject.getCategory();
                Integer wereHereCount = (Integer)graphObject.getProperty(PlacePickerFragment.WERE_HERE_COUNT);
                String result = null;
                if (category != null && wereHereCount != null) {
                    result = PlacePickerFragment.this.getString(R.string.com_facebook_placepicker_subtitle_format, new Object[]{category, wereHereCount});
                } else if (category == null && wereHereCount != null) {
                    result = PlacePickerFragment.this.getString(R.string.com_facebook_placepicker_subtitle_were_here_only_format, new Object[]{wereHereCount});
                } else if (category != null && wereHereCount == null) {
                    result = PlacePickerFragment.this.getString(R.string.com_facebook_placepicker_subtitle_catetory_only_format, new Object[]{category});
                }
                return result;
            }

            @Override
            protected int getGraphObjectRowLayoutId(GraphPlace graphObject) {
                return R.layout.com_facebook_placepickerfragment_list_row;
            }

            @Override
            protected int getDefaultPicture() {
                return R.drawable.com_facebook_place_default_icon;
            }
        };
        adapter.setShowCheckbox(false);
        adapter.setShowPicture(this.getShowPictures());
        return adapter;
    }

    @Override
    PickerFragment.LoadingStrategy createLoadingStrategy() {
        return new AsNeededLoadingStrategy();
    }

    @Override
    PickerFragment.SelectionStrategy createSelectionStrategy() {
        return new PickerFragment.SingleSelectionStrategy(this);
    }

    private Request createRequest(Location location, int radiusInMeters, int resultsLimit, String searchText, Set<String> extraFields, Session session) {
        Request request = Request.newPlacesSearchRequest(session, location, radiusInMeters, resultsLimit, searchText, null);
        HashSet<String> fields = new HashSet<String>(extraFields);
        String[] requiredFields = new String[]{ID, NAME, LOCATION, CATEGORY, WERE_HERE_COUNT};
        fields.addAll(Arrays.asList(requiredFields));
        String pictureField = this.adapter.getPictureFieldSpecifier();
        if (pictureField != null) {
            fields.add(pictureField);
        }
        Bundle parameters = request.getParameters();
        parameters.putString("fields", TextUtils.join((CharSequence)",", fields));
        request.setParameters(parameters);
        return request;
    }

    private void setPlacePickerSettingsFromBundle(Bundle inState) {
        if (inState != null) {
            this.setRadiusInMeters(inState.getInt(RADIUS_IN_METERS_BUNDLE_KEY, this.radiusInMeters));
            this.setResultsLimit(inState.getInt(RESULTS_LIMIT_BUNDLE_KEY, this.resultsLimit));
            if (inState.containsKey(SEARCH_TEXT_BUNDLE_KEY)) {
                this.setSearchText(inState.getString(SEARCH_TEXT_BUNDLE_KEY));
            }
            if (inState.containsKey(LOCATION_BUNDLE_KEY)) {
                Location location = (Location)inState.getParcelable(LOCATION_BUNDLE_KEY);
                this.setLocation(location);
            }
            this.showSearchBox = inState.getBoolean(SHOW_SEARCH_BOX_BUNDLE_KEY, this.showSearchBox);
        }
    }

    private Timer createSearchTextTimer() {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                PlacePickerFragment.this.onSearchTextTimerTriggered();
            }
        }, 0L, 2000L);
        return timer;
    }

    private void onSearchTextTimerTriggered() {
        if (this.hasSearchTextChangedSinceLastQuery) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    FacebookException error = null;
                    try {
                        PlacePickerFragment.this.loadData(true);
                    }
                    catch (FacebookException fe) {
                        error = fe;
                        if (error == null) return;
                        PickerFragment.OnErrorListener onErrorListener = PlacePickerFragment.this.getOnErrorListener();
                        if (onErrorListener != null) {
                            onErrorListener.onError(PlacePickerFragment.this, error);
                            return;
                        } else {
                            Logger.log(LoggingBehavior.REQUESTS, PlacePickerFragment.TAG, "Error loading data : %s", error);
                        }
                        return;
                    }
                    catch (Exception e) {
                        try {
                            error = new FacebookException(e);
                            if (error == null) return;
                        }
                        catch (Throwable throwable) {
                            if (error == null) throw throwable;
                            PickerFragment.OnErrorListener onErrorListener = PlacePickerFragment.this.getOnErrorListener();
                            if (onErrorListener != null) {
                                onErrorListener.onError(PlacePickerFragment.this, error);
                                throw throwable;
                            } else {
                                Logger.log(LoggingBehavior.REQUESTS, PlacePickerFragment.TAG, "Error loading data : %s", error);
                            }
                            throw throwable;
                        }
                        PickerFragment.OnErrorListener onErrorListener = PlacePickerFragment.this.getOnErrorListener();
                        if (onErrorListener != null) {
                            onErrorListener.onError(PlacePickerFragment.this, error);
                            return;
                        } else {
                            Logger.log(LoggingBehavior.REQUESTS, PlacePickerFragment.TAG, "Error loading data : %s", error);
                        }
                        return;
                    }
                    if (error == null) return;
                    PickerFragment.OnErrorListener onErrorListener = PlacePickerFragment.this.getOnErrorListener();
                    if (onErrorListener != null) {
                        onErrorListener.onError(PlacePickerFragment.this, error);
                        return;
                    } else {
                        Logger.log(LoggingBehavior.REQUESTS, PlacePickerFragment.TAG, "Error loading data : %s", error);
                    }
                }
            });
        } else {
            this.searchTextTimer.cancel();
            this.searchTextTimer = null;
        }
    }

    private class AsNeededLoadingStrategy
    extends PickerFragment.LoadingStrategy {
        private AsNeededLoadingStrategy() {
            super(PlacePickerFragment.this);
        }

        public void attach(GraphObjectAdapter<GraphPlace> adapter) {
            super.attach(adapter);
            this.adapter.setDataNeededListener(new GraphObjectAdapter.DataNeededListener(){

                @Override
                public void onDataNeeded() {
                    if (!AsNeededLoadingStrategy.this.loader.isLoading()) {
                        AsNeededLoadingStrategy.this.loader.followNextLink();
                    }
                }
            });
        }

        protected void onLoadFinished(GraphObjectPagingLoader<GraphPlace> loader, SimpleGraphObjectCursor<GraphPlace> data) {
            super.onLoadFinished(loader, data);
            if (data == null || loader.isLoading()) {
                return;
            }
            PlacePickerFragment.this.hideActivityCircle();
            if (data.isFromCache()) {
                loader.refreshOriginalRequest(data.areMoreObjectsAvailable() ? 2000 : 0);
            }
        }
    }

    private class SearchTextWatcher
    implements TextWatcher {
        private SearchTextWatcher() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            PlacePickerFragment.this.onSearchBoxTextChanged(s.toString(), false);
        }

        public void afterTextChanged(Editable s) {
        }
    }
}

