/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.internal;

import com.facebook.Settings;
import java.util.concurrent.Executor;

class WorkQueue {
    public static final int DEFAULT_MAX_CONCURRENT = 8;
    private final Object workLock = new Object();
    private WorkNode pendingJobs;
    private final int maxConcurrent;
    private final Executor executor;
    private WorkNode runningJobs = null;
    private int runningCount = 0;

    WorkQueue() {
        this(8);
    }

    WorkQueue(int maxConcurrent) {
        this(maxConcurrent, Settings.getExecutor());
    }

    WorkQueue(int maxConcurrent, Executor executor) {
        this.maxConcurrent = maxConcurrent;
        this.executor = executor;
    }

    WorkItem addActiveWorkItem(Runnable callback) {
        return this.addActiveWorkItem(callback, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WorkItem addActiveWorkItem(Runnable callback, boolean addToFront) {
        WorkNode node = new WorkNode(callback);
        Object object = this.workLock;
        synchronized (object) {
            this.pendingJobs = node.addToList(this.pendingJobs, addToFront);
        }
        this.startItem();
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validate() {
        Object object = this.workLock;
        synchronized (object) {
            int count = 0;
            if (this.runningJobs != null) {
                WorkNode walk = this.runningJobs;
                do {
                    walk.verify(true);
                    ++count;
                } while ((walk = walk.getNext()) != this.runningJobs);
            }
            assert (this.runningCount == count);
        }
    }

    private void startItem() {
        this.finishItemAndStartNew(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishItemAndStartNew(WorkNode finished) {
        WorkNode ready = null;
        Object object = this.workLock;
        synchronized (object) {
            if (finished != null) {
                this.runningJobs = finished.removeFromList(this.runningJobs);
                --this.runningCount;
            }
            if (this.runningCount < this.maxConcurrent && (ready = this.pendingJobs) != null) {
                this.pendingJobs = ready.removeFromList(this.pendingJobs);
                this.runningJobs = ready.addToList(this.runningJobs, false);
                ++this.runningCount;
                ready.setIsRunning(true);
            }
        }
        if (ready != null) {
            this.execute(ready);
        }
    }

    private void execute(final WorkNode node) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    node.getCallback().run();
                }
                finally {
                    WorkQueue.this.finishItemAndStartNew(node);
                }
            }
        });
    }

    static interface WorkItem {
        public boolean cancel();

        public boolean isRunning();

        public void moveToFront();
    }

    private class WorkNode
    implements WorkItem {
        private final Runnable callback;
        private WorkNode next;
        private WorkNode prev;
        private boolean isRunning;

        WorkNode(Runnable callback) {
            this.callback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            Object object = WorkQueue.this.workLock;
            synchronized (object) {
                block4: {
                    if (this.isRunning()) break block4;
                    WorkQueue.this.pendingJobs = this.removeFromList(WorkQueue.this.pendingJobs);
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void moveToFront() {
            Object object = WorkQueue.this.workLock;
            synchronized (object) {
                if (!this.isRunning()) {
                    WorkQueue.this.pendingJobs = this.removeFromList(WorkQueue.this.pendingJobs);
                    WorkQueue.this.pendingJobs = this.addToList(WorkQueue.this.pendingJobs, true);
                }
            }
        }

        @Override
        public boolean isRunning() {
            return this.isRunning;
        }

        Runnable getCallback() {
            return this.callback;
        }

        WorkNode getNext() {
            return this.next;
        }

        void setIsRunning(boolean isRunning) {
            this.isRunning = isRunning;
        }

        WorkNode addToList(WorkNode list, boolean addToFront) {
            assert (this.next == null);
            assert (this.prev == null);
            if (list == null) {
                this.next = this.prev = this;
                list = this.prev;
            } else {
                this.next = list;
                this.prev = list.prev;
                this.next.prev = this.prev.next = this;
            }
            return addToFront ? this : list;
        }

        WorkNode removeFromList(WorkNode list) {
            assert (this.next != null);
            assert (this.prev != null);
            if (list == this) {
                list = this.next == this ? null : this.next;
            }
            this.next.prev = this.prev;
            this.prev.next = this.next;
            this.prev = null;
            this.next = null;
            return list;
        }

        void verify(boolean shouldBeRunning) {
            assert (this.prev.next == this);
            assert (this.next.prev == this);
            assert (this.isRunning() == shouldBeRunning);
        }
    }
}

