/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.annotation.TargetApi;
import android.os.AsyncTask;
import android.os.Handler;
import android.util.Log;
import com.facebook.Request;
import com.facebook.RequestBatch;
import com.facebook.Response;
import com.facebook.Settings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;

@TargetApi(value=3)
public class RequestAsyncTask
extends AsyncTask<Void, Void, List<Response>> {
    private static final String TAG = RequestAsyncTask.class.getCanonicalName();
    private static Method executeOnExecutorMethod;
    private final HttpURLConnection connection;
    private final RequestBatch requests;
    private Exception exception;

    static {
        Method[] methodArray = AsyncTask.class.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] parameters;
            Method method = methodArray[n2];
            if ("executeOnExecutor".equals(method.getName()) && (parameters = method.getParameterTypes()).length == 2 && parameters[0] == Executor.class && parameters[1].isArray()) {
                executeOnExecutorMethod = method;
                break;
            }
            ++n2;
        }
    }

    public RequestAsyncTask(Request ... requests) {
        this((HttpURLConnection)null, new RequestBatch(requests));
    }

    public RequestAsyncTask(Collection<Request> requests) {
        this((HttpURLConnection)null, new RequestBatch(requests));
    }

    public RequestAsyncTask(RequestBatch requests) {
        this((HttpURLConnection)null, requests);
    }

    public RequestAsyncTask(HttpURLConnection connection, Request ... requests) {
        this(connection, new RequestBatch(requests));
    }

    public RequestAsyncTask(HttpURLConnection connection, Collection<Request> requests) {
        this(connection, new RequestBatch(requests));
    }

    public RequestAsyncTask(HttpURLConnection connection, RequestBatch requests) {
        this.requests = requests;
        this.connection = connection;
    }

    protected final Exception getException() {
        return this.exception;
    }

    protected final RequestBatch getRequests() {
        return this.requests;
    }

    public String toString() {
        return "{RequestAsyncTask: " + " connection: " + this.connection + ", requests: " + this.requests + "}";
    }

    protected void onPreExecute() {
        super.onPreExecute();
        if (this.requests.getCallbackHandler() == null) {
            this.requests.setCallbackHandler(new Handler());
        }
    }

    protected void onPostExecute(List<Response> result) {
        super.onPostExecute(result);
        if (this.exception != null) {
            Log.d((String)TAG, (String)String.format("onPostExecute: exception encountered during request: %s", this.exception.getMessage()));
        }
    }

    protected List<Response> doInBackground(Void ... params) {
        try {
            if (this.connection == null) {
                return this.requests.executeAndWait();
            }
            return Request.executeConnectionAndWait(this.connection, this.requests);
        }
        catch (Exception e) {
            this.exception = e;
            return null;
        }
    }

    RequestAsyncTask executeOnSettingsExecutor() {
        try {
            if (executeOnExecutorMethod != null) {
                executeOnExecutorMethod.invoke((Object)this, Settings.getExecutor(), null);
                return this;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        this.execute(new Void[0]);
        return this;
    }
}

