/*
 * Decompiled with CFR 0.152.
 */
package com.facebook;

import android.os.Handler;
import com.facebook.Request;
import com.facebook.RequestOutputStream;
import com.facebook.RequestProgress;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

class ProgressNoopOutputStream
extends OutputStream
implements RequestOutputStream {
    private final Map<Request, RequestProgress> progressMap = new HashMap<Request, RequestProgress>();
    private final Handler callbackHandler;
    private Request currentRequest;
    private RequestProgress currentRequestProgress;
    private int batchMax;

    ProgressNoopOutputStream(Handler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public void setCurrentRequest(Request currentRequest) {
        this.currentRequest = currentRequest;
        this.currentRequestProgress = currentRequest != null ? this.progressMap.get(currentRequest) : null;
    }

    int getMaxProgress() {
        return this.batchMax;
    }

    Map<Request, RequestProgress> getProgressMap() {
        return this.progressMap;
    }

    void addProgress(long size) {
        if (this.currentRequestProgress == null) {
            this.currentRequestProgress = new RequestProgress(this.callbackHandler, this.currentRequest);
            this.progressMap.put(this.currentRequest, this.currentRequestProgress);
        }
        this.currentRequestProgress.addToMax(size);
        this.batchMax = (int)((long)this.batchMax + size);
    }

    @Override
    public void write(byte[] buffer) {
        this.addProgress(buffer.length);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) {
        this.addProgress(length);
    }

    @Override
    public void write(int oneByte) {
        this.addProgress(1L);
    }
}

