/*
 * Decompiled with CFR 0.152.
 */
package cn.uc.gamesdk.service;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import cn.uc.gamesdk.bridge.a.f;
import cn.uc.gamesdk.c.f;
import cn.uc.gamesdk.d.b;
import cn.uc.gamesdk.d.c;
import cn.uc.gamesdk.d.l;
import cn.uc.gamesdk.f.a;
import cn.uc.gamesdk.g.g;
import cn.uc.gamesdk.h.i;
import cn.uc.gamesdk.info.OrderInfo;
import cn.uc.gamesdk.info.PaymentInfo;
import cn.uc.gamesdk.service.ServiceResultConverter;
import java.text.DecimalFormat;
import org.json.JSONException;
import org.json.JSONObject;

public class PayService
extends cn.uc.gamesdk.bridge.a.c {
    private static final String a = "PayService";
    private static final String b = "getPaymentInfo";
    private static final String c = "payNotifyCp";
    private static final String d = "cmccPay";
    private static final String e = "exitSdk";
    private static final String f = "alixPay";
    private static final String g = "cmccGamePay";

    @Override
    public cn.uc.gamesdk.bridge.a.f execute(String action, JSONObject paramObj, String callbackId) {
        if (b.equals(action)) {
            return this.getPaymentInfo();
        }
        if (c.equals(action)) {
            return this.payNotifyCp(paramObj);
        }
        if (e.equals(action)) {
            return this.exitSdk();
        }
        if (g.equals(action)) {
            return this.cmccGamePay(paramObj);
        }
        if (d.equals(action)) {
            return this.cmccPay(paramObj);
        }
        if (f.equals(action)) {
            return this.alixPay(paramObj, callbackId);
        }
        return null;
    }

    @Override
    public boolean isSynch(String action) {
        return !d.equals(action) && !g.equals(action) && !f.equals(action);
    }

    public cn.uc.gamesdk.bridge.a.f getPaymentInfo() {
        PaymentInfo paymentInfo = cn.uc.gamesdk.c.f.p;
        if (paymentInfo == null) {
            paymentInfo = new PaymentInfo();
        }
        JSONObject retObj = new JSONObject();
        try {
            retObj.put("roleId", (Object)paymentInfo.getRoleId());
            retObj.put("roleName", (Object)paymentInfo.getRoleName());
            retObj.put("grade", (Object)paymentInfo.getGrade());
            retObj.put("callbackInfo", (Object)paymentInfo.getCustomInfo());
            retObj.put("callbackUrl", (Object)"");
            retObj.put("allowContinuousPay", paymentInfo.isAllowContinuousPay());
            DecimalFormat df = new DecimalFormat("#.00");
            retObj.put("amount", Double.parseDouble(df.format(paymentInfo.getAmount())));
        }
        catch (JSONException e2) {
            cn.uc.gamesdk.g.g.a(a, b, "json exception", "", (Exception)((Object)e2));
            return ServiceResultConverter.toErrorResult(b, (Exception)((Object)e2));
        }
        catch (NumberFormatException e1) {
            cn.uc.gamesdk.g.g.b(a, b, "\u8f6c\u6362double\u7c7b\u578b\u62a5\u9519", e1);
            return ServiceResultConverter.toErrorResult(b, e1);
        }
        return ServiceResultConverter.toWrapSuccessResult(retObj);
    }

    public cn.uc.gamesdk.bridge.a.f payNotifyCp(JSONObject paramObj) {
        OrderInfo orderInfo = new OrderInfo();
        orderInfo.setOrderId(paramObj.optString("orderId"));
        orderInfo.setOrderAmount((float)paramObj.optDouble("orderAmount"));
        orderInfo.setPayWay(paramObj.optInt("payWay"));
        orderInfo.setPayWayName(paramObj.optString("payWayName"));
        int code = paramObj.optInt("code", 1);
        l.a(orderInfo, code);
        return ServiceResultConverter.toWrapSuccessResult(null);
    }

    public cn.uc.gamesdk.bridge.a.f cmccPay(JSONObject paramObj) {
        int payAmount = paramObj.optInt("payAmount");
        c cmccPay = new c(cn.uc.gamesdk.c.f.c, payAmount, cn.uc.gamesdk.c.f.p, cn.uc.gamesdk.c.f.j);
        i response = cmccPay.a();
        return ServiceResultConverter.toSuccessResult(response.l());
    }

    private cn.uc.gamesdk.bridge.a.f exitSdk() {
        this.ctx.finish();
        return ServiceResultConverter.toWrapSuccessResult(null);
    }

    public cn.uc.gamesdk.bridge.a.f cmccGamePay(JSONObject paramObj) {
        String domain;
        String token = paramObj.optString("token");
        int type = paramObj.optInt("type");
        String downUrl = paramObj.optString("downUrl");
        String referUrl = paramObj.optString("referUrl");
        String loginUrl = paramObj.optString("loginUrl");
        loginUrl = loginUrl.replace("&amp;", "&");
        int delayDown = paramObj.optInt("delayDown");
        int delayLogin = paramObj.optInt("delayLogin");
        String ua = paramObj.optString("ua");
        String payKey = paramObj.optString("payKey");
        String payUrl = paramObj.optString("payUrl");
        String ver = paramObj.optString("ver");
        String orderId = paramObj.optString("tradeId");
        int orderAmount = paramObj.optInt("orderAmount");
        a kulInfo = new a();
        kulInfo.a(delayDown);
        kulInfo.b(delayLogin);
        kulInfo.g(loginUrl);
        kulInfo.b(downUrl);
        kulInfo.c(referUrl);
        kulInfo.f(ua);
        kulInfo.e(payKey);
        Context context = this.ctx.getContext();
        kulInfo.a(cn.uc.gamesdk.j.i.d(context));
        String mobileNum = cn.uc.gamesdk.j.i.c(context);
        kulInfo.d(mobileNum);
        if (cn.uc.gamesdk.j.l.k(mobileNum)) {
            type = 1;
        }
        if ((domain = this.ctx.getCurrentDomain()).equalsIgnoreCase("localhost")) {
            try {
                domain = cn.uc.gamesdk.j.l.i(payUrl);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        i response = new b(kulInfo, token, payUrl, ver, type, orderAmount, orderId, domain).a();
        return ServiceResultConverter.toSuccessResult(response.l());
    }

    private cn.uc.gamesdk.bridge.a.f alixPay(JSONObject paramObj, final String callbackId) {
        final String payInfo = paramObj.optString("payInfo", null);
        final PayService me = this;
        this.ctx.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Handler callbackHander = new Handler(){

                    public void handleMessage(Message msg) {
                        try {
                            String alixPayResultStr = (String)msg.obj;
                            cn.uc.gamesdk.g.g.a(PayService.a, PayService.f, "in callbackHandler \u652f\u4ed8\u5b9d\u63d2\u4ef6\u56de\u8c03\u7ed3\u679c=" + alixPayResultStr);
                            switch (msg.what) {
                                case 1: {
                                    if (alixPayResultStr == null) break;
                                    try {
                                        JSONObject resultJson = cn.uc.gamesdk.a.b.b(alixPayResultStr, ";");
                                        if (resultJson != null && !resultJson.has("rawResult")) {
                                            resultJson.put("rawResult", (Object)alixPayResultStr);
                                        }
                                        me.ctx.sendJavascript(ServiceResultConverter.toWrapSuccessResult(resultJson).a(callbackId));
                                    }
                                    catch (Exception e2) {
                                        e2.printStackTrace();
                                    }
                                    break;
                                }
                                case -1: {
                                    i alixNotInstallResponse = i.a(-9, "\u652f\u4ed8\u5b9d\u63d2\u4ef6\u9700\u8981\u5b89\u88c5");
                                    me.ctx.sendJavascript(ServiceResultConverter.toSuccessResult(alixNotInstallResponse.l()).a(callbackId));
                                }
                            }
                            super.handleMessage(msg);
                        }
                        catch (Exception e3) {
                            cn.uc.gamesdk.g.g.a(PayService.a, PayService.f, "SDK INNER API call error", "\u652f\u4ed8\u5b9d\u63d2\u4ef6\u5f02\u5e38");
                        }
                    }
                };
                l.a(me.ctx.getContext(), payInfo, callbackHander);
            }
        });
        cn.uc.gamesdk.bridge.a.f result = new cn.uc.gamesdk.bridge.a.f(f.a.a);
        result.a(true);
        return result;
    }
}

