/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import twitter4j.RateLimitStatus;
import twitter4j.TwitterException;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.json.z_T4JInternalParseUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RateLimitStatusJSONImpl
implements RateLimitStatus,
Serializable {
    private static final long serialVersionUID = 1625565652687304084L;
    private int remaining;
    private int limit;
    private int resetTimeInSeconds;
    private int secondsUntilReset;

    static Map<String, RateLimitStatus> createRateLimitStatuses(HttpResponse res, Configuration conf) throws TwitterException {
        JSONObject json = res.asJSONObject();
        Map<String, RateLimitStatus> map = RateLimitStatusJSONImpl.createRateLimitStatuses(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(map, json);
        }
        return map;
    }

    static Map<String, RateLimitStatus> createRateLimitStatuses(JSONObject json) throws TwitterException {
        HashMap<String, RateLimitStatusJSONImpl> map = new HashMap<String, RateLimitStatusJSONImpl>();
        try {
            JSONObject resources = json.getJSONObject("resources");
            Iterator resourceKeys = resources.keys();
            while (resourceKeys.hasNext()) {
                JSONObject resource = resources.getJSONObject((String)resourceKeys.next());
                Iterator endpointKeys = resource.keys();
                while (endpointKeys.hasNext()) {
                    String endpoint = (String)endpointKeys.next();
                    JSONObject rateLimitStatusJSON = resource.getJSONObject(endpoint);
                    RateLimitStatusJSONImpl rateLimitStatus = new RateLimitStatusJSONImpl(rateLimitStatusJSON);
                    map.put(endpoint, rateLimitStatus);
                }
            }
            return Collections.unmodifiableMap(map);
        }
        catch (JSONException jsone) {
            throw new TwitterException((Exception)((Object)jsone));
        }
    }

    private RateLimitStatusJSONImpl(int limit, int remaining, int resetTimeInSeconds) {
        this.limit = limit;
        this.remaining = remaining;
        this.resetTimeInSeconds = resetTimeInSeconds;
        this.secondsUntilReset = (int)(((long)resetTimeInSeconds * 1000L - System.currentTimeMillis()) / 1000L);
    }

    RateLimitStatusJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    void init(JSONObject json) throws TwitterException {
        this.limit = z_T4JInternalParseUtil.getInt("limit", json);
        this.remaining = z_T4JInternalParseUtil.getInt("remaining", json);
        this.resetTimeInSeconds = z_T4JInternalParseUtil.getInt("reset", json);
        this.secondsUntilReset = (int)(((long)this.resetTimeInSeconds * 1000L - System.currentTimeMillis()) / 1000L);
    }

    static RateLimitStatus createFromResponseHeader(HttpResponse res) {
        if (null == res) {
            return null;
        }
        String strLimit = res.getResponseHeader("X-Rate-Limit-Limit");
        if (strLimit == null) {
            return null;
        }
        int limit = Integer.parseInt(strLimit);
        String remaining = res.getResponseHeader("X-Rate-Limit-Remaining");
        if (remaining == null) {
            return null;
        }
        int remainingHits = Integer.parseInt(remaining);
        String reset = res.getResponseHeader("X-Rate-Limit-Reset");
        if (reset == null) {
            return null;
        }
        long longReset = Long.parseLong(reset);
        int resetTimeInSeconds = (int)longReset;
        return new RateLimitStatusJSONImpl(limit, remainingHits, resetTimeInSeconds);
    }

    @Override
    public int getRemaining() {
        return this.remaining;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getResetTimeInSeconds() {
        return this.resetTimeInSeconds;
    }

    @Override
    public int getSecondsUntilReset() {
        return this.secondsUntilReset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RateLimitStatusJSONImpl that = (RateLimitStatusJSONImpl)o;
        if (this.limit != that.limit) {
            return false;
        }
        if (this.remaining != that.remaining) {
            return false;
        }
        if (this.resetTimeInSeconds != that.resetTimeInSeconds) {
            return false;
        }
        return this.secondsUntilReset == that.secondsUntilReset;
    }

    public int hashCode() {
        int result = this.remaining;
        result = 31 * result + this.limit;
        result = 31 * result + this.resetTimeInSeconds;
        result = 31 * result + this.secondsUntilReset;
        return result;
    }

    public String toString() {
        return "RateLimitStatusJSONImpl{remaining=" + this.remaining + ", limit=" + this.limit + ", resetTimeInSeconds=" + this.resetTimeInSeconds + ", secondsUntilReset=" + this.secondsUntilReset + '}';
    }
}

