/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import twitter4j.MediaEntity;
import twitter4j.TwitterException;
import twitter4j.internal.json.EntityIndex;
import twitter4j.internal.json.z_T4JInternalParseUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaEntityJSONImpl
extends EntityIndex
implements MediaEntity {
    private static final long serialVersionUID = 224487082931268487L;
    private long id;
    private String url;
    private String mediaURL;
    private String mediaURLHttps;
    private String expandedURL;
    private String displayURL;
    private Map<Integer, MediaEntity.Size> sizes;
    private String type;

    MediaEntityJSONImpl(JSONObject json) throws TwitterException {
        try {
            JSONArray indicesArray = json.getJSONArray("indices");
            this.setStart(indicesArray.getInt(0));
            this.setEnd(indicesArray.getInt(1));
            this.id = z_T4JInternalParseUtil.getLong("id", json);
            this.url = json.getString("url");
            this.expandedURL = json.getString("expanded_url");
            this.mediaURL = json.getString("media_url");
            this.mediaURLHttps = json.getString("media_url_https");
            this.displayURL = json.getString("display_url");
            JSONObject sizes = json.getJSONObject("sizes");
            this.sizes = new HashMap<Integer, MediaEntity.Size>(4);
            this.addMediaEntitySizeIfNotNull(this.sizes, sizes, MediaEntity.Size.LARGE, "large");
            this.addMediaEntitySizeIfNotNull(this.sizes, sizes, MediaEntity.Size.MEDIUM, "medium");
            this.addMediaEntitySizeIfNotNull(this.sizes, sizes, MediaEntity.Size.SMALL, "small");
            this.addMediaEntitySizeIfNotNull(this.sizes, sizes, MediaEntity.Size.THUMB, "thumb");
            if (!json.isNull("type")) {
                this.type = json.getString("type");
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException((Exception)((Object)jsone));
        }
    }

    private void addMediaEntitySizeIfNotNull(Map<Integer, MediaEntity.Size> sizes, JSONObject sizes_json, Integer size, String key) throws JSONException {
        JSONObject size_json = sizes_json.optJSONObject(key);
        if (size_json != null) {
            sizes.put(size, new Size(size_json));
        }
    }

    MediaEntityJSONImpl() {
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getMediaURL() {
        return this.mediaURL;
    }

    @Override
    public String getMediaURLHttps() {
        return this.mediaURLHttps;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getDisplayURL() {
        return this.displayURL;
    }

    @Override
    public String getExpandedURL() {
        return this.expandedURL;
    }

    @Override
    public Map<Integer, MediaEntity.Size> getSizes() {
        return this.sizes;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int getStart() {
        return super.getStart();
    }

    @Override
    public int getEnd() {
        return super.getEnd();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MediaEntityJSONImpl)) {
            return false;
        }
        MediaEntityJSONImpl that = (MediaEntityJSONImpl)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public String toString() {
        return "MediaEntityJSONImpl{id=" + this.id + ", url=" + this.url + ", mediaURL=" + this.mediaURL + ", mediaURLHttps=" + this.mediaURLHttps + ", expandedURL=" + this.expandedURL + ", displayURL='" + this.displayURL + '\'' + ", sizes=" + this.sizes + ", type=" + this.type + '}';
    }

    static class Size
    implements MediaEntity.Size {
        private static final long serialVersionUID = 8681853416159361581L;
        int width;
        int height;
        int resize;

        Size(JSONObject json) throws JSONException {
            this.width = json.getInt("w");
            this.height = json.getInt("h");
            this.resize = "fit".equals(json.getString("resize")) ? 100 : 101;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getResize() {
            return this.resize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Size)) {
                return false;
            }
            Size size = (Size)o;
            if (this.height != size.height) {
                return false;
            }
            if (this.resize != size.resize) {
                return false;
            }
            return this.width == size.width;
        }

        public int hashCode() {
            int result = this.width;
            result = 31 * result + this.height;
            result = 31 * result + this.resize;
            return result;
        }

        public String toString() {
            return "Size{width=" + this.width + ", height=" + this.height + ", resize=" + this.resize + '}';
        }
    }
}

