/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal;

import android.content.Context;
import android.webkit.WebView;
import com.facebook.ads.internal.AdHandler;
import com.facebook.ads.internal.HtmlAdDataModel;
import com.facebook.ads.internal.StringUtils;

public class HtmlAdHandler
extends AdHandler {
    private final WebView webView;
    private volatile boolean adActivated;

    public HtmlAdHandler(WebView webView, AdHandler.ImpressionHelper impressionHelper, long sendImpressionDelay, Context context) {
        super(impressionHelper, sendImpressionDelay, context);
        this.webView = webView;
    }

    public void setAdDataModel(HtmlAdDataModel adDataModel) {
        super.setAdDataModel(adDataModel);
        this.adActivated = false;
    }

    public synchronized void activateAd() {
        if (this.adActivated || this.adDataModel == null) {
            return;
        }
        HtmlAdDataModel dataModel = (HtmlAdDataModel)this.adDataModel;
        if (!StringUtils.isNullOrEmpty(dataModel.getActivationCommand())) {
            this.webView.loadUrl("javascript:" + dataModel.getActivationCommand());
        }
        this.scheduleImpressionRetry();
        this.adActivated = true;
    }

    protected synchronized void sendImpression() {
        HtmlAdDataModel dataModel = (HtmlAdDataModel)this.adDataModel;
        if (!StringUtils.isNullOrEmpty(dataModel.getSendImpressionCommand())) {
            this.webView.loadUrl("javascript:" + dataModel.getSendImpressionCommand());
        }
        if (this.impressionHelper != null) {
            this.impressionHelper.afterImpressionSent();
        }
    }
}

