/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import com.facebook.ads.internal.AdDataModel;
import com.facebook.ads.internal.AdInvalidationBehavior;
import com.facebook.ads.internal.StringUtils;
import java.util.Collection;
import java.util.HashSet;
import org.json.JSONArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdInvalidationUtils {
    public static boolean shouldInvalidate(Context context, AdDataModel dataModel) {
        AdInvalidationBehavior invalidationBehavior = dataModel.getInvalidationBehavior();
        if (invalidationBehavior == null || invalidationBehavior == AdInvalidationBehavior.NONE) {
            return false;
        }
        boolean packageInstalled = false;
        Collection<String> detectionStrings = dataModel.getDetectionStrings();
        if (detectionStrings == null || detectionStrings.isEmpty()) {
            return false;
        }
        for (String packageName : detectionStrings) {
            if (!AdInvalidationUtils.isNativePackageInstalled(context, packageName)) continue;
            packageInstalled = true;
            break;
        }
        if (invalidationBehavior == AdInvalidationBehavior.INSTALLED) {
            return packageInstalled;
        }
        if (invalidationBehavior == AdInvalidationBehavior.NOT_INSTALLED) {
            return !packageInstalled;
        }
        return false;
    }

    public static boolean isNativePackageInstalled(Context context, String packageName) {
        if (StringUtils.isNullOrEmpty(packageName)) {
            return false;
        }
        PackageManager pm = context.getPackageManager();
        try {
            pm.getPackageInfo(packageName, 1);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static Collection<String> parseDetectionStrings(JSONArray detectionStrings) {
        if (detectionStrings == null || detectionStrings.length() == 0) {
            return null;
        }
        HashSet<String> results = new HashSet<String>();
        for (int i = 0; i < detectionStrings.length(); ++i) {
            results.add(detectionStrings.optString(i));
        }
        return results;
    }
}

