/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ads;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.RelativeLayout;
import com.facebook.ads.internal.AdWebViewInterface;
import com.facebook.ads.internal.AdWebViewUtils;
import com.facebook.ads.internal.HtmlAdDataModel;
import com.facebook.ads.internal.HtmlAdHandler;
import com.facebook.ads.internal.action.AdAction;
import com.facebook.ads.internal.action.AdActionFactory;

public class InterstitialAdActivity
extends Activity {
    private static final String TAG = InterstitialAdActivity.class.getSimpleName();
    private static final String DATA_MODEL_KEY = "dataModel";
    private static final String LAST_REQUESTED_ORIENTATION_KEY = "lastRequestedOrientation";
    private static final int AD_WEBVIEW_ID = 100001;
    private static final int ORIENTATION_REVERSE_PORTRAIT = 9;
    private static final int ORIENTATION_REVERSE_LANDSCAPE = 8;
    private WebView adWebView;
    private int lastRequestedOrientation;
    private int displayWidth;
    private int displayHeight;
    private boolean isRestart = false;
    private HtmlAdDataModel dataModel;
    private HtmlAdHandler adHandler;
    private String placementId;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        RelativeLayout relativeLayout = new RelativeLayout((Context)this);
        this.adWebView = new WebView((Context)this);
        this.adWebView.setId(100001);
        this.adWebView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        AdWebViewUtils.config(this.adWebView, new AdWebViewClient(), new AdWebViewInterface());
        relativeLayout.addView((View)this.adWebView);
        this.adHandler = new HtmlAdHandler(this.adWebView, null, 1000L, (Context)this);
        this.setContentView((View)relativeLayout, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        Intent intent = this.getIntent();
        this.loadAdFromIntentOrSavedState(intent, savedInstanceState);
        this.sendBroadcastForEvent("com.facebook.ads.interstitial.displayed");
    }

    public void onStart() {
        super.onStart();
        if (!this.isRestart) {
            this.setScreenOrientation(this.displayWidth, this.displayHeight);
        } else if (this.lastRequestedOrientation >= 0) {
            this.setRequestedOrientation(this.lastRequestedOrientation);
            this.lastRequestedOrientation = -1;
        }
        this.isRestart = false;
    }

    public void setRequestedOrientation(int requestedOrientation) {
        this.lastRequestedOrientation = requestedOrientation;
        super.setRequestedOrientation(requestedOrientation);
    }

    private void setScreenOrientation(int displayWidth, int displayHeight) {
        boolean defaultInPortrait = displayHeight >= displayWidth;
        int currentOrientation = ((WindowManager)this.getSystemService("window")).getDefaultDisplay().getRotation();
        if (defaultInPortrait) {
            switch (currentOrientation) {
                case 1: 
                case 2: {
                    this.setRequestedOrientation(9);
                    break;
                }
                default: {
                    this.setRequestedOrientation(1);
                    break;
                }
            }
        } else {
            switch (currentOrientation) {
                case 2: 
                case 3: {
                    this.setRequestedOrientation(8);
                    break;
                }
                default: {
                    this.setRequestedOrientation(0);
                }
            }
        }
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        super.onSaveInstanceState(savedInstanceState);
        if (this.dataModel != null) {
            savedInstanceState.putBundle(DATA_MODEL_KEY, this.dataModel.saveToBundle());
        }
        savedInstanceState.putInt(LAST_REQUESTED_ORIENTATION_KEY, this.lastRequestedOrientation);
        savedInstanceState.putString("adInterstitialUniqueId", this.placementId);
    }

    public void onRestart() {
        super.onRestart();
        this.isRestart = true;
    }

    private void loadAdFromIntentOrSavedState(Intent intent, Bundle savedInstanceState) {
        if (savedInstanceState != null && savedInstanceState.containsKey(DATA_MODEL_KEY)) {
            this.dataModel = HtmlAdDataModel.fromBundle(savedInstanceState.getBundle(DATA_MODEL_KEY));
            if (this.dataModel != null) {
                this.adWebView.loadDataWithBaseURL("https://www.facebook.com/", this.dataModel.getMarkup(), "text/html", "utf-8", null);
            }
            this.lastRequestedOrientation = savedInstanceState.getInt(LAST_REQUESTED_ORIENTATION_KEY, -1);
            this.placementId = savedInstanceState.getString("adInterstitialUniqueId");
            this.isRestart = true;
            return;
        }
        this.displayWidth = intent.getIntExtra("displayWidth", 0);
        this.displayHeight = intent.getIntExtra("displayHeight", 0);
        this.placementId = intent.getStringExtra("adInterstitialUniqueId");
        this.dataModel = HtmlAdDataModel.fromIntentExtra(intent);
        if (this.dataModel != null) {
            this.adHandler.setAdDataModel(this.dataModel);
            this.adWebView.loadDataWithBaseURL("https://www.facebook.com/", this.dataModel.getMarkup(), "text/html", "utf-8", null);
        }
    }

    public void finish() {
        this.adHandler.cancelImpressionRetry();
        this.adWebView.loadUrl("about:blank");
        this.adWebView.clearCache(true);
        this.sendBroadcastForEvent("com.facebook.ads.interstitial.dismissed");
        super.finish();
    }

    private void sendBroadcastForEvent(String event) {
        Intent intent = new Intent(event);
        intent.putExtra("adInterstitialUniqueId", this.placementId);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
    }

    private class AdWebViewClient
    extends WebViewClient {
        private static final String FBAD_CLOSE = "close";

        private AdWebViewClient() {
        }

        public void onLoadResource(WebView view, String url) {
            InterstitialAdActivity.this.adHandler.activateAd();
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            Uri uri = Uri.parse((String)url);
            if ("fbad".equals(uri.getScheme()) && FBAD_CLOSE.equals(uri.getAuthority())) {
                InterstitialAdActivity.this.finish();
                return true;
            }
            InterstitialAdActivity.this.sendBroadcastForEvent("com.facebook.ads.interstitial.clicked");
            AdAction adAction = AdActionFactory.getAdAction((Context)InterstitialAdActivity.this, uri);
            if (adAction != null) {
                try {
                    adAction.execute(null);
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)"Error executing action", (Throwable)ex);
                }
            }
            return true;
        }
    }
}

