/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.api.store;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Parcel;
import android.os.Parcelable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;
import tv.ouya.console.api.Product;

public class AppDescription
implements Parcelable {
    private static final String DATE_FORMAT = "yyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String[] APP_STATUSES = new String[]{"unsubmitted", "submitted", "under_review", "approved", "published", "rejected"};
    public static final Parcelable.Creator<AppDescription> CREATOR = new Parcelable.Creator<AppDescription>(){

        public AppDescription createFromParcel(Parcel parcel) {
            String uuid = parcel.readString();
            String title = parcel.readString();
            String imageUrl = parcel.readString();
            boolean hasPrimaryProduct = parcel.readInt() == 1;
            Product primaryProduct = null;
            if (hasPrimaryProduct) {
                primaryProduct = (Product)Product.CREATOR.createFromParcel(parcel);
            }
            int versionCount = parcel.readInt();
            HashMap<String, AppVersion> versions = null;
            if (versionCount > -1) {
                versions = new HashMap<String, AppVersion>();
                for (int i = 0; i < versionCount; ++i) {
                    String key = parcel.readString();
                    AppVersion version = new AppVersion();
                    version.setUuid(parcel.readString());
                    version.setUploadedAt(parcel.readString());
                    version.setMainImageFullUrl(parcel.readString());
                    version.setContentRating(parcel.readString());
                    versions.put(key, version);
                }
            }
            double rating = parcel.readDouble();
            int ratingCount = parcel.readInt();
            boolean premium = parcel.readByte() == 1;
            boolean inAppPurchases = parcel.readByte() == 1;
            String type = parcel.readString();
            return new AppDescription(uuid, title, imageUrl, primaryProduct, versions, rating, ratingCount, premium, inAppPurchases, type);
        }

        public AppDescription[] newArray(int size) {
            return new AppDescription[size];
        }
    };
    private String uuid;
    private String title;
    private HashMap<String, AppVersion> versions;
    private String imageUrl;
    private double rating;
    private int ratingCount;
    private boolean premium;
    private boolean inAppPurchases;
    public Product primaryProduct;
    private String type;

    public AppDescription() {
    }

    public AppDescription(JSONObject object) throws JSONException {
        this.readFromJSON(object);
    }

    public AppDescription(String uuid, String title, HashMap<String, AppVersion> versions) {
        this(uuid, title, null, null, versions, 0.0, 0, false, false, null);
    }

    public AppDescription(String uuid, String title, String imageUrl, Product primaryProduct, HashMap<String, AppVersion> versions, double rating, int ratingCount, boolean premium, boolean inAppPurchases, String type) {
        this.uuid = uuid;
        this.title = title;
        this.imageUrl = imageUrl;
        this.versions = versions;
        this.primaryProduct = primaryProduct;
        this.rating = rating;
        this.ratingCount = ratingCount;
        this.premium = premium;
        this.inAppPurchases = inAppPurchases;
        this.type = type;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public HashMap<String, AppVersion> getVersions() {
        return this.versions;
    }

    public void setVersions(HashMap<String, AppVersion> versions) {
        this.versions = versions;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setMainImageFullUrl(String mainImageFullUrl) {
        this.imageUrl = mainImageFullUrl;
    }

    public Product getPrimaryProduct() {
        return this.primaryProduct;
    }

    public double getRating() {
        return this.rating;
    }

    public int getRatingCount() {
        return this.ratingCount;
    }

    public boolean getPremium() {
        return this.premium;
    }

    public void setPremium(boolean newPremium) {
        this.premium = newPremium;
    }

    public boolean getInAppPurchases() {
        return this.inAppPurchases;
    }

    public void setInAppPurchases(boolean newInAppPurchases) {
        this.inAppPurchases = newInAppPurchases;
    }

    public void setRating(double rating) {
        this.rating = rating;
    }

    public void setRatingCount(int ratingCount) {
        this.ratingCount = ratingCount;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.uuid);
        dest.writeString(this.title);
        dest.writeString(this.imageUrl);
        dest.writeInt(this.primaryProduct != null ? 1 : 0);
        if (this.primaryProduct != null) {
            this.primaryProduct.writeToParcel(dest, flags);
        }
        if (this.versions == null) {
            dest.writeInt(-1);
        } else {
            dest.writeInt(this.versions.size());
            for (String key : this.versions.keySet()) {
                dest.writeString(key);
                dest.writeString(this.versions.get(key).getUuid());
                dest.writeString(this.versions.get(key).getUploadedAt());
                dest.writeString(this.versions.get(key).getMainImageFullUrl());
                dest.writeString(this.versions.get(key).getContentRating());
            }
        }
        dest.writeDouble(this.rating);
        dest.writeInt(this.ratingCount);
        dest.writeByte(this.premium ? (byte)1 : 0);
        dest.writeByte(this.inAppPurchases ? (byte)1 : 0);
        dest.writeString(this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AppDescription)) {
            return false;
        }
        AppDescription that = (AppDescription)o;
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        if (this.uuid != null ? !this.uuid.equals(that.uuid) : that.uuid != null) {
            return false;
        }
        if (this.imageUrl != null ? !this.imageUrl.equals(that.imageUrl) : that.imageUrl != null) {
            return false;
        }
        if (this.primaryProduct == null ? that.primaryProduct != null : !this.primaryProduct.equals(that.primaryProduct)) {
            return false;
        }
        if (this.versions != null ? !this.versions.equals(that.versions) : that.versions != null) {
            return false;
        }
        if (this.rating != that.rating) {
            return false;
        }
        if (this.ratingCount != that.ratingCount) {
            return false;
        }
        if (this.premium != that.premium) {
            return false;
        }
        if (this.inAppPurchases != that.inAppPurchases) {
            return false;
        }
        return this.type == null || this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.uuid != null ? this.uuid.hashCode() : 0;
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.versions != null ? this.versions.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AppDescription{title='" + this.title + '\'' + ", uuid='" + this.uuid + '\'' + ", versions=" + this.versions + '}';
    }

    public void readFromJSON(JSONObject object) throws JSONException {
        this.uuid = object.optString("uuid", null);
        if (this.uuid == null) {
            this.uuid = object.getString("package");
        }
        this.title = object.getString("title");
        if (object.has("image")) {
            this.imageUrl = object.getString("image");
        }
        this.type = object.optString("type");
        this.versions = new HashMap();
        if (this.type == null || !this.type.equals("details_page")) {
            if (object.has("versions")) {
                JSONObject versionsJSON = object.getJSONObject("versions");
                Iterator versionKeys = versionsJSON.keys();
                while (versionKeys.hasNext()) {
                    String key = (String)versionKeys.next();
                    this.versions.put(key, new AppVersion(versionsJSON.getJSONObject(key)));
                }
            } else {
                AppVersion fakeVersion = new AppVersion();
                String versionUuid = object.optString("version", null);
                if (versionUuid == null) {
                    versionUuid = object.getJSONObject("latestVersion").getString("uuid");
                }
                fakeVersion.setUuid(versionUuid);
                fakeVersion.setMainImageFullUrl(object.optString("image"));
                fakeVersion.setContentRating(object.optString("contentRating", object.optString("content_rating", null)));
                this.versions.put("approved", fakeVersion);
            }
            JSONObject productJSON = object.optJSONObject("primaryProduct");
            if (productJSON != null) {
                this.primaryProduct = new Product();
                this.primaryProduct.readFromJSONObject(productJSON);
            }
            if (object.has("rating")) {
                this.rating = object.getJSONObject("rating").getDouble("average");
                this.ratingCount = object.getJSONObject("rating").getInt("count");
            } else {
                this.rating = object.optDouble("ratingAverage", 0.0);
                this.ratingCount = object.optInt("ratingCount", 0);
            }
            this.premium = object.optBoolean("premium");
            this.inAppPurchases = object.optBoolean("inAppPurchases");
        }
    }

    public String getMostRecentVersionUuid() {
        return this.getMostRecentVersion().getUuid();
    }

    public String getMostRecentVersionUploadedAt() {
        return this.getMostRecentVersion().getUploadedAt();
    }

    public String getMostRecentVersionMainImageFullUrl() {
        return this.getMostRecentVersion().getMainImageFullUrl();
    }

    public String getMostRecentVersionContentRating() {
        return this.getMostRecentVersion().getContentRating();
    }

    private AppVersion getMostRecentVersion() {
        if (this.versions == null) {
            return AppVersion.EMPTY_VERSION;
        }
        for (String status : APP_STATUSES) {
            if (!this.versions.containsKey(status)) continue;
            return this.versions.get(status);
        }
        return AppVersion.EMPTY_VERSION;
    }

    public Intent getLaunchIntent(Context context) {
        PackageManager packageManager = context.getPackageManager();
        Intent mainIntent = new Intent("android.intent.action.MAIN", null);
        mainIntent.addFlags(0x10000000);
        mainIntent.addCategory("android.intent.category.LAUNCHER");
        mainIntent.addCategory("tv.ouya.intent.category.GAME");
        mainIntent.setPackage(this.getUuid());
        ResolveInfo resolveInfo = packageManager.resolveActivity(mainIntent, 0);
        if (resolveInfo == null) {
            mainIntent.removeCategory("tv.ouya.intent.category.GAME");
            mainIntent.addCategory("tv.ouya.intent.category.APP");
            resolveInfo = packageManager.resolveActivity(mainIntent, 0);
        }
        if (resolveInfo == null) {
            mainIntent.removeCategory("tv.ouya.intent.category.APP");
            resolveInfo = packageManager.resolveActivity(mainIntent, 0);
        }
        if (resolveInfo == null) {
            return null;
        }
        mainIntent.setClassName(resolveInfo.activityInfo.applicationInfo.packageName, resolveInfo.activityInfo.name);
        return mainIntent;
    }

    public static class AppVersion {
        public static final AppVersion EMPTY_VERSION = new AppVersion();
        private String uuid;
        private String uploadedAt;
        private String mainImageFullUrl;
        private String contentRating;

        public AppVersion() {
        }

        public AppVersion(JSONObject object) throws JSONException {
            this.readFromJSON(object);
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public String getUploadedAt() {
            return this.uploadedAt;
        }

        public Date getUploadedAtDate() {
            try {
                return this.parseDate(this.uploadedAt);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }

        public void setUploadedAt(String uploadedAt) {
            this.uploadedAt = uploadedAt;
        }

        public String getMainImageFullUrl() {
            return this.mainImageFullUrl;
        }

        public void setMainImageFullUrl(String mainImageFullUrl) {
            this.mainImageFullUrl = mainImageFullUrl;
        }

        public String getContentRating() {
            return this.contentRating;
        }

        public void setContentRating(String contentRating) {
            this.contentRating = contentRating;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AppVersion that = (AppVersion)o;
            if (this.uploadedAt != null ? !this.uploadedAt.equals(that.uploadedAt) : that.uploadedAt != null) {
                return false;
            }
            if (this.uuid != null ? !this.uuid.equals(that.uuid) : that.uuid != null) {
                return false;
            }
            if (this.mainImageFullUrl != null ? !this.mainImageFullUrl.equals(that.mainImageFullUrl) : that.mainImageFullUrl != null) {
                return false;
            }
            return !(this.contentRating != null ? !this.contentRating.equals(that.contentRating) : that.contentRating != null);
        }

        public int hashCode() {
            int result = this.uuid != null ? this.uuid.hashCode() : 0;
            result = 31 * result + (this.uploadedAt != null ? this.uploadedAt.hashCode() : 0);
            result = 31 * result + (this.mainImageFullUrl != null ? this.mainImageFullUrl.hashCode() : 0);
            result = 31 * result + (this.contentRating != null ? this.contentRating.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "AppVersion{uuid='" + this.uuid + '\'' + ", uploadedAt=" + this.uploadedAt + ", mainImageFullUrl='" + this.mainImageFullUrl + '\'' + ", contentRating='" + this.contentRating + '\'' + '}';
        }

        public void readFromJSON(JSONObject object) throws JSONException {
            this.uuid = object.getString("uuid");
            this.uploadedAt = object.getString("uploadedAt");
            this.mainImageFullUrl = object.getString("mainImageFullUrl");
            this.contentRating = object.optString("contentRating");
        }

        private Date parseDate(String dateString) throws ParseException {
            SimpleDateFormat sdf = new SimpleDateFormat(AppDescription.DATE_FORMAT);
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            return sdf.parse(dateString);
        }
    }
}

