/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.api;

import android.os.Parcel;
import android.os.Parcelable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class UserInfo
implements Parcelable {
    public static final Parcelable.Creator<UserInfo> CREATOR = new Parcelable.Creator<UserInfo>(){

        public UserInfo createFromParcel(Parcel parcel) {
            UserInfo info = new UserInfo();
            info.username = parcel.readString();
            info.email = parcel.readString();
            info.password = parcel.readString();
            long birthTime = parcel.readLong();
            if (birthTime > 0L) {
                info.dateOfBirth = new GregorianCalendar();
                info.dateOfBirth.setTimeInMillis(birthTime);
            }
            info.gender = parcel.readInt();
            info.founder = parcel.readByte() == 1;
            info.emailOptOut = parcel.readByte() == 1;
            return info;
        }

        public UserInfo[] newArray(int size) {
            return new UserInfo[size];
        }
    };
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    public static final DateFormat DOB_FORMAT = new SimpleDateFormat("MM/dd/yyyy");
    private String username;
    private String email;
    private String password;
    private Calendar dateOfBirth;
    private int gender;
    private boolean founder;
    private boolean emailOptOut;

    public UserInfo() {
    }

    public UserInfo(String username, String email, boolean founder) {
        this.username = username;
        this.email = email;
        this.founder = founder;
    }

    public UserInfo(String username, String email, boolean founder, String password, String password2, boolean emailOptOut) {
        this(username, email, founder);
        this.password = password;
        this.emailOptOut = emailOptOut;
    }

    public String getEmail() {
        return this.email;
    }

    public UserInfo setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public UserInfo setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public UserInfo setUsername(String username) {
        this.username = username;
        return this;
    }

    public boolean isFounder() {
        return this.founder;
    }

    public boolean isEmailOptOut() {
        return this.emailOptOut;
    }

    public void setEmailOptOut(boolean emailOptOut) {
        this.emailOptOut = emailOptOut;
    }

    public Calendar getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(Calendar dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public int getGender() {
        return this.gender;
    }

    public String getGenderString() {
        switch (this.getGender()) {
            case 1: {
                return "male";
            }
            case 2: {
                return "female";
            }
        }
        return "unknown";
    }

    public void setGender(int gender) {
        this.gender = gender;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserInfo userInfo = (UserInfo)o;
        if (this.email != null ? !this.email.equals(userInfo.email) : userInfo.email != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(userInfo.password) : userInfo.password != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(userInfo.username) : userInfo.username != null) {
            return false;
        }
        if (this.dateOfBirth != null ? !this.dateOfBirth.equals(userInfo.dateOfBirth) : userInfo.dateOfBirth != null) {
            return false;
        }
        if (this.founder != userInfo.founder) {
            return false;
        }
        return this.emailOptOut == userInfo.emailOptOut;
    }

    public int hashCode() {
        int result = this.username != null ? this.username.hashCode() : 0;
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.dateOfBirth != null ? this.dateOfBirth.hashCode() : 0);
        result = 31 * result + new Integer(this.gender).hashCode();
        result = 31 * result + Boolean.valueOf(this.founder).hashCode();
        result = 31 * result + Boolean.valueOf(this.emailOptOut).hashCode();
        return result;
    }

    public String toString() {
        return "UserInfo{username='" + this.username + '\'' + ", email='" + this.email + '\'' + ", password='" + this.password + '\'' + ", dateOfBirth='" + this.dateOfBirth + '\'' + ", gender='" + this.gender + '\'' + ", founder='" + (this.founder ? 1 : 0) + '\'' + ", emailOptOut='" + (this.emailOptOut ? 1 : 0) + '\'' + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeString(this.username);
        parcel.writeString(this.email);
        parcel.writeString(this.password);
        parcel.writeLong(this.dateOfBirth == null ? 0L : this.dateOfBirth.getTimeInMillis());
        parcel.writeInt(this.gender);
        parcel.writeByte((byte)(this.founder ? 1 : 0));
        parcel.writeByte((byte)(this.emailOptOut ? 1 : 0));
    }

    static {
        DOB_FORMAT.setLenient(false);
    }
}

