/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.api;

import android.os.Parcel;
import android.os.Parcelable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Date;
import java.util.TimeZone;

public class Receipt
implements Parcelable {
    public static final Parcelable.Creator<Receipt> CREATOR;
    private static final SimpleDateFormat DATE_PARSER;
    private String identifier;
    private int priceInCents;
    private Date purchaseDate;
    private String gamer;
    private String uuid;
    private double localPrice;
    private String currency;
    private Date generatedDate;

    public Receipt() {
    }

    public Receipt(String identifier, int priceInCents, Date purchaseDate, Date generatedDate, String gamerUuid, String uuid, double localPrice, String currency) {
        this.identifier = identifier;
        this.priceInCents = priceInCents;
        this.purchaseDate = purchaseDate;
        this.generatedDate = generatedDate;
        this.gamer = gamerUuid;
        this.uuid = uuid;
        this.localPrice = localPrice;
        this.currency = currency;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Deprecated
    public int getPriceInCents() {
        return this.priceInCents;
    }

    public Date getPurchaseDate() {
        return this.purchaseDate;
    }

    public String getGamer() {
        return this.gamer;
    }

    public double getLocalPrice() {
        return this.localPrice;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getFormattedPrice() {
        DecimalFormat df;
        if (this.currency != null && !this.currency.isEmpty()) {
            df = (DecimalFormat)NumberFormat.getCurrencyInstance();
            df.setCurrency(Currency.getInstance(this.currency));
        } else {
            df = new DecimalFormat("#.00");
        }
        return df.format(this.localPrice);
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setPriceInCents(int priceInCents) {
        this.priceInCents = priceInCents;
    }

    public void setPurchaseDate(Date purchaseDate) {
        this.purchaseDate = purchaseDate;
    }

    public void setDate(String date) {
        try {
            this.setPurchaseDate(DATE_PARSER.parse(date));
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public Date getGeneratedDate() {
        return this.generatedDate;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.identifier);
        dest.writeInt(this.priceInCents);
        dest.writeLong(this.purchaseDate.getTime());
        dest.writeLong(this.generatedDate.getTime());
        dest.writeString(this.gamer);
        dest.writeString(this.uuid);
        dest.writeDouble(this.localPrice);
        dest.writeString(this.currency);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Receipt)) {
            return false;
        }
        Receipt receipt = (Receipt)o;
        if (!this.identifier.equals(receipt.identifier)) {
            return false;
        }
        if (this.priceInCents != receipt.priceInCents) {
            return false;
        }
        if (!this.purchaseDate.equals(receipt.purchaseDate)) {
            return false;
        }
        if (!this.gamer.equals(receipt.gamer)) {
            return false;
        }
        if (!this.uuid.equals(receipt.uuid)) {
            return false;
        }
        if (this.localPrice != receipt.localPrice) {
            return false;
        }
        return this.currency == null || this.currency.equals(receipt.currency);
    }

    public int hashCode() {
        int result = this.identifier.hashCode();
        result = 31 * result + this.priceInCents;
        result = 31 * result + this.purchaseDate.hashCode();
        result = 31 * result + this.gamer.hashCode();
        result = 31 * result + this.uuid.hashCode();
        result = 31 * result + Double.valueOf(this.localPrice).hashCode();
        if (this.currency != null) {
            result = 31 * result + this.currency.hashCode();
        }
        return result;
    }

    static {
        DATE_PARSER = new SimpleDateFormat("yyy-MM-dd'T'HH:mm:ss'Z'");
        DATE_PARSER.setTimeZone(TimeZone.getTimeZone("UTC"));
        CREATOR = new Parcelable.Creator<Receipt>(){

            public Receipt createFromParcel(Parcel parcel) {
                return new Receipt(parcel.readString(), parcel.readInt(), new Date(parcel.readLong()), new Date(parcel.readLong()), parcel.readString(), parcel.readString(), parcel.readDouble(), parcel.readString());
            }

            public Receipt[] newArray(int size) {
                return new Receipt[size];
            }
        };
    }
}

