/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.api;

import android.util.Log;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class MappingParser {
    private static final String TAG = MappingParser.class.getSimpleName();
    private final String STRING_NOT_FOUND = "NOT_FOUND";
    private Vector<String> mStringHash = new Vector();
    private SparseArray<Controller> mController = new SparseArray();
    private Controller mControllerFallback = null;

    MappingParser() {
    }

    private String getStringById(int id) {
        if (id >= 0 && id < this.mStringHash.size()) {
            return this.mStringHash.get(id);
        }
        return "NOT_FOUND";
    }

    int getIdByString(String val) {
        if (!this.mStringHash.contains(val)) {
            this.mStringHash.add(val);
        }
        return this.mStringHash.indexOf(val);
    }

    public Controller getController(int controllerName) {
        if (null == this.mController.get(controllerName)) {
            if (null != this.mControllerFallback) {
                int count = this.mControllerFallback.mAlias.size();
                for (int i = 0; i < count; ++i) {
                    Log.i((String)TAG, (String)("Using controller fallback=" + this.getStringById(((Alias)this.mControllerFallback.mAlias.valueAt((int)i)).mName)));
                }
            }
            return this.mControllerFallback;
        }
        return (Controller)this.mController.get(controllerName);
    }

    public Button getButton(Controller controller, int keyCode) {
        if (null == controller) {
            return null;
        }
        if (null == controller.mButton.get(keyCode)) {
            return null;
        }
        return (Button)controller.mButton.get(keyCode);
    }

    public Button getButton(int controllerName, int keyCode) {
        Controller controller = this.getController(controllerName);
        if (null == controller) {
            return null;
        }
        return this.getButton(controller, keyCode);
    }

    public void parse(String jsonData) {
        if (null == jsonData) {
            return;
        }
        try {
            JSONObject device = new JSONObject(jsonData);
            if (device.has("controller")) {
                JSONArray controller = device.getJSONArray("controller");
                for (int controllerId = 0; controllerId < controller.length(); ++controllerId) {
                    JSONObject objButton;
                    Controller mappingController = new Controller();
                    JSONObject objController = controller.getJSONObject(controllerId);
                    JSONArray controllerAlias = objController.getJSONArray("alias");
                    for (int aliasId = 0; aliasId < controllerAlias.length(); ++aliasId) {
                        JSONObject objAlias = controllerAlias.getJSONObject(aliasId);
                        Alias alias = new Alias();
                        alias.mName = this.getIdByString(objAlias.getString("name"));
                        alias.mFriendlyName = this.getIdByString(objAlias.getString("friendly_name"));
                        if (objAlias.has("fallback")) {
                            alias.mFallback = objAlias.getBoolean("fallback");
                        }
                        mappingController.mAlias.put(alias.mName, (Object)alias);
                        this.mController.put(alias.mName, (Object)mappingController);
                        if (!alias.mFallback) continue;
                        this.mControllerFallback = mappingController;
                    }
                    if (objController.has("axis_exclude_source")) {
                        JSONArray excludeSource = objController.getJSONArray("axis_exclude_source");
                        for (int excludeId = 0; excludeId < excludeSource.length(); ++excludeId) {
                            int source = excludeSource.getInt(excludeId);
                            mappingController.mAxisExcludeSource.append(source, true);
                        }
                    }
                    if (objController.has("axis_remap")) {
                        JSONArray axis = objController.getJSONArray("axis_remap");
                        for (int axisId = 0; axisId < axis.length(); ++axisId) {
                            AxisRemap mappingAxis = new AxisRemap();
                            JSONObject objAxis = axis.getJSONObject(axisId);
                            mappingAxis.mSourceAxis = objAxis.getInt("source_axis");
                            mappingAxis.mDestinationAxis = objAxis.getInt("destination_axis");
                            mappingController.mAxisRemap.add(mappingAxis);
                        }
                    }
                    if (objController.has("button_is_axis")) {
                        JSONArray button = objController.getJSONArray("button_is_axis");
                        for (int buttonId = 0; buttonId < button.length(); ++buttonId) {
                            int destinationKeyCode;
                            ButtonIsAxis mappingButton = new ButtonIsAxis();
                            objButton = button.getJSONObject(buttonId);
                            mappingButton.mSourceAxis = objButton.getInt("source_axis");
                            mappingButton.mActionDownMax = (float)objButton.getDouble("action_down_max");
                            mappingButton.mActionDownMin = (float)objButton.getDouble("action_down_min");
                            mappingButton.mDestinationKeyCode = destinationKeyCode = objButton.getInt("destination_keycode");
                            mappingController.mButtonIsAxis.add(mappingButton);
                        }
                    }
                    if (!objController.has("button")) continue;
                    JSONArray button = objController.getJSONArray("button");
                    for (int buttonId = 0; buttonId < button.length(); ++buttonId) {
                        Button mappingButton = new Button();
                        objButton = button.getJSONObject(buttonId);
                        mappingButton.mSourceKeyCode = objButton.getInt("source_keycode");
                        int destination_keycode = objButton.getInt("destination_keycode");
                        if (objButton.has("exclude_source")) {
                            JSONArray excludeSource = objButton.getJSONArray("exclude_source");
                            for (int excludeId = 0; excludeId < excludeSource.length(); ++excludeId) {
                                int source = excludeSource.getInt(excludeId);
                                mappingButton.mExcludeSource.append(source, true);
                            }
                        }
                        mappingButton.mDestinationKeyCode = destination_keycode;
                        mappingController.mButton.put(mappingButton.mSourceKeyCode, (Object)mappingButton);
                    }
                }
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Failed to load input json: ", (Throwable)e);
        }
    }

    class Controller {
        public SparseArray<Alias> mAlias = new SparseArray();
        public SparseBooleanArray mAxisExcludeSource = new SparseBooleanArray();
        public Vector<AxisRemap> mAxisRemap = new Vector();
        public SparseArray<Button> mButton = new SparseArray();
        public Vector<ButtonIsAxis> mButtonIsAxis = new Vector();

        Controller() {
        }
    }

    class ButtonIsAxis {
        public int mSourceAxis = 0;
        public float mActionDownMax = 0.0f;
        public float mActionDownMin = 0.0f;
        public int mDestinationKeyCode = 0;

        ButtonIsAxis() {
        }
    }

    class AxisRemap {
        public int mSourceAxis = 0;
        public int mDestinationAxis = 0;

        AxisRemap() {
        }
    }

    class Button {
        public int mSourceKeyCode = 0;
        public int mDestinationKeyCode = 0;
        public SparseBooleanArray mExcludeSource = new SparseBooleanArray();

        Button() {
        }
    }

    private class Alias {
        public int mName = -1;
        public int mFriendlyName = -1;
        public boolean mFallback = false;

        private Alias() {
        }
    }
}

