/*
 * Decompiled with CFR 0.152.
 */
package tv.ouya.console.api;

import android.os.Parcel;
import android.os.Parcelable;
import org.json.JSONException;
import org.json.JSONObject;

public class CreditCardInfo
implements Parcelable {
    public static final Parcelable.Creator<CreditCardInfo> CREATOR = new Parcelable.Creator<CreditCardInfo>(){

        public CreditCardInfo createFromParcel(Parcel parcel) {
            return new CreditCardInfo(parcel.readDouble(), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readString(), parcel.readInt() == 1);
        }

        public CreditCardInfo[] newArray(int size) {
            return new CreditCardInfo[size];
        }
    };
    private double balance;
    private String lastFourDigits;
    private String provider;
    private String expiresAt;
    private String currencyCode;
    private boolean infoRequired;

    public CreditCardInfo() {
    }

    public CreditCardInfo(JSONObject object) throws JSONException {
        this.readFromJSONObject(object);
    }

    public CreditCardInfo(double balance, String lastFourDigits, String provider, String expiresAt, String currencyCode, boolean infoRequired) {
        this.balance = balance;
        this.lastFourDigits = lastFourDigits;
        this.provider = provider;
        this.expiresAt = expiresAt;
        this.currencyCode = currencyCode;
        this.infoRequired = infoRequired;
    }

    public double getBalance() {
        return this.balance;
    }

    public String getLastFourDigits() {
        return this.lastFourDigits;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getExpiresAt() {
        return this.expiresAt;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public boolean isInfoRequired() {
        return this.infoRequired;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(this.balance);
        dest.writeString(this.lastFourDigits);
        dest.writeString(this.provider);
        dest.writeString(this.expiresAt);
        dest.writeString(this.currencyCode);
        dest.writeInt(this.infoRequired ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreditCardInfo)) {
            return false;
        }
        CreditCardInfo creditCardInfo = (CreditCardInfo)o;
        if (this.balance != creditCardInfo.balance) {
            return false;
        }
        if (!this.lastFourDigits.equals(creditCardInfo.lastFourDigits)) {
            return false;
        }
        if (!this.provider.equals(creditCardInfo.provider)) {
            return false;
        }
        if (!this.expiresAt.equals(creditCardInfo.expiresAt)) {
            return false;
        }
        if (!this.currencyCode.equals(creditCardInfo.currencyCode)) {
            return false;
        }
        return this.infoRequired == creditCardInfo.infoRequired;
    }

    public int hashCode() {
        int result = Double.valueOf(this.balance).hashCode();
        if (this.lastFourDigits != null) {
            result = 31 * result + this.lastFourDigits.hashCode();
        }
        if (this.provider != null) {
            result = 31 * result + this.provider.hashCode();
        }
        if (this.expiresAt != null) {
            result = 31 * result + this.expiresAt.hashCode();
        }
        if (this.currencyCode != null) {
            result = 31 * result + this.currencyCode.hashCode();
        }
        return result;
    }

    private void readFromJSONObject(JSONObject object) throws JSONException {
        this.balance = object.optDouble("balance");
        this.currencyCode = object.optString("currency");
        this.infoRequired = object.getBoolean("requiresPaymentMethod");
        if (object.isNull("credit_card")) {
            this.expiresAt = null;
            this.provider = null;
            this.lastFourDigits = null;
        } else {
            JSONObject cardObj = object.getJSONObject("credit_card");
            this.lastFourDigits = cardObj.optString("last_four");
            this.provider = cardObj.optString("provider");
            this.expiresAt = cardObj.optString("expires_at");
        }
    }
}

