/*
 * Decompiled with CFR 0.152.
 */
package com.nibiru.lib.controller;

import android.os.Bundle;
import android.os.Parcelable;
import android.view.MotionEvent;
import com.nibiru.lib.controller.BaseEvent;
import java.util.Locale;

public class MouseEvent
extends BaseEvent {
    public static final int ACTION_HOVER_ENTER = 9;
    public static final int ACTION_HOVER_EXIT = 10;
    public static final int ACTION_HOVER_MOVE = 7;
    public int action;
    public float x;
    public float y;
    private int fb;
    private int fc;
    private MotionEvent fd;

    public MouseEvent(Bundle bundle) {
        super(bundle);
        this.action = bundle.getInt("action");
        this.fc = bundle.getInt("maxH");
        this.fb = bundle.getInt("maxW");
        this.fd = (MotionEvent)bundle.getParcelable("event");
        this.x = bundle.getFloat("x", 0.0f);
        this.y = bundle.getFloat("y", 0.0f);
    }

    public MouseEvent(MotionEvent motionEvent) {
        this.action = motionEvent.getAction();
        this.fd = MotionEvent.obtain((MotionEvent)motionEvent);
        this.x = motionEvent.getX();
        this.y = motionEvent.getY();
    }

    public MouseEvent() {
    }

    public void recycle() {
        if (this.fd != null) {
            this.fd.recycle();
            this.fd = null;
        }
    }

    public MouseEvent(int n2, int n3, float f2, float f3) {
        super(n2);
        this.action = n3;
        this.data.putInt("action", n3);
        this.x = f2;
        this.data.putFloat("x", f2);
        this.y = f3;
        this.data.putFloat("y", f3);
    }

    public MouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            return;
        }
        this.x = mouseEvent.x;
        this.y = mouseEvent.y;
        this.action = mouseEvent.action;
        this.fc = mouseEvent.fc;
        this.fb = mouseEvent.fb;
        this.fd = mouseEvent.fd;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int n2) {
        this.action = n2;
        this.data.putInt("action", n2);
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f2) {
        this.x = f2;
        this.data.putFloat("x", f2);
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f2) {
        this.y = f2;
        this.data.putFloat("y", f2);
    }

    public int getMaxScreenW() {
        return this.fb;
    }

    public void setMaxScreenW(int n2) {
        this.fb = n2;
        this.data.putInt("maxW", n2);
    }

    public int getMaxScrrenH() {
        return this.fc;
    }

    public void setMaxScrrenH(int n2) {
        this.fc = n2;
        this.data.putInt("maxH", this.fc);
    }

    public MotionEvent getOriginEvent() {
        return this.fd;
    }

    public void setOriginEvent(MotionEvent motionEvent) {
        this.fd = motionEvent;
        this.data.putParcelable("event", (Parcelable)motionEvent);
    }

    @Override
    public String getUnityMessage() {
        return String.format(Locale.US, "%f %f %d", Float.valueOf(this.x), Float.valueOf(this.y), this.playerOrder);
    }
}

