/*
 * Decompiled with CFR 0.152.
 */
package com.nibiru.lib.controller;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import com.nibiru.lib.BTDevice;
import com.nibiru.lib.controller.BaseEvent;
import com.nibiru.lib.controller.ControllerKeyEvent;
import java.math.BigDecimal;
import java.util.Locale;

public class GyroEvent
extends BaseEvent
implements Parcelable {
    private long time;
    private float ey;
    private float ez;
    private float eA;
    public static final int MAX_VALUE = 65536;
    public static final int GYRO_AXIS_X = 0;
    public static final int GYRO_AXIS_Y = 1;
    public static final int GYRO_AXIS_Z = 2;
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return new GyroEvent(parcel);
        }
    };

    public GyroEvent() {
    }

    public GyroEvent(GyroEvent gyroEvent) {
        this.time = gyroEvent.time;
        this.playerOrder = gyroEvent.playerOrder;
        this.ey = gyroEvent.ey;
        this.ez = gyroEvent.ez;
        this.eA = gyroEvent.eA;
    }

    public GyroEvent(Parcel parcel) {
        this.time = parcel.readLong();
        this.playerOrder = parcel.readInt();
        this.ey = parcel.readFloat();
        this.ez = parcel.readFloat();
        this.eA = parcel.readFloat();
    }

    public void setAxisValue(int[] nArray) {
        if (nArray == null || nArray.length < 3) {
            return;
        }
        this.ey = nArray[0];
        this.ez = nArray[1];
        this.eA = nArray[2];
    }

    public void setAxisValue(float[] fArray, BTDevice bTDevice) {
        if (fArray == null || fArray.length < 3) {
            return;
        }
        this.ey = fArray[0] / (float)bTDevice.getGycXMax();
        this.ez = fArray[1] / (float)bTDevice.getGycYMax();
        this.eA = fArray[2] / (float)bTDevice.getGycZMax();
    }

    public void setTime(long l2) {
        this.time = l2;
    }

    @Override
    public void setPlayerOrder(int n2) {
        this.playerOrder = n2;
    }

    public static ControllerKeyEvent getControllerKeyEvent(GyroEvent gyroEvent) {
        ControllerKeyEvent controllerKeyEvent = null;
        if (Math.abs(gyroEvent.getGyroValue(0)) > gyroEvent.getGyroValue(1)) {
            if (gyroEvent.getGyroValue(0) > 0.5) {
                controllerKeyEvent = new ControllerKeyEvent(0, 21, gyroEvent.getPlayerOrder());
            } else if (gyroEvent.getGyroValue(0) < -0.5) {
                controllerKeyEvent = new ControllerKeyEvent(0, 22, gyroEvent.getPlayerOrder());
            } else if (Math.abs(gyroEvent.getGyroValue(0)) < 0.5) {
                if (gyroEvent.getGyroValue(0) > 0.0) {
                    controllerKeyEvent = new ControllerKeyEvent(1, 21, gyroEvent.getPlayerOrder());
                } else if (gyroEvent.getGyroValue(0) < 0.0) {
                    controllerKeyEvent = new ControllerKeyEvent(1, 22, gyroEvent.getPlayerOrder());
                }
            }
        } else if (gyroEvent.getGyroValue(1) > 0.5) {
            controllerKeyEvent = new ControllerKeyEvent(0, 19, gyroEvent.getPlayerOrder());
        } else if (gyroEvent.getGyroValue(1) < -0.5) {
            controllerKeyEvent = new ControllerKeyEvent(0, 20, gyroEvent.getPlayerOrder());
        } else if (Math.abs(gyroEvent.getGyroValue(1)) < 0.5) {
            if (gyroEvent.getGyroValue(1) > 0.0) {
                controllerKeyEvent = new ControllerKeyEvent(1, 19, gyroEvent.getPlayerOrder());
            } else if (gyroEvent.getGyroValue(1) < 0.0) {
                controllerKeyEvent = new ControllerKeyEvent(1, 20, gyroEvent.getPlayerOrder());
            }
        }
        return controllerKeyEvent;
    }

    public static GyroEvent getDefaultGyroEvent(int n2) {
        GyroEvent gyroEvent = new GyroEvent();
        new GyroEvent().ey = GyroEvent.getFormatData(0.0f);
        gyroEvent.ez = GyroEvent.getFormatData(0.0f);
        gyroEvent.eA = GyroEvent.getFormatData(0.0f);
        gyroEvent.playerOrder = n2;
        gyroEvent.time = SystemClock.uptimeMillis();
        return gyroEvent;
    }

    public GyroEvent(byte[] byArray, int n2) {
        int n3 = byArray[0] & 0xFF;
        int n4 = byArray[1] & 0xFF;
        int n5 = byArray[2] & 0xFF;
        int n6 = byArray[3] & 0xFF;
        int n7 = byArray[4] & 0xFF;
        int n8 = byArray[5] & 0xFF;
        this.ey = (n3 << 8) + n4;
        this.ez = (n5 << 8) + n6;
        this.eA = (n7 << 8) + n8;
        if (this.ey >= 32768.0f) {
            this.ey -= 65536.0f;
        }
        if (this.ez >= 32768.0f) {
            this.ez -= 65536.0f;
        }
        if (this.eA >= 32768.0f) {
            this.eA -= 65536.0f;
        }
        this.ey = GyroEvent.getFormatData(this.ey / 32768.0f);
        this.ez = GyroEvent.getFormatData(this.ez / 32768.0f);
        this.eA = GyroEvent.getFormatData(this.eA / 32768.0f);
        this.playerOrder = n2;
        this.time = SystemClock.uptimeMillis();
    }

    public boolean isEquals(GyroEvent gyroEvent) {
        if (this.playerOrder != gyroEvent.getPlayerOrder()) {
            return false;
        }
        return (double)Math.abs(this.ey - gyroEvent.ey) < 0.02 && (double)Math.abs(this.ez - gyroEvent.ez) < 0.02 && (double)Math.abs(this.eA - gyroEvent.eA) < 0.02;
    }

    public long getTime() {
        return this.time;
    }

    @Override
    public int getPlayerOrder() {
        return this.playerOrder;
    }

    public static float getFormatData(float f2) {
        float f3;
        f2 = new BigDecimal(f2).setScale(3, 4).floatValue();
        if ((double)Math.abs(f3) < 0.02) {
            f2 = 0.0f;
        }
        return f2;
    }

    public double getGyroValue(int n2) {
        switch (n2) {
            case 0: {
                return this.ey;
            }
            case 1: {
                return this.ez;
            }
            case 2: {
                return this.eA;
            }
        }
        return 0.0;
    }

    public String toString() {
        return "GyroEvent [time=" + this.time + ", playerOrder=" + this.playerOrder + ", gyroX=" + this.getGyroValue(0) + ", gyroY=" + this.getGyroValue(1) + ", gyroZ=" + this.getGyroValue(2) + "]";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeLong(this.time);
        parcel.writeInt(this.playerOrder);
        parcel.writeFloat(this.ey);
        parcel.writeFloat(this.ez);
        parcel.writeFloat(this.eA);
    }

    public float[] getAxisValues() {
        float[] fArray = new float[3];
        float[] fArray2 = fArray;
        fArray[0] = this.ey;
        fArray2[1] = this.ez;
        fArray2[2] = this.eA;
        return fArray2;
    }

    @Override
    public String getUnityMessage() {
        return String.format(Locale.US, "%f %f %f %d", Float.valueOf(this.ey), Float.valueOf(this.ez), Float.valueOf(this.eA), this.playerOrder);
    }
}

