/*
 * Decompiled with CFR 0.152.
 */
package com.nibiru.lib.controller;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import com.nibiru.lib.controller.Controller;
import com.nibiru.lib.controller.ControllerService;
import com.nibiru.lib.controller.ControllerServiceException;
import com.nibiru.lib.controller.CursorService;
import com.nibiru.lib.controller.p;

public class GeneralControllerActivity
extends Activity {
    protected ControllerService mControllerService;
    protected CursorService mCursorService;
    protected int mArrowId = -1;
    protected int mMouseStartKey = 108;
    private p as;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.af();
    }

    public void onCreateInVRMode(Bundle bundle) {
        super.onCreate(bundle);
        this.af();
    }

    private void af() {
        this.mControllerService = Controller.getControllerService((Context)this);
        this.mControllerService.setSDKMode(2);
        this.mCursorService = this.mControllerService.getCursorService();
        this.as = this.mControllerService.getExitManager();
        if (this.mControllerService != null && this.mControllerService.checkNibiruInstall((Context)this, true)) {
            this.initNibiruService();
        }
        this.mControllerService.setControllerServiceListener(new ControllerService.OnControllerSeviceListener(this){
            private /* synthetic */ GeneralControllerActivity ex;
            {
                this.ex = generalControllerActivity;
            }

            @Override
            public final void onControllerServiceReady(boolean bl) {
                if (bl) {
                    this.ex.mControllerService.handleFullScreenMode();
                }
            }
        });
    }

    protected void initNibiruService() {
        try {
            this.mControllerService.register((Context)this, true);
            return;
        }
        catch (ControllerServiceException controllerServiceException) {
            ControllerServiceException controllerServiceException2 = controllerServiceException;
            controllerServiceException.printStackTrace();
            return;
        }
    }

    protected void onResume() {
        super.onResume();
        this.setScreenOnMode(true);
        if (this.mControllerService != null) {
            this.mControllerService.setEnable(true);
            this.mControllerService.handleFullScreenMode();
        }
    }

    public void showGameGuide(boolean bl) {
        if (this.mControllerService == null) {
            return;
        }
        this.mControllerService.showGameGuide(bl);
    }

    public boolean hasDeviceConnected() throws ControllerServiceException {
        if (this.mControllerService == null) {
            throw new ControllerServiceException("Controller Service is not connected to driver, please install your driver first and wait for connection build");
        }
        return this.mControllerService.hasDeviceConnected();
    }

    public void setArrowResId(int n2) {
        this.mArrowId = n2;
        if (this.mCursorService != null) {
            this.mCursorService.setCursorResource(n2);
        }
    }

    protected void setScreenOnMode(boolean bl) {
        if (bl) {
            this.getWindow().clearFlags(128);
            this.getWindow().setFlags(128, 128);
            return;
        }
        this.getWindow().clearFlags(128);
    }

    protected void onPause() {
        super.onPause();
        if (this.mControllerService != null) {
            this.mControllerService.setEnable(false);
        }
        this.setScreenOnMode(false);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mControllerService != null) {
            this.mControllerService.unregister();
            this.mControllerService = null;
        }
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (this.mControllerService != null && this.mControllerService.handleExternalInput((InputEvent)keyEvent)) {
            return true;
        }
        if (this.as != null && this.as.d(keyEvent.getKeyCode(), keyEvent.getAction())) {
            return true;
        }
        return super.dispatchKeyEvent(keyEvent);
    }

    public boolean dispatchGenericMotionEvent(MotionEvent motionEvent) {
        if (this.mControllerService != null && this.mControllerService.handleExternalInput((InputEvent)motionEvent)) {
            return true;
        }
        return super.dispatchGenericMotionEvent(motionEvent);
    }

    protected void onActivityResult(int n2, int n3, Intent intent) {
        if (this.as != null && this.as.e(n2, n3)) {
            return;
        }
        super.onActivityResult(n2, n3, intent);
    }
}

