/*
 * Decompiled with CFR 0.152.
 */
package com.nibiru.lib.controller;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import com.nibiru.lib.controller.Controller;
import com.nibiru.lib.controller.ControllerKeyEvent;
import com.nibiru.lib.controller.ControllerService;
import com.nibiru.lib.controller.ControllerServiceException;
import com.nibiru.lib.controller.CursorService;
import com.nibiru.lib.controller.OnKeyListener;
import com.nibiru.lib.controller.OnStickListener;
import com.nibiru.lib.controller.StickEvent;

public class CompatControllerActivity
extends Activity
implements OnKeyListener,
OnStickListener {
    protected ControllerService mControllerService;
    protected int mCursorKey;

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.initNibiruService();
    }

    protected void onResume() {
        super.onResume();
        if ((this.mControllerService == null || this.mControllerService != null && !this.mControllerService.isServiceEnable()) && this.mControllerService.checkNibiruInstall((Context)this, false)) {
            this.initNibiruService();
        }
        this.getWindow().setFlags(128, 128);
        if (this.mControllerService != null) {
            this.mControllerService.setEnable(true);
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.mControllerService != null) {
            this.mControllerService.setEnable(false);
        }
        this.getWindow().clearFlags(128);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mControllerService != null) {
            this.mControllerService.unregister();
            this.mControllerService = null;
        }
    }

    private void initNibiruService() {
        if (this.mControllerService == null || this.mControllerService != null && !this.mControllerService.isServiceEnable()) {
            this.mControllerService = Controller.getControllerService((Context)this);
            this.mControllerService.getContinusKeyService().registerContinuesDirectionKey();
            this.mControllerService.getStickSimService().startStickSim();
            this.mControllerService.setAutoDriverCheck(false);
            this.mControllerService.setAutoGameGuide(true);
            try {
                this.mControllerService.register();
                return;
            }
            catch (ControllerServiceException controllerServiceException) {
                ControllerServiceException controllerServiceException2 = controllerServiceException;
                controllerServiceException.printStackTrace();
            }
        }
    }

    @Override
    public void onControllerStickEvent(int n2, StickEvent stickEvent) {
    }

    @Override
    public void onControllerKeyDown(int n2, int n3, ControllerKeyEvent controllerKeyEvent) {
        if (this.mControllerService != null && n3 == this.mCursorKey) {
            CursorService cursorService = this.mControllerService.getCursorService();
            if (cursorService.isCursorShow()) {
                cursorService.hideCursor();
                return;
            }
            cursorService.createCursor();
        }
    }

    @Override
    public void onControllerKeyUp(int n2, int n3, ControllerKeyEvent controllerKeyEvent) {
    }

    public void setCurosorKey(int n2) {
        this.mCursorKey = n2;
    }

    public void setCursorResId(int n2) {
        if (this.mControllerService != null) {
            CursorService cursorService = this.mControllerService.getCursorService();
            cursorService.setCursorResource(n2);
        }
    }
}

