/*
 * Decompiled with CFR 0.152.
 */
package com.nibiru.lib.controller;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import com.nibiru.lib.BTDevice;
import com.nibiru.lib.controller.BaseEvent;
import java.math.BigDecimal;
import java.util.Locale;

public class AccEvent
extends BaseEvent
implements Parcelable {
    private long time;
    private float l;
    private float m;
    private float n;
    public static final int MAX_VALUE = 65536;
    public static final int ACC_AXIS_X = 0;
    public static final int ACC_AXIS_Y = 1;
    public static final int ACC_AXIS_Z = 2;
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return new AccEvent(parcel);
        }
    };

    public AccEvent() {
    }

    public AccEvent(AccEvent accEvent) {
        this.time = accEvent.time;
        this.playerOrder = accEvent.playerOrder;
        this.l = accEvent.l;
        this.m = accEvent.m;
        this.n = accEvent.n;
    }

    public AccEvent(Parcel parcel) {
        this.time = parcel.readLong();
        this.playerOrder = parcel.readInt();
        this.l = parcel.readFloat();
        this.m = parcel.readFloat();
        this.n = parcel.readFloat();
    }

    public static AccEvent getDefaultAccEvent(int n2) {
        AccEvent accEvent = new AccEvent();
        new AccEvent().l = AccEvent.getFormatData(0.0f, false);
        accEvent.m = AccEvent.getFormatData(0.0f, false);
        accEvent.n = AccEvent.getFormatData(0.0f, true);
        accEvent.playerOrder = n2;
        accEvent.time = SystemClock.uptimeMillis();
        return accEvent;
    }

    public void setAxisValue(int[] nArray) {
        if (nArray == null || nArray.length < 3) {
            return;
        }
        this.l = nArray[0];
        this.m = nArray[1];
        this.n = nArray[2];
    }

    public void setAxisValue(float[] fArray, BTDevice bTDevice) {
        if (fArray == null || fArray.length < 3) {
            return;
        }
        this.l = fArray[0] / (float)bTDevice.getAccXMax();
        this.m = fArray[1] / (float)bTDevice.getAccYMax();
        this.n = fArray[2] / (float)bTDevice.getAccZMax();
    }

    public void setTime(long l2) {
        this.time = l2;
    }

    @Override
    public void setPlayerOrder(int n2) {
        this.playerOrder = n2;
    }

    public AccEvent(byte[] byArray, int n2) {
        int n3 = byArray[0] & 0xFF;
        int n4 = byArray[1] & 0xFF;
        int n5 = byArray[2] & 0xFF;
        int n6 = byArray[3] & 0xFF;
        int n7 = byArray[4] & 0xFF;
        int n8 = byArray[5] & 0xFF;
        this.l = (n3 << 8) + n4;
        this.m = (n5 << 8) + n6;
        this.n = (n7 << 8) + n8;
        if (this.l >= 32768.0f) {
            this.l -= 65536.0f;
        }
        if (this.m >= 32768.0f) {
            this.m -= 65536.0f;
        }
        if (this.n >= 32768.0f) {
            this.n -= 65536.0f;
        }
        this.l = AccEvent.getFormatData(this.l / 32768.0f, false);
        this.m = AccEvent.getFormatData(this.m / 32768.0f, false);
        this.n = AccEvent.getFormatData(this.n / 32768.0f, true);
        this.playerOrder = n2;
        this.time = SystemClock.uptimeMillis();
    }

    public boolean isEquals(AccEvent accEvent) {
        if (this.playerOrder != accEvent.getPlayerOrder()) {
            return false;
        }
        return (double)Math.abs(this.l - accEvent.l) < 0.02 && (double)Math.abs(this.m - accEvent.m) < 0.02 && (double)Math.abs(this.n - accEvent.n) < 0.02;
    }

    public long getTime() {
        return this.time;
    }

    @Override
    public int getPlayerOrder() {
        return this.playerOrder;
    }

    public static float getFormatData(float f2, boolean bl) {
        f2 = new BigDecimal(f2).setScale(3, 4).floatValue();
        if (bl) {
            if (Math.abs((double)f2 - 0.5) < 0.02) {
                f2 = 0.5f;
            }
        } else if ((double)Math.abs(f2) < 0.02) {
            f2 = 0.0f;
        }
        return f2;
    }

    public float getAccValue(int n2) {
        switch (n2) {
            case 0: {
                return this.l;
            }
            case 1: {
                return this.m;
            }
            case 2: {
                return this.n;
            }
        }
        return 0.0f;
    }

    public String toString() {
        return "AccEvent [time=" + this.time + ", playerOrder=" + this.playerOrder + ", accX=" + this.getAccValue(0) + ", accY=" + this.getAccValue(1) + ", accZ=" + this.getAccValue(2) + "]";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeLong(this.time);
        parcel.writeInt(this.playerOrder);
        parcel.writeFloat(this.l);
        parcel.writeFloat(this.m);
        parcel.writeFloat(this.n);
    }

    public float[] getAxisValues() {
        float[] fArray = new float[3];
        float[] fArray2 = fArray;
        fArray[0] = this.l;
        fArray2[1] = this.m;
        fArray2[2] = this.n;
        return fArray2;
    }

    @Override
    public String getUnityMessage() {
        return String.format(Locale.US, "%f %f %f %d", Float.valueOf(this.l), Float.valueOf(this.m), Float.valueOf(this.n), this.playerOrder);
    }
}

