/*
 * Decompiled with CFR 0.152.
 */
package com.nibiru.lib;

import android.bluetooth.BluetoothDevice;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.view.InputDevice;
import com.nibiru.lib.b;
import com.nibiru.lib.controller.ControllerKeyEvent;
import com.nibiru.lib.controller.StickEvent;
import java.io.Serializable;
import java.util.Arrays;

public class BTDevice
implements Parcelable,
Serializable {
    protected static final long serialVersionUID = 4473651087026692626L;
    protected String deviceName = "No Device";
    protected int deviceId = -1;
    protected int deviceType = -1;
    protected int deviceSource = 0;
    protected int playerOrder = 0;
    protected String deviceAddr = "0:0:0:0:0:0";
    protected boolean isConnected = false;
    protected long connectTime = 0L;
    protected int state = 3;
    protected boolean isExternal = false;
    protected int features = 0;
    protected boolean isSupportAcc = false;
    protected boolean isSupportGyro = false;
    protected int gestureMode = 2;
    protected int isAutoConnect = 0;
    protected StickEvent lastStickEvent = null;
    protected ControllerKeyEvent lastKeyEvent = null;
    protected int lastHatKey = 0;
    protected b mDeviceInfo;
    public static final int STATE_CONNING = 0;
    public static final int STATE_CONN = 1;
    public static final int STATE_DISCONNING = 2;
    public static final int STATE_DISCONN = 3;
    public static final int STATE_STOP = 4;
    public static final int GESTURE_NIBIRU_MODE = 0;
    public static final int GESTURE_DPAD_MODE = 1;
    public static final int GESTURE_SWING_MODE = 2;
    protected int[] accArray;
    protected int[] gycArray;
    private BluetoothDevice a;
    public static final Parcelable.Creator CREATOR = new Parcelable.Creator(){

        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            return new BTDevice(parcel);
        }
    };

    public BTDevice(BluetoothDevice bluetoothDevice) {
        this.deviceAddr = bluetoothDevice.getAddress();
        this.deviceName = bluetoothDevice.getName();
        if (this.deviceName == null || this.deviceName.length() == 0) {
            this.deviceName = "Unknown Device";
        }
        this.state = 3;
        this.a = bluetoothDevice;
    }

    public BTDevice(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        this.deviceName = bundle.getString("device_name");
        this.deviceId = bundle.getInt("device_id");
        this.deviceType = bundle.getInt("device_type");
        this.deviceSource = bundle.getInt("device_source");
        this.playerOrder = bundle.getInt("player");
        this.deviceAddr = bundle.getString("addr");
        this.isConnected = bundle.getBoolean("is_connected");
        this.connectTime = bundle.getLong("connect_time");
        this.state = bundle.getInt("state");
        this.isExternal = bundle.getBoolean("is_external");
        this.features = bundle.getInt("feature");
        this.isSupportAcc = bundle.getBoolean("is_support_acc");
        this.isSupportGyro = bundle.getBoolean("is_support_gyro");
        this.accArray = bundle.getIntArray("acc_array");
        this.gycArray = bundle.getIntArray("gyc_array");
        this.gestureMode = bundle.getInt("gesture_mode");
        this.isAutoConnect = bundle.getInt("is_auto_connect");
    }

    public Bundle getBundle() {
        Bundle bundle = new Bundle();
        bundle.putString("device_name", this.deviceName);
        bundle.putInt("device_id", this.deviceId);
        bundle.putInt("device_type", this.deviceType);
        bundle.putInt("device_source", this.deviceSource);
        bundle.putInt("player", this.playerOrder);
        bundle.putString("addr", this.deviceAddr);
        bundle.putBoolean("is_connected", this.isConnected);
        bundle.putLong("connect_time", this.connectTime);
        bundle.putInt("state", this.state);
        bundle.putBoolean("is_external", this.isExternal);
        bundle.putInt("feature", this.features);
        bundle.putBoolean("is_support_acc", this.isSupportAcc);
        bundle.putBoolean("is_support_gyro", this.isSupportGyro);
        bundle.putIntArray("acc_array", this.accArray);
        bundle.putIntArray("gyc_array", this.gycArray);
        bundle.putInt("gesture_mode", this.gestureMode);
        bundle.putInt("is_auto_connect", this.isAutoConnect);
        return bundle;
    }

    public b getDeviceInfo() {
        return this.mDeviceInfo;
    }

    public int getIsAutoConnect() {
        return this.isAutoConnect;
    }

    public void setIsAutoConnect(int n2) {
        this.isAutoConnect = n2;
    }

    public void setDeviceInfo(b b2) {
        this.mDeviceInfo = b2;
        if (b2 != null) {
            this.deviceSource = b2.getSource();
        }
    }

    public int getGestureMode() {
        return this.gestureMode;
    }

    public void setGestureMode(int n2) {
        this.gestureMode = n2;
    }

    public boolean isExternal() {
        return this.deviceAddr != null && (this.deviceAddr.startsWith("sys") || this.deviceAddr.startsWith("virtual") || this.deviceAddr.startsWith("gen"));
    }

    public void setExternal(boolean bl) {
        this.isExternal = bl;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(int n2) {
        this.deviceId = n2;
    }

    public int getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(int n2) {
        this.deviceType = n2;
    }

    public int getPlayerOrder() {
        return this.playerOrder;
    }

    public void setPlayerOrder(int n2) {
        this.playerOrder = n2;
    }

    public String getDeviceAddr() {
        return this.deviceAddr;
    }

    public void setDeviceAddr(String string) {
        this.deviceAddr = string;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setConnected(boolean bl) {
        this.isConnected = bl;
    }

    public int getDeviceSource() {
        return this.deviceSource;
    }

    public void setDeviceSource(int n2) {
        this.deviceSource = n2;
    }

    public int getFeatures() {
        return this.features;
    }

    public boolean isSupportAcc() {
        return this.isSupportAcc;
    }

    public void setSupportAcc(boolean bl) {
        this.isSupportAcc = bl;
        if (bl) {
            this.features |= 1;
            return;
        }
        this.features &= 0xFFFFFFFE;
    }

    public boolean isSupportGyro() {
        return this.isSupportGyro;
    }

    public void setSupportGyro(boolean bl) {
        this.isSupportGyro = bl;
        if (this.isSupportAcc) {
            this.features |= 2;
            return;
        }
        this.features &= 0xFFFFFFFD;
    }

    public void addFeatures(int n2) {
        this.features |= n2;
    }

    public void removeFeatures(int n2) {
        this.features &= ~n2;
    }

    public void setDeviceName(String string) {
        this.deviceName = string;
    }

    public StickEvent getLastStickEvent() {
        return this.lastStickEvent;
    }

    public void setLastStickEvent(StickEvent stickEvent) {
        this.lastStickEvent = stickEvent;
    }

    public ControllerKeyEvent getLastKeyEvent() {
        return this.lastKeyEvent;
    }

    public void setLastKeyEvent(ControllerKeyEvent controllerKeyEvent) {
        this.lastKeyEvent = controllerKeyEvent;
    }

    public int[] getAccMaxArray() {
        return this.accArray;
    }

    public int[] getGycMaxArray() {
        return this.gycArray;
    }

    public int getAccXMax() {
        return this.accArray[0];
    }

    public int getAccYMax() {
        return this.accArray[1];
    }

    public int getAccZMax() {
        return this.accArray[2];
    }

    public int getGycXMax() {
        return this.gycArray[0];
    }

    public int getGycYMax() {
        return this.gycArray[1];
    }

    public int getGycZMax() {
        return this.gycArray[2];
    }

    public void setAccMaxArray(int[] nArray) {
        this.accArray = nArray;
    }

    public void setGycMaxArray(int[] nArray) {
        this.gycArray = nArray;
    }

    public String toString() {
        return "BTDevice [deviceName=" + this.deviceName + ", deviceId=" + this.deviceId + ", deviceType=" + this.deviceType + ", state=" + this.state + ", deviceSource=" + this.deviceSource + ", playerOrder=" + this.playerOrder + ", deviceAddr=" + this.deviceAddr + ", isConnected=" + this.isConnected + ", connectTime=" + this.connectTime + ", state=" + this.state + ", isExternal=" + this.isExternal + ", features=" + this.features + ", isSupportAcc=" + this.isSupportAcc + ", isSupportGyro=" + this.isSupportGyro + ", lastStickEvent=" + this.lastStickEvent + ", lastKeyEvent=" + this.lastKeyEvent + ", mDeviceInfo=" + this.mDeviceInfo + ", accArray=" + Arrays.toString(this.accArray) + ", gycArray=" + Arrays.toString(this.gycArray) + "]";
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    public void setConnectTime(long l2) {
        this.connectTime = l2;
    }

    public int hashCode() {
        int n2 = 31 + (this.deviceAddr == null ? 0 : this.deviceAddr.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (BTDevice)object;
        return !(this.deviceAddr == null ? ((BTDevice)object).deviceAddr != null : !this.deviceAddr.equals(((BTDevice)object).deviceAddr));
    }

    public BTDevice(String string, int n2, int n3, String string2, boolean bl, int n4, boolean bl2) {
        this.isExternal = bl;
        this.state = n4;
        this.isConnected = bl2;
        this.deviceName = string;
        this.deviceId = n2;
        this.deviceType = n3;
        this.deviceAddr = string2;
    }

    public BTDevice() {
    }

    public BTDevice(String string) {
        this.deviceName = "device";
        this.deviceId = -1;
        this.deviceAddr = string;
        this.deviceType = -1;
        this.deviceSource = 0;
    }

    public boolean isValid() {
        if (this.isExternal) {
            return true;
        }
        return !this.deviceAddr.equals("0:0:0:0:0:0") && this.deviceType >= 0;
    }

    public void recordConnectTime() {
        this.connectTime = System.currentTimeMillis();
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n2) {
        this.state = n2;
    }

    public boolean isHost() {
        return this.playerOrder == 1;
    }

    public BTDevice(Parcel parcel) {
        this.setConnectTime(parcel.readLong());
        this.setDeviceAddr(parcel.readString());
        this.setDeviceId(parcel.readInt());
        this.setDeviceName(parcel.readString());
        this.setDeviceType(parcel.readInt());
        this.setConnected(parcel.readInt() == 1);
        this.setPlayerOrder(parcel.readInt());
        this.setState(parcel.readInt());
        this.setExternal(parcel.readInt() == 1);
        this.setFeatures(parcel.readInt());
        this.setSupportAcc(parcel.readInt() == 1);
        this.setSupportGyro(parcel.readInt() == 1);
    }

    public void setFeatures(int n2) {
        this.features = n2;
    }

    public BTDevice(InputDevice inputDevice) {
        this.isExternal = true;
        this.isConnected = true;
        this.state = 1;
        this.deviceId = inputDevice.getId();
        this.deviceName = inputDevice.getName();
        this.deviceType = 0;
        this.connectTime = SystemClock.uptimeMillis();
        this.deviceAddr = "gen:" + inputDevice.getName() + ":" + inputDevice.getId();
    }

    public BTDevice(BTDevice bTDevice) {
        this.isExternal = bTDevice.isExternal;
        this.isConnected = bTDevice.isConnected;
        this.state = bTDevice.state;
        this.deviceId = bTDevice.deviceId;
        this.deviceName = bTDevice.deviceName;
        this.deviceType = bTDevice.deviceType;
        this.connectTime = bTDevice.connectTime;
        this.playerOrder = bTDevice.playerOrder;
        this.deviceAddr = bTDevice.deviceAddr;
        this.deviceSource = bTDevice.getDeviceSource();
        this.a = bTDevice.getBluetoothDevice();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeLong(this.connectTime);
        if (this.deviceAddr == null) {
            this.deviceAddr = "";
        }
        parcel.writeString(this.deviceAddr);
        parcel.writeInt(this.deviceId);
        if (this.deviceName == null) {
            this.deviceName = "Unknown";
        }
        parcel.writeString(this.deviceName);
        parcel.writeInt(this.deviceType);
        parcel.writeInt(this.isConnected ? 1 : 0);
        parcel.writeInt(this.playerOrder);
        parcel.writeInt(this.state);
        parcel.writeInt(this.isExternal ? 1 : 0);
        parcel.writeInt(this.features);
        parcel.writeInt(this.isSupportAcc ? 1 : 0);
        parcel.writeInt(this.isSupportGyro ? 1 : 0);
    }

    public int getLastHatKey() {
        return this.lastHatKey;
    }

    public void setLastHatKey(int n2) {
        this.lastHatKey = n2;
    }

    public BluetoothDevice getBluetoothDevice() {
        return this.a;
    }
}

