/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets.plaf;

import com.explodingpixels.data.Rating;
import com.explodingpixels.macwidgets.ITunesRatingTableCellRenderer;
import com.explodingpixels.macwidgets.ITunesTableHeaderRenderer;
import com.explodingpixels.macwidgets.MacFontUtils;
import com.explodingpixels.widgets.TableHeaderUtils;
import com.explodingpixels.widgets.TableUtils;
import com.explodingpixels.widgets.WindowUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellEditor;

public class ITunesTableUI
extends BasicTableUI {
    protected static final Color EVEN_ROW_COLOR = new Color(241, 245, 250);
    protected static final Color TABLE_GRID_COLOR = new Color(0xD9D9D9);
    protected static final Color SELECTION_ACTIVE_SELECTION_FOREGROUND_COLOR = Color.WHITE;
    protected static final Color SELECTION_ACTIVE_SELECTION_BACKGROUND_COLOR = new Color(4030687);
    protected static final Color SELECTION_INACTIVE_SELECTION_FOREGROUND_COLOR = Color.BLACK;
    protected static final Color SELECTION_INACTIVE_SELECTION_BACKGROUND_COLOR = new Color(0xC0C0C0);
    protected static final Color SELECTION_ACTIVE_BOTTOM_BORDER_COLOR = new Color(125, 170, 234);
    protected static final Color SELECTION_INACTIVE_BOTTOM_BORDER_COLOR = new Color(224, 224, 224);
    protected static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.table.remove(this.rendererPane);
        this.rendererPane = this.createCustomCellRendererPane();
        this.table.add(this.rendererPane);
        this.table.setOpaque(false);
        this.table.setFont(MacFontUtils.ITUNES_FONT);
        this.table.setGridColor(TABLE_GRID_COLOR);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setAutoResizeMode(0);
        this.table.getTableHeader().setDefaultRenderer(new ITunesTableHeaderRenderer(this.table));
        this.table.setShowHorizontalLines(false);
        TableHeaderUtils.makeHeaderFillEmptySpace(this.table);
        TableUtils.makeStriped(this.table, EVEN_ROW_COLOR);
        this.table.setDefaultRenderer(Rating.class, new ITunesRatingTableCellRenderer());
        this.table.setDefaultEditor(Object.class, this.createDefaultTableCellEditor());
        this.makeTableActive();
        WindowUtils.installWeakWindowFocusListener(this.table, this.createWindowFocusListener());
    }

    @Override
    protected void installListeners() {
        super.installListeners();
    }

    private void makeTableActive() {
        this.table.setSelectionForeground(SELECTION_ACTIVE_SELECTION_FOREGROUND_COLOR);
        this.table.setSelectionBackground(SELECTION_ACTIVE_SELECTION_BACKGROUND_COLOR);
    }

    private void makeTableInactive() {
        this.table.setSelectionForeground(SELECTION_INACTIVE_SELECTION_FOREGROUND_COLOR);
        this.table.setSelectionBackground(SELECTION_INACTIVE_SELECTION_BACKGROUND_COLOR);
    }

    private TableCellEditor createDefaultTableCellEditor() {
        JTextField textField = new JTextField();
        textField.setFont(MacFontUtils.ITUNES_FONT);
        textField.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        return new DefaultCellEditor(textField);
    }

    private WindowFocusListener createWindowFocusListener() {
        return new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                ITunesTableUI.this.makeTableActive();
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                ITunesTableUI.this.makeTableInactive();
            }
        };
    }

    public Border getRowBorder() {
        return BorderFactory.createEmptyBorder(0, 5, 0, 5);
    }

    public Border getSelectedRowBorder() {
        return BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.getSelectedRowBottomHighlight()), BorderFactory.createEmptyBorder(1, 5, 0, 5));
    }

    private Color getSelectedRowBottomHighlight() {
        return WindowUtils.isParentWindowFocused(this.table) ? SELECTION_ACTIVE_BOTTOM_BORDER_COLOR : SELECTION_INACTIVE_BOTTOM_BORDER_COLOR;
    }

    protected CellRendererPane createCustomCellRendererPane() {
        return new CellRendererPane(){

            @Override
            public void paintComponent(Graphics graphics, Component component, Container container, int x, int y, int w, int h, boolean shouldValidate) {
                int rowAtPoint = ITunesTableUI.this.table.rowAtPoint(new Point(x, y));
                boolean isSelected = ITunesTableUI.this.table.isRowSelected(rowAtPoint);
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    jComponent.setOpaque(isSelected);
                    jComponent.setBorder(isSelected ? ITunesTableUI.this.getSelectedRowBorder() : ITunesTableUI.this.getRowBorder());
                    jComponent.setBackground(isSelected ? ITunesTableUI.this.table.getSelectionBackground() : TRANSPARENT_COLOR);
                }
                super.paintComponent(graphics, component, container, x, y, w, h, shouldValidate);
            }
        };
    }
}

