/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue.extras;

import org.jfugue.ChannelPressure;
import org.jfugue.Controller;
import org.jfugue.Instrument;
import org.jfugue.JFugueElement;
import org.jfugue.KeySignature;
import org.jfugue.Layer;
import org.jfugue.Measure;
import org.jfugue.Note;
import org.jfugue.ParserListenerAdapter;
import org.jfugue.Pattern;
import org.jfugue.PitchBend;
import org.jfugue.PolyphonicPressure;
import org.jfugue.Tempo;
import org.jfugue.Time;
import org.jfugue.Voice;

public class GetPatternForVoiceTool
extends ParserListenerAdapter {
    private byte voice = 0;
    private byte activeVoice = 0;
    private Pattern pattern;

    public GetPatternForVoiceTool(int voice) {
        this.voice = (byte)voice;
        this.reset();
    }

    public void reset() {
        this.pattern = new Pattern();
        this.activeVoice = 0;
    }

    public void voiceEvent(Voice voice) {
        if (this.activeVoice != voice.getVoice()) {
            this.activeVoice = voice.getVoice();
            this.addElementIfActiveVoice(voice);
        }
    }

    public void tempoEvent(Tempo tempo) {
        this.pattern.add(tempo.getMusicString());
    }

    public void keySignatureEvent(KeySignature keySig) {
        this.pattern.add(keySig.getMusicString());
    }

    public void instrumentEvent(Instrument instrument) {
        this.addElementIfActiveVoice(instrument);
    }

    public void layerEvent(Layer layer) {
        this.addElementIfActiveVoice(layer);
    }

    public void measureEvent(Measure measure) {
        this.addElementIfActiveVoice(measure);
    }

    public void timeEvent(Time time) {
        this.addElementIfActiveVoice(time);
    }

    public void controllerEvent(Controller controller) {
        this.addElementIfActiveVoice(controller);
    }

    public void channelPressureEvent(ChannelPressure channelPressure) {
        this.addElementIfActiveVoice(channelPressure);
    }

    public void polyphonicPressureEvent(PolyphonicPressure polyphonicPressure) {
        this.addElementIfActiveVoice(polyphonicPressure);
    }

    public void pitchBendEvent(PitchBend pitchBend) {
        this.addElementIfActiveVoice(pitchBend);
    }

    public void noteEvent(Note note) {
        this.addElementIfActiveVoice(note);
    }

    public void sequentialNoteEvent(Note note) {
        this.addElementIfActiveVoice(note);
    }

    public void parallelNoteEvent(Note note) {
        this.addElementIfActiveVoice(note);
    }

    private void addElementIfActiveVoice(JFugueElement element) {
        if (this.activeVoice == this.voice) {
            this.pattern.add(element.getMusicString());
        }
    }

    public Pattern getPattern() {
        return this.pattern;
    }
}

