/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import org.jfugue.DurationPatternTool;
import org.jfugue.JFugueException;
import org.jfugue.MusicStringParser;
import org.jfugue.Pattern;
import org.jfugue.Player;
import org.jfugue.StreamingMidiRenderer;

public final class StreamingPlayer {
    private Sequencer sequencer;
    private StreamingMidiRenderer renderer;
    private MusicStringParser parser;
    private DurationPatternTool durationPatternTool;

    public StreamingPlayer() {
        try {
            this.init(MidiSystem.getSequencer());
        }
        catch (MidiUnavailableException e) {
            throw new JFugueException("The MIDI System cannot instantiate a sequencer.  Although this error is reported by JFugue, the problem is not with JFugue itself.  Find resources for using MIDI on your specific system.  The exception message from MidiSystem.getSequencer() is: " + e.getMessage());
        }
    }

    public StreamingPlayer(Sequencer sequencer) {
        this.init(sequencer);
    }

    public StreamingPlayer(Synthesizer synth) throws MidiUnavailableException {
        this(Player.getSequencerConnectedToSynthesizer(synth));
    }

    private void init(Sequencer sequencer) {
        this.setSequencer(sequencer);
        this.parser = new MusicStringParser();
        this.renderer = new StreamingMidiRenderer();
        this.parser.addParserListener(this.renderer);
        this.durationPatternTool = new DurationPatternTool();
        this.parser.addParserListener(this.durationPatternTool);
    }

    private void openSequencer() {
        if (this.getSequencer() == null) {
            throw new JFugueException("The MIDI System cannot instantiate a sequencer.  Although this error is reported by JFugue, the problem is not with JFugue itself.  Find resources for using MIDI on your specific system.");
        }
        if (!this.getSequencer().isOpen()) {
            try {
                this.getSequencer().open();
            }
            catch (MidiUnavailableException e) {
                throw new JFugueException("The MIDI System cannot instantiate a sequencer.  Although this error is reported by JFugue, the problem is not with JFugue itself.  Find resources for using MIDI on your specific system.  The exception message from MidiSystem.getSequencer() is: " + e.getMessage());
            }
        }
    }

    public void close() {
        this.getSequencer().close();
        try {
            if (MidiSystem.getSynthesizer() != null) {
                MidiSystem.getSynthesizer().close();
            }
        }
        catch (MidiUnavailableException e) {
            throw new JFugueException("General error: " + e.getMessage());
        }
        this.renderer.close();
    }

    private void setSequencer(Sequencer sequencer) {
        this.sequencer = sequencer;
    }

    public Sequencer getSequencer() {
        return this.sequencer;
    }

    public void stream(Pattern singleToken) {
        this.parser.parse(singleToken);
    }

    public void stream(String singleToken) {
        this.stream(new Pattern(singleToken));
    }

    public void streamAndWait(Pattern fragment) {
        String[] tokens;
        String[] stringArray = tokens = fragment.getTokens();
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            this.durationPatternTool.reset();
            Pattern pattern = new Pattern(token);
            this.parser.parse(pattern);
            long duration = this.durationPatternTool.getDuration();
            try {
                System.out.println(duration);
                Thread.sleep(duration);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    public void streamAndWait(String fragment) {
        this.streamAndWait(new Pattern(fragment));
    }
}

