/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import org.jfugue.ChannelPressure;
import org.jfugue.Controller;
import org.jfugue.Instrument;
import org.jfugue.KeySignature;
import org.jfugue.Layer;
import org.jfugue.Measure;
import org.jfugue.MusicStringParser;
import org.jfugue.Note;
import org.jfugue.ParserListener;
import org.jfugue.PitchBend;
import org.jfugue.PolyphonicPressure;
import org.jfugue.StreamingMidiEventManager;
import org.jfugue.Tempo;
import org.jfugue.Time;
import org.jfugue.Voice;

public class StreamingMidiRenderer
implements ParserListener {
    private StreamingMidiEventManager eventManager;
    private MusicStringParser parser = new MusicStringParser();
    long initialNoteTime = 0L;

    public StreamingMidiRenderer() {
        this.parser.addParserListener(this);
        this.reset();
    }

    public void reset() {
        this.eventManager = new StreamingMidiEventManager();
    }

    public void voiceEvent(Voice voice) {
        this.eventManager.setCurrentTrack(voice.getVoice());
    }

    public void tempoEvent(Tempo tempo) {
    }

    public void instrumentEvent(Instrument instrument) {
        this.eventManager.addEvent(192, instrument.getInstrument(), 0);
    }

    public void layerEvent(Layer layer) {
        this.eventManager.setCurrentLayer(layer.getLayer());
    }

    public void timeEvent(Time time) {
        this.eventManager.setTrackTimer(time.getTime());
    }

    public void measureEvent(Measure measure) {
    }

    public void keySignatureEvent(KeySignature keySig) {
        this.eventManager.addMetaMessage(89, new byte[]{keySig.getKeySig(), keySig.getScale()});
    }

    public void controllerEvent(Controller controller) {
        this.eventManager.addEvent(176, controller.getIndex(), controller.getValue());
    }

    public void channelPressureEvent(ChannelPressure channelPressure) {
        this.eventManager.addEvent(208, channelPressure.getPressure());
    }

    public void polyphonicPressureEvent(PolyphonicPressure polyphonicPressure) {
        this.eventManager.addEvent(160, polyphonicPressure.getKey(), polyphonicPressure.getPressure());
    }

    public void pitchBendEvent(PitchBend pitchBend) {
        this.eventManager.addEvent(224, pitchBend.getBend()[0], pitchBend.getBend()[1]);
    }

    public void noteEvent(Note note) {
        boolean noteOff;
        this.initialNoteTime = this.eventManager.getTrackTimer();
        long duration = note.getDuration();
        boolean noteOn = !note.isEndOfTie();
        boolean bl = noteOff = !note.isStartOfTie();
        if (note.isRest()) {
            this.eventManager.advanceTrackTimer(note.getDuration());
        } else {
            this.initialNoteTime = this.eventManager.getTrackTimer();
            byte attackVelocity = note.getAttackVelocity();
            byte decayVelocity = note.getDecayVelocity();
            this.eventManager.addNoteEvents(note.getValue(), attackVelocity, decayVelocity, duration, noteOn, noteOff);
        }
    }

    public void sequentialNoteEvent(Note note) {
        throw new UnsupportedOperationException("Sequential notes (declared using an underscore character) are not supported by JFugue's StreamingMidiRenderer");
    }

    public void parallelNoteEvent(Note note) {
        long duration = note.getDuration();
        this.eventManager.setTrackTimer(this.initialNoteTime);
        if (note.isRest()) {
            this.eventManager.advanceTrackTimer(note.getDuration());
        } else {
            byte attackVelocity = note.getAttackVelocity();
            byte decayVelocity = note.getDecayVelocity();
            this.eventManager.addNoteEvents(note.getValue(), attackVelocity, decayVelocity, duration, !note.isEndOfTie(), !note.isStartOfTie());
        }
    }

    public void close() {
        this.eventManager.close();
    }
}

