/*
 * Decompiled with CFR 0.152.
 */
package org.jfugue;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jfugue.IntervalNotation;
import org.jfugue.JFugueException;
import org.jfugue.Note;
import org.jfugue.Pattern;

public class Rhythm
implements Serializable {
    private Map<Character, String> charToNote = new HashMap<Character, String>();
    private String[] layers = new String[this.MAX_LAYERS];
    private String[] voices = new String[this.MAX_VOICES];
    private String[] voiceDetails = new String[this.MAX_VOICES];
    private int MAX_LAYERS = 127;
    private int MAX_VOICES = 16;
    private int PERCUSSION_TRACK = 9;

    public void addSubstitution(char stringChar, String musicString) {
        this.charToNote.put(Character.valueOf(stringChar), musicString);
    }

    public String getSubstitution(char stringChar) {
        return this.charToNote.get(Character.valueOf(stringChar));
    }

    public void removeSubstitution(char stringChar) {
        this.charToNote.remove(Character.valueOf(stringChar));
    }

    public void setLayer(int layer, String rhythmString) {
        if (layer < 0 || layer > this.MAX_LAYERS) {
            throw new JFugueException("Layer * is not a number, or is not in the range 0 - 127.", Integer.toString(layer), rhythmString);
        }
        this.layers[layer] = rhythmString;
    }

    public String getLayer(int layer) {
        return this.layers[layer];
    }

    public void clearLayer(int layer) {
        this.layers[layer] = null;
    }

    public void setVoice(int voice, String rhythmString) {
        if (voice < 0 || voice > this.MAX_LAYERS || voice == this.PERCUSSION_TRACK) {
            throw new JFugueException("Voice * is not a number, or is not in the range 0 - 127.", Integer.toString(voice), rhythmString);
        }
        this.voices[voice] = rhythmString;
    }

    public String getVoice(int voice) {
        return this.voices[voice];
    }

    public void clearVoice(int voice) {
        this.voices[voice] = null;
    }

    public void setVoiceDetails(int voice, String musicString) {
        if (voice < 0 || voice > this.MAX_LAYERS || voice == this.PERCUSSION_TRACK) {
            throw new JFugueException("Voice * is not a number, or is not in the range 0 - 127.", Integer.toString(voice), musicString);
        }
        this.voiceDetails[voice] = musicString;
    }

    public String getVoiceDetails(int voice) {
        return this.voiceDetails[voice];
    }

    public void clearVoiceDetails(int voice) {
        this.voiceDetails[voice] = null;
    }

    public String getMusicString() {
        StringBuffer buffy = new StringBuffer();
        buffy.append("V9 ");
        int i = 0;
        while (i < this.MAX_LAYERS) {
            String rhythmString = this.getLayer(i);
            if (rhythmString != null) {
                buffy.append("L");
                buffy.append(i);
                buffy.append(" ");
                int r = 0;
                while (r < rhythmString.length()) {
                    char ch = rhythmString.charAt(r);
                    String substitution = this.getSubstitution(ch);
                    if (substitution != null) {
                        buffy.append(substitution);
                        buffy.append(" ");
                    }
                    ++r;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.MAX_VOICES) {
            String rhythmString;
            boolean voiceCommandAdded = false;
            String detailsString = this.getVoiceDetails(i);
            if (detailsString != null) {
                buffy.append("V");
                buffy.append(i);
                voiceCommandAdded = true;
                buffy.append(" ");
                buffy.append(detailsString);
                buffy.append(" ");
            }
            if ((rhythmString = this.getVoice(i)) != null) {
                if (!voiceCommandAdded) {
                    buffy.append("V");
                    buffy.append(i);
                    buffy.append(" ");
                }
                int r = 0;
                while (r < rhythmString.length()) {
                    char ch = rhythmString.charAt(r);
                    String substitution = this.getSubstitution(ch);
                    if (substitution != null) {
                        buffy.append(substitution);
                        buffy.append(" ");
                    }
                    ++r;
                }
            }
            ++i;
        }
        return buffy.toString();
    }

    public Pattern getPattern() {
        return new Pattern(this.getMusicString());
    }

    public Pattern getPatternWithInterval(Pattern pattern) {
        IntervalNotation interval = new IntervalNotation(this.getMusicString());
        return interval.getPatternForRootNote(pattern);
    }

    public Pattern getPatternWithInterval(String string) {
        IntervalNotation interval = new IntervalNotation(this.getMusicString());
        return interval.getPatternForRootNote(string);
    }

    public Pattern getPatternWithInterval(Note rootNote) {
        IntervalNotation interval = new IntervalNotation(this.getMusicString());
        return interval.getPatternForRootNote(rootNote);
    }
}

